/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.dialogs.ISortCriteria;
import com.ibm.etools.fm.editor.formatted.dialogs.SortByColumnCriteria;
import com.ibm.etools.fm.editor.formatted.dialogs.SortByColumnCriteriaDialog;
import com.ibm.etools.fm.editor.formatted.dialogs.SortByFieldCriteria;
import com.ibm.etools.fm.editor.formatted.dialogs.SortByFieldRefCriteriaDialog;
import com.ibm.etools.fm.editor.formatted.dialogs.SortByKeyCriteria;
import com.ibm.etools.fm.editor.formatted.dialogs.SortDialogTableLabelProvider;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SortDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String SORT_COMMAND = "SORT ";
    public static final String ASCENDING_CHAR = "A";
    public static final String DESCENDING_CHAR = "D";
    private FormattedEditor editor;
    private Button currentlySelectedButton;
    private Button selByColButton;
    private Button selByRefButton;
    private Button selByKeyButton;
    private TableViewer sortCriteriaTableViewer;
    private ArrayList<ISortCriteria> sortCriteriaList;
    private Button criteriaUpButton;
    private Button criteriaDownButton;
    private Button criteriaAddButton;
    private Button criteriaDelButton;
    private Button criteriaUpdateButton;
    private boolean sortByFieldAllowed = true;

    public SortDialog(FormattedEditor editor) {
        this.editor = editor;
        this.sortCriteriaList = new ArrayList();
        int i = 0;
        while (i < editor.getCurrentSortCriteria().size()) {
            this.sortCriteriaList.add(editor.getCurrentSortCriteria().get(i).copy());
            ++i;
        }
        this.sortByFieldAllowed = true;
        if (editor.getTemplateResource() == null && editor.getSessionIdentifier().getSessionType() != AbstractSessionFormatted.SessionType.DB2) {
            this.sortByFieldAllowed = false;
            if (this.sortCriteriaList.size() > 0 && this.sortCriteriaList.get(0) instanceof SortByFieldCriteria) {
                this.sortCriteriaList.clear();
            }
        } else if (editor.getCurrentEditorMode() == IFMEditor.EditorMode.CHARACTER) {
            this.sortByFieldAllowed = false;
            if (this.sortCriteriaList.size() > 0 && this.sortCriteriaList.get(0) instanceof SortByFieldCriteria) {
                this.sortCriteriaList.clear();
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.SortDialog_TITLE);
        this.setMessage(Messages.SortDialog_MSG);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createSortCriteriaButtons(composite);
        this.createSortCriteriaTable(composite);
        this.setCriteriaTableContents(0);
        if (!this.sortByFieldAllowed) {
            this.selByRefButton.setEnabled(false);
            if (this.editor.getCurrentSortCriteria().size() > 0) {
                ISortCriteria aCriteria = this.editor.getCurrentSortCriteria().get(0);
                if (aCriteria instanceof SortByFieldCriteria) {
                    this.selByRefButton.setSelection(true);
                    this.currentlySelectedButton = this.selByRefButton;
                } else if (aCriteria instanceof SortByColumnCriteria) {
                    this.selByColButton.setSelection(true);
                    this.currentlySelectedButton = this.selByColButton;
                } else if (aCriteria instanceof SortByKeyCriteria) {
                    this.selByKeyButton.setSelection(true);
                    this.currentlySelectedButton = this.selByKeyButton;
                    this.enableCriteriaControls(false);
                } else {
                    this.editor.getCurrentSortCriteria().clear();
                    this.selByColButton.setSelection(true);
                    this.currentlySelectedButton = this.selByColButton;
                }
            } else {
                this.selByColButton.setSelection(true);
                this.currentlySelectedButton = this.selByColButton;
            }
        } else if (this.editor.getCurrentSortCriteria().size() > 0) {
            ISortCriteria aCriteria = this.editor.getCurrentSortCriteria().get(0);
            if (aCriteria instanceof SortByFieldCriteria) {
                this.selByRefButton.setSelection(true);
                this.currentlySelectedButton = this.selByRefButton;
            } else if (aCriteria instanceof SortByColumnCriteria) {
                this.selByColButton.setSelection(true);
                this.currentlySelectedButton = this.selByColButton;
            } else if (aCriteria instanceof SortByKeyCriteria) {
                this.selByKeyButton.setSelection(true);
                this.currentlySelectedButton = this.selByKeyButton;
                this.enableCriteriaControls(false);
            } else {
                this.editor.getCurrentSortCriteria().clear();
                this.selByRefButton.setSelection(true);
                this.currentlySelectedButton = this.selByRefButton;
            }
        } else {
            this.selByRefButton.setSelection(true);
            this.currentlySelectedButton = this.selByRefButton;
        }
        this.setComplete(this.validateCriteriaSpecification());
        return composite;
    }

    private void createSortCriteriaButtons(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.selByColButton = GUI.button.radio((Composite)composite, (String)Messages.SortDialog_SORT_BY_COL_NO, (Object)GUI.grid.d.left1());
        this.selByColButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (SortDialog.this.selByColButton.getSelection()) {
                    if (SortDialog.this.sortCriteriaList.size() > 0 && SortDialog.this.currentlySelectedButton != SortDialog.this.selByColButton) {
                        if (!PDDialogs.openConfirm((String)Messages.FMPlugin_QUESTION_TITLE, (String)Messages.SortDialog_SORT_TYPE_CHANGE)) {
                            SortDialog.this.currentlySelectedButton.setSelection(true);
                            SortDialog.this.selByColButton.setSelection(false);
                            SortDialog.this.setComplete(SortDialog.this.validateCriteriaSpecification());
                            return;
                        }
                        SortDialog.this.sortCriteriaList.clear();
                        SortDialog.this.setCriteriaTableContents(0);
                    }
                    SortDialog.this.currentlySelectedButton = SortDialog.this.selByColButton;
                    SortDialog.this.enableCriteriaControls(true);
                    SortDialog.this.setComplete(SortDialog.this.validateCriteriaSpecification());
                }
            }
        });
        this.selByRefButton = GUI.button.radio((Composite)composite, (String)Messages.SortDialog_SORT_BY_FIELD, (Object)GUI.grid.d.left1());
        this.selByRefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (SortDialog.this.selByRefButton.getSelection()) {
                    if (SortDialog.this.sortCriteriaList.size() > 0 && SortDialog.this.currentlySelectedButton != SortDialog.this.selByRefButton) {
                        if (!PDDialogs.openConfirm((String)Messages.FMPlugin_QUESTION_TITLE, (String)Messages.SortDialog_SORT_TYPE_CHANGE)) {
                            SortDialog.this.currentlySelectedButton.setSelection(true);
                            SortDialog.this.selByRefButton.setSelection(false);
                            SortDialog.this.setComplete(SortDialog.this.validateCriteriaSpecification());
                            return;
                        }
                        SortDialog.this.sortCriteriaList.clear();
                        SortDialog.this.setCriteriaTableContents(0);
                    }
                    SortDialog.this.currentlySelectedButton = SortDialog.this.selByRefButton;
                    SortDialog.this.enableCriteriaControls(true);
                    SortDialog.this.setComplete(SortDialog.this.validateCriteriaSpecification());
                }
            }
        });
        this.selByKeyButton = GUI.button.radio((Composite)composite, (String)Messages.SortDialog_SORT_BY_KEY, (Object)GUI.grid.d.left1());
        this.selByKeyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (SortDialog.this.selByKeyButton.getSelection()) {
                    if (SortDialog.this.sortCriteriaList.size() > 0 && SortDialog.this.currentlySelectedButton != SortDialog.this.selByKeyButton) {
                        if (!PDDialogs.openConfirm((String)Messages.FMPlugin_QUESTION_TITLE, (String)Messages.SortDialog_SORT_TYPE_CHANGE)) {
                            SortDialog.this.currentlySelectedButton.setSelection(true);
                            SortDialog.this.selByKeyButton.setSelection(false);
                            SortDialog.this.setComplete(SortDialog.this.validateCriteriaSpecification());
                            return;
                        }
                        SortDialog.this.sortCriteriaList.clear();
                        SortDialog.this.sortCriteriaList.add(new SortByKeyCriteria());
                    }
                    if (SortDialog.this.sortCriteriaList.isEmpty()) {
                        SortDialog.this.sortCriteriaList.add(new SortByKeyCriteria());
                    }
                    SortDialog.this.setCriteriaTableContents(0);
                    SortDialog.this.enableCriteriaControls(false);
                    SortDialog.this.currentlySelectedButton = SortDialog.this.selByKeyButton;
                    SortDialog.this.setComplete(SortDialog.this.validateCriteriaSpecification());
                }
            }
        });
        if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            this.selByColButton.setEnabled(false);
        }
        if (!this.editor.getSessionProperties().isKSDS()) {
            this.selByKeyButton.setEnabled(false);
        }
    }

    private void createSortCriteriaTable(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.sortCriteriaTableViewer = new TableViewer(composite, 68356);
        this.sortCriteriaTableViewer.getTable().setHeaderVisible(true);
        this.sortCriteriaTableViewer.getTable().setLinesVisible(true);
        GridData gd = GUI.grid.d.fillAll();
        gd.minimumHeight = 100;
        gd.minimumWidth = 200;
        this.sortCriteriaTableViewer.getTable().setLayoutData((Object)gd);
        this.createColumns();
        this.sortCriteriaTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sortCriteriaTableViewer.setLabelProvider((IBaseLabelProvider)new SortDialogTableLabelProvider());
        this.sortCriteriaTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SortDialog.this.updateCriteria();
            }
        });
        Composite buttonComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.left1());
        this.criteriaAddButton = GUI.button.push((Composite)buttonComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/add.gif"), (String)Messages.SortDialog_ADD_CRITERIA, (Object)GUI.grid.d.left1());
        this.criteriaAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (SortDialog.this.sortCriteriaList.size() == 5) {
                    SortDialog.this.setErrorMessage(Messages.SortDialog_MAX_CRITERIA);
                    return;
                }
                if (SortDialog.this.selByColButton.getSelection()) {
                    SortByColumnCriteriaDialog dialog = new SortByColumnCriteriaDialog(SortDialog.this.editor, null);
                    if (dialog.open() != 0) {
                        SortDialog.this.setComplete(SortDialog.this.validateCriteriaSpecification());
                        return;
                    }
                    SortDialog.this.sortCriteriaList.add(dialog.getSortCriteria());
                    SortDialog.this.setCriteriaTableContents(SortDialog.this.sortCriteriaList.size() - 1);
                    SortDialog.this.setComplete(SortDialog.this.validateCriteriaSpecification());
                } else {
                    SortByFieldRefCriteriaDialog dialog = new SortByFieldRefCriteriaDialog(SortDialog.this.editor, null);
                    if (dialog.open() != 0) {
                        SortDialog.this.setComplete(SortDialog.this.validateCriteriaSpecification());
                        return;
                    }
                    SortDialog.this.sortCriteriaList.add(dialog.getSortCriteria());
                    SortDialog.this.setCriteriaTableContents(SortDialog.this.sortCriteriaList.size() - 1);
                    SortDialog.this.setComplete(SortDialog.this.validateCriteriaSpecification());
                }
            }
        });
        this.criteriaUpdateButton = GUI.button.push((Composite)buttonComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/editfield.gif"), (String)Messages.SortDialog_UPDATE_CRITERIA, (Object)GUI.grid.d.left1());
        this.criteriaUpdateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SortDialog.this.updateCriteria();
            }
        });
        this.criteriaDelButton = GUI.button.push((Composite)buttonComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/delete.gif"), (String)Messages.SortDialog_DEL_CRITERIA, (Object)GUI.grid.d.left1());
        this.criteriaDelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (SortDialog.this.sortCriteriaList.isEmpty()) {
                    SortDialog.this.setComplete(SortDialog.this.validateCriteriaSpecification());
                    return;
                }
                int selIndex = SortDialog.this.sortCriteriaTableViewer.getTable().getSelectionIndex();
                if (selIndex == -1) {
                    SortDialog.this.setComplete(SortDialog.this.validateCriteriaSpecification());
                    return;
                }
                SortDialog.this.sortCriteriaList.remove(selIndex);
                SortDialog.this.setCriteriaTableContents(Math.min(selIndex, SortDialog.this.sortCriteriaList.size() - 1));
                if (selIndex < SortDialog.this.sortCriteriaList.size()) {
                    SortDialog.this.sortCriteriaTableViewer.getTable().select(selIndex);
                } else {
                    if (--selIndex < 0) {
                        selIndex = 0;
                    }
                    SortDialog.this.sortCriteriaTableViewer.getTable().select(selIndex);
                }
                SortDialog.this.setComplete(SortDialog.this.validateCriteriaSpecification());
            }
        });
        this.criteriaUpButton = GUI.button.push((Composite)buttonComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/moveup.gif"), (String)Messages.SortDialog_UP_CRITERIA, (Object)GUI.grid.d.left1());
        this.criteriaUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (SortDialog.this.sortCriteriaList.size() < 2) {
                    return;
                }
                int selectionIndex = SortDialog.this.sortCriteriaTableViewer.getTable().getSelectionIndex();
                if (selectionIndex == 0) {
                    return;
                }
                ISortCriteria aCriteria = SortDialog.this.sortCriteriaList.get(selectionIndex);
                int newIndex = selectionIndex - 1;
                SortDialog.this.sortCriteriaList.remove(selectionIndex);
                SortDialog.this.sortCriteriaList.add(newIndex, aCriteria);
                SortDialog.this.setCriteriaTableContents(newIndex);
                SortDialog.this.setComplete(SortDialog.this.validateCriteriaSpecification());
            }
        });
        this.criteriaDownButton = GUI.button.push((Composite)buttonComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/movedown.gif"), (String)Messages.SortDialog_DOWN_CRITERIA, (Object)GUI.grid.d.left1());
        this.criteriaDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (SortDialog.this.sortCriteriaList.size() < 2) {
                    return;
                }
                int selectionIndex = SortDialog.this.sortCriteriaTableViewer.getTable().getSelectionIndex();
                if (selectionIndex == SortDialog.this.sortCriteriaList.size() - 1) {
                    return;
                }
                ISortCriteria aCriteria = SortDialog.this.sortCriteriaList.get(selectionIndex);
                int newIndex = selectionIndex + 1;
                SortDialog.this.sortCriteriaList.remove(selectionIndex);
                SortDialog.this.sortCriteriaList.add(newIndex, aCriteria);
                SortDialog.this.setCriteriaTableContents(newIndex);
                SortDialog.this.setComplete(SortDialog.this.validateCriteriaSpecification());
            }
        });
    }

    private void updateCriteria() {
        int selectionIndex = this.sortCriteriaTableViewer.getTable().getSelectionIndex();
        if (selectionIndex == -1) {
            return;
        }
        ISortCriteria aCriteria = this.sortCriteriaList.get(selectionIndex);
        if (this.selByColButton.getSelection()) {
            SortByColumnCriteriaDialog dialog = new SortByColumnCriteriaDialog(this.editor, (SortByColumnCriteria)aCriteria);
            if (dialog.open() != 0) {
                this.setComplete(this.validateCriteriaSpecification());
                return;
            }
            this.sortCriteriaList.add(selectionIndex, dialog.getSortCriteria());
            this.sortCriteriaList.remove(selectionIndex + 1);
            this.setCriteriaTableContents(selectionIndex);
            this.setComplete(this.validateCriteriaSpecification());
        } else {
            SortByFieldRefCriteriaDialog dialog = new SortByFieldRefCriteriaDialog(this.editor, (SortByFieldCriteria)aCriteria);
            if (dialog.open() != 0) {
                this.setComplete(this.validateCriteriaSpecification());
                return;
            }
            this.sortCriteriaList.add(selectionIndex, dialog.getSortCriteria());
            this.sortCriteriaList.remove(selectionIndex + 1);
            this.setCriteriaTableContents(selectionIndex);
            this.setComplete(this.validateCriteriaSpecification());
        }
    }

    private void createColumns() {
        FormattedEditorUtility.createTableViewerColumn(Messages.SortDialog_CRITERIA, 200, this.sortCriteriaTableViewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.SortDialog_ORDER, 100, this.sortCriteriaTableViewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.SortDialog_TYPE, 150, this.sortCriteriaTableViewer, 131072);
    }

    private void enableCriteriaControls() {
        if (this.selByKeyButton.getSelection()) {
            return;
        }
        if (this.sortCriteriaTableViewer.getTable().getItemCount() > 0) {
            this.criteriaDelButton.setEnabled(true);
            this.criteriaUpButton.setEnabled(true);
            this.criteriaDownButton.setEnabled(true);
            this.criteriaUpdateButton.setEnabled(true);
        } else {
            this.criteriaDelButton.setEnabled(false);
            this.criteriaUpButton.setEnabled(false);
            this.criteriaDownButton.setEnabled(false);
            this.criteriaUpdateButton.setEnabled(false);
        }
    }

    private void enableCriteriaControls(boolean enable) {
        this.sortCriteriaTableViewer.getTable().setEnabled(enable);
        this.criteriaAddButton.setEnabled(enable);
        this.criteriaDelButton.setEnabled(enable);
        this.criteriaUpButton.setEnabled(enable);
        this.criteriaDownButton.setEnabled(enable);
        this.criteriaUpdateButton.setEnabled(enable);
    }

    private boolean validateCriteriaSpecification() {
        this.enableCriteriaControls();
        if (this.sortCriteriaList.isEmpty()) {
            this.setErrorMessage(Messages.SortDialog_NO_CRITERIA);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void setCriteriaTableContents(int selectionIndex) {
        this.sortCriteriaTableViewer.setInput(this.sortCriteriaList);
        if (this.sortCriteriaList.size() > 0) {
            this.sortCriteriaTableViewer.getTable().select(selectionIndex);
        }
    }

    public ArrayList<ISortCriteria> getSortCommands() {
        return this.sortCriteriaList;
    }

    public static String getSortCommandAsString(ArrayList<ISortCriteria> sortCriteriaList) {
        Objects.requireNonNull(sortCriteriaList, "Must specify a non-null sortCriteriaList.");
        StringBuilder sb = new StringBuilder(SORT_COMMAND);
        int i = 0;
        while (i < sortCriteriaList.size()) {
            ISortCriteria aCriteria = sortCriteriaList.get(i);
            if (i == 0) {
                sb.append(aCriteria.getSortCriteriaAsString());
            } else {
                sb.append(",");
                sb.append(" ");
                sb.append(aCriteria.getSortCriteriaAsString());
            }
            ++i;
        }
        return sb.toString();
    }

    protected void okPressed() {
        this.editor.setSortCriteria(this.sortCriteriaList);
        super.okPressed();
    }
}

