/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.dialogs.FieldInformation;
import com.ibm.etools.fm.editor.formatted.dialogs.ISortCriteria;
import com.ibm.etools.fm.editor.formatted.dialogs.SortByFieldCriteria;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class SortByFieldRefCriteriaDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private FormattedEditor editor = null;
    private String sortOrderSpec = "A";
    private List fieldSelectionList = null;
    private Button ascendingButton = null;
    private Button descendingButton = null;
    private ArrayList<FieldInformation> currentFields = null;
    private SortByFieldCriteria sortCriteria = null;
    private SortByFieldCriteria initCriteria = null;

    public SortByFieldRefCriteriaDialog(FormattedEditor editor, SortByFieldCriteria initCriteria) {
        this.editor = editor;
        this.initCriteria = initCriteria;
        this.currentFields = FormattedEditorUtility.getCurrentFieldInformation(editor);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.SortByFieldRefCriteriaDialog_TITLE);
        this.setMessage(Messages.SortByFieldRefCriteriaDialog_MSG);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createOrderComposite(composite);
        this.createFieldSectionListComposite(composite);
        this.initFields();
        this.setComplete(this.validateFieldSelection());
        return composite;
    }

    private void createOrderComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.ascendingButton = GUI.button.radio((Composite)composite, (String)Messages.SortDialog_ASC, (Object)GUI.grid.d.left1());
        this.ascendingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SortByFieldRefCriteriaDialog.this.sortOrderSpec = "A";
                SortByFieldRefCriteriaDialog.this.validateFieldSelection();
            }
        });
        this.descendingButton = GUI.button.radio((Composite)composite, (String)Messages.SortDialog_DSC, (Object)GUI.grid.d.left1());
        this.descendingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SortByFieldRefCriteriaDialog.this.sortOrderSpec = "D";
                SortByFieldRefCriteriaDialog.this.validateFieldSelection();
            }
        });
    }

    private void createFieldSectionListComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)composite, (String)MessageFormat.format(Messages.SortByFieldRefCriteriaDialog_FIELD, this.editor.getLayoutName(this.editor.getActiveLayoutID())), (Object)GUI.grid.d.left1());
        this.fieldSelectionList = new List(composite, 772);
        GridData gd = GUI.grid.d.fillAll();
        gd.heightHint = 300;
        gd.widthHint = 300;
        this.fieldSelectionList.setLayoutData((Object)gd);
        String[] items = new String[this.currentFields.size()];
        int i = 0;
        while (i < this.currentFields.size()) {
            items[i] = this.currentFields.get(i).getName();
            ++i;
        }
        this.fieldSelectionList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SortByFieldRefCriteriaDialog.this.setComplete(SortByFieldRefCriteriaDialog.this.validateFieldSelection());
            }
        });
        this.fieldSelectionList.setItems(items);
        this.fieldSelectionList.select(0);
    }

    private void initFields() {
        if (this.initCriteria == null) {
            return;
        }
        if ("A".equals(this.initCriteria.getSortOrder())) {
            this.ascendingButton.setSelection(true);
            this.sortOrderSpec = "A";
        } else {
            this.descendingButton.setSelection(true);
            this.sortOrderSpec = "D";
        }
        this.fieldSelectionList.select(this.initCriteria.getFieldInformation().getIndex());
    }

    private boolean validateFieldSelection() {
        int currentSelection = this.fieldSelectionList.getSelectionIndex();
        FieldInformation info = this.currentFields.get(currentSelection);
        this.sortCriteria = new SortByFieldCriteria(info, this.sortOrderSpec);
        return true;
    }

    public ISortCriteria getSortCriteria() {
        return this.sortCriteria;
    }
}

