/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.dialogs.ISortCriteria;
import com.ibm.etools.fm.editor.formatted.dialogs.SortByColumnCriteria;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPageUtility;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.text.MessageFormat;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SortByColumnCriteriaDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private FormattedEditor editor = null;
    private String sortOrderSpec = "A";
    private Text startColumnText = null;
    private Text endColumnText = null;
    private Button ascendingButton = null;
    private Button descendingButton = null;
    private SortByColumnCriteria initCriteria = null;
    private SortByColumnCriteria sortCriteria = null;

    public SortByColumnCriteriaDialog(FormattedEditor editor, SortByColumnCriteria initCriteria) {
        this.editor = editor;
        this.initCriteria = initCriteria;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.SortByColumnCriteriaDialog_TITLE);
        this.setMessage(Messages.SortByColumnCriteriaDialog_MSG);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createOrderComposite(composite);
        this.createColumnsEntryComposite(composite);
        this.initValues();
        this.setComplete(this.validateEntry());
        return composite;
    }

    private void createOrderComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.ascendingButton = GUI.button.radio((Composite)composite, (String)Messages.SortDialog_ASC, (Object)GUI.grid.d.left1());
        this.ascendingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SortByColumnCriteriaDialog.this.sortOrderSpec = "A";
                SortByColumnCriteriaDialog.this.setComplete(SortByColumnCriteriaDialog.this.validateEntry());
            }
        });
        this.descendingButton = GUI.button.radio((Composite)composite, (String)Messages.SortDialog_DSC, (Object)GUI.grid.d.left1());
        this.descendingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SortByColumnCriteriaDialog.this.sortOrderSpec = "D";
                SortByColumnCriteriaDialog.this.setComplete(SortByColumnCriteriaDialog.this.validateEntry());
            }
        });
    }

    private void createColumnsEntryComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.SortByColumnCriteriaDialog_START, (Object)GUI.grid.d.left1());
        this.startColumnText = GUI.text.field((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        this.startColumnText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                FormattedPageUtility.digitEntryTextValue(e);
            }
        });
        this.startColumnText.setText("1");
        this.startColumnText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent arg0) {
                SortByColumnCriteriaDialog.this.setComplete(SortByColumnCriteriaDialog.this.validateEntry());
            }
        });
        GUI.label.left((Composite)composite, (String)Messages.SortByColumnCriteriaDialog_END, (Object)GUI.grid.d.left1());
        this.endColumnText = GUI.text.field((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        this.endColumnText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                FormattedPageUtility.digitEntryTextValue(e);
            }
        });
        this.endColumnText.setText("" + this.editor.getSessionProperties().getMaxRECL());
        this.endColumnText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent arg0) {
                SortByColumnCriteriaDialog.this.setComplete(SortByColumnCriteriaDialog.this.validateEntry());
            }
        });
        this.startColumnText.selectAll();
        this.startColumnText.setFocus();
    }

    private void initValues() {
        if (this.initCriteria == null) {
            this.ascendingButton.setSelection(true);
            this.sortOrderSpec = "A";
            return;
        }
        this.startColumnText.setText("" + this.initCriteria.getStartColumn());
        this.endColumnText.setText("" + this.initCriteria.getEndColumn());
        if ("A".equals(this.initCriteria.getSortOrder())) {
            this.ascendingButton.setSelection(true);
            this.sortOrderSpec = "A";
        } else {
            this.descendingButton.setSelection(true);
            this.sortOrderSpec = "D";
        }
    }

    private boolean validateEntry() {
        String startValue = this.startColumnText.getText();
        if (startValue.isEmpty()) {
            this.setErrorMessage(Messages.SortByColumnCriteriaDialog_NO_START);
            return false;
        }
        int startColumnNo = Integer.parseInt(startValue);
        if (startColumnNo == 0) {
            this.setErrorMessage(Messages.SortByColumnCriteriaDialog_ZERO_START);
            return false;
        }
        if (startColumnNo > this.editor.getSessionProperties().getMaxRECL()) {
            this.setErrorMessage(MessageFormat.format(Messages.SortByColumnCriteriaDialog_START_TOO_BIG, this.editor.getSessionProperties().getMaxRECL()));
            return false;
        }
        String endValue = this.endColumnText.getText();
        if (endValue.isEmpty()) {
            this.setErrorMessage(Messages.SortByColumnCriteriaDialog_NO_END);
            return false;
        }
        int endColumnNo = Integer.parseInt(endValue);
        if (endColumnNo == 0) {
            this.setErrorMessage(Messages.SortByColumnCriteriaDialog_ZERO_END);
            return false;
        }
        if (endColumnNo > this.editor.getSessionProperties().getMaxRECL()) {
            this.setErrorMessage(MessageFormat.format(Messages.SortByColumnCriteriaDialog_END_TOO_BIG, this.editor.getSessionProperties().getMaxRECL()));
            return false;
        }
        if (startColumnNo > endColumnNo) {
            this.setErrorMessage(MessageFormat.format(Messages.SortByColumnCriteriaDialog_END_BIGGER_THAN_START, startColumnNo, endColumnNo));
            return false;
        }
        this.sortCriteria = new SortByColumnCriteria(startColumnNo, endColumnNo, this.sortOrderSpec);
        this.setErrorMessage(null);
        return true;
    }

    public ISortCriteria getSortCriteria() {
        return this.sortCriteria;
    }
}

