/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.dialogs.FieldInformation;
import com.ibm.etools.fm.editor.template1.StringArrayElementTableLabelProvider;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;

public class SingleFieldSelectionDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private FormattedEditor editor = null;
    private Layouttype activeLayout = null;
    private Table fieldTable = null;
    private TableViewer fieldTableViewer = null;
    ArrayList<FieldInformation> fieldsInfo = null;
    private ArrayList<Integer> fieldListIndex = null;
    private int selectedFieldIndex = 0;
    private Combo wFilter;

    public SingleFieldSelectionDialog(FormattedEditor editor) {
        this.editor = editor;
        this.activeLayout = editor.getActiveLayout();
        this.selectedFieldIndex = 0;
    }

    protected Control createDialogArea(Composite parent) {
        this.fieldsInfo = FormattedEditorUtility.getCurrentFieldInformation(this.editor);
        this.fieldListIndex = this.fieldsInfo.size() > 0 ? new ArrayList(this.fieldsInfo.size()) : new ArrayList();
        this.setTitle(Messages.SingleFieldSelectionDialog_TITLE);
        this.setMessage(MessageFormat.format(Messages.SingleFieldSelectionDialog_MSG, this.editor.getTemplateResource().getFormattedName()));
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.wFilter = this.createFilter(composite);
        this.prepareFieldSelctionList(composite);
        this.setComplete(true);
        return composite;
    }

    private void prepareFieldSelctionList(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.fieldTable = new Table(composite, 68356);
        this.fieldTable.setHeaderVisible(true);
        this.fieldTable.setLinesVisible(true);
        this.fieldTable.setLayoutData((Object)GUI.grid.d.fillAll());
        this.fieldTableViewer = new TableViewer(this.fieldTable);
        this.fieldTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        SingleFieldSelectionDialog.createFieldTableColumns(this.fieldTableViewer);
        this.fieldTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SingleFieldSelectionDialog.this.selectedFieldIndex = SingleFieldSelectionDialog.this.fieldListIndex.get(SingleFieldSelectionDialog.this.fieldTable.getSelectionIndex());
            }
        });
        this.filterItems();
    }

    private static void createFieldTableColumns(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn(Messages.SingleFieldSelectionDialog_Reference, 100, viewer, 0x1000000);
        FormattedEditorUtility.createTableViewerColumn(Messages.SingleFieldSelectionDialog_Name, 400, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.SingleFieldSelectionDialog_Type, 100, viewer, 0x1000000);
        FormattedEditorUtility.createTableViewerColumn(Messages.SingleFieldSelectionDialog_Strat_Length, 100, viewer, 0x1000000);
        viewer.setLabelProvider((IBaseLabelProvider)new StringArrayElementTableLabelProvider());
    }

    private void filterItems() {
        if (this.fieldTable == null) {
            return;
        }
        this.fieldTable.removeAll();
        this.fieldListIndex.clear();
        String filter = StringUtils.makeFilterRegExp((String)this.wFilter.getText());
        ArrayList<String[]> fieldsContents = new ArrayList<String[]>();
        int i = 0;
        while (i < this.fieldsInfo.size()) {
            String fieldName = this.fieldsInfo.get(i).getName();
            if (fieldName.matches(filter)) {
                FieldInformation fieldInfo = this.fieldsInfo.get(i);
                Symboltype fieldSymbol = fieldInfo.getSymbol();
                fieldsContents.add(new String[]{Integer.toString(fieldSymbol.getRef() - this.activeLayout.getId() + 1), fieldSymbol.getName(this.editor.getSystem()), fieldSymbol.getType().getName(), fieldSymbol.getStart() + ":" + fieldSymbol.getLength()});
                this.fieldListIndex.add(new Integer(i));
            }
            ++i;
        }
        this.fieldTableViewer.setInput(fieldsContents);
        this.fieldTable.select(0);
        if (this.fieldListIndex.size() > 0) {
            this.selectedFieldIndex = this.fieldListIndex.get(0);
        }
    }

    private Combo createFilter(Composite parent) {
        Composite filterComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)filterComposite, (String)Messages.SingleFieldSelectionDialog_Filter, (Object)GUI.grid.d.left1());
        final Combo filter = GUI.combo.editable((Composite)filterComposite, (Object)GUI.grid.d.fillAll());
        Listener filterTraverseListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    try {
                        filter.add(filter.getText());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    event.doit = false;
                }
            }
        };
        filter.addListener(31, filterTraverseListener);
        Listener filterModifyListener = new Listener(){

            public void handleEvent(Event event) {
                SingleFieldSelectionDialog.this.filterItems();
            }
        };
        filter.addListener(24, filterModifyListener);
        filter.setToolTipText(Messages.SingleFieldSelectionDialog_TOOLTIP_FILTER);
        new ComboValueSaver(filter, ((Object)((Object)this)).getClass().getCanonicalName() + "Filter");
        return filter;
    }

    public int getSelectedFieldIndex() {
        return this.selectedFieldIndex + 1;
    }
}

