/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ShowDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private IFMEditor editor;
    private Button showNotSelectedRecordsButton = null;
    private Button showSuppressedRecordsButton = null;
    private Button shadowExButton = null;
    private Button shadowNotButton = null;
    private Button shadowSupButton = null;
    private ArrayList<String> commands = null;

    public ShowDialog(IFMEditor editor) {
        this.editor = editor;
    }

    private void enableControls() {
        if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            this.showNotSelectedRecordsButton.setEnabled(false);
            this.showSuppressedRecordsButton.setEnabled(false);
            this.shadowExButton.setEnabled(true);
            this.shadowNotButton.setEnabled(false);
            this.shadowSupButton.setEnabled(false);
        }
        if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.IMS) {
            this.showNotSelectedRecordsButton.setEnabled(false);
            this.showSuppressedRecordsButton.setEnabled(true);
            this.shadowExButton.setEnabled(false);
            this.shadowNotButton.setEnabled(false);
            this.shadowSupButton.setEnabled(false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.setTitle(Messages.ShowDialog_TITLE);
        this.setMessage(Messages.ShowDialog_MSG);
        this.createShowGroupComposite(composite);
        this.createShadowGroupComposite(composite);
        this.enableControls();
        return composite;
    }

    private void createShowGroupComposite(Composite parent) {
        Group group = GUI.group((Composite)parent, (String)Messages.ShowDialog_SHOW_GROUP, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.showNotSelectedRecordsButton = new Button((Composite)group, 32);
        this.showNotSelectedRecordsButton.setText(Messages.ShowDialog_SHOW_NOT);
        this.showSuppressedRecordsButton = new Button((Composite)group, 32);
        this.showSuppressedRecordsButton.setText(Messages.ShowDialog_SHOW_SUP);
        this.showNotSelectedRecordsButton.setSelection(this.editor.isShowNotSelectedRecords());
        this.showSuppressedRecordsButton.setSelection(this.editor.isShowSuppressedRecords());
        if (this.editor.getTemplateResource() == null) {
            this.showNotSelectedRecordsButton.setEnabled(false);
            this.showSuppressedRecordsButton.setEnabled(false);
        }
    }

    private void createShadowGroupComposite(Composite parent) {
        Group group = GUI.group((Composite)parent, (String)Messages.ShowDialog_SHADOW_GROUP, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.shadowExButton = new Button((Composite)group, 32);
        this.shadowExButton.setText(Messages.ShowDialog_EX);
        this.shadowNotButton = new Button((Composite)group, 32);
        this.shadowNotButton.setText(Messages.ShowDialog_NOT);
        this.shadowSupButton = new Button((Composite)group, 32);
        this.shadowSupButton.setText(Messages.ShowDialog_SUP);
        this.shadowExButton.setSelection(this.editor.isDisplayShadowLinesForEx());
        this.shadowNotButton.setSelection(this.editor.isDisplayShadowLinesForNot());
        this.shadowSupButton.setSelection(this.editor.isDisplayShadowLinesForSup());
    }

    protected void okPressed() {
        this.commands = new ArrayList();
        if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            if (this.shadowExButton.getSelection()) {
                this.editor.setDisplayShdowLinesForEx(true);
                this.commands.add("SHADOW EX ON");
            } else {
                this.editor.setDisplayShdowLinesForEx(false);
                this.commands.add("SHADOW EX OFF");
            }
            super.okPressed();
            return;
        }
        if (this.editor.getTemplateResource() != null) {
            if (this.showNotSelectedRecordsButton.getSelection()) {
                this.editor.setShowNotSelectedRecords(true);
                this.commands.add("SHOW NOT ON");
            } else {
                this.editor.setShowNotSelectedRecords(false);
                this.commands.add("SHOW NOT OFF");
            }
            if (this.showSuppressedRecordsButton.getSelection()) {
                this.editor.setShowSuppressedRecords(true);
                this.commands.add("SHOW SUP ON");
            } else {
                this.editor.setShowSuppressedRecords(false);
                this.commands.add("SHOW SUP OFF");
            }
        }
        if (this.shadowExButton.getSelection()) {
            this.editor.setDisplayShdowLinesForEx(true);
            this.commands.add("SHADOW EX ON");
        } else {
            this.editor.setDisplayShdowLinesForEx(false);
            this.commands.add("SHADOW EX OFF");
        }
        if (this.shadowNotButton.getSelection()) {
            this.editor.setDisplayShdowLinesForNot(true);
            this.commands.add("SHADOW NOT ON");
        } else {
            this.editor.setDisplayShdowLinesForNot(false);
            this.commands.add("SHADOW NOT OFF");
        }
        if (this.shadowSupButton.getSelection()) {
            this.editor.setDisplayShdowLinesForSup(true);
            this.commands.add("SHADOW SUP ON");
        } else {
            this.editor.setDisplayShdowLinesForSup(false);
            this.commands.add("SHADOW SUP OFF");
        }
        super.okPressed();
    }

    public ArrayList<String> getShowCommands() {
        return this.commands;
    }
}

