/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.HostVersion;
import com.ibm.etools.fm.core.socket.func.SetCCSID;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.NavigationSpecification;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.dialogs.FieldSelectionDialog;
import com.ibm.etools.fm.editor.formatted.dialogs.FindColumnLimitDialog;
import com.ibm.etools.fm.editor.formatted.dialogs.FormattedEditorDialogUtils;
import com.ibm.etools.fm.editor.formatted1.ImsEditor;
import com.ibm.etools.fm.editor.formatted1.dialogs.ImsSegmentSelectionDialog;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDBiDiHelpers;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;

public class FindReplaceDialog
extends Dialog
implements ModifyListener,
SelectionListener,
IPropertyListener {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(FindReplaceDialog.class);
    private static final String FIND_COMMAND = "FIND ";
    private static final String FIND_NOT_COMMAND = "FNOT ";
    private static final String CHANGE_COMMAND = "CHANGE ";
    private static final String CHANGE_NOT_COMMAND = "CNOT ";
    private static final String RESET_COMMAND = "RESET FIND";
    private static final String REPLACE_SUCCESS_MESSAGE_ID = "FMNBE879";
    private static final String REPLACE_SUCCESS_WITH_WARNING_MESSAGE_ID = "FMNBE683";
    private static final String FIND_RESULT_FORMATTED_MESSAGE_ID = "FMNBC026";
    private static final String FIND_RESULT_CHAR_MESSAGE_ID = "FMNBC027";
    private final IFMEditor editor;
    private final String resourceName;
    private Combo findCombo;
    private Combo replaceCombo;
    private Text selectedRange;
    private Button bFind;
    private Button bReset;
    private Button bReplace;
    private Button bCloseWindow;
    private Text statusMessage;
    private Button srchOptsCaseSensitiveButton;
    private Button srchOptsHexSearchButton;
    private Button srchOptsPictureSearchButton;
    private Button srchOptsConvertToHexButton;
    private Button srchRegexOptionButton;
    private Button srchOptsNullButton;
    private Button repOptsCaseSensitiveButton;
    private Button repOptsHexSearchButton;
    private Button repOptsPictureSearchButton;
    private Button repOptsConvertToHexButton;
    private Button repOptsNullButton;
    private Button findOptsNextButton;
    private Button findOptsAllButton;
    private Button findOptsPrevButton;
    private Button findOptsFirstButton;
    private Button findOptsLastButton;
    private String findOptsValue = "NEXT";
    private Button findNotOptionButton;
    private Button matchOptsCharsButton;
    private Button matchOptsPrefixButton;
    private Button matchOptsSuffixButton;
    private Button matchOptsWordButton;
    private String matchOptsValue = "CHAR";
    private Button scopeAllButton;
    private Button scopeExButton;
    private Button scopeNotExButton;
    private String scopeValue = "";
    private Text selectedSegment;
    private Button imsScopeDatabase;
    private Button imsScopeRecord;
    private Button imsScopeDependent;
    private String prevSearchCommand = "";

    public FindReplaceDialog(Shell parentShell, IFMEditor editor, String resourceName) {
        super(parentShell);
        super.setShellStyle(1248);
        this.editor = editor;
        this.resourceName = resourceName;
        editor.addPropertyListener(this);
    }

    protected Point getInitialLocation(Point initialSize) {
        return new Point(10, initialSize.y);
    }

    protected Control createContents(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createEntryComposite(composite);
        this.createImsOptionsComposite(composite);
        this.createOptionsComposite(composite);
        this.createButtonsComposite(composite);
        this.statusMessage = GUI.text.areaReadOnly((Composite)composite, (Object)GUI.grid.d.fillAll());
        return parent;
    }

    private void createEntryComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.FindReplace_FIND_FIELD, (Object)GUI.grid.d.left1());
        this.findCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)2));
        new ComboValueSaver(this.findCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "find");
        FormattedEditorDialogUtils.addInsertNotCharacterListener(this.findCombo);
        GUI.label.left((Composite)composite, (String)Messages.FindReplace_REPLACE_WITH, (Object)GUI.grid.d.left1());
        this.replaceCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)2));
        new ComboValueSaver(this.replaceCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "replace");
        GUI.label.left((Composite)composite, (String)Messages.FindReplace_SRCH_RANGE, (Object)GUI.grid.d.left1());
        this.selectedRange = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        Composite rangeButtonComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.noMargins((int)2, (boolean)true), (Object)GUI.grid.d.fillH((int)1));
        Button fieldButton = GUI.button.push((Composite)rangeButtonComposite, (String)Messages.FindReplace_FIELD_SEL_BUTTON, (Object)GUI.grid.d.fillAll());
        fieldButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldSelectionDialog page = new FieldSelectionDialog(FindReplaceDialog.this.editor, FindReplaceDialog.this.selectedRange.getText());
                if (page.open() != 0) {
                    return;
                }
                FindReplaceDialog.this.selectedRange.setText(page.getSelection());
            }
        });
        if (this.editor.getTemplateResource() == null) {
            fieldButton.setEnabled(false);
        }
        Button colButton = GUI.button.push((Composite)rangeButtonComposite, (String)Messages.FindReplace_COL_SEL_BUTTON, (Object)GUI.grid.d.fillAll());
        colButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FindColumnLimitDialog dialog = new FindColumnLimitDialog(FindReplaceDialog.this.editor.getSessionProperties().getMaxRECL(), FindReplaceDialog.this.selectedRange.getText());
                if (dialog.open() != 0) {
                    return;
                }
                FindReplaceDialog.this.selectedRange.setText(dialog.getSelectedColumnRange());
            }
        });
        if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            colButton.setEnabled(false);
        }
        if (!this.editor.isEditSession()) {
            this.replaceCombo.setEnabled(false);
        }
        if (this.editor.getTemplateResource() == null) {
            fieldButton.setEnabled(false);
            this.selectedRange.setText("1 " + this.editor.getSessionProperties().getMaxRECL());
        } else if (this.editor instanceof FormattedEditor) {
            FormattedEditor fEditor = (FormattedEditor)this.editor;
            if (fEditor.getCurrentEditorMode() == IFMEditor.EditorMode.CHARACTER) {
                this.selectedRange.setText("1 " + fEditor.getSessionProperties().getMaxRECL());
            } else {
                this.selectedRange.setText("#ALL");
            }
        } else {
            this.selectedRange.setText("#ALL");
        }
    }

    private void createOptionsComposite(Composite parent) {
        Composite optionsComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false), (Object)GUI.grid.d.vert((int)128, (boolean)false, (int)1));
        Composite findOptsComposite = GUI.composite((Composite)optionsComposite, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.vert((int)128, (boolean)false, (int)1));
        this.createFindOptions(findOptsComposite);
        Composite patternComposite = GUI.composite((Composite)optionsComposite, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.vert((int)128, (boolean)false, (int)1));
        Group srchOptions = GUI.group((Composite)patternComposite, (String)Messages.FindReplace_SRCH_OPS, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.createSearchStringOptions(srchOptions);
        Group replaceOptions = GUI.group((Composite)patternComposite, (String)Messages.FindReplace_REP_OPS, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.createReplaceStringOptions(replaceOptions);
        Group matchOptions = GUI.group((Composite)optionsComposite, (String)Messages.FindReplace_MATCH_OPS, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.createMatchOptions(matchOptions);
        Group scopeOptions = GUI.group((Composite)optionsComposite, (String)Messages.FindReplace_SCOPE_OPS, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.vert((int)128, (boolean)true, (int)1));
        this.createFindScopeGroup(scopeOptions);
    }

    private void createImsOptionsComposite(Composite parent) {
        if (this.editor.getSessionIdentifier().getSessionType() != AbstractSessionFormatted.SessionType.IMS) {
            return;
        }
        Group group = GUI.group((Composite)parent, (String)Messages.FindReplaceDialog_0, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)group, (String)Messages.FindReplaceDialog_1, (Object)GUI.grid.d.left1());
        this.selectedSegment = GUI.text.fieldReadOnly((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        Button segSelectionButton = GUI.button.push((Composite)group, (String)Messages.FindReplaceDialog_2, (Object)GUI.grid.d.left1());
        segSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!FindReplaceDialog.this.editor.isShowSuppressedRecords()) {
                    PDDialogs.openInfoThreadSafe((String)Messages.FindReplaceDialog_3);
                    return;
                }
                ImsSegmentSelectionDialog dialog = new ImsSegmentSelectionDialog(FindReplaceDialog.this.editor.getSessionIdentifier().getImsEditOptions(), ((ImsEditor)FindReplaceDialog.this.editor).getImsSegmentInformation().getDatabaseInfo(), FindReplaceDialog.this.selectedSegment.getText());
                if (dialog.open() != 0) {
                    return;
                }
                FindReplaceDialog.this.selectedSegment.setText(dialog.getSelectedSegmentName());
            }
        });
        Group imsSearchScopeGroup = GUI.group((Composite)group, (String)Messages.FindReplaceDialog_4, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillH((int)3));
        Composite imsScopeComposite = GUI.composite((Composite)imsSearchScopeGroup, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        this.imsScopeDatabase = GUI.button.radio((Composite)imsScopeComposite, (String)Messages.FindReplaceDialog_5, (Object)GUI.grid.d.fillH((int)1));
        this.imsScopeDatabase.setToolTipText(Messages.FindReplaceDialog_6);
        this.imsScopeDatabase.setSelection(true);
        this.imsScopeRecord = GUI.button.radio((Composite)imsScopeComposite, (String)Messages.FindReplaceDialog_7, (Object)GUI.grid.d.fillH((int)1));
        this.imsScopeRecord.setToolTipText(Messages.FindReplaceDialog_8);
        this.imsScopeDependent = GUI.button.radio((Composite)imsScopeComposite, (String)Messages.FindReplaceDialog_9, (Object)GUI.grid.d.fillH((int)1));
        this.imsScopeDependent.setToolTipText(Messages.FindReplaceDialog_10);
    }

    private void createButtonsComposite(Composite parent) {
        Composite buttonBar = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)true), (Object)GUI.grid.d.horiz((int)131072, (boolean)false, (int)1));
        this.bFind = GUI.button.push((Composite)buttonBar, (String)Messages.FindReplace_FIND_BUTTON, (Object)GUI.grid.d.fillH((int)1));
        this.bFind.addSelectionListener((SelectionListener)this);
        this.bReplace = GUI.button.push((Composite)buttonBar, (String)Messages.FindReplace_REPLACE_BUTTON, (Object)GUI.grid.d.fillH((int)1));
        this.bReplace.addSelectionListener((SelectionListener)this);
        this.bReset = GUI.button.push((Composite)buttonBar, (String)Messages.FindReplace_RESET_BUTTON, (Object)GUI.grid.d.fillH((int)1));
        this.bReset.addSelectionListener((SelectionListener)this);
        this.bCloseWindow = GUI.button.push((Composite)buttonBar, (String)JFaceResources.getString((String)"close"), (Object)GUI.grid.d.fillH((int)1));
        this.bCloseWindow.addSelectionListener((SelectionListener)this);
        parent.addFocusListener((FocusListener)new FocusAdapter(){});
        if (!this.editor.isEditSession()) {
            this.bReplace.setEnabled(false);
            this.repOptsCaseSensitiveButton.setEnabled(false);
            this.repOptsHexSearchButton.setEnabled(false);
            this.repOptsPictureSearchButton.setEnabled(false);
            this.repOptsConvertToHexButton.setEnabled(false);
            if (this.repOptsNullButton != null) {
                this.repOptsNullButton.setEnabled(false);
            }
        }
        this.getShell().setDefaultButton(this.bFind);
    }

    public void modifyText(ModifyEvent e) {
        if (this.findCombo != null && !this.findCombo.isDisposed() && this.findCombo.getText() != null && !this.findCombo.getText().equals("")) {
            this.bFind.setEnabled(true);
            if (this.replaceCombo != null && !this.replaceCombo.isDisposed() && this.replaceCombo.getText() != null) {
                this.bReplace.setEnabled(true);
            } else {
                this.bReplace.setEnabled(false);
            }
        } else {
            this.bFind.setEnabled(false);
            this.bReplace.setEnabled(false);
        }
    }

    public void widgetSelected(SelectionEvent se) {
        if (!(se.getSource() instanceof Button)) {
            return;
        }
        Button bSource = (Button)se.getSource();
        if (bSource == this.bCloseWindow) {
            this.close();
        } else if (bSource == this.bFind) {
            this.doFind();
        } else if (bSource == this.bReplace) {
            this.doReplace();
        } else if (bSource == this.bReset) {
            this.doReset();
        }
    }

    private void doFind() {
        String options = this.prepareFindOptions(false);
        if (options == null) {
            return;
        }
        String cmd = FIND_COMMAND + options;
        if (this.editor.getSessionIdentifier().getSessionType() != AbstractSessionFormatted.SessionType.IMS && this.findNotOptionButton.getSelection()) {
            cmd = FIND_NOT_COMMAND + options;
        }
        if (PDBiDiHelpers.isResourceEncodingBiDi((IZRL)this.editor.getResource())) {
            this.editor.setFindActive(true);
        }
        this.doExecute(cmd);
    }

    private boolean doReplace() {
        String options = this.prepareFindOptions(true);
        if (options == null) {
            return false;
        }
        String cmd = CHANGE_COMMAND + options;
        if (this.editor.getSessionIdentifier().getSessionType() != AbstractSessionFormatted.SessionType.IMS && this.findNotOptionButton.getSelection()) {
            cmd = CHANGE_NOT_COMMAND + options;
        }
        this.doExecute(cmd);
        if (PDBiDiHelpers.isResourceEncodingBiDi((IZRL)this.editor.getResource())) {
            this.editor.setFindActive(true);
        }
        return true;
    }

    private void doReset() {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    String cmdToExecute = FindReplaceDialog.RESET_COMMAND;
                    FindReplaceDialog.this.prevSearchCommand = FindReplaceDialog.RESET_COMMAND;
                    monitor.beginTask(MessageFormat.format(Messages.FindReplaceDialog_EX, cmdToExecute), 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    Result result = FindReplaceDialog.this.editor.getSessionIdentifier().sendCommand(cmdToExecute, null, howIsGoing);
                    if (result.getRC() >= 8) {
                        FindReplaceDialog.this.setStatusMessageThreadSafe(PDBiDiHelpers.translateIfBidiRequired((IZRL)FindReplaceDialog.this.editor.getResource(), (String)result.getMessagesCombined().toString(), (boolean)false), false);
                    } else {
                        FindReplaceDialog.this.setStatusMessageThreadSafe(MessageFormat.format(Messages.FindReplaceDialog_RESET, FindReplaceDialog.RESET_COMMAND), false);
                    }
                    monitor.worked(1);
                    if (!FindReplaceDialog.this.editor.loadRecordsFromHost(howIsGoing)) {
                        return;
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            PDDialogs.openErrorThreadSafe((String)Messages.FindReplaceWindow_EXEC_ERR_MSG, (String)MessageFormat.format(Messages.FindReplaceWindow_EXEC_ERR_TITLE, RESET_COMMAND), (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
            this.editor.disableEditorActions();
            return;
        }
        if (PDBiDiHelpers.isResourceEncodingBiDi((IZRL)this.editor.getResource())) {
            this.editor.setFindActive(false);
        }
    }

    private void doExecute(final String command) {
        final StringBuilder firstHitFormattedInfo = new StringBuilder();
        final boolean isRegexSelected = this.srchRegexOptionButton != null ? this.srchRegexOptionButton.getSelection() : false;
        final StringBuilder firstHitCharInfo = new StringBuilder();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    String foundLocation;
                    String cmdToExecute = command;
                    if (FindReplaceDialog.this.prevSearchCommand.equals(cmdToExecute)) {
                        if (cmdToExecute.startsWith(FindReplaceDialog.FIND_COMMAND) || cmdToExecute.startsWith(FindReplaceDialog.FIND_NOT_COMMAND)) {
                            cmdToExecute = "RFIND";
                        } else if (command.startsWith("CHANGE") || cmdToExecute.startsWith(FindReplaceDialog.CHANGE_NOT_COMMAND)) {
                            cmdToExecute = "RCHANGE";
                        }
                    }
                    FindReplaceDialog.this.prevSearchCommand = command;
                    String desc = MessageFormat.format(Messages.FindReplaceDialog_EX, cmdToExecute);
                    monitor.beginTask(desc, 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    FindReplaceDialog.this.setStatusMessageThreadSafe(desc + "\n", true);
                    boolean contentChanged = false;
                    if (isRegexSelected) {
                        SetCCSID setccsid = new SetCCSID();
                        String codePage = FindReplaceDialog.this.editor.getSystem().getCodePage();
                        String numericPart = codePage.replaceAll("\\D", "");
                        String padded = String.format("%05d", Integer.parseInt(numericPart));
                        setccsid.setCCSID(padded);
                        Result result = UtilityFunctionRunner.execute((IPDHost)FindReplaceDialog.this.editor.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)FindReplaceDialog.this.editor.getSystem()), (UtilityFunction)setccsid, (IHowIsGoing)howIsGoing);
                        if (result.getRC() != 0) {
                            return;
                        }
                    }
                    Result result = FindReplaceDialog.this.editor.getSessionIdentifier().sendCommand(cmdToExecute, null, howIsGoing);
                    monitor.worked(1);
                    if (result.getRC() >= 8) {
                        FindReplaceDialog.this.setStatusMessageThreadSafe(PDBiDiHelpers.translateIfBidiRequired((IZRL)FindReplaceDialog.this.editor.getResource(), (String)result.getMessagesCombined().toString(), (boolean)false), true);
                        if (!FindReplaceDialog.this.editor.loadRecordsFromHost(howIsGoing)) {
                            return;
                        }
                        return;
                    }
                    String msg = PDBiDiHelpers.translateIfBidiRequired((IZRL)FindReplaceDialog.this.editor.getResource(), (String)result.getMessagesCombined().toString(), (boolean)false);
                    FindReplaceDialog.this.setStatusMessageThreadSafe(msg, true);
                    if (msg.indexOf(FindReplaceDialog.REPLACE_SUCCESS_MESSAGE_ID) != -1) {
                        contentChanged = true;
                        FindReplaceDialog.this.editor.setDirty(contentChanged);
                    } else if (msg.indexOf(FindReplaceDialog.REPLACE_SUCCESS_WITH_WARNING_MESSAGE_ID) != -1) {
                        contentChanged = true;
                        FindReplaceDialog.this.editor.setDirty(contentChanged);
                    }
                    String messages = PDBiDiHelpers.translateIfBidiRequired((IZRL)FindReplaceDialog.this.editor.getResource(), (String)result.getMessagesCombined().toString(), (boolean)false);
                    if (messages.indexOf(FindReplaceDialog.FIND_RESULT_CHAR_MESSAGE_ID) != -1) {
                        foundLocation = messages.substring(messages.indexOf(FindReplaceDialog.FIND_RESULT_CHAR_MESSAGE_ID));
                        foundLocation = foundLocation.contains("\n") ? foundLocation.substring(0, foundLocation.indexOf("\n")) : foundLocation.substring(0, foundLocation.length());
                        firstHitCharInfo.append(foundLocation);
                    }
                    if (messages.indexOf(FindReplaceDialog.FIND_RESULT_FORMATTED_MESSAGE_ID) != -1) {
                        foundLocation = messages.substring(messages.indexOf(FindReplaceDialog.FIND_RESULT_FORMATTED_MESSAGE_ID));
                        foundLocation = foundLocation.contains("\n") ? foundLocation.substring(0, foundLocation.indexOf("\n")) : foundLocation.substring(0, foundLocation.length());
                        firstHitFormattedInfo.append(foundLocation);
                    }
                    if (!FindReplaceDialog.this.editor.loadRecordsFromHost(howIsGoing)) {
                        return;
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            PDDialogs.openErrorThreadSafe((String)Messages.FindReplaceWindow_EXEC_ERR_MSG, (String)MessageFormat.format(Messages.FindReplaceWindow_EXEC_ERR_TITLE, command), (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
            this.editor.disableEditorActions();
            return;
        }
        if (this.editor.getCurrentEditorContents().isEmpty()) {
            return;
        }
        if (this.editor instanceof FormattedEditor) {
            FormattedEditor fEditor = (FormattedEditor)this.editor;
            if (fEditor.getCurrentEditorMode() == IFMEditor.EditorMode.FORMATTED) {
                if (firstHitFormattedInfo.length() > 0) {
                    String aLine = firstHitFormattedInfo.toString();
                    String field = aLine.substring(aLine.indexOf("at field"));
                    field = field.substring("at field".length(), field.indexOf(44)).trim();
                    DisplayLine recToken = this.editor.getCurrentEditorContents().get(0);
                    this.editor.setCursor(new NavigationSpecification(recToken, Integer.parseInt(field), true));
                }
            } else if (firstHitCharInfo.length() > 0) {
                String aLine = firstHitCharInfo.toString();
                aLine = aLine.substring(aLine.indexOf("at ") + 3);
                DisplayLine recToken = this.editor.getCurrentEditorContents().get(0);
                this.editor.setCursor(new NavigationSpecification(recToken, Integer.parseInt(aLine) - 1, false));
            }
        } else if (firstHitFormattedInfo.length() > 0) {
            String aLine = firstHitFormattedInfo.toString();
            String field = aLine.substring(aLine.indexOf("at field"));
            field = field.substring("at field".length(), field.indexOf(44)).trim();
            DisplayLine recToken = this.editor.getCurrentEditorContents().get(0);
            this.editor.setCursor(new NavigationSpecification(recToken, Integer.parseInt(field), true));
        }
    }

    private void setStatusMessageThreadSafe(final String msg, final boolean append) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> statusCodes = new ArrayList<String>();
                String[] stringArray = msg.split("\\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    Object newmsg = s.replace("RFIND", "FIND");
                    String strFOUND = " " + Messages.FindReplace_MFOUND;
                    String strBOTTOM = Messages.FindReplace_MBOTTOM;
                    String strTOP = Messages.FindReplace_MTOP;
                    if (append) {
                        String[] messages;
                        if (((String)newmsg).contains(strFOUND)) {
                            int index = msg.indexOf(strFOUND);
                            String splitted = msg.substring(0, index);
                            Pattern p = Pattern.compile("(\\d+)(?!.*\\d)");
                            Matcher m = p.matcher(splitted);
                            String occurrenceStr = "";
                            while (m.find()) {
                                occurrenceStr = m.group();
                            }
                            newmsg = occurrenceStr + strFOUND;
                            FindReplaceDialog.this.statusMessage.append((String)newmsg);
                        } else if (((String)newmsg).contains(strBOTTOM)) {
                            FindReplaceDialog.this.statusMessage.append(strBOTTOM);
                        } else if (((String)newmsg).contains(strTOP)) {
                            FindReplaceDialog.this.statusMessage.append(strTOP);
                        } else if ((((String)newmsg).contains("FMNBE224") || ((String)newmsg).contains("FMNBE223") || ((String)newmsg).contains(FindReplaceDialog.REPLACE_SUCCESS_MESSAGE_ID)) && (messages = ((String)newmsg).split(" ", 2)).length > 0) {
                            String code = messages[0];
                            String message = messages[1];
                            if (!statusCodes.contains(code)) {
                                statusCodes.add(code);
                                FindReplaceDialog.this.statusMessage.append(message + "\n");
                            }
                        }
                    } else {
                        FindReplaceDialog.this.statusMessage.setText((String)newmsg);
                    }
                    ++n2;
                }
            }
        });
    }

    private String prepareFindOptions(boolean withReplace) {
        Object srchStr = this.findCombo.getText();
        String replaceStr = this.replaceCombo.getText();
        String findOpts = this.getFindOptions();
        String matchOpts = this.getMatchOptions();
        String fieldSelection = this.selectedRange.getText();
        String scopeOpts = this.getFindScope();
        if (!this.srchByDb2Null() && ((String)srchStr).isEmpty()) {
            this.statusMessage.setText(Messages.FindReplace_INVALID_SRCH_STRING);
            return null;
        }
        if (this.srchOptsCaseSensitiveButton.getSelection()) {
            if ((srchStr = StringUtils.getFormattedInputWithCaseEscaper((String)srchStr)) == null) {
                this.statusMessage.setText(Messages.FindReplace_INVALID_SRCH_STRING);
                return null;
            }
        } else if (this.srchOptsHexSearchButton.getSelection()) {
            srchStr = ((String)srchStr).trim();
            if ((srchStr = StringUtils.getFormattedInputWithHexEscaper((String)srchStr)) == null) {
                this.statusMessage.setText(Messages.FindReplace_INVALID_SRCH_STRING);
                return null;
            }
        } else if (this.srchOptsPictureSearchButton.getSelection()) {
            if ((srchStr = StringUtils.getFormattedInputWithPictureEscaper((String)srchStr)) == null) {
                this.statusMessage.setText(Messages.FindReplace_INVALID_SRCH_STRING);
                return null;
            }
        } else if (this.srchOptsConvertToHexButton.getSelection()) {
            if ((srchStr = StringUtils.getHexValue((String)srchStr, (String)this.editor.getResource().getPersistentProperty("encoding"))) == null) {
                this.statusMessage.setText(Messages.FindReplace_INVALID_SRCH_STRING);
                return null;
            }
        } else if (this.srchByDb2Null()) {
            srchStr = "''2";
        } else {
            srchStr = StringUtils.getFormattedEntryString((String)srchStr);
            srchStr = PDBiDiHelpers.translateIfBidiRequired((IZRL)this.editor.getResource(), (String)srchStr, (boolean)true);
        }
        if (((String)srchStr).length() > 100) {
            this.statusMessage.setText(Messages.FindReplace_SRCH_STR_TOO_LONG);
            return null;
        }
        if (this.srchRegexOptionButton != null && this.srchRegexOptionButton.getSelection()) {
            srchStr = "r" + (String)srchStr;
        }
        if (withReplace) {
            if (replaceStr == null) {
                this.statusMessage.setText(Messages.FindReplace_INVALID_REPLACE_STRING);
                return null;
            }
            if (this.repOptsCaseSensitiveButton.getSelection()) {
                if ((replaceStr = StringUtils.getFormattedInputWithCaseEscaper((String)replaceStr)) == null) {
                    this.statusMessage.setText(Messages.FindReplace_INVALID_REPLACE_STRING);
                    return null;
                }
            } else if (this.repOptsHexSearchButton.getSelection()) {
                replaceStr = replaceStr.trim();
                if ((replaceStr = StringUtils.getFormattedInputWithHexEscaper((String)replaceStr)) == null) {
                    this.statusMessage.setText(Messages.FindReplace_INVALID_REPLACE_STRING);
                    return null;
                }
            } else if (this.repOptsPictureSearchButton.getSelection()) {
                if ((replaceStr = StringUtils.getFormattedInputWithPictureEscaper((String)replaceStr)) == null) {
                    this.statusMessage.setText(Messages.FindReplace_INVALID_REPLACE_STRING);
                    return null;
                }
            } else if (this.repOptsConvertToHexButton.getSelection()) {
                if ((replaceStr = StringUtils.getHexValue((String)replaceStr, (String)this.editor.getResource().getPersistentProperty("encoding"))) == null) {
                    this.statusMessage.setText(Messages.FindReplace_INVALID_REPLACE_STRING);
                    return null;
                }
            } else if (this.replaceByDB2Null()) {
                replaceStr = "''2";
            } else {
                replaceStr = StringUtils.getFormattedEntryString((String)replaceStr);
                replaceStr = PDBiDiHelpers.translateIfBidiRequired((IZRL)this.editor.getResource(), (String)replaceStr, (boolean)true);
            }
            if (replaceStr.length() > 100) {
                this.statusMessage.setText(Messages.FindReplace_REPLACE_STR_TOO_LONG);
                return null;
            }
            ComboValueSaver.getInstance((Combo)this.replaceCombo).forceSaveCurrentValue();
            ComboValueSaver.getInstance((Combo)this.replaceCombo).setCustomItems(new String[0], false, false);
            this.replaceCombo.select(0);
        }
        ComboValueSaver.getInstance((Combo)this.findCombo).forceSaveCurrentValue();
        ComboValueSaver.getInstance((Combo)this.findCombo).setCustomItems(new String[0], false, false);
        this.findCombo.select(0);
        String imsOptsStr = "";
        if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.IMS) {
            StringBuilder sb = new StringBuilder();
            String segment = this.selectedSegment.getText();
            if (!segment.isEmpty()) {
                sb.append("SEG(").append(segment).append(")");
            }
            if (this.imsScopeDatabase.getSelection()) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append("DB");
            } else if (this.imsScopeRecord.getSelection()) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append("REC");
            } else if (this.imsScopeDependent.getSelection()) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append("DEP");
            }
            imsOptsStr = sb.toString();
        }
        this.statusMessage.setText("");
        return (String)srchStr + " " + (String)(withReplace ? replaceStr + " " : "") + imsOptsStr + (imsOptsStr.length() > 0 ? " " : "") + findOpts + " " + matchOpts + " " + scopeOpts + " " + fieldSelection;
    }

    private boolean srchByDb2Null() {
        if (this.editor.getSessionIdentifier().getSessionType() != AbstractSessionFormatted.SessionType.DB2) {
            return false;
        }
        return this.srchOptsNullButton != null && this.srchOptsNullButton.getSelection();
    }

    private boolean replaceByDB2Null() {
        if (this.editor.getSessionIdentifier().getSessionType() != AbstractSessionFormatted.SessionType.DB2) {
            return false;
        }
        return this.repOptsNullButton != null && this.repOptsNullButton.getSelection();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    protected void configureShell(Shell sh) {
        super.configureShell(sh);
        sh.setText(MessageFormat.format(Messages.FindReplace_FIND_REPLACE_TITLE, this.resourceName));
        this.setShellStyle(0);
    }

    protected void setShellStyle(int arg0) {
        super.setShellStyle(96);
    }

    public boolean close() {
        this.editor.setSearchActive(false);
        if (this.editor.isFindModeActive() && PDBiDiHelpers.isResourceEncodingBiDi((IZRL)this.editor.getResource())) {
            this.editor.setFindActive(false);
            this.doReset();
        }
        return super.close();
    }

    public void propertyChanged(Object arg0, int arg1) {
        if (arg0 instanceof FormattedEditor && arg1 == 2051) {
            this.close();
        } else if (arg0 instanceof ImsEditor && arg1 == 2051) {
            this.close();
        }
    }

    private void createSearchStringOptions(Group group) {
        this.srchOptsCaseSensitiveButton = new Button((Composite)group, 32);
        this.srchOptsCaseSensitiveButton.setText(Messages.FindReplace_SRCH_OPTS_CASE);
        this.srchOptsCaseSensitiveButton.setSelection(false);
        this.srchOptsCaseSensitiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.srchOptsCaseSensitiveButton.getSelection()) {
                    FindReplaceDialog.this.srchOptsHexSearchButton.setSelection(false);
                    FindReplaceDialog.this.srchOptsPictureSearchButton.setSelection(false);
                    FindReplaceDialog.this.srchOptsConvertToHexButton.setSelection(false);
                    FindReplaceDialog.this.selectSrchOptsNullButton(false);
                }
            }
        });
        this.srchOptsHexSearchButton = new Button((Composite)group, 32);
        this.srchOptsHexSearchButton.setText(Messages.FindReplace_SRCH_OPTS_HEX);
        this.srchOptsHexSearchButton.setSelection(false);
        this.srchOptsHexSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.srchOptsHexSearchButton.getSelection()) {
                    FindReplaceDialog.this.srchOptsCaseSensitiveButton.setSelection(false);
                    FindReplaceDialog.this.srchOptsPictureSearchButton.setSelection(false);
                    FindReplaceDialog.this.srchOptsConvertToHexButton.setSelection(false);
                    Optional.ofNullable(FindReplaceDialog.this.srchRegexOptionButton).ifPresent(b -> b.setSelection(false));
                    FindReplaceDialog.this.selectSrchOptsNullButton(false);
                }
            }
        });
        this.srchOptsPictureSearchButton = new Button((Composite)group, 32);
        this.srchOptsPictureSearchButton.setText(Messages.FindReplace_SRCH_OPTS_PIC);
        this.srchOptsPictureSearchButton.setSelection(false);
        this.srchOptsPictureSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.srchOptsPictureSearchButton.getSelection()) {
                    FindReplaceDialog.this.srchOptsCaseSensitiveButton.setSelection(false);
                    FindReplaceDialog.this.srchOptsHexSearchButton.setSelection(false);
                    FindReplaceDialog.this.srchOptsConvertToHexButton.setSelection(false);
                    Optional.ofNullable(FindReplaceDialog.this.srchRegexOptionButton).ifPresent(b -> b.setSelection(false));
                    FindReplaceDialog.this.selectSrchOptsNullButton(false);
                }
            }
        });
        this.srchOptsPictureSearchButton.setToolTipText(Messages.PictureSupport_DESC);
        this.srchOptsConvertToHexButton = GUI.button.checkbox((Composite)group, (String)Messages.FindReplaceDialog_EncodingHex, (Object)GUI.grid.d.left1());
        this.srchOptsConvertToHexButton.setSelection(false);
        this.srchOptsConvertToHexButton.setToolTipText(Messages.FindReplace_SRCH_CONVERT_TO_HEX_TIP);
        this.srchOptsConvertToHexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.srchOptsConvertToHexButton.getSelection()) {
                    FindReplaceDialog.this.srchOptsCaseSensitiveButton.setSelection(false);
                    FindReplaceDialog.this.srchOptsHexSearchButton.setSelection(false);
                    FindReplaceDialog.this.srchOptsPictureSearchButton.setSelection(false);
                    Optional.ofNullable(FindReplaceDialog.this.srchRegexOptionButton).ifPresent(b -> b.setSelection(false));
                    FindReplaceDialog.this.selectSrchOptsNullButton(false);
                }
            }
        });
        HostVersion.getInstance().setHost(this.editor.getSystem());
        int hostVersion = HostVersion.getInstance().getVersion();
        int maxhostVer = 150109;
        int majorVersion = Integer.parseInt(("" + hostVersion).substring(0, 2));
        if (majorVersion == 16) {
            maxhostVer = 160102;
        }
        if (hostVersion >= maxhostVer) {
            this.srchRegexOptionButton = GUI.button.checkbox((Composite)group, (String)Messages.FindReplace_SRCH_OPTS_REGEX, (Object)GUI.grid.d.left1());
            this.srchRegexOptionButton.setSelection(false);
            this.srchRegexOptionButton.setToolTipText(Messages.FindReplace_SRCH_OPTS_REGEX_TOOL_TIP);
            this.srchRegexOptionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FindReplaceDialog.this.srchRegexOptionButton.getSelection()) {
                        FindReplaceDialog.this.srchOptsConvertToHexButton.setSelection(false);
                        FindReplaceDialog.this.srchOptsPictureSearchButton.setSelection(false);
                        FindReplaceDialog.this.srchOptsHexSearchButton.setSelection(false);
                        FindReplaceDialog.this.selectSrchOptsNullButton(false);
                    }
                }
            });
        }
        if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            this.srchOptsNullButton = GUI.button.checkbox((Composite)group, (String)Messages.FindReplaceDialog_Db2Null, (Object)GUI.grid.d.left1());
            this.srchOptsNullButton.setSelection(false);
            this.srchOptsNullButton.setToolTipText(Messages.FindReplaceDialog_SrchDb2Null);
            this.srchOptsNullButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FindReplaceDialog.this.srchOptsNullButton.getSelection()) {
                        FindReplaceDialog.this.srchOptsCaseSensitiveButton.setSelection(false);
                        FindReplaceDialog.this.srchOptsHexSearchButton.setSelection(false);
                        FindReplaceDialog.this.srchOptsPictureSearchButton.setSelection(false);
                        FindReplaceDialog.this.srchOptsConvertToHexButton.setSelection(false);
                        FindReplaceDialog.this.selectSrchOptsNullButton(true);
                    } else {
                        FindReplaceDialog.this.selectSrchOptsNullButton(false);
                    }
                }
            });
        }
        GUI.label.left((Composite)group, (String)"", (Object)GUI.grid.d.left1());
    }

    private void selectSrchOptsNullButton(boolean select) {
        if (this.srchOptsNullButton != null) {
            this.srchOptsNullButton.setSelection(select);
            if (select) {
                this.findCombo.setEnabled(false);
            } else {
                this.findCombo.setEnabled(true);
            }
        }
    }

    private void createReplaceStringOptions(Group group) {
        this.repOptsCaseSensitiveButton = new Button((Composite)group, 32);
        this.repOptsCaseSensitiveButton.setText(Messages.FindReplace_SRCH_OPTS_CASE);
        this.repOptsCaseSensitiveButton.setSelection(false);
        this.repOptsCaseSensitiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.repOptsCaseSensitiveButton.getSelection()) {
                    FindReplaceDialog.this.repOptsHexSearchButton.setSelection(false);
                    FindReplaceDialog.this.repOptsPictureSearchButton.setSelection(false);
                    FindReplaceDialog.this.repOptsConvertToHexButton.setSelection(false);
                    FindReplaceDialog.this.selectRepOptsNullButton(false);
                }
            }
        });
        this.repOptsHexSearchButton = new Button((Composite)group, 32);
        this.repOptsHexSearchButton.setText(Messages.FindReplace_SRCH_OPTS_HEX);
        this.repOptsHexSearchButton.setSelection(false);
        this.repOptsHexSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.repOptsHexSearchButton.getSelection()) {
                    FindReplaceDialog.this.repOptsCaseSensitiveButton.setSelection(false);
                    FindReplaceDialog.this.repOptsPictureSearchButton.setSelection(false);
                    FindReplaceDialog.this.repOptsConvertToHexButton.setSelection(false);
                    FindReplaceDialog.this.selectRepOptsNullButton(false);
                }
            }
        });
        this.repOptsPictureSearchButton = new Button((Composite)group, 32);
        this.repOptsPictureSearchButton.setText(Messages.FindReplace_SRCH_OPTS_PIC);
        this.repOptsPictureSearchButton.setSelection(false);
        this.repOptsPictureSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.repOptsPictureSearchButton.getSelection()) {
                    FindReplaceDialog.this.repOptsCaseSensitiveButton.setSelection(false);
                    FindReplaceDialog.this.repOptsHexSearchButton.setSelection(false);
                    FindReplaceDialog.this.repOptsConvertToHexButton.setSelection(false);
                    FindReplaceDialog.this.selectRepOptsNullButton(false);
                }
            }
        });
        this.repOptsPictureSearchButton.setToolTipText(Messages.PictureSupport_DESC);
        this.repOptsConvertToHexButton = GUI.button.checkbox((Composite)group, (String)Messages.FindReplaceDialog_EncodingHex, (Object)GUI.grid.d.left1());
        this.repOptsConvertToHexButton.setToolTipText(Messages.FindReplace_SRCH_CONVERT_TO_HEX_TIP);
        this.repOptsConvertToHexButton.setSelection(false);
        this.repOptsConvertToHexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.repOptsConvertToHexButton.getSelection()) {
                    FindReplaceDialog.this.repOptsCaseSensitiveButton.setSelection(false);
                    FindReplaceDialog.this.repOptsHexSearchButton.setSelection(false);
                    FindReplaceDialog.this.repOptsPictureSearchButton.setSelection(false);
                    FindReplaceDialog.this.selectRepOptsNullButton(false);
                }
            }
        });
        if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            this.repOptsNullButton = GUI.button.checkbox((Composite)group, (String)Messages.FindReplaceDialog_Db2Null, (Object)GUI.grid.d.left1());
            this.repOptsNullButton.setToolTipText(Messages.FindReplaceDialog_ReplaceDb2Null);
            this.repOptsNullButton.setSelection(false);
            this.repOptsNullButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FindReplaceDialog.this.repOptsNullButton.getSelection()) {
                        FindReplaceDialog.this.repOptsCaseSensitiveButton.setSelection(false);
                        FindReplaceDialog.this.repOptsHexSearchButton.setSelection(false);
                        FindReplaceDialog.this.repOptsPictureSearchButton.setSelection(false);
                        FindReplaceDialog.this.repOptsConvertToHexButton.setSelection(false);
                        FindReplaceDialog.this.selectRepOptsNullButton(true);
                    } else {
                        FindReplaceDialog.this.selectRepOptsNullButton(false);
                    }
                }
            });
        }
    }

    private void selectRepOptsNullButton(boolean select) {
        if (this.repOptsNullButton != null) {
            this.repOptsNullButton.setSelection(select);
            if (select) {
                this.replaceCombo.setEnabled(false);
            } else {
                this.replaceCombo.setEnabled(true);
            }
        }
    }

    private void createFindOptions(Composite parent) {
        Group navGroup = GUI.group((Composite)parent, (String)Messages.FindReplace_NavGroup, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.findOptsNextButton = new Button((Composite)navGroup, 16);
        this.findOptsNextButton.setText(Messages.FindReplace_FR_OPTS_NEXT);
        this.findOptsNextButton.setSelection(true);
        this.findOptsNextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.findOptsValue = "NEXT";
            }
        });
        this.findOptsAllButton = new Button((Composite)navGroup, 16);
        this.findOptsAllButton.setText(Messages.FindReplace_FR_OPTS_ALL);
        this.findOptsAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.findOptsValue = "ALL";
            }
        });
        this.findOptsPrevButton = new Button((Composite)navGroup, 16);
        this.findOptsPrevButton.setText(Messages.FindReplace_FR_OPTS_PREV);
        this.findOptsPrevButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.findOptsValue = "PREV";
            }
        });
        this.findOptsFirstButton = new Button((Composite)navGroup, 16);
        this.findOptsFirstButton.setText(Messages.FindReplace_FR_OPTS_FIRST);
        this.findOptsFirstButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.findOptsValue = "FIRST";
            }
        });
        if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.IMS) {
            GUI.label.left((Composite)navGroup, (String)"", (Object)GUI.grid.d.left1());
        } else {
            this.findOptsLastButton = new Button((Composite)navGroup, 16);
            this.findOptsLastButton.setText(Messages.FindReplace_FR_OPTS_LAST);
            this.findOptsLastButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FindReplaceDialog.this.findOptsValue = "LAST";
                }
            });
        }
        Group otherGroup = GUI.group((Composite)parent, (String)Messages.FindReplace_Others, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.IMS) {
            GUI.label.left((Composite)otherGroup, (String)"", (Object)GUI.grid.d.left1());
        } else {
            this.findNotOptionButton = GUI.button.checkbox((Composite)otherGroup, (String)Messages.FindReplace_NotFindOpt, (Object)GUI.grid.d.left1());
            this.findNotOptionButton.setToolTipText(Messages.FindReplace_NotFindOptTip);
            if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
                this.findNotOptionButton.setEnabled(false);
            }
        }
        GUI.label.left((Composite)otherGroup, (String)"", (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)otherGroup, (String)"", (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)otherGroup, (String)"", (Object)GUI.grid.d.left1());
    }

    public String getFindOptions() {
        return this.findOptsValue;
    }

    private void createMatchOptions(Group group) {
        this.matchOptsCharsButton = new Button((Composite)group, 16);
        this.matchOptsCharsButton.setText(Messages.FindReplace_MATCH_OPTS_CHARS);
        this.matchOptsCharsButton.setSelection(true);
        this.matchOptsCharsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.matchOptsValue = "CHAR";
            }
        });
        this.matchOptsPrefixButton = new Button((Composite)group, 16);
        this.matchOptsPrefixButton.setText(Messages.FindReplace_MATCH_OPTS_PREFIX);
        this.matchOptsPrefixButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.matchOptsValue = "PRE";
            }
        });
        this.matchOptsSuffixButton = new Button((Composite)group, 16);
        this.matchOptsSuffixButton.setText(Messages.FindReplace_MATCH_OPTS_SUFFIX);
        this.matchOptsSuffixButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.matchOptsValue = "SUF";
            }
        });
        this.matchOptsWordButton = new Button((Composite)group, 16);
        this.matchOptsWordButton.setText(Messages.FindReplace_MATCH_OPTS_WORD);
        this.matchOptsWordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.matchOptsValue = "WORD";
            }
        });
    }

    public String getMatchOptions() {
        return this.matchOptsValue;
    }

    private void createFindScopeGroup(Group group) {
        this.scopeAllButton = new Button((Composite)group, 16);
        this.scopeAllButton.setText(Messages.FindReplace_SRCH_ALL);
        this.scopeAllButton.setSelection(true);
        this.scopeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.scopeValue = "";
            }
        });
        this.scopeExButton = new Button((Composite)group, 16);
        this.scopeExButton.setText(Messages.FindReplace_SRCH_EXCLUDED);
        this.scopeExButton.setSelection(false);
        this.scopeExButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.scopeValue = "EX";
            }
        });
        this.scopeNotExButton = new Button((Composite)group, 16);
        this.scopeNotExButton.setText(Messages.FindReplace_SRCH_NOT_EXCLUDED);
        this.scopeNotExButton.setSelection(false);
        this.scopeNotExButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.scopeValue = "NX";
            }
        });
        GUI.label.left((Composite)group, (String)"", (Object)GUI.grid.d.left1());
    }

    public String getFindScope() {
        return this.scopeValue;
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        return new Point(initialSize.x, initialSize.y * 110 / 100);
    }
}

