/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPageUtility;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.text.MessageFormat;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FindColumnLimitDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private int maxRange = 0;
    private Text startColumnText = null;
    private Text endColumnText = null;
    private String selectedRange = "";
    private String initRange = "";

    public FindColumnLimitDialog(int maxRange, String initValue) {
        this.maxRange = maxRange;
        this.selectedRange = "";
        this.initRange = initValue;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.FindColumnLimitDialog_TITLE);
        this.setMessage(Messages.FindColumnLimitDialog_MSG);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createColumnsEntryComposite(composite);
        this.setComplete(this.validateEntry());
        return composite;
    }

    private void createColumnsEntryComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.FindColumnLimitDialog_START, (Object)GUI.grid.d.left1());
        this.startColumnText = GUI.text.field((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        this.startColumnText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                FormattedPageUtility.digitEntryTextValue(e);
            }
        });
        this.startColumnText.setText("1");
        this.startColumnText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                FindColumnLimitDialog.this.setComplete(FindColumnLimitDialog.this.validateEntry());
            }
        });
        NumberForcer.addTo(this.startColumnText);
        GUI.label.left((Composite)composite, (String)Messages.FindColumnLimitDialog_END, (Object)GUI.grid.d.left1());
        this.endColumnText = GUI.text.field((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        this.endColumnText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                FormattedPageUtility.digitEntryTextValue(e);
            }
        });
        this.endColumnText.setText("" + this.maxRange);
        this.endColumnText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                FindColumnLimitDialog.this.setComplete(FindColumnLimitDialog.this.validateEntry());
            }
        });
        NumberForcer.addTo(this.endColumnText);
        this.processInitValue();
        this.startColumnText.selectAll();
        this.startColumnText.setFocus();
    }

    private void processInitValue() {
        if (this.initRange == null) {
            this.startColumnText.setText("1");
            this.endColumnText.setText("" + this.maxRange);
            return;
        }
        if (this.initRange.indexOf(32) != -1) {
            try {
                this.startColumnText.setText("" + Integer.parseInt(this.initRange.substring(0, this.initRange.indexOf(32))));
                this.endColumnText.setText("" + Integer.parseInt(this.initRange.substring(this.initRange.indexOf(32) + 1)));
            }
            catch (Exception e) {
                this.startColumnText.setText("1");
                this.endColumnText.setText("" + this.maxRange);
            }
        } else {
            try {
                this.startColumnText.setText("" + Integer.parseInt(this.initRange));
                this.endColumnText.setText("");
            }
            catch (Exception e) {
                this.startColumnText.setText("1");
                this.endColumnText.setText("" + this.maxRange);
            }
        }
    }

    private boolean validateEntry() {
        String startValue = this.startColumnText.getText();
        if (startValue.isEmpty()) {
            this.setErrorMessage(Messages.FindColumnLimitDialog_NO_START);
            return false;
        }
        int startColumnNo = Integer.parseInt(startValue);
        if (startColumnNo == 0) {
            this.setErrorMessage(Messages.FindColumnLimitDialog_ZERO_START);
            return false;
        }
        if (startColumnNo > this.maxRange) {
            this.setErrorMessage(MessageFormat.format(Messages.FindColumnLimitDialog_START_TOO_BIG, this.maxRange));
            return false;
        }
        int endColumnNo = -1;
        String endValue = this.endColumnText.getText();
        if (!endValue.isEmpty()) {
            endColumnNo = Integer.parseInt(endValue);
            if (endColumnNo == 0) {
                this.setErrorMessage(Messages.FindColumnLimitDialog_ZERO_END);
                return false;
            }
            if (endColumnNo > this.maxRange) {
                this.setErrorMessage(MessageFormat.format(Messages.FindColumnLimitDialog_END_TOO_BIG, this.maxRange));
                return false;
            }
        }
        if (endColumnNo != -1 && startColumnNo > endColumnNo) {
            this.setErrorMessage(MessageFormat.format(Messages.FindColumnLimitDialog_END_BIGGER_THAN_START, startColumnNo, endColumnNo));
            return false;
        }
        this.selectedRange = endColumnNo != -1 ? startColumnNo + " " + endColumnNo : "" + startColumnNo;
        this.setErrorMessage(null);
        return true;
    }

    public String getSelectedColumnRange() {
        return this.selectedRange;
    }
}

