/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.dialogs.FieldInformation;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FieldSelectionDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ALL_FIELDS_SELECTED = "#ALL";
    private IFMEditor editor = null;
    private TableViewer fieldTableViewer = null;
    private String selectedFields = null;
    private String initialSelection = null;

    public FieldSelectionDialog(IFMEditor editor, String initialSelection) {
        this.editor = editor;
        this.initialSelection = initialSelection == null ? "" : initialSelection;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.FieldSelectionDialog_TITLE);
        this.setMessage(MessageFormat.format(Messages.FieldSelectionDialog_MSG, this.editor.getLayoutName(this.editor.getActiveLayoutID()), this.editor.getTemplateResource().getFormattedName()));
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.prepareFieldSelctionTable(composite);
        ArrayList<FieldInformation> fields = FormattedEditorUtility.getCurrentFieldInformation(this.editor);
        this.prepareButtons(composite);
        this.fieldTableViewer.setInput(fields);
        this.initialiseFieldSelection();
        this.setComplete(this.validateFieldSelection());
        return composite;
    }

    private void prepareFieldSelctionTable(Composite parent) {
        GridData data = GUI.grid.d.fillAll();
        data.heightHint = 300;
        data.widthHint = 300;
        Composite tableComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)data);
        this.fieldTableViewer = new TableViewer(tableComposite, 802);
        this.fieldTableViewer.getTable().setLayoutData((Object)GUI.grid.d.fillAll());
        TableViewerColumn viewerColumn = new TableViewerColumn(this.fieldTableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setWidth(200);
        column.setResizable(true);
        column.setMoveable(true);
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                FieldInformation info = (FieldInformation)cell.getElement();
                cell.setText(info.getName());
            }
        });
        this.fieldTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fieldTableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FieldSelectionDialog.this.setComplete(FieldSelectionDialog.this.validateFieldSelection());
            }
        });
    }

    private void initialiseFieldSelection() {
        if (this.initialSelection.isEmpty()) {
            return;
        }
        if (ALL_FIELDS_SELECTED.equals(this.initialSelection)) {
            TableItem[] items = this.fieldTableViewer.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                items[i].setChecked(true);
                ++i;
            }
        } else {
            TableItem[] items = this.fieldTableViewer.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                items[i].setChecked(false);
                ++i;
            }
            StringTokenizer st = new StringTokenizer(this.initialSelection, "#");
            while (st.hasMoreTokens()) {
                this.setSelection(st.nextToken());
            }
        }
    }

    private void setSelection(String selectedRefID) {
        if (((String)selectedRefID).endsWith(",")) {
            selectedRefID = ((String)selectedRefID).substring(0, ((String)selectedRefID).length() - 1);
        }
        selectedRefID = "#" + (String)selectedRefID;
        TableItem[] items = this.fieldTableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            FieldInformation info = (FieldInformation)items[i].getData();
            if (info.getRefID().equals(selectedRefID)) {
                items[i].setChecked(true);
                return;
            }
            ++i;
        }
    }

    private void prepareButtons(Composite parent) {
        Composite buttonComp = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)true), (Object)GUI.grid.d.left1());
        Button selectAllButton = GUI.button.push((Composite)buttonComp, (String)Messages.FieldSelectionDialog_SELECT_ALL, (Object)GUI.grid.d.fillH((int)1));
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (FieldSelectionDialog.this.fieldTableViewer != null && !FieldSelectionDialog.this.fieldTableViewer.getTable().isDisposed()) {
                    TableItem[] items = FieldSelectionDialog.this.fieldTableViewer.getTable().getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].setChecked(true);
                        ++i;
                    }
                }
                FieldSelectionDialog.this.setComplete(FieldSelectionDialog.this.validateFieldSelection());
            }
        });
        Button deselectAllButton = GUI.button.push((Composite)buttonComp, (String)Messages.FieldSelectionDialog_DESELECT_ALL, (Object)GUI.grid.d.fillH((int)1));
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (FieldSelectionDialog.this.fieldTableViewer != null && !FieldSelectionDialog.this.fieldTableViewer.getTable().isDisposed()) {
                    TableItem[] items = FieldSelectionDialog.this.fieldTableViewer.getTable().getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].setChecked(false);
                        ++i;
                    }
                }
                FieldSelectionDialog.this.setComplete(FieldSelectionDialog.this.validateFieldSelection());
            }
        });
        Button resetButton = GUI.button.push((Composite)buttonComp, (String)Messages.FieldSelectionDialog_RESET, (Object)GUI.grid.d.fillH((int)1));
        resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                FieldSelectionDialog.this.initialiseFieldSelection();
                FieldSelectionDialog.this.setComplete(FieldSelectionDialog.this.validateFieldSelection());
            }
        });
    }

    private boolean validateFieldSelection() {
        ArrayList<String> selectedFieldRefs = new ArrayList<String>();
        TableItem[] items = this.fieldTableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                FieldInformation info = (FieldInformation)items[i].getData();
                selectedFieldRefs.add(info.getRefID());
            }
            ++i;
        }
        if (selectedFieldRefs.isEmpty()) {
            this.setErrorMessage(Messages.FieldSelectionDialog_NO_SEL);
            return false;
        }
        if (selectedFieldRefs.size() == items.length) {
            this.selectedFields = ALL_FIELDS_SELECTED;
        } else {
            this.selectedFields = (String)selectedFieldRefs.get(0);
            i = 1;
            while (i < selectedFieldRefs.size()) {
                this.selectedFields = String.valueOf(this.selectedFields) + "," + (String)selectedFieldRefs.get(i);
                ++i;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public String getSelection() {
        return this.selectedFields;
    }
}

