/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.dialogs.FieldSelectionDialog;
import com.ibm.etools.fm.editor.formatted.dialogs.FindColumnLimitDialog;
import com.ibm.etools.fm.editor.formatted.dialogs.FormattedEditorDialogUtils;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExcludeDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private FormattedEditor editor = null;
    private Combo textCombo = null;
    private String textValue = "";
    private Text searchRangeText = null;
    private Button fieldSelectionButton = null;
    private boolean enableFieldSelection = true;
    private Button columnSelectionButton = null;
    private Button excludeAllButton;
    private Button srchOptsCaseSensitiveButton;
    private Button srchOptsHexSearchButton;
    private Button srchOptsPictureSearchButton;
    private Button srchOptsNullButton;
    private Button exOptsNextButton;
    private Button exOptsAllButton;
    private Button exOptsPrevButton;
    private Button exOptsFirstButton;
    private Button exOptsLastButton;
    private String exOptsValue = "NEXT";
    private Button matchOptsCharsButton;
    private Button matchOptsPrefixButton;
    private Button matchOptsSuffixButton;
    private Button matchOptsWordButton;
    private String matchOptsValue = "CHAR";
    private String excludeCommandValue = "";
    private boolean excludeAll = false;

    public ExcludeDialog(Shell parent, FormattedEditor editor) {
        this.editor = editor;
        this.enableFieldSelection = true;
        if (editor.getTemplateResource() == null) {
            this.enableFieldSelection = false;
        }
        TrayDialog.setDialogHelpAvailable((boolean)false);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ExcludeDialog_TITLE);
        this.setMessage(Messages.ExcludeDialog_EXP);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Composite topComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)topComposite, (String)Messages.ExcludeDialog_EX_STR, (Object)GUI.grid.d.left1());
        this.textCombo = GUI.combo.editable((Composite)topComposite, (Object)GUI.grid.d.fillH((int)2));
        new ComboValueSaver(this.textCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "exclude");
        FormattedEditorDialogUtils.addInsertNotCharacterListener(this.textCombo);
        this.textCombo.setFocus();
        GUI.label.left((Composite)topComposite, (String)Messages.ExcludeDialog_SRCH_RANGE, (Object)GUI.grid.d.left1());
        this.searchRangeText = GUI.text.fieldReadOnly((Composite)topComposite, (Object)GUI.grid.d.fillH((int)1));
        this.searchRangeText.setEditable(false);
        if (this.editor.getTemplateResource() == null) {
            this.searchRangeText.setText("1 " + this.editor.getSessionProperties().getMaxRECL());
        } else if (this.editor.getCurrentEditorMode() == IFMEditor.EditorMode.CHARACTER) {
            this.searchRangeText.setText("1 " + this.editor.getSessionProperties().getMaxRECL());
        } else {
            this.searchRangeText.setText("#ALL");
        }
        Composite rangeButtonsComposite = GUI.composite((Composite)topComposite, (Layout)GUI.grid.l.margins((int)2, (boolean)true), (Object)GUI.grid.d.left1());
        this.fieldSelectionButton = GUI.button.push((Composite)rangeButtonsComposite, (String)Messages.ExcludeDialog_FIELD_SEL_BUTTON, (Object)GUI.grid.d.fillH((int)1));
        this.fieldSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldSelectionDialog page = new FieldSelectionDialog(ExcludeDialog.this.editor, ExcludeDialog.this.searchRangeText.getText());
                if (page.open() != 0) {
                    return;
                }
                ExcludeDialog.this.searchRangeText.setText(page.getSelection());
            }
        });
        if (!this.enableFieldSelection) {
            this.searchRangeText.setEnabled(false);
            this.fieldSelectionButton.setEnabled(false);
        }
        this.columnSelectionButton = GUI.button.push((Composite)rangeButtonsComposite, (String)Messages.ExcludeDialog_COLEL_BUTTON, (Object)GUI.grid.d.fillH((int)1));
        this.columnSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindColumnLimitDialog dialog = new FindColumnLimitDialog(ExcludeDialog.this.editor.getSessionProperties().getMaxRECL(), ExcludeDialog.this.searchRangeText.getText());
                if (dialog.open() != 0) {
                    return;
                }
                ExcludeDialog.this.searchRangeText.setText(dialog.getSelectedColumnRange());
            }
        });
        if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            this.columnSelectionButton.setEnabled(false);
        }
        Composite optionsComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.vert((int)128, (boolean)false, (int)1));
        Group srchOptions = GUI.group((Composite)optionsComposite, (String)Messages.ExcludeDialog_SRCH_OPS, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.vert((int)128, (boolean)true, (int)1));
        this.createSearchStringOptions(srchOptions);
        Group exOptions = GUI.group((Composite)optionsComposite, (String)Messages.ExcludeDialog_EX_OPS, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.vert((int)128, (boolean)true, (int)1));
        this.createExcludeOptions(exOptions);
        Group matchOptions = GUI.group((Composite)optionsComposite, (String)Messages.ExcludeDialog_MATCH_OPS, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.vert((int)128, (boolean)true, (int)1));
        this.createMatchOptions(matchOptions);
        return composite;
    }

    private void createSearchStringOptions(Group group) {
        this.excludeAllButton = new Button((Composite)group, 32);
        this.excludeAllButton.setText(Messages.ExcludeDialog_EX_ALL_OPTS);
        this.excludeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ExcludeDialog.this.enableControls(!ExcludeDialog.this.excludeAllButton.getSelection());
            }
        });
        this.srchOptsCaseSensitiveButton = new Button((Composite)group, 32);
        this.srchOptsCaseSensitiveButton.setText(Messages.ExcludeDialog_SRCH_OPTS_CASE);
        this.srchOptsCaseSensitiveButton.setSelection(false);
        this.srchOptsCaseSensitiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ExcludeDialog.this.srchOptsCaseSensitiveButton.getSelection()) {
                    ExcludeDialog.this.srchOptsHexSearchButton.setSelection(false);
                    ExcludeDialog.this.srchOptsPictureSearchButton.setSelection(false);
                    ExcludeDialog.this.selectSrchOptsNullButton(false);
                }
            }
        });
        this.srchOptsHexSearchButton = new Button((Composite)group, 32);
        this.srchOptsHexSearchButton.setText(Messages.ExcludeDialog_SRCH_OPTS_HEX);
        this.srchOptsHexSearchButton.setSelection(false);
        this.srchOptsHexSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExcludeDialog.this.srchOptsHexSearchButton.getSelection()) {
                    ExcludeDialog.this.srchOptsCaseSensitiveButton.setSelection(false);
                    ExcludeDialog.this.srchOptsPictureSearchButton.setSelection(false);
                    ExcludeDialog.this.selectSrchOptsNullButton(false);
                }
            }
        });
        this.srchOptsPictureSearchButton = new Button((Composite)group, 32);
        this.srchOptsPictureSearchButton.setText(Messages.ExcludeDialog_SRCH_OPTS_PICTURE);
        this.srchOptsPictureSearchButton.setSelection(false);
        this.srchOptsPictureSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExcludeDialog.this.srchOptsPictureSearchButton.getSelection()) {
                    ExcludeDialog.this.srchOptsCaseSensitiveButton.setSelection(false);
                    ExcludeDialog.this.srchOptsHexSearchButton.setSelection(false);
                    ExcludeDialog.this.selectSrchOptsNullButton(false);
                }
            }
        });
        this.srchOptsPictureSearchButton.setToolTipText(Messages.PictureSupport_DESC);
        if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            this.srchOptsNullButton = GUI.button.checkbox((Composite)group, (String)Messages.ExcludeDialog_Db2Null, (Object)GUI.grid.d.left1());
            this.srchOptsNullButton.setSelection(false);
            this.srchOptsNullButton.setToolTipText(Messages.ExcludeDialog_SrchForDb2Null);
            this.srchOptsNullButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ExcludeDialog.this.srchOptsNullButton.getSelection()) {
                        ExcludeDialog.this.srchOptsCaseSensitiveButton.setSelection(false);
                        ExcludeDialog.this.srchOptsHexSearchButton.setSelection(false);
                        ExcludeDialog.this.srchOptsPictureSearchButton.setSelection(false);
                        ExcludeDialog.this.selectSrchOptsNullButton(true);
                    } else {
                        ExcludeDialog.this.selectSrchOptsNullButton(false);
                    }
                }
            });
        }
    }

    private void createExcludeOptions(Group group) {
        this.exOptsNextButton = new Button((Composite)group, 16);
        this.exOptsNextButton.setText(Messages.ExcludeDialog_EX_OPTS_NEXT);
        this.exOptsNextButton.setSelection(true);
        this.exOptsNextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcludeDialog.this.exOptsValue = "NEXT";
                ExcludeDialog.this.excludeAll = false;
            }
        });
        this.exOptsAllButton = new Button((Composite)group, 16);
        this.exOptsAllButton.setText(Messages.ExcludeDialog_EX_OPTS_ALL);
        this.exOptsAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcludeDialog.this.exOptsValue = "ALL";
                ExcludeDialog.this.excludeAll = true;
            }
        });
        this.exOptsPrevButton = new Button((Composite)group, 16);
        this.exOptsPrevButton.setText(Messages.ExcludeDialog_EX_OPTS_PREV);
        this.exOptsPrevButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcludeDialog.this.exOptsValue = "PREV";
                ExcludeDialog.this.excludeAll = false;
            }
        });
        this.exOptsFirstButton = new Button((Composite)group, 16);
        this.exOptsFirstButton.setText(Messages.ExcludeDialog_EX_OPTS_FIRST);
        this.exOptsFirstButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcludeDialog.this.exOptsValue = "FIRST";
                ExcludeDialog.this.excludeAll = false;
            }
        });
        this.exOptsLastButton = new Button((Composite)group, 16);
        this.exOptsLastButton.setText(Messages.ExcludeDialog_EX_OPTS_LAST);
        this.exOptsLastButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcludeDialog.this.exOptsValue = "LAST";
                ExcludeDialog.this.excludeAll = false;
            }
        });
    }

    public String getExcludeOptions() {
        return this.exOptsValue;
    }

    private void createMatchOptions(Group group) {
        this.matchOptsCharsButton = new Button((Composite)group, 16);
        this.matchOptsCharsButton.setText(Messages.ExcludeDialog_MATCH_OPTS_CHARS);
        this.matchOptsCharsButton.setSelection(true);
        this.matchOptsCharsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcludeDialog.this.matchOptsValue = "CHAR";
            }
        });
        this.matchOptsPrefixButton = new Button((Composite)group, 16);
        this.matchOptsPrefixButton.setText(Messages.ExcludeDialog_MATCH_OPTS_PREFIX);
        this.matchOptsPrefixButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcludeDialog.this.matchOptsValue = "PRE";
            }
        });
        this.matchOptsSuffixButton = new Button((Composite)group, 16);
        this.matchOptsSuffixButton.setText(Messages.ExcludeDialog_MATCH_OPTS_SUFFIX);
        this.matchOptsSuffixButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcludeDialog.this.matchOptsValue = "SUF";
            }
        });
        this.matchOptsWordButton = new Button((Composite)group, 16);
        this.matchOptsWordButton.setText(Messages.ExcludeDialog_MATCH_OPTS_WORD);
        this.matchOptsWordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcludeDialog.this.matchOptsValue = "WORD";
            }
        });
    }

    public String getMatchOptions() {
        return this.matchOptsValue;
    }

    public boolean close() {
        if (this.getReturnCode() == 1) {
            return super.close();
        }
        if (this.excludeAllButton.getSelection()) {
            this.excludeCommandValue = "EXCLUDE ALL";
            return super.close();
        }
        if (!this.validateInputText()) {
            return false;
        }
        this.excludeCommandValue = "EXCLUDE " + this.textValue + " " + this.exOptsValue + " " + this.matchOptsValue;
        if (!this.searchRangeText.getText().trim().isEmpty()) {
            this.excludeCommandValue = String.valueOf(this.excludeCommandValue) + " " + this.searchRangeText.getText();
        }
        return super.close();
    }

    private boolean validateInputText() {
        String value = this.textCombo.getText();
        if (!this.srchByDb2Null() && value.isEmpty()) {
            this.setErrorMessage(Messages.ExcludeDialog_INVALID_TEXT);
            this.textValue = "";
            return false;
        }
        if ("*".equals(value)) {
            this.setErrorMessage(Messages.ExcludeDialog_WILD_CARD);
            this.textValue = "";
            return false;
        }
        if (this.srchOptsHexSearchButton.getSelection()) {
            value = value.toUpperCase().trim();
            if ((value = StringUtils.getFormattedInputWithHexEscaper((String)value)) == null) {
                this.setErrorMessage(Messages.ExcludeDialog_INVALID_HEX);
                return false;
            }
            this.setErrorMessage(null);
            this.textValue = value;
        } else if (this.srchOptsCaseSensitiveButton.getSelection()) {
            this.textValue = StringUtils.getFormattedInputWithCaseEscaper((String)value);
            this.setErrorMessage(null);
        } else if (this.srchOptsPictureSearchButton.getSelection()) {
            this.textValue = StringUtils.getFormattedInputWithPictureEscaper((String)value);
            this.setErrorMessage(null);
        } else if (this.srchByDb2Null()) {
            this.textValue = "''2";
        } else {
            this.setErrorMessage(null);
            this.textValue = StringUtils.getFormattedEntryString((String)value);
        }
        return true;
    }

    public String getExcludeCommand() {
        return this.excludeCommandValue;
    }

    public boolean isExcludeAll() {
        return this.excludeAll;
    }

    public void setTitle(String newTitle) {
        this.getShell().setText(newTitle);
        super.setTitle(newTitle);
    }

    private void enableControls(boolean enabled) {
        this.textCombo.setEnabled(enabled);
        this.searchRangeText.setEnabled(enabled);
        if (this.enableFieldSelection) {
            this.fieldSelectionButton.setEnabled(enabled);
        }
        this.columnSelectionButton.setEnabled(enabled);
        this.srchOptsCaseSensitiveButton.setEnabled(enabled);
        this.srchOptsHexSearchButton.setEnabled(enabled);
        this.srchOptsPictureSearchButton.setEnabled(enabled);
        if (this.srchOptsNullButton != null) {
            this.srchOptsNullButton.setEnabled(enabled);
        }
        this.exOptsNextButton.setEnabled(enabled);
        this.exOptsAllButton.setEnabled(enabled);
        this.exOptsPrevButton.setEnabled(enabled);
        this.exOptsFirstButton.setEnabled(enabled);
        this.exOptsLastButton.setEnabled(enabled);
        this.matchOptsCharsButton.setEnabled(enabled);
        this.matchOptsPrefixButton.setEnabled(enabled);
        this.matchOptsSuffixButton.setEnabled(enabled);
        this.matchOptsWordButton.setEnabled(enabled);
    }

    private void selectSrchOptsNullButton(boolean select) {
        if (this.srchOptsNullButton != null) {
            this.srchOptsNullButton.setSelection(select);
            if (select) {
                this.textCombo.setEnabled(false);
            } else {
                this.textCombo.setEnabled(true);
            }
        }
    }

    private boolean srchByDb2Null() {
        if (this.editor.getSessionIdentifier().getSessionType() != AbstractSessionFormatted.SessionType.DB2) {
            return false;
        }
        return this.srchOptsNullButton != null && this.srchOptsNullButton.getSelection();
    }
}

