/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.model.data.DataSetProperties;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.editor.template.dialogs.NewDynamicTemplateDialog;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.callback.ISelectedValueFormatter;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.dialog.lookup.filter.ILookupFilterProvider;
import com.ibm.etools.fm.ui.util.RemoteServicesUI;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.widget.SystemSelectionCombo;
import com.ibm.pdtools.common.component.bidi.BidiUtils;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDBiDiHelpers;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.EmptyWildcardZRL;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import com.ibm.pdtools.common.component.jhost.util.EncodingUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EditorOptionDialog
extends BaseTitleAreaDialog
implements IHostProvider {
    private static final Pattern PATTERN_PLACEHOLDER = Pattern.compile("&[^.]+\\.");
    private PDLogger logger = PDLogger.get(EditorOptionDialog.class);
    private IPDHost host;
    private String dialogTitle;
    private String dialogMsg;
    private BaseEditorOptions options;
    private ComboViewer resourceNameComboViewer;
    private ComboViewer volumeSerialComboViewer;
    private ComboViewer templateDSNComboViewer;
    private ComboViewer startPositionTypeComboViewer;
    private ComboViewer startPositionComboViewer;
    private Button inplaceEditButton;
    private ComboViewer recordLimitComboViewer;
    private Button recordSamplingButton;
    private ComboViewer includePhysicalRecordsComboViewer;
    private ComboViewer skipPhysicalRecordComboViewer;
    private Button includeOnlySelectedButton;
    private ComboViewer binaryReclenComboViewer;
    private ComboViewer encodingComboViewer;
    private ComboViewer dbcsEncodingComboViewer;
    private ComboViewer textLayoutComboViewer;
    private ComboViewer textDirectionComboViewer;
    private ComboViewer ioExitComboViewer;
    private Button mqDesciptorButton;
    private static String[] layoutValues = new String[]{Messages.EditorOptionDialog_TEXT_LAYOUT_LOGICAL, Messages.EditorOptionDialog_TEXT_LAYOUT_VISUAL};
    private static String[] layoutValuesNonWindows = new String[]{Messages.EditorOptionDialog_TEXT_LAYOUT_LOGICAL};
    private static String[] directionValues = new String[]{Messages.EditorOptionDialog_TEXT_DIRECTION_LTR, Messages.EditorOptionDialog_TEXT_DIRECTION_RTL};
    private IZRL aZrl;

    public void updateUI() {
        String encodingForSession;
        String skipPhysicalRecords;
        String binaryLength;
        String templateFormattedName;
        int i;
        String[] items;
        if (this.volumeSerialComboViewer != null && this.options.getaVolumeSerial() != null) {
            items = this.volumeSerialComboViewer.getCombo().getItems();
            i = 0;
            while (i < items.length) {
                if (items[i].trim().compareTo(this.options.getaVolumeSerial()) == 0) {
                    this.volumeSerialComboViewer.getCombo().select(i);
                    break;
                }
                ++i;
            }
        }
        if (this.templateDSNComboViewer != null && this.options.getaTemplate() != null && (templateFormattedName = this.options.getaTemplate().getFormattedName()) != null) {
            this.updateComboTextIfNewValueNonNull(this.templateDSNComboViewer, templateFormattedName);
        }
        if (this.startPositionTypeComboViewer != null && this.options.getStartType() != null) {
            items = this.startPositionTypeComboViewer.getCombo().getItems();
            i = 0;
            while (i < items.length) {
                if (BaseEditorOptions.BaseStartPosType.valueOf((String)items[i].trim()).equals((Object)this.options.getStartType())) {
                    this.startPositionTypeComboViewer.getCombo().select(i);
                    this.startPositionTypeComboViewer.getCombo().notifyListeners(13, new Event());
                    if (!this.startPositionComboViewer.getCombo().isEnabled()) break;
                    this.startPositionComboViewer.getCombo().setText(this.options.getaStartPosition());
                    break;
                }
                ++i;
            }
        }
        if ((binaryLength = this.options.getBinaryLength()) != null) {
            this.updateComboTextIfNewValueNonNull(this.binaryReclenComboViewer, binaryLength);
        }
        this.updateCheckButtonSelectionIfButtonNotNull(this.recordSamplingButton, this.options.isRecordSampling());
        this.updateCheckButtonSelectionIfButtonNotNull(this.inplaceEditButton, this.options.isInplaceEdit());
        String includePhysicalRecords = this.options.getIncludePhysicalRecords();
        if (includePhysicalRecords != null) {
            this.updateComboTextIfNewValueNonNull(this.includePhysicalRecordsComboViewer, includePhysicalRecords);
        }
        if ((skipPhysicalRecords = this.options.getSkipPhysicalRecords()) != null) {
            this.updateComboTextIfNewValueNonNull(this.skipPhysicalRecordComboViewer, skipPhysicalRecords);
        }
        this.updateCheckButtonSelectionIfButtonNotNull(this.includeOnlySelectedButton, this.options.isOnlySelectedRecs());
        String recordLimit = this.options.getRecordLimit();
        if (recordLimit != null) {
            this.updateComboTextIfNewValueNonNull(this.recordLimitComboViewer, recordLimit);
        }
        if ((encodingForSession = this.options.getEncodingForSession()) != null) {
            this.updateComboTextIfNewValueNonNull(this.encodingComboViewer, encodingForSession);
        }
        if (this.dbcsEncodingComboViewer != null && this.options.isDbcsEncodingValueSet()) {
            this.updateComboTextIfNewValueNonNull(this.dbcsEncodingComboViewer, this.options.getDbcsEncodingForSession());
        }
        if (this.dbcsEncodingComboViewer != null && this.options.isDbcsEncodingValueSet()) {
            this.updateComboTextIfNewValueNonNull(this.dbcsEncodingComboViewer, this.options.getDbcsEncodingForSession());
        }
        PDBiDiHelpers.enableBidiCombos((String)this.encodingComboViewer.getCombo().getText(), (Combo)this.textLayoutComboViewer.getCombo(), (Combo)this.textDirectionComboViewer.getCombo(), (boolean)true);
        String ioExitName = this.options.getIoExitName();
        if (ioExitName != null) {
            this.updateComboTextIfNewValueNonNull(this.ioExitComboViewer, ioExitName);
        }
        this.updateCheckButtonSelectionIfButtonNotNull(this.mqDesciptorButton, this.options.isMQDescriptorSelected());
    }

    private void updateComboTextIfNewValueNonNull(ComboViewer viewer, String value) {
        if (viewer != null && value != null) {
            viewer.getCombo().setText(value);
        } else {
            this.logger.trace((Object)MessageFormat.format("updateTextIfNewValueNonNull: viewer={0} value={1}", viewer == null ? "null" : viewer, value == null ? "null" : value));
        }
    }

    private void updateCheckButtonSelectionIfButtonNotNull(Button button2, boolean value) {
        if (button2 != null) {
            button2.setSelection(value);
            button2.notifyListeners(13, new Event());
        } else {
            this.logger.trace((Object)"updateButtonFromModelField: button is null.");
        }
    }

    private static ComboViewer createComboViewer(Group group, String toolTip, String cvsId) {
        Objects.requireNonNull(group, "Must provide a non-null parent group.");
        return EditorOptionDialog.createComboViewer(GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1)), toolTip, cvsId, null, false, 0);
    }

    private static ComboViewer createComboViewer(Combo combo2, String toolTip, String cvsId, String[] customItems, boolean customAtTop, int selectIndex) {
        Objects.requireNonNull(combo2, "Must provide a non-null parent combo.");
        ComboViewer cv = new ComboViewer(combo2);
        combo2.setToolTipText(toolTip);
        if (cvsId != null) {
            new ComboValueSaver(combo2, cvsId);
        }
        if (customItems != null) {
            ComboValueSaver.getInstance((Combo)combo2).setCustomItems(customItems, customAtTop);
        }
        if (selectIndex >= 0) {
            combo2.select(selectIndex);
        }
        return cv;
    }

    public EditorOptionDialog(Shell parentShell, IPDHost host, IZRL selectedResource) {
        if (selectedResource != null && !host.equals(selectedResource.getSystem())) {
            throw new IllegalArgumentException();
        }
        this.options = new BaseEditorOptions();
        this.host = host;
        this.options.setTemplateSystem(host);
        this.options.setaResource(selectedResource);
        this.options.setEncodingForSession(host.getCodePage());
        this.dialogTitle = Messages.EditorOptionDialog_EDITOR_TITLE_EDIT;
        this.dialogMsg = Messages.EditorOptionDialog_EDITOR_MSG_EDIT;
        TrayDialog.setDialogHelpAvailable((boolean)false);
    }

    public EditorOptionDialog(Shell parentShell, IPDHost host, BaseEditorOptions opts) {
        this(parentShell, host, opts.getaResource());
        this.options.setTemplateSystem(opts.getTemplateSystem() != null ? opts.getTemplateSystem() : host);
        this.options.setaVolumeSerial(opts.getaVolumeSerial());
        this.options.setaTemplate(opts.getaTemplate());
        this.options.setStartType(opts.getStartType());
        this.options.setaStartPosition(opts.getaStartPosition());
        this.options.setBinaryLength(opts.getBinaryLength());
        this.options.setRecordSampling(opts.isRecordSampling());
        this.options.setInplaceEdit(opts.isInplaceEdit());
        this.options.setOnlySelectedRecs(opts.isOnlySelectedRecs());
        this.options.setIncludePhysicalRecords(opts.getIncludePhysicalRecords());
        this.options.setSkipPhysicalRecords(opts.getSkipPhysicalRecords());
        this.options.setRecordLimit(opts.getRecordLimit());
        this.options.setEncodingForSession(opts.getEncodingForSession());
        this.options.setDbcsEncodingForSession(opts.getDbcsEncodingForSession());
        this.options.setBidiFormat(opts.getBidiFormat());
        this.options.setIoExitName(opts.getIoExitName());
        this.options.setMQDescriptor(opts.isMQDescriptorSelected());
    }

    protected Control createDialogArea(Composite parent) {
        Matcher matcher;
        this.getShell().setText(this.dialogTitle);
        this.setTitle(this.dialogTitle);
        this.setMessage(this.dialogMsg);
        IZRL zrl = this.options.getaResource();
        if (zrl != null && (matcher = PATTERN_PLACEHOLDER.matcher(zrl.getFormattedName())).find()) {
            this.setMessage(Messages.EditorOptionDialog_EDITOR_MSG_PLACEHOLDERS, 2);
        }
        GridLayout margins = GUI.grid.l.margins((int)1, (boolean)false);
        margins.verticalSpacing = 0;
        Composite composite = GUI.composite((Composite)parent, (Layout)margins, (Object)GUI.grid.d.fillAll());
        this.createResourceComposite(composite);
        this.createTemplateComposite(composite);
        this.createStartPositionComposite(composite);
        this.createProcessingOptionsComposite(composite);
        this.updateUI();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = new GridData();
        data.widthHint = 100;
        Button editButton = GUI.button.push((Composite)parent, (String)Messages.EditorOptionDialog_EDIT, (Object)data, (String)Messages.EditorOptionDialog_EDIT_TIP);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                EditorOptionDialog.this.handleEditPressed();
            }
        });
        GUI.button.push((Composite)parent, (String)Messages.EditorOptionDialog_VIEW, (Object)data, (String)Messages.EditorOptionDialog_VIEW_TIP).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                EditorOptionDialog.this.handleViewPressed();
            }
        });
        GUI.button.push((Composite)parent, (String)Messages.EditorOptionDialog_CANCEL, (Object)data).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                EditorOptionDialog.this.logger.trace((Object)"Cancel pressed.");
                EditorOptionDialog.this.cancelPressed();
            }
        });
        this.getShell().setDefaultButton(editButton);
    }

    private void handleEditPressed() {
        this.options.setEditSession(true);
        this.logger.trace((Object)"Edit pressed.");
        this.validateAndClose();
    }

    private void handleViewPressed() {
        if (this.inplaceEditButton.getSelection()) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorOptionDialog_INPLACE_NOT_FOR_BROWSE);
        } else {
            this.options.setEditSession(false);
            this.logger.trace((Object)"View pressed.");
            this.validateAndClose();
        }
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = GUI.composite((Composite)parent, (Layout)GUI.grid.l.customMargins((int)3, (boolean)false, (int)10, (int)15), (Object)new GridData(0x1000008, 4, true, true));
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    private void createResourceComposite(Composite parent) {
        GridLayout margins = GUI.grid.l.margins((int)3, (boolean)false);
        margins.verticalSpacing = 0;
        margins.horizontalSpacing = 0;
        Group group = GUI.group((Composite)parent, (String)Messages.EditorOptionDialog_INPUT_RESOURCE_GROUP_NAME, (Layout)margins, (Object)GUI.grid.d.fillAll());
        ComboViewer resourceSystemComboViewer = SystemSelectionCombo.createSystemLabelAndComboViewer((Composite)group, new HashSet<IPDHost>(RegistryLocator.instance().getHostRegistry().all()), this.host);
        GUI.label.left((Composite)group, (String)"", (Object)GUI.grid.d.left1());
        resourceSystemComboViewer.getCombo().setEnabled(false);
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_DSNPATH, (Object)GUI.grid.d.left1());
        this.resourceNameComboViewer = EditorOptionDialog.createComboViewer(GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1)), Messages.EditorOptionDialog_RESOURCE_TIP, null, null, false, -1);
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)group), this.resourceNameComboViewer.getCombo(), (IHostProvider)this.getSystem()).types(ZRLs.getEditableResourceTypes((IPDHost)this.getSystem())).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                EditorOptionDialog.this.options.setaResource(zrl);
            }
        }).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Resource").create();
        this.resourceNameComboViewer.getCombo().setText(this.options.getaResource() != null ? this.options.getaResource().getFormattedName() : "");
        this.resourceNameComboViewer.getCombo().setFocus();
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_VOLUME_SERIAL, (Object)GUI.grid.d.left1());
        this.volumeSerialComboViewer = EditorOptionDialog.createComboViewer(GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1)), Messages.EditorOptionDialog_VOLUME_TIP, ((Object)((Object)this)).getClass().getCanonicalName() + "volser", null, false, -1);
        GUI.label.left((Composite)group, (String)"", (Object)GUI.grid.d.left1());
        if (this.getSystem().getHostType() != HostType.ZOS) {
            this.volumeSerialComboViewer.getCombo().setEnabled(false);
        }
    }

    private void createTemplateComposite(Composite parent) {
        List assocs;
        GridLayout margins = GUI.grid.l.margins((int)5, (boolean)false);
        margins.verticalSpacing = 0;
        margins.horizontalSpacing = 0;
        Group group = GUI.group((Composite)parent, (String)Messages.EditorOptionDialog_TEMPLATE_GROUP_NAME, (Layout)margins, (Object)GUI.grid.d.fillH((int)1));
        final ComboViewer templateSystemComboViewer = SystemSelectionCombo.createSystemLabelAndComboViewer((Composite)group, new HashSet<IPDHost>(RegistryLocator.instance().getHostRegistry().all()), this.options.getTemplateSystem(), 2);
        GUI.label.left((Composite)group, (String)"", (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)group, (String)"", (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_DSN, (Object)GUI.grid.d.left1());
        this.templateDSNComboViewer = new ComboViewer(GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1)));
        this.templateDSNComboViewer.getCombo().setToolTipText(Messages.EditorOptionDialog_TEMPLATE_TIP);
        if (!this.resourceNameComboViewer.getCombo().getText().isEmpty()) {
            this.templateDSNComboViewer.getCombo().setFocus();
        }
        templateSystemComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditorOptionDialog.this.handleTemplateSelectionChange((IStructuredSelection)event.getSelection());
            }
        });
        GUI.button.push((Composite)group, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/templateEditor.gif"), (String)Messages.__EDIT_TEMPLATE, (Object)GUI.grid.d.left1()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorOptionDialog.this.handleTemplateEditButtonSelection();
            }
        });
        GUI.button.push((Composite)group, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/menus/createTemplate.gif"), (String)Messages.NewDynamicTemplateDialog_Title, (Object)GUI.grid.d.left1()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorOptionDialog.this.handleNewDynamicTemplateButtonSelection();
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)group), this.templateDSNComboViewer.getCombo(), new IHostProvider(){

            public IPDHost getSystem() {
                return EditorOptionDialog.this.options.getTemplateSystem();
            }
        }).formatter(new ISelectedValueFormatter(){

            @Override
            public String getNewValue(IPDHost selectedHost, IZRL zrl) {
                return EditorOptionDialog.this.options.getaTemplate().getFormattedName();
            }
        }).filter(new ILookupFilterProvider(){

            @Override
            public String getInitialFilter(Combo combo2) {
                String text2 = combo2.getText();
                int openingParenthesis = text2.indexOf("(");
                return openingParenthesis != -1 ? text2.substring(0, openingParenthesis) : text2;
            }
        }).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                EditorOptionDialog.this.options.setaTemplate(zrl);
                EditorOptionDialog.this.options.setTemplateSystem(selectedHost);
                templateSystemComboViewer.setSelection((ISelection)new StructuredSelection((Object)EditorOptionDialog.this.options.getTemplateSystem()));
            }
        }).types(FMHost.getPermittedTemplateResourceType((IPDHost)this.host)).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Template").create();
        if (this.options.getaResource() != null && (assocs = FMHost.getSystem((IPDHost)this.host).getTemplateAssociations(this.options.getaResource())).size() > 0) {
            ComboValueSaver.getInstance((Combo)this.templateDSNComboViewer.getCombo()).setCustomItems(assocs.toArray(new String[0]), false, false);
            this.templateDSNComboViewer.getCombo().select(0);
        }
    }

    private void handleTemplateSelectionChange(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof IPDHost) {
            this.options.setTemplateSystem((IPDHost)selection.getFirstElement());
            List assocs = ZRLs.convertZRLListToFormattedNames((List)FMHost.getSystem((IPDHost)this.host).getTemplateAssociations(this.options.getaResource(), this.options.getTemplateSystem()));
            ComboValueSaver.getInstance((Combo)this.templateDSNComboViewer.getCombo()).setCustomItems(assocs.toArray(new String[0]), false, false);
            this.templateDSNComboViewer.getCombo().select(0);
        }
    }

    private void handleTemplateEditButtonSelection() {
        String aTemplateName = this.templateDSNComboViewer.getCombo().getText().trim();
        if (aTemplateName.isEmpty()) {
            PDDialogs.openErrorThreadSafe((String)Messages.EditorOptionDialog_TemplateEditNoTemplate);
        } else if (this.options.getDynamicTemplateFlag() || this.validateTemplateName()) {
            if (this.options.getRunTempKey() != null) {
                TemplateEditorUtilities.openTemplateEditSession(this.options.getaTemplate(), this.options, this.options.getDynamicTemplateFlag(), this.options.getRunTempKey());
            } else {
                TemplateEditorUtilities.openTemplateEditSession(this.options.getaTemplate(), this.options);
            }
        } else {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.EditorOptionDialog_TemplateEditInvalidTemplate, aTemplateName));
        }
    }

    private void handleNewDynamicTemplateButtonSelection() {
        IZRL templateResource = NewDynamicTemplateDialog.showCreateTemplateWizard(this.options, this.getSystem());
        this.options.setaTemplate(templateResource);
        this.templateDSNComboViewer.getCombo().setText(templateResource.getFormattedName());
        this.options.setDynamicTemplateFlag(true);
    }

    private void createStartPositionComposite(Composite parent) {
        GridLayout margins = GUI.grid.l.margins((int)2, (boolean)false);
        margins.verticalSpacing = 0;
        margins.horizontalSpacing = 0;
        Group group = GUI.group((Composite)parent, (String)Messages.EditorOptionDialog_START_POSITION_GROUP, (Layout)margins, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_START_POS_TYPE, (Object)GUI.grid.d.left1());
        this.startPositionTypeComboViewer = EditorOptionDialog.createComboViewer(GUI.combo.readOnly((Composite)group, (Object)GUI.grid.d.fillH((int)1), (Object[])ArrayUtils.getToStringArray((Object[])BaseEditorOptions.BaseStartPosType.values())), Messages.EditorOptionDialog_START_POSITION_TYPE_TIP, null, null, false, 0);
        this.startPositionTypeComboViewer.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorOptionDialog.this.handleStartPositionTypeComboSelection();
            }
        });
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_START_POS, (Object)GUI.grid.d.left1());
        this.startPositionComboViewer = EditorOptionDialog.createComboViewer(group, Messages.EditorOptionDialog_START_POSITION_TIP, null);
        this.startPositionComboViewer.getCombo().setEnabled(false);
    }

    private void handleStartPositionTypeComboSelection() {
        String str = this.startPositionTypeComboViewer.getCombo().getText();
        Combo startPosCombo = this.startPositionComboViewer.getCombo();
        switch (BaseEditorOptions.BaseStartPosType.valueOf((String)str)) {
            case NONE: {
                startPosCombo.setEnabled(false);
                break;
            }
            case KEY: 
            case RBA: 
            case RECORD_NUMBER: {
                startPosCombo.setEnabled(true);
                break;
            }
        }
    }

    private void createProcessingOptionsComposite(Composite parent) {
        GridLayout margins = GUI.grid.l.margins((int)2, (boolean)false);
        margins.verticalSpacing = 0;
        margins.horizontalSpacing = 0;
        Group group = GUI.group((Composite)parent, (String)Messages.EditorOptionDialog_PROCESSING_OPTION_GROUP_NAME, (Layout)margins, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_INPLACE_EDIT, (Object)GUI.grid.d.left1());
        this.inplaceEditButton = GUI.button.checkbox((Composite)group, (String)"", (Object)GUI.grid.d.left1());
        this.inplaceEditButton.setSelection(false);
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_REC_SAMP, (Object)GUI.grid.d.left1());
        this.recordSamplingButton = GUI.button.checkbox((Composite)group, (String)"", (Object)GUI.grid.d.left1());
        this.recordSamplingButton.setSelection(false);
        this.recordSamplingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorOptionDialog.this.includePhysicalRecordsComboViewer.getCombo().setEnabled(EditorOptionDialog.this.recordSamplingButton.getSelection());
                EditorOptionDialog.this.skipPhysicalRecordComboViewer.getCombo().setEnabled(EditorOptionDialog.this.recordSamplingButton.getSelection());
            }
        });
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_INC_PHY_REC, (Object)GUI.grid.d.left1());
        this.includePhysicalRecordsComboViewer = EditorOptionDialog.createComboViewer(group, Messages.EditorOptionDialog_INCLUDE_PHYSICAL_TIP, ((Object)((Object)this)).getClass().getCanonicalName() + "inclPhy");
        this.includePhysicalRecordsComboViewer.getCombo().setEnabled(false);
        NumberForcer.addNumberForcerPositiveInteger(this.includePhysicalRecordsComboViewer.getCombo(), ((Object)((Object)this)).getClass().getCanonicalName() + "inclPhy");
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_SKIP_PHY_REC, (Object)GUI.grid.d.left1());
        this.skipPhysicalRecordComboViewer = EditorOptionDialog.createComboViewer(group, Messages.EditorOptionDialog_SKIP_PHYSICAL_TIP, ((Object)((Object)this)).getClass().getCanonicalName() + "skipPhys");
        NumberForcer.addNumberForcerPositiveInteger(this.skipPhysicalRecordComboViewer.getCombo(), ((Object)((Object)this)).getClass().getCanonicalName() + "skipPhys");
        this.skipPhysicalRecordComboViewer.getCombo().setEnabled(false);
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_REC_LIMIT, (Object)GUI.grid.d.left1());
        this.recordLimitComboViewer = new ComboViewer(GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1)));
        new ComboValueSaver(this.recordLimitComboViewer.getCombo(), ((Object)((Object)this)).getClass().getCanonicalName() + "recLim");
        NumberForcer.addNumberForcerPositiveInteger(this.recordLimitComboViewer.getCombo(), ((Object)((Object)this)).getClass().getCanonicalName() + "recLim");
        this.recordLimitComboViewer.getCombo().setToolTipText(Messages.EditorOptionDialog_RECORD_LIMIT_TIP);
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_ONLY_SEL, (Object)GUI.grid.d.left1());
        this.includeOnlySelectedButton = GUI.button.checkbox((Composite)group, (String)"", (Object)GUI.grid.d.left1());
        this.includeOnlySelectedButton.setToolTipText(Messages.EditorOptionDialog_INCLUDE_ONLY_SELECTED_TIP);
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_RECLEN, (Object)GUI.grid.d.left1());
        this.binaryReclenComboViewer = new ComboViewer(GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1)));
        new ComboValueSaver(this.binaryReclenComboViewer.getCombo(), ((Object)((Object)this)).getClass().getCanonicalName() + "binRecLen");
        NumberForcer.addNumberForcerPositiveInteger(this.binaryReclenComboViewer.getCombo(), ((Object)((Object)this)).getClass().getCanonicalName() + "binRecLen");
        this.binaryReclenComboViewer.getCombo().setToolTipText(Messages.EditorOptionDialog_BINARY_REC_LEN_TIP);
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_ENCODING, (Object)GUI.grid.d.left1());
        this.encodingComboViewer = EditorOptionDialog.createComboViewer(GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1)), Messages.EditorOptionDialog_ENCODING_TIP, ((Object)((Object)this)).getClass().getCanonicalName() + "encoding", EncodingUtils.getDefaultEncodingValues(), false, 0);
        this.encodingComboViewer.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PDBiDiHelpers.enableBidiCombos((String)EditorOptionDialog.this.encodingComboViewer.getCombo().getText(), (Combo)EditorOptionDialog.this.textLayoutComboViewer.getCombo(), (Combo)EditorOptionDialog.this.textDirectionComboViewer.getCombo(), (boolean)false);
            }
        });
        GUI.label.left((Composite)group, (String)Messages.Db2EditorDialog_GraphicEncoding, (Object)GUI.grid.d.left1());
        this.dbcsEncodingComboViewer = EditorOptionDialog.createComboViewer(GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1)), Messages.Db2EditorDialog_GraphicEncodingDesc, ((Object)((Object)this)).getClass().getCanonicalName() + "dbcsEncodingCombo", EncodingUtils.getDefaultDBCSEncodingValues(), false, -1);
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_TEXT_LAYOUT, (Object)GUI.grid.d.left1());
        this.textLayoutComboViewer = Util.isMac() ? EditorOptionDialog.createComboViewer(GUI.combo.readOnly((Composite)group, (Object)GUI.grid.d.fillH((int)1), (Object[])layoutValuesNonWindows), Messages.EditorOptionDialog_MacBidiLimitationToolip, ((Object)((Object)this)).getClass().getCanonicalName() + "textLayout", null, false, 0) : EditorOptionDialog.createComboViewer(GUI.combo.readOnly((Composite)group, (Object)GUI.grid.d.fillH((int)1), (Object[])layoutValues), Messages.EditorOptionDialog_TEXT_LAYOUT_TIP, ((Object)((Object)this)).getClass().getCanonicalName() + "textLayout", null, false, BidiUtils.isBidiVisualSupportRequired((String)this.host.getBidiFormat()) ? 1 : 0);
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_TEXT_DIRECTION, (Object)GUI.grid.d.left1());
        this.textDirectionComboViewer = EditorOptionDialog.createComboViewer(GUI.combo.readOnly((Composite)group, (Object)GUI.grid.d.fillH((int)1), (Object[])directionValues), Messages.EditorOptionDialog_TEXT_DIRECTION_TIP, ((Object)((Object)this)).getClass().getCanonicalName() + "textDirection", null, false, BidiUtils.isBidiRTLSupportRequired((String)this.host.getBidiFormat()) ? 1 : 0);
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_0, (Object)GUI.grid.d.left1());
        this.ioExitComboViewer = new ComboViewer(GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1)));
        this.ioExitComboViewer.getCombo().setToolTipText(Messages.EditorOptionDialog_1);
        this.ioExitComboViewer.getCombo().select(0);
        GUI.label.left((Composite)group, (String)Messages.EditorOptionDialog_MQ_INCLUDE_DESCRIPTORS, (Object)GUI.grid.d.left1());
        this.mqDesciptorButton = GUI.button.checkbox((Composite)group, (String)"", (Object)GUI.grid.d.left1());
        this.mqDesciptorButton.setSelection(false);
        this.mqDesciptorButton.setToolTipText(Messages.EditorOptionDialog_MQ_INCLUDE_DESCRIPTORS_TIP);
        this.mqDesciptorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorOptionDialog.this.options.setMQDescriptor(EditorOptionDialog.this.mqDesciptorButton.getSelection());
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean validateAndClose() {
        if (!this.validateResourceName()) {
            return false;
        }
        String aVolume = this.volumeSerialComboViewer.getCombo().getText().toUpperCase();
        if (!aVolume.isEmpty()) {
            if (this.options.getaResource() instanceof MessageQueue || this.options.getaResource() instanceof UssFile) {
                PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.EditorOptionDialog_VOLUME_NA, this.options.getaResource().getFormattedName()));
                this.options.setaVolumeSerial(null);
            } else {
                if (!Volume.isValid((String)aVolume, (String)this.host.getCodePage())) {
                    this.setErrorMessage(Messages.EditorOptionDialog_VOLUME_SERIAL_INVALID);
                    this.options.setaVolumeSerial(null);
                    this.volumeSerialComboViewer.getCombo().setFocus();
                    return false;
                }
                this.options.setaVolumeSerial(aVolume);
            }
        } else {
            this.options.setaVolumeSerial(null);
        }
        if (!this.templateDSNComboViewer.getCombo().getText().isEmpty()) {
            if (!this.options.getaResource().getSystem().isSameSystem(this.options.getTemplateSystem()) && !this.validateRemoteTemplateSystem()) {
                return false;
            }
            if (!this.options.getDynamicTemplateFlag() && !this.validateTemplateName()) {
                return false;
            }
        } else {
            this.options.setaTemplate(null);
        }
        if (!this.validateStartPosition()) {
            return false;
        }
        if (!this.validateStartPositionAndResourceType(this.options.getStartType(), this.options.getaResource())) {
            return false;
        }
        if (!this.validateProcessingOptions()) {
            return false;
        }
        if (!this.validateEncoding()) {
            return false;
        }
        if (!this.validateDbcsEncoding()) {
            return false;
        }
        if (!this.validateBidiOptions()) {
            return false;
        }
        if (!this.validateIoExitName()) {
            return false;
        }
        boolean isClose = this.close();
        this.logger.trace((Object)("isClose=" + isClose));
        return isClose;
    }

    private boolean validateRemoteTemplateSystem() {
        if (RemoteServicesUI.validateRemoteSystem(this.host, this.options.getTemplateSystem())) {
            return true;
        }
        this.setMessage(Messages.EditorOptionDialog_REMOTE_SYSTEM_INVALID, 3);
        return false;
    }

    private boolean validateStartPosition() {
        BaseEditorOptions.BaseStartPosType startPositionType = BaseEditorOptions.BaseStartPosType.valueOf((String)this.startPositionTypeComboViewer.getCombo().getText());
        String value = this.startPositionComboViewer.getCombo().getText();
        switch (startPositionType) {
            case KEY: {
                if (value.isEmpty()) {
                    this.setMessage(Messages.EditorOptionDialog_START_POS_KEYERR, 3);
                    this.startPositionComboViewer.getCombo().setFocus();
                    this.options.setStartType(BaseEditorOptions.BaseStartPosType.NONE);
                    this.options.setaStartPosition(null);
                    return false;
                }
                this.options.setStartType(startPositionType);
                this.options.setaStartPosition(value);
                return true;
            }
            case RBA: 
            case RECORD_NUMBER: {
                try {
                    Integer.parseInt(value);
                    this.options.setStartType(startPositionType);
                    this.options.setaStartPosition(value);
                    return true;
                }
                catch (Exception e) {
                    if (startPositionType == BaseEditorOptions.BaseStartPosType.RBA) {
                        this.setMessage(Messages.EditorOptionDialog_START_POS_RBAERR, 3);
                    } else {
                        this.setMessage(Messages.EditorOptionDialog_START_POS_RECNUMERR, 3);
                    }
                    this.options.setStartType(BaseEditorOptions.BaseStartPosType.NONE);
                    this.options.setaStartPosition(null);
                    this.startPositionComboViewer.getCombo().setFocus();
                    return false;
                }
            }
        }
        this.options.setStartType(BaseEditorOptions.BaseStartPosType.NONE);
        this.options.setaStartPosition(null);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateStartPositionAndResourceType(BaseEditorOptions.BaseStartPosType startType, IZRL aResource) {
        try {
            if (startType == BaseEditorOptions.BaseStartPosType.KEY && !(aResource instanceof DataSetOrMember) && !(aResource instanceof CicsFile)) {
                this.setMessage(MessageFormat.format(Messages.EditorOptionDialog_INVALID_START_POS, aResource.getFormattedName()), 3);
                return false;
            }
            if (startType == BaseEditorOptions.BaseStartPosType.RBA && !(aResource instanceof DataSetOrMember)) {
                this.setMessage(MessageFormat.format(Messages.EditorOptionDialog_INVALID_START_POS, aResource.getFormattedName()), 3);
                return false;
            }
            switch (startType) {
                case KEY: {
                    if (!(aResource instanceof DataSetOrMember)) {
                        return true;
                    }
                    DataSetOrMember zosResource = (DataSetOrMember)aResource;
                    Result<StringBuffer> result = ZrlLoaderDialogUtils.refreshDataSetProperties(zosResource);
                    if (!result.isSuccessfulWithoutWarnings()) {
                        String msg = MessageFormat.format(Messages.EditorOptionDialog_RESOURCE_PROPS_ERR, zosResource.getFormattedName());
                        this.setMessage(msg, 1);
                        return true;
                    }
                    if (!zosResource.getConfirmedExists()) {
                        this.setErrorMessage(MessageFormat.format(Messages.EditorOptionDialog_RESOURCE_DOES_NOT_EXIT, zosResource.getFormattedName()));
                        return false;
                    }
                    DataSetProperties props = zosResource.asDataSet().getProperties();
                    if (props == null) {
                        String msg = MessageFormat.format(Messages.EditorOptionDialog_RESOURCE_PROPS_ERR, zosResource.getFormattedName());
                        this.setMessage(msg, 1);
                        this.logger.error((Object)msg);
                        return true;
                    }
                    if (zosResource.asDataSet().getType() != DataSetType.KSDS && zosResource.asDataSet().getType() != DataSetType.KSDSIAM) {
                        this.setMessage(MessageFormat.format(Messages.EditorOptionDialog_NO_KEY, zosResource.getFormattedName()), 3);
                        this.resourceNameComboViewer.getCombo().setFocus();
                        return false;
                    }
                    return true;
                }
                case RBA: {
                    DataSetOrMember zosResource = (DataSetOrMember)aResource;
                    Result<StringBuffer> result = ZrlLoaderDialogUtils.refreshDataSetProperties(zosResource);
                    if (!result.isSuccessfulWithoutWarnings()) {
                        String msg = MessageFormat.format(Messages.EditorOptionDialog_RESOURCE_PROPS_ERR, zosResource.getFormattedName());
                        this.setMessage(msg, 1);
                        return true;
                    }
                    if (!zosResource.getConfirmedExists()) {
                        this.setMessage(MessageFormat.format(Messages.EditorOptionDialog_RESOURCE_DOES_NOT_EXIT, zosResource.getFormattedName()), 3);
                        this.resourceNameComboViewer.getCombo().setFocus();
                        return false;
                    }
                    if (zosResource.asDataSet().getType().getAccessMethod() == DataSetType.AccessMethod.VSAM) {
                        return true;
                    }
                    this.setMessage(MessageFormat.format(Messages.EditorOptionDialog_NO_RBA, zosResource.getFormattedName()), 3);
                    this.resourceNameComboViewer.getCombo().setFocus();
                    return false;
                }
            }
            return true;
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    private boolean validateResourceName() {
        if (this.resourceNameComboViewer.getCombo().getText().trim().isEmpty()) {
            this.setMessage(Messages.EditorOptionDialog_DSNERR_MSG, 3);
            this.resourceNameComboViewer.getCombo().setFocus();
            return false;
        }
        String value = this.resourceNameComboViewer.getCombo().getText();
        if (!ZRLs.isParseable((IPDHost)this.host, (String)value, (String)this.host.getCodePage())) {
            this.setErrorMessage(Messages.EditorOptionDialog_DSNERR_MSG);
            this.resourceNameComboViewer.getCombo().setFocus();
            return false;
        }
        this.aZrl = ZRLs.parseZRL((IPDHost)this.host, (String)value);
        if (ZRLs.isSupportedResourceType((IPDHost)this.getSystem(), (IZRL)this.aZrl)) {
            this.options.setaResource(this.aZrl);
            return true;
        }
        this.setErrorMessage(Messages.EditorOptionDialog_3);
        this.resourceNameComboViewer.getCombo().setFocus();
        return false;
    }

    private boolean validateTemplateName() {
        String result;
        block7: {
            String value = this.templateDSNComboViewer.getCombo().getText().trim();
            if (this.options.getaTemplate() != null && value.equalsIgnoreCase(this.options.getaTemplate().getFormattedName())) {
                return true;
            }
            if (value.equals("?")) {
                this.options.setaTemplate((IZRL)new EmptyWildcardZRL(this.options.getTemplateSystem()));
                return true;
            }
            this.options.setaTemplate(null);
            if (value.isEmpty() || !ZRLs.isParseable((IPDHost)this.options.getTemplateSystem(), (String)value, (String)this.options.getTemplateSystem().getCodePage())) {
                this.setErrorMessage(Messages.ExportDialog_14);
                this.options.setaTemplate(null);
                this.templateDSNComboViewer.getCombo().setFocus();
                return false;
            }
            this.setMessage(this.dialogMsg);
            result = TemplateEditorUtilities.okAsTemplate(ZRLs.parseZRL((IPDHost)this.options.getTemplateSystem(), (String)value), true, null);
            if (result != null) break block7;
            this.options.setaTemplate(ZRLs.parseZRL((IPDHost)this.options.getTemplateSystem(), (String)value));
            return true;
        }
        try {
            this.setErrorMessage(result);
            this.templateDSNComboViewer.getCombo().setFocus();
            this.options.setaTemplate(null);
            return false;
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(Messages.EditorOptionDialog_DSNERR_MSG);
            this.templateDSNComboViewer.getCombo().setFocus();
            this.options.setaTemplate(null);
            return false;
        }
        catch (InterruptedException e) {
            this.templateDSNComboViewer.getCombo().setFocus();
            this.options.setaTemplate(null);
            return false;
        }
    }

    public void setErrorMessage(String newErrorMessage) {
        if (!this.getShell().isDisposed()) {
            super.setErrorMessage(newErrorMessage);
        } else {
            this.logger.error((Throwable)new Exception("Attempted to set error message, when shell disposed: " + newErrorMessage));
        }
    }

    private boolean validateProcessingOptions() {
        if (!this.recordLimitComboViewer.getCombo().getText().isEmpty()) {
            if (!EditorOptionDialog.isValidInteger(this.recordLimitComboViewer.getCombo().getText())) {
                this.setMessage(Messages.EditorOptionDialog_RECORD_LIMIT_ERR, 3);
                this.recordLimitComboViewer.getCombo().setFocus();
                return false;
            }
            this.options.setRecordLimit(this.recordLimitComboViewer.getCombo().getText());
        } else {
            this.options.setRecordLimit(null);
        }
        if (this.recordSamplingButton.getSelection()) {
            String includePhysicalRecordValue = this.includePhysicalRecordsComboViewer.getCombo().getText();
            String skipPhysicalRecordValue = this.skipPhysicalRecordComboViewer.getCombo().getText();
            if (!EditorOptionDialog.isValidInteger(includePhysicalRecordValue)) {
                this.setMessage(Messages.EditorOptionDialog_INC_PHYRICAL_REC_ERR, 3);
                this.includePhysicalRecordsComboViewer.getCombo().setFocus();
                return false;
            }
            if (!EditorOptionDialog.isValidInteger(skipPhysicalRecordValue)) {
                this.setMessage(Messages.EditorOptionDialog_SKIP_PHYRICAL_REC_ERR, 3);
                this.skipPhysicalRecordComboViewer.getCombo().setFocus();
                return false;
            }
            this.options.setRecordSampling(true);
            this.options.setIncludePhysicalRecords(includePhysicalRecordValue);
            this.options.setSkipPhysicalRecords(skipPhysicalRecordValue);
        } else {
            this.options.setRecordSampling(false);
            this.options.setIncludePhysicalRecords(null);
            this.options.setSkipPhysicalRecords(null);
        }
        if (this.includeOnlySelectedButton.getSelection()) {
            if (this.templateDSNComboViewer.getCombo().getText().isEmpty()) {
                this.setMessage(Messages.EditorOptionDialog_SEL_ONLY_NO_TEMPLATE_ERR, 3);
                this.includeOnlySelectedButton.setFocus();
                return false;
            }
            this.options.setOnlySelectedRecs(true);
        } else {
            this.options.setOnlySelectedRecs(false);
        }
        this.options.setInplaceEdit(this.inplaceEditButton.getSelection());
        if (!this.binaryReclenComboViewer.getCombo().getText().isEmpty()) {
            String lengthValue = this.binaryReclenComboViewer.getCombo().getText();
            if (lengthValue.isEmpty() || !EditorOptionDialog.isValidInteger(lengthValue)) {
                this.setMessage(Messages.EditorOptionDialog_BIN_RECL_ERR, 3);
                this.binaryReclenComboViewer.getCombo().setFocus();
                return false;
            }
            this.options.setBinaryLength(lengthValue);
        } else {
            this.options.setBinaryLength(null);
        }
        this.setMessage(this.dialogMsg);
        if (!(this.options.getaResource() instanceof UssFile) && this.binaryReclenComboViewer.getCombo().getText().length() > 0) {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.EditorOptionDialog_BIN_LEN_INVALID, this.options.getaResource().getFormattedName()));
        }
        return true;
    }

    private static boolean isValidInteger(String value) {
        Objects.requireNonNull(value);
        if (value.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public IPDHost getSystem() {
        return this.host;
    }

    private boolean validateEncoding() {
        String value = this.encodingComboViewer.getCombo().getText();
        if (value.isEmpty()) {
            this.options.setEncodingForSession(this.host.getCodePage());
            return true;
        }
        if (!EncodingUtils.isValidCodePage((String)(value = EncodingUtils.parseCodePage((String)value)))) {
            this.setMessage(MessageFormat.format(Messages.EditorOptionDialog_ENCODING_NOT_SUPPORTED, value), 3);
            this.encodingComboViewer.getCombo().setFocus();
            return false;
        }
        this.options.setEncodingForSession(value);
        return true;
    }

    private boolean validateDbcsEncoding() {
        String value = this.dbcsEncodingComboViewer.getCombo().getText();
        if (value.isEmpty()) {
            this.options.setDbcsEncodingForSession("");
            return true;
        }
        if (!EncodingUtils.isValidCodePage((String)(value = EncodingUtils.parseCodePage((String)value)))) {
            this.setErrorMessage(Messages.Db2EditorDialog_31);
            this.dbcsEncodingComboViewer.getCombo().setFocus();
            this.options.setDbcsEncodingForSession("");
            return false;
        }
        this.options.setDbcsEncodingForSession(value);
        return true;
    }

    private boolean validateBidiOptions() {
        this.options.setBidiFormat(PDBiDiHelpers.getBidiFormat((String)this.textLayoutComboViewer.getCombo().getText(), (String)this.textDirectionComboViewer.getCombo().getText()));
        return true;
    }

    private boolean validateIoExitName() {
        String value = this.ioExitComboViewer.getCombo().getText().trim().toUpperCase();
        if (value.isEmpty()) {
            this.options.setIoExitName(null);
            return true;
        }
        if (!Member.isParseable((String)value, (boolean)false, (String)this.options.getaResource().getSystem().getCodePage())) {
            this.setErrorMessage(Messages.EditorOptionDialog_2);
            this.ioExitComboViewer.getCombo().setFocus();
            return false;
        }
        this.options.setIoExitName(value);
        return true;
    }

    public BaseEditorOptions getEditorOptions() {
        return this.options;
    }

    public IZRL getResource() {
        if (this.validateResourceName()) {
            return this.aZrl;
        }
        return null;
    }
}

