/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.contents;

import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;

public class HexRecordWrapper
extends DisplayLine {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private DisplayLine dLine = null;
    private boolean highBits;

    public HexRecordWrapper(IZRL resource, DisplayLine displayLine, boolean highBits) {
        super(resource, displayLine.getRecord());
        this.dLine = displayLine;
        this.highBits = highBits;
    }

    public DisplayLine getDisplayLine() {
        return this.dLine;
    }

    public boolean isHighBits() {
        return this.highBits;
    }

    public String getEntireHighOrLowHexString() {
        String hexValue = this.dLine.getRecord().getHex();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < hexValue.length()) {
            if (this.highBits) {
                if (i % 2 == 0) {
                    sb.append(hexValue.charAt(i));
                }
            } else if (i % 2 != 0) {
                sb.append(hexValue.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public String getFieldHighOrLowHexString(int start, int length) {
        String hexValue = this.getEntireHighOrLowHexString();
        if (start - 1 >= hexValue.length()) {
            return "";
        }
        if (start - 1 + length >= hexValue.length()) {
            return hexValue.substring(start - 1);
        }
        return hexValue.substring(start - 1, length);
    }

    public void prepareHighAndLow(StringBuilder high, StringBuilder low) {
        String hexValue = this.dLine.getRecord().getHex();
        int i = 0;
        while (i < hexValue.length()) {
            if (i % 2 == 0) {
                high.append(hexValue.charAt(i));
            } else {
                low.append(hexValue.charAt(i));
            }
            ++i;
        }
    }

    public void setHighAndLowHexValues(String newHighHex, String newLowHex) {
        StringBuffer updatedValue = new StringBuffer();
        int i = 0;
        while (i < newHighHex.length()) {
            updatedValue.append(newHighHex.charAt(i));
            updatedValue.append(newLowHex.charAt(i));
            ++i;
        }
        this.getRecord().setHex(updatedValue.toString().toUpperCase());
        this.getRecord().setChg(true);
    }
}

