/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.editor.formatted.ColumnSelectAssistProposalProvider;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.NavigationAssistProposalProvider;
import com.ibm.etools.fm.editor.formatted.NavigationSpecification;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.handler.JumpToRecord;
import com.ibm.etools.fm.editor.formatted.handler.PageDown;
import com.ibm.etools.fm.editor.formatted.handler.PageUp;
import com.ibm.etools.fm.editor.template.TemplateEditor;
import com.ibm.etools.fm.editor.template2.TemplateEditor2;
import com.ibm.etools.fm.model.formatted.HdrType;
import com.ibm.etools.fm.model.formatted.HdrfldType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TopNavigationBar {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String TOP = "TOP";
    public static final String BOTTOM = "BOT";
    public static final String LOCATE = "LOCATE";
    public static final String KEY = "KEY ";
    public static final String UP = "UP";
    public static final String UP_SHORTCUT = "-";
    public static final String DOWN = "DOWN";
    public static final String DOWN_SHORTCUT = "+";
    public static final String OFFSET = "OFFSET";
    private FormattedEditor editor;
    private Combo navigationCombo;
    private static final String NAVIGATION_COMBO = "com.ibm.etools.fm.editor.formatted.TopNavigationBar.navCombo";
    private Button stepRightButton;
    private Button stepLeftButton;
    private Text columnNoText;
    private Text currentText;
    private Text totalText;
    private Text cursorText;
    private NavigationAssistProposalProvider navigationAssistProposalProvider;
    private ColumnSelectAssistProposalProvider proposalProvider;
    private static final char assistIndicator = '\u0001';
    private Text editorModeText;

    public TopNavigationBar(FormattedEditor editor2) {
        this.editor = editor2;
    }

    public Control createControl(Composite parent) {
        Composite toolbarComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)7, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createNavigationComposite(toolbarComposite);
        this.createNavigationButtonsComposite(toolbarComposite);
        this.createLocationComposite(toolbarComposite);
        this.createEditTypeComposite(toolbarComposite);
        parent.pack();
        return parent;
    }

    private void createNavigationComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false, (int)0), (Object)GUI.grid.d.fillH((int)1, (int)150));
        GUI.label.left((Composite)composite, (String)Messages.TopNavigationBar_NAV, (Object)GUI.grid.d.left1());
        this.navigationCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1, (int)50));
        String[] history = FMUIPlugin.getDefault().getDialogValues(NAVIGATION_COMBO);
        int tempInd = history.length;
        String[] navigationComboInit = new String[tempInd + 7];
        if (history.length > 0) {
            int i = 0;
            while (i < tempInd) {
                navigationComboInit[i] = history[i];
                ++i;
            }
        } else {
            history = new String[7];
        }
        navigationComboInit[tempInd++] = TOP;
        navigationComboInit[tempInd++] = BOTTOM;
        navigationComboInit[tempInd++] = "UP\u0001";
        navigationComboInit[tempInd++] = "DOWN\u0001";
        navigationComboInit[tempInd++] = "LOCATE\u0001";
        navigationComboInit[tempInd++] = KEY.trim() + "\u0001";
        navigationComboInit[tempInd++] = OFFSET.trim() + "\u0001";
        this.navigationCombo.setItems(navigationComboInit);
        this.navigationCombo.select(0);
        this.navigationCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\n' || e.character == '\r') {
                    String cmd = TopNavigationBar.this.navigationCombo.getText();
                    boolean doIt = true;
                    if (cmd.endsWith("\u0001")) {
                        doIt = false;
                    }
                    cmd = cmd.trim();
                    if (doIt && cmd.length() > 0) {
                        if (!TopNavigationBar.this.editor.updateDirtyContents()) {
                            return;
                        }
                        String formattedCommand = TopNavigationBar.this.validateNavigationCommand(cmd = cmd.replace('\u0001', ' '));
                        if (formattedCommand != null) {
                            FMUIPlugin.getDefault().renewDialogValue(TopNavigationBar.NAVIGATION_COMBO, formattedCommand);
                        }
                        TopNavigationBar.this.executeCommand(formattedCommand, cmd);
                    }
                }
            }
        });
        this.navigationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String cmd = TopNavigationBar.this.navigationCombo.getText();
                boolean doIt = true;
                if (cmd.endsWith("\u0001")) {
                    doIt = false;
                }
                cmd = cmd.trim();
                if (doIt && cmd.length() > 0) {
                    if (!TopNavigationBar.this.editor.updateDirtyContents()) {
                        return;
                    }
                    String formattedCommand = TopNavigationBar.this.validateNavigationCommand(cmd = cmd.replace('\u0001', ' '));
                    if (formattedCommand != null) {
                        FMUIPlugin.getDefault().renewDialogValue(TopNavigationBar.NAVIGATION_COMBO, formattedCommand);
                    }
                    TopNavigationBar.this.executeCommand(formattedCommand, cmd);
                }
            }
        });
        this.navigationCombo.setToolTipText(Messages.TopNavigationBar_NAV_CMD_DESC);
        this.setupNavigationContentAssist();
        GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/run.gif"), (String)Messages.TopNavigationBar_GO_TIP, (Object)GUI.grid.d.left1()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String cmd = TopNavigationBar.this.navigationCombo.getText().trim();
                if (!cmd.isEmpty()) {
                    String formattedCommand = TopNavigationBar.this.validateNavigationCommand(cmd);
                    if (formattedCommand != null) {
                        FMUIPlugin.getDefault().renewDialogValue(TopNavigationBar.NAVIGATION_COMBO, formattedCommand);
                    }
                    TopNavigationBar.this.executeCommand(formattedCommand, cmd);
                }
            }
        });
    }

    public void setupNavigationContentAssist() {
        if (this.navigationAssistProposalProvider == null && this.editor.getActiveLayout() != null) {
            ComboContentAdapter contentAdapter = new ComboContentAdapter();
            this.navigationAssistProposalProvider = new NavigationAssistProposalProvider('\u0001');
            this.navigationAssistProposalProvider.setFiltering(false);
            KeyStroke ks = KeyStroke.getInstance((int)262144, (int)32);
            new ContentProposalAdapter((Control)this.navigationCombo, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)this.navigationAssistProposalProvider, ks, null);
            ControlDecoration hint = new ControlDecoration((Control)this.navigationCombo, 16512);
            hint.setShowOnlyOnFocus(true);
            FieldDecoration cp = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
            hint.setImage(cp.getImage());
            hint.setDescriptionText(Messages.TopNavigationBar_6);
        }
    }

    private boolean executeCommand(String formattedCommand, String enteredValue) {
        if (formattedCommand == null) {
            PDDialogs.openErrorThreadSafe((String)Messages.TopNavigationBar_INVALID_CMD, (String)(MessageFormat.format(Messages.TopNavigationBar_INVALID_CMD_DESC, enteredValue) + "\n\n" + Messages.TopNavigationBar_NAV_CMD_DESC));
            return false;
        }
        new JumpToRecord(formattedCommand).run(this.editor);
        return true;
    }

    private String validateNavigationCommand(String cmd) {
        int value;
        block12: {
            if (TOP.equals(cmd = cmd.toUpperCase())) {
                return cmd;
            }
            if ("BOTTOM".equals(cmd) || BOTTOM.equals(cmd)) {
                return BOTTOM;
            }
            if (cmd.startsWith(LOCATE)) {
                return this.validateLocationWithCommad(LOCATE, cmd);
            }
            if (cmd.startsWith(OFFSET)) {
                return this.validateLocationWithCommad(OFFSET, cmd);
            }
            if (cmd.startsWith(KEY)) {
                return cmd;
            }
            if (cmd.startsWith(UP)) {
                return this.validateLocationWithCommad(UP, cmd);
            }
            if (cmd.startsWith(DOWN)) {
                return this.validateLocationWithCommad(DOWN, cmd);
            }
            if (cmd.startsWith(UP_SHORTCUT)) {
                return this.validateLocationWithCommad(UP_SHORTCUT, cmd);
            }
            if (cmd.startsWith(DOWN_SHORTCUT)) {
                return this.validateLocationWithCommad(DOWN_SHORTCUT, cmd);
            }
            try {
                value = Integer.parseInt(cmd);
                if (value > 0) break block12;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return "LOCATE " + value;
    }

    private String validateLocationWithCommad(String commandString, String enteredValue) {
        String location = enteredValue.substring(commandString.length()).trim();
        if (location.isEmpty()) {
            return null;
        }
        try {
            int recno = Integer.parseInt(location);
            if (recno > 0) {
                if (UP_SHORTCUT.equals(commandString)) {
                    return "UP " + recno;
                }
                if (DOWN_SHORTCUT.equals(commandString)) {
                    return "DOWN " + recno;
                }
                return commandString + " " + recno;
            }
            if (commandString.contains(OFFSET)) {
                return "OFFSET " + recno;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void createNavigationButtonsComposite(Composite parent) {
        Composite buttonComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)4, (boolean)false, (int)0), (Object)GUI.grid.d.left1());
        GUI.button.push((Composite)buttonComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/windowup.gif"), (String)Messages.StepUpAction_TOOLTIP, (Object)GUI.grid.d.left1()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PageUp action = new PageUp();
                action.run(TopNavigationBar.this.editor);
            }
        });
        GUI.button.push((Composite)buttonComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/windowdown.gif"), (String)Messages.StepDownAction_TOOLTIP, (Object)GUI.grid.d.left1()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PageDown action = new PageDown();
                action.run(TopNavigationBar.this.editor);
            }
        });
        this.stepLeftButton = GUI.button.push((Composite)buttonComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/windowleft.gif"), (String)Messages.StepLeftAction_TOOLTIP, (Object)GUI.grid.d.left1());
        this.stepLeftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TopNavigationBar.this.editor.goLeft();
            }
        });
        this.stepRightButton = GUI.button.push((Composite)buttonComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/windowright.gif"), (String)Messages.StepRightAction_TOOLTIP, (Object)GUI.grid.d.left1());
        this.stepRightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TopNavigationBar.this.editor.goRight();
            }
        });
        Composite showComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false, (int)0), (Object)GUI.grid.d.fillH((int)1, (int)100));
        GUI.label.left((Composite)showComposite, (String)Messages.ShowColumn, (Object)GUI.grid.d.left1());
        this.columnNoText = GUI.text.field((Composite)showComposite, (Object)GUI.grid.d.fillH((int)1, (int)50));
        this.columnNoText.setToolTipText(Messages.ShowColumnTooltip);
        this.columnNoText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    TopNavigationBar.this.editor.startFromColumn(TopNavigationBar.this.columnNoText.getText());
                }
            }
        });
        this.columnNoText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TopNavigationBar.this.editor.startFromColumn(TopNavigationBar.this.columnNoText.getText());
            }
        });
        if (this.editor != null && this.editor.getCurrentEditorMode() != IFMEditor.EditorMode.FORMATTED) {
            this.setSegmented(false);
        } else {
            this.setSegmented(true);
        }
    }

    public void setSegmented(boolean segmented) {
        this.stepLeftButton.setEnabled(segmented);
        this.stepRightButton.setEnabled(segmented);
        this.columnNoText.setEnabled(segmented);
    }

    private void createLocationComposite(Composite parent) {
        Composite cursorComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false, (int)0), (Object)GUI.grid.d.fillH((int)1, (int)150));
        GUI.label.left((Composite)cursorComposite, (String)Messages.TopNavigationBar_0, (Object)GUI.grid.d.left1());
        this.cursorText = GUI.text.field((Composite)cursorComposite, (Object)GUI.grid.d.fillH((int)1, (int)50));
        this.cursorText.setToolTipText(Messages.TopNavigationBar_1);
        this.cursorText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    if (TopNavigationBar.this.cursorText.getText().endsWith(":")) {
                        return;
                    }
                    TopNavigationBar.this.setCursorLocation();
                }
            }
        });
        this.setupLayoutContentAssist();
        GUI.button.push((Composite)cursorComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/run.gif"), (String)Messages.TopNavigationBar_2, (Object)GUI.grid.d.left1()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TopNavigationBar.this.setCursorLocation();
            }
        });
        Composite currentComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false, (int)0), (Object)GUI.grid.d.fillH((int)1, (int)100));
        GUI.label.left((Composite)currentComposite, (String)Messages.TopNavigationBar_CURRENT, (Object)GUI.grid.d.left1());
        this.currentText = GUI.text.fieldReadOnly((Composite)currentComposite, (Object)GUI.grid.d.fillH((int)1, (int)50));
        Composite totalComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false, (int)0), (Object)GUI.grid.d.fillH((int)1, (int)100));
        GUI.label.left((Composite)totalComposite, (String)Messages.TopNavigationBar_TOTAL, (Object)GUI.grid.d.left1());
        this.totalText = GUI.text.fieldReadOnly((Composite)totalComposite, (Object)GUI.grid.d.fillH((int)1, (int)50));
    }

    public void setupLayoutContentAssist() {
        if (this.proposalProvider == null && this.editor.getCurrentEditorMode() == IFMEditor.EditorMode.FORMATTED && this.editor.getActiveLayout() != null) {
            TextContentAdapter contentAdapter = new TextContentAdapter();
            this.proposalProvider = new ColumnSelectAssistProposalProvider(this.editor);
            this.proposalProvider.setFiltering(true);
            KeyStroke ks = KeyStroke.getInstance((int)262144, (int)32);
            new ContentProposalAdapter((Control)this.cursorText, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)this.proposalProvider, ks, null);
            ControlDecoration hint = new ControlDecoration((Control)this.cursorText, 16512);
            hint.setShowOnlyOnFocus(true);
            FieldDecoration cp = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
            hint.setImage(cp.getImage());
            hint.setDescriptionText(Messages.TopNavigationBar_3);
        }
    }

    private void setCursorLocation() {
        if (this.editor.getCurrentEditorContents().isEmpty()) {
            PDDialogs.openInfoThreadSafe((String)Messages.TopNavigationBar_4);
            return;
        }
        String cursorLocationText = this.cursorText.getText();
        if (cursorLocationText == null || cursorLocationText.trim().isEmpty()) {
            return;
        }
        NavCommandInput command = this.parseInput(cursorLocationText = cursorLocationText.trim());
        if (command == null) {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.TopNavigationBar_5, cursorLocationText));
            return;
        }
        DisplayLine currentLine = this.editor.getCurrentLine();
        if (currentLine == null) {
            currentLine = this.editor.getCurrentEditorContents().get(0);
        }
        if (this.editor.getCurrentEditorMode() == IFMEditor.EditorMode.FORMATTED) {
            if (command.columnNumber != -1) {
                this.editor.setCursor(new NavigationSpecification(currentLine, command.columnNumber, true));
            }
            this.editor.setCursor(new NavigationSpecification(command.columnNumber, command.cursorLocation));
        } else {
            this.editor.setCursor(new NavigationSpecification(currentLine, command.cursorLocation, false));
        }
    }

    private NavCommandInput parseInput(String inputStr) {
        if (this.editor.getCurrentEditorMode() == IFMEditor.EditorMode.FORMATTED) {
            return this.parseInputForTable(inputStr);
        }
        return this.parseInputForChar(inputStr);
    }

    private NavCommandInput parseInputForChar(String inputStr) {
        try {
            int location = Integer.parseInt(inputStr);
            if (location >= 0) {
                NavCommandInput input = new NavCommandInput(-1, location);
                return input;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private NavCommandInput parseInputForTable(String inputStr) {
        if (inputStr.startsWith("#")) {
            int realColIndex;
            int curSpec;
            block26: {
                HdrType headerType;
                Symboltype selectedSymbol;
                int arrayEle;
                boolean withArrayEle;
                block25: {
                    block24: {
                        block23: {
                            int colSpec;
                            block22: {
                                StringTokenizer st;
                                block21: {
                                    st = new StringTokenizer(inputStr, "#:, ()");
                                    boolean bl = withArrayEle = inputStr.indexOf(40) != -1;
                                    if (!withArrayEle || this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.BASE) break block21;
                                    return null;
                                }
                                colSpec = Integer.parseInt(st.nextToken());
                                arrayEle = -1;
                                if (withArrayEle) {
                                    arrayEle = Integer.parseInt(st.nextToken());
                                }
                                curSpec = 0;
                                if (st.hasMoreTokens()) {
                                    curSpec = Integer.parseInt(st.nextToken());
                                }
                                if (!st.hasMoreTokens()) break block22;
                                return null;
                            }
                            selectedSymbol = null;
                            Layouttype currentLayout = this.editor.getActiveLayout();
                            int i = 0;
                            while (i < currentLayout.getSymbol().size()) {
                                Symboltype aSymbol = (Symboltype)currentLayout.getSymbol().get(i);
                                if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
                                    refName = TemplateEditor2.getFieldReferenceNumberForDisplay(currentLayout, aSymbol);
                                    if (refName.equals("#" + colSpec)) {
                                        selectedSymbol = aSymbol;
                                        break;
                                    }
                                } else {
                                    refName = TemplateEditor.getFieldReferenceNumberForDisplay(currentLayout, aSymbol, false);
                                    if (refName.equals("" + colSpec)) {
                                        selectedSymbol = aSymbol;
                                        break;
                                    }
                                }
                                ++i;
                            }
                            if (selectedSymbol != null) break block23;
                            return null;
                        }
                        headerType = this.editor.getCurrentTableHeader(this.editor.getActiveLayoutID());
                        if (headerType != null) break block24;
                        return null;
                    }
                    if (headerType.getHdrfld() != null && !headerType.getHdrfld().isEmpty()) break block25;
                    return null;
                }
                try {
                    realColIndex = -1;
                    int i = 0;
                    while (i < headerType.getHdrfld().size()) {
                        HdrfldType aHdrField = (HdrfldType)headerType.getHdrfld().get(i);
                        if (aHdrField.getSym() == selectedSymbol.getRef()) {
                            if (withArrayEle) {
                                if (aHdrField.getDim() != null && aHdrField.getDim().equals("(" + arrayEle + ")")) {
                                    realColIndex = i + 1;
                                    break;
                                }
                            } else {
                                realColIndex = i + 1;
                                break;
                            }
                        }
                        ++i;
                    }
                    if (realColIndex != -1) break block26;
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
            return new NavCommandInput(realColIndex, curSpec);
        }
        return this.parseInputForChar(inputStr);
    }

    private void createEditTypeComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false, (int)0), (Object)GUI.grid.d.fillH((int)1, (int)100));
        GUI.label.left((Composite)composite, (String)Messages.TopNavigationBar_EDIT_MODE, (Object)GUI.grid.d.left1());
        this.editorModeText = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1, (int)50));
        if (!this.editor.isEditSession()) {
            this.editorModeText.setText(BaseEditorOptions.EditType.VIEW.name());
        } else {
            this.editorModeText.setText(this.editor.getSessionProperties().isInplaceEdit() ? BaseEditorOptions.EditType.INPLACE.name() : BaseEditorOptions.EditType.FULL.name());
        }
    }

    public void setLocationText(String current, String total) {
        this.currentText.setText(current);
        this.totalText.setText(total);
    }

    public void setCursorLocationText(String cursorLoc) {
        if (!this.cursorText.isDisposed()) {
            if (cursorLoc != null && cursorLoc.length() > 0) {
                this.cursorText.setText(cursorLoc);
            } else {
                this.cursorText.setText("");
            }
        }
    }

    public void setColumnNoText(int showFromColumnIndex) {
        if (!this.columnNoText.isDisposed()) {
            this.columnNoText.setText(Integer.toString(showFromColumnIndex));
        }
    }

    public void setEditType(BaseEditorOptions.EditType view2) {
        if (this.editorModeText != null && !this.editorModeText.isDisposed() && view2 != null) {
            this.editorModeText.setText(view2.name());
        }
    }

    private static class NavCommandInput {
        public int columnNumber = -1;
        public int cursorLocation = -1;

        public NavCommandInput(int columnNumber, int cursorLocation) {
            this.columnNumber = columnNumber;
            this.cursorLocation = cursorLocation;
        }
    }
}

