/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted;

import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.handler.PageDown;
import com.ibm.etools.fm.editor.formatted.handler.PageUp;
import java.util.Objects;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;

public class ScrollSupportStrategy {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public static MouseWheelListener prepareMouseWheelListener(final FormattedEditor editor2, ScrollBar scrollBar) {
        return new MouseWheelListener(){

            public void mouseScrolled(MouseEvent event) {
                editor2.setNeedScrolling(false);
            }
        };
    }

    public static void handleScrollAction(FormattedEditor editor2, ScrollBar scroll, Event event) {
        Objects.requireNonNull(editor2, "Must specify a non-null editor.");
        if (editor2.isScrollInAction()) {
            return;
        }
        if (event.detail == 1) {
            return;
        }
        int max = scroll.getMaximum();
        int current = scroll.getSelection();
        int thumb = scroll.getThumb();
        if (current == 0) {
            if (editor2.isNeedScrolling()) {
                PageUp action = new PageUp();
                action.run(editor2);
            } else {
                editor2.setNeedScrolling(true);
            }
        } else if (current + thumb == max) {
            if (editor2.isNeedScrolling()) {
                PageDown action = new PageDown();
                action.run(editor2);
            } else {
                editor2.setNeedScrolling(true);
            }
        } else {
            editor2.setNeedScrolling(false);
        }
    }
}

