/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.db2.Db2EditOptions;
import com.ibm.etools.fm.core.model.ims.ImsEditorOptions;
import com.ibm.etools.fm.core.model.ims.ImsSegmentsInformation;
import com.ibm.etools.fm.core.util.ImsKeyPositionOptionsUtil;
import com.ibm.etools.fm.editor.formatted.FMEditSessionProperties;
import com.ibm.etools.fm.editor.formatted.FMEditorInputWithTemplate;
import com.ibm.etools.fm.editor.formatted.operations.GetTemplateOperation;
import com.ibm.etools.fm.editor.formatted.operations.SendShowCommandOperation;
import com.ibm.etools.fm.editor.formatted.operations.StartImsEditSessionOperation;
import com.ibm.etools.fm.editor.formatted1.dialogs.ImsKeyPositioningDialog;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.etools.fm.jhost.core.version.ServerTooOldException;
import com.ibm.etools.fm.model.fmnxdpos.DbposType;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.etools.fm.ui.util.EditorManagement;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDFileSystemUtil;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.comms.TheHost;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import com.ibm.pdtools.common.component.ui.prefs.PDCommonPreferencePage;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDEditorManagement;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class OpenFormattedEditorJob
extends Job {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private PDLogger logger = PDLogger.get(OpenFormattedEditorJob.class);
    private FMEditSessionProperties props = null;
    private AbstractSessionFormatted.SessionType sessionType;
    private BaseEditorOptions baseOptions = null;
    private Db2EditOptions db2Options = null;
    private ImsEditorOptions imsOptions = null;
    private IFile cachedFile = null;
    private AbstractSessionFormatted session;
    private IFile templateCachedFile = null;
    private boolean editorStartOK = false;
    private Result<StringBuffer> overallResult;
    private IZRL backupTemplate = null;
    private UUID uniqueKey = null;
    private IActionItem actionItem = null;

    public OpenFormattedEditorJob(FMEditSessionProperties props, BaseEditorOptions options, IZRL backupTemplate) {
        super(MessageFormat.format(Messages.OpenFormattedEditorJob_NAME, options.getaResource().getFormattedName()));
        this.sessionType = AbstractSessionFormatted.SessionType.BASE;
        options.getaResource().setPersistentProperty("encoding", options.getEncodingForSession());
        options.getaResource().setPersistentProperty("dbcsEncoding", options.getDbcsEncodingForSession());
        options.getaResource().setPersistentProperty("bidiFormat", options.getBidiFormat());
        this.baseOptions = options;
        this.props = props;
        this.backupTemplate = backupTemplate;
        this.registerPostJobAction();
        this.setUser(true);
        this.logger.trace((Object)"Opening editor...");
    }

    public OpenFormattedEditorJob(FMEditSessionProperties props, BaseEditorOptions options, IZRL backupTemplate, UUID uniqueKey) {
        this(props, options, backupTemplate);
        this.uniqueKey = uniqueKey;
    }

    public OpenFormattedEditorJob(FMEditSessionProperties props, BaseEditorOptions options, IZRL backupTemplate, IActionItem action) {
        this(props, options, backupTemplate);
        this.actionItem = action;
    }

    public OpenFormattedEditorJob(FMEditSessionProperties props, BaseEditorOptions options, IZRL backupTemplate, IActionItem action, UUID uniqueKey) {
        this(props, options, backupTemplate, action);
        this.uniqueKey = uniqueKey;
    }

    public OpenFormattedEditorJob(FMEditSessionProperties props, Db2EditOptions options, IZRL backupTemplate, String encoding, String dbcsEncoding, String bidiFormat) {
        super(MessageFormat.format(Messages.OpenFormattedEditorJob_NAME, options.getTable().getFormattedName()));
        this.sessionType = AbstractSessionFormatted.SessionType.DB2;
        this.props = props;
        this.db2Options = options;
        this.backupTemplate = backupTemplate;
        if (this.db2Options != null && this.db2Options.getTable() != null) {
            this.db2Options.getTable().setPersistentProperty("encoding", encoding);
            this.db2Options.getTable().setPersistentProperty("dbcsEncoding", dbcsEncoding);
            this.db2Options.getTable().setPersistentProperty("bidiFormat", bidiFormat);
        }
        this.registerPostJobAction();
        this.overallResult = new Result();
        this.setUser(true);
    }

    public OpenFormattedEditorJob(FMEditSessionProperties props, ImsEditorOptions options, IZRL backupTemplate, String encoding, String dbcsEncoding, String bidiFormat) {
        super(MessageFormat.format(Messages.OpenFormattedEditorJob_NAME, options.getDatabase() != null ? options.getDatabase().getName() : (options.getPcb() != null ? options.getPcb().getName() : "")));
        this.sessionType = AbstractSessionFormatted.SessionType.IMS;
        this.props = props;
        this.imsOptions = options;
        this.backupTemplate = backupTemplate;
        if (this.imsOptions != null && this.imsOptions.getImsResource() != null) {
            this.imsOptions.getImsResource().setPersistentProperty("encoding", encoding);
            this.imsOptions.getImsResource().setPersistentProperty("dbcsEncoding", dbcsEncoding);
            this.imsOptions.getImsResource().setPersistentProperty("bidiFormat", bidiFormat);
        }
        this.registerPostJobAction();
        this.overallResult = new Result();
        this.setUser(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
        switch (this.sessionType) {
            case IMS: {
                return this.runIms(howIsGoing);
            }
            case DB2: {
                return this.runDB2(howIsGoing);
            }
        }
        return this.runBase(howIsGoing);
    }

    private Result<StringBuffer> startEditSession(IHowIsGoing monitor) throws InterruptedException {
        this.session = AbstractSessionFormatted.createFormattedEditSession((BaseEditorOptions)this.baseOptions, (FMEditSessionProperties)this.props);
        if (this.uniqueKey != null) {
            String xmlBuffer = FMUIPlugin.getDefault().getTemplateXMLBuffer(this.uniqueKey);
            return this.session.startBase(monitor, FormattedEditorPreferencePage.getEditorInitSettings(), xmlBuffer);
        }
        return this.session.startBase(monitor, FormattedEditorPreferencePage.getEditorInitSettings());
    }

    private IStatus runBase(IHowIsGoing monitor) {
        try {
            StringBuilder msgCombined;
            monitor.beginTask(MessageFormat.format(Messages.OpenFormattedEditorJob_NAME, this.baseOptions.getaResource().getFormattedName()), 2);
            FMUIPlugin.getDefault().removeDSEditSession(this.baseOptions.getaResource());
            FMUIPlugin.getDefault().addNewDSEditSession(this.baseOptions.getaResource());
            Result<StringBuffer> result = this.startEditSession(monitor);
            ConnectionUtilities.getLogin((TheHost)new TheHost(new HostDetails(this.baseOptions.getaResource().getSystem())), (IHowIsGoing)monitor);
            if (!result.isSuccessfulWithoutWarnings() && this.baseOptions.checkForAnddisableUnsupportedHostEditorOptions(result)) {
                if (PDCommonPreferencePage.isReportingVersionIncompatibleProblems()) {
                    PDDialogs.openWarningThreadSafe((String)Messages.OpenFormattedEditorJob_SERVER_TOO_OLD, (String)Messages.OpenFormattedEditorJob_SOME_OPTIONS_NOT_SUPPORTED);
                }
                result = this.startEditSession(monitor);
            }
            if (!result.isSuccessfulWithoutWarnings()) {
                FMUIPlugin.getDefault().removeDSEditSession(this.baseOptions.getaResource());
                String errMsg = "";
                errMsg = this.baseOptions.isEditSession() ? MessageFormat.format(Messages.OpenAsFormatted_EDIT_XML_ERROR, this.baseOptions.getaResource().getFormattedName(), this.baseOptions.getaTemplate() != null ? this.baseOptions.getaTemplate().getFormattedName() : Messages.NONE) : MessageFormat.format(Messages.OpenAsFormatted_BROWSE_XML_ERROR, this.baseOptions.getaResource().getFormattedName(), this.baseOptions.getaTemplate() != null ? this.baseOptions.getaTemplate().getFormattedName() : Messages.NONE);
                StringBuilder msgCombined2 = result.getMessagesCombined();
                errMsg = OpenFormattedEditorJob.inUse(msgCombined2).concat(errMsg);
                if (this.baseOptions.getaTemplate() != null && msgCombined2.indexOf("FMNBE046") != -1) {
                    PDDialogWithText.ITextDialogRunnable action = this.createRetrieveListingAction();
                    PDDialogs.openErrorThreadSafe((String)errMsg, (String)msgCombined2.toString(), (String[])new String[]{Messages.OpenAsTemplate_GET_LIST}, (PDDialogWithText.ITextDialogRunnable[])new PDDialogWithText.ITextDialogRunnable[]{action});
                } else {
                    PDDialogs.openErrorThreadSafe((String)errMsg, (String)msgCombined2.toString());
                }
                if (this.actionItem != null) {
                    this.actionItem.setErrorToolTipText(msgCombined2.toString());
                }
                this.editorStartOK = false;
                return new Status(0, "com.ibm.etools.fm.ui", "editStartErr1");
            }
            if (result.getRC() == 0 && this.uniqueKey == null && (msgCombined = result.getMessagesCombined()) != null && msgCombined.length() != 0) {
                PDDialogs.openWarningThreadSafe((String)Messages.Warning, (String)msgCombined.toString());
            }
            monitor.worked(1);
            IFile dataSetFile = this.session.getCacheFile();
            if (dataSetFile == null) {
                FMUIPlugin.getDefault().removeDSEditSession(this.baseOptions.getaResource());
                String errMsg = "";
                errMsg = this.baseOptions.isEditSession() ? MessageFormat.format(Messages.OpenAsFormatted_EDIT_XML_ERROR, this.baseOptions.getaResource().getFormattedName()) : MessageFormat.format(Messages.OpenAsFormatted_BROWSE_XML_ERROR, this.baseOptions.getaResource().getFormattedName());
                PDDialogs.openErrorThreadSafe((String)errMsg);
                if (this.actionItem != null) {
                    this.actionItem.setErrorToolTipText(errMsg);
                }
                this.editorStartOK = false;
                return new Status(0, "com.ibm.etools.fm.ui", "editStartErr2");
            }
            monitor.worked(1);
            if (!this.loadTemplate(monitor)) {
                FMUIPlugin.getDefault().removeDSEditSession(this.baseOptions.getaResource());
                this.editorStartOK = false;
                return new Status(0, "com.ibm.etools.fm.ui", "templateReadErr");
            }
            monitor.worked(1);
            if (this.baseOptions.getaTemplate() != null && !SendShowCommandOperation.sendDefaults(this.session, monitor)) {
                FMUIPlugin.getDefault().removeDSEditSession(this.baseOptions.getaResource());
                this.editorStartOK = false;
                return new Status(0, "com.ibm.etools.fm.ui", "showCmdErr");
            }
            monitor.worked(1);
            if (!this.readRecords(monitor)) {
                FMUIPlugin.getDefault().removeDSEditSession(this.baseOptions.getaResource());
                this.editorStartOK = false;
                return new Status(0, "com.ibm.etools.fm.ui", "readDataErr");
            }
            monitor.worked(1);
            this.editorStartOK = true;
            return new Status(0, "com.ibm.etools.fm.ui", "success");
        }
        catch (InterruptedException ie) {
            FMUIPlugin.getDefault().removeDSEditSession(this.baseOptions.getaResource());
            return new Status(0, "com.ibm.etools.fm.ui", "cancelled");
        }
        catch (IllegalArgumentException e) {
            FMUIPlugin.getDefault().removeDSEditSession(this.baseOptions.getaResource());
            throw e;
        }
    }

    public static String inUse(StringBuilder msg) {
        String summaryMsg = "";
        if (msg.indexOf("FMNBA313") != -1) {
            summaryMsg = Messages.OpenAsFormatted_DSN_IN_USE;
        } else if (msg.indexOf("FMNBE123") != -1) {
            summaryMsg = Messages.OpenAsFormatted_MEMBER_IN_USE;
        } else if (msg.indexOf("FMNBA375") != -1 && msg.indexOf("data set in use") != -1) {
            summaryMsg = Messages.OpenAsFormatted_DATASET_IN_USE;
        }
        return summaryMsg + " ";
    }

    private PDDialogWithText.ITextDialogRunnable createRetrieveListingAction() {
        PDDialogWithText.ITextDialogRunnable action = new PDDialogWithText.ITextDialogRunnable(){

            public void run(PDDialogWithText dialog) {
                block2: {
                    try {
                        PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                block5: {
                                    monitor.setTaskName(Messages.OpenAsTemplate_GET_LIST_OPS_NAME);
                                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                                    IFile tmpFile = null;
                                    try {
                                        tmpFile = PDFileSystemUtil.getTempFile((String)"FM");
                                        Result listResult = (this).OpenFormattedEditorJob.this.session.getCompilerListing(howIsGoing, tmpFile);
                                        if (listResult.getRC() == 0) {
                                            PDEditorManagement.openEditorFromWorkerThread((IFile)tmpFile, (IHowIsGoing)howIsGoing);
                                        } else {
                                            PDDialogs.openErrorThreadSafe((String)Messages.OpenAsTemplate_GET_LIST_ERR, (String)listResult.getMessagesCombined().toString());
                                            if ((this).OpenFormattedEditorJob.this.actionItem != null) {
                                                (this).OpenFormattedEditorJob.this.actionItem.setErrorToolTipText(listResult.getMessagesCombined().toString());
                                            }
                                        }
                                    }
                                    catch (CoreException e) {
                                        String errMsg = Messages.OpenAsTemplate_GET_LIST_ERR;
                                        PDDialogs.openErrorThreadSafe((String)errMsg);
                                        (this).OpenFormattedEditorJob.this.logger.error((Object)errMsg, (Throwable)e);
                                        if ((this).OpenFormattedEditorJob.this.actionItem == null) break block5;
                                        (this).OpenFormattedEditorJob.this.actionItem.setErrorToolTipText(errMsg);
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        String errMsg = Messages.OpenAsTemplate_GET_LIST_ERR;
                        PDDialogs.openErrorThreadSafe((String)errMsg);
                        OpenFormattedEditorJob.this.logger.error((Object)errMsg, (Throwable)e);
                        if (OpenFormattedEditorJob.this.actionItem == null) break block2;
                        OpenFormattedEditorJob.this.actionItem.setErrorToolTipText(errMsg);
                    }
                }
            }
        };
        return action;
    }

    private IStatus runDB2(IHowIsGoing monitor) {
        try {
            monitor.beginTask(MessageFormat.format(Messages.OpenFormattedEditorJob_NAME, this.db2Options.getTable().getFormattedName()), 2);
            FMUIPlugin.getDefault().addNewDSEditSession((IZRL)this.db2Options.getTable());
            ConnectionUtilities.getLogin((TheHost)new TheHost(new HostDetails(this.db2Options.getSystem())), (IHowIsGoing)monitor);
            this.session = AbstractSessionFormatted.createFormattedEditSession((Db2EditOptions)this.db2Options, (FMEditSessionProperties)this.props);
            Result result = this.session.startDB2Session(monitor);
            if (!result.isSuccessfulWithoutWarnings()) {
                FMUIPlugin.getDefault().removeDSEditSession((IZRL)this.db2Options.getTable());
                String errMsg = "";
                errMsg = this.db2Options.isEdit() ? MessageFormat.format(Messages.OpenAsFormatted_EDIT_XML_ERROR, this.db2Options.getTable().getFormattedName(), this.db2Options.getTemplate() != null ? this.db2Options.getTemplate().getFormattedName() : Messages.NONE) : MessageFormat.format(Messages.OpenAsFormatted_BROWSE_XML_ERROR, this.db2Options.getTable().getFormattedName(), this.db2Options.getTemplate() != null ? this.db2Options.getTemplate().getFormattedName() : Messages.NONE);
                StringBuilder msgCombined = result.getMessagesCombined();
                errMsg = OpenFormattedEditorJob.inUse(msgCombined).concat(errMsg);
                PDDialogs.openErrorThreadSafe((String)errMsg, (String)msgCombined.toString());
                if (this.actionItem != null) {
                    this.actionItem.setErrorToolTipText(msgCombined.toString());
                }
                this.overallResult.setRC(8);
                this.overallResult.add(errMsg);
                this.editorStartOK = false;
                return new Status(0, "com.ibm.etools.fm.ui", "editStartErr1");
            }
            monitor.worked(1);
            IFile dataSetFile = this.session.getCacheFile();
            if (dataSetFile == null) {
                FMUIPlugin.getDefault().removeDSEditSession((IZRL)this.db2Options.getTable());
                String errMsg = "";
                errMsg = this.db2Options.isEdit() ? MessageFormat.format(Messages.OpenAsFormatted_EDIT_XML_ERROR, this.db2Options.getTable().getFormattedName()) : MessageFormat.format(Messages.OpenAsFormatted_BROWSE_XML_ERROR, this.db2Options.getTable().getFormattedName());
                PDDialogs.openErrorThreadSafe((String)errMsg);
                if (this.actionItem != null) {
                    this.actionItem.setErrorToolTipText(errMsg);
                }
                this.editorStartOK = false;
                this.overallResult.setRC(8);
                this.overallResult.add(errMsg);
                return new Status(0, "com.ibm.etools.fm.ui", "editStartErr2");
            }
            monitor.worked(1);
            if (!this.loadTemplate(monitor)) {
                FMUIPlugin.getDefault().removeDSEditSession((IZRL)this.db2Options.getTable());
                this.editorStartOK = false;
                this.overallResult.setRC(8);
                String errMsg = MessageFormat.format(Messages.OpenAsFormatted_DB2_GET_TEMPLATE_ERROR, this.db2Options.getTemplate().getFormattedName(), this.db2Options.getTable().getFormattedName());
                this.overallResult.add(errMsg);
                return new Status(0, "com.ibm.etools.fm.ui", "templateReadErr");
            }
            monitor.worked(1);
            if (!SendShowCommandOperation.sendDb2Defaults(this.session, monitor)) {
                FMUIPlugin.getDefault().removeDSEditSession((IZRL)this.db2Options.getTable());
                this.editorStartOK = false;
                return new Status(0, "com.ibm.etools.fm.ui", "showCmdErr");
            }
            if (!this.readRecords(monitor)) {
                FMUIPlugin.getDefault().removeDSEditSession((IZRL)this.db2Options.getTable());
                this.editorStartOK = false;
                this.overallResult.setRC(8);
                String errMsg = MessageFormat.format(Messages.OpenAsFormatted_DB2_READ_RECORD_ERROR, this.db2Options.getTable().getFormattedName());
                this.overallResult.add(errMsg);
                return new Status(0, "com.ibm.etools.fm.ui", "readDataErr");
            }
            monitor.worked(1);
            this.editorStartOK = true;
            return new Status(0, "com.ibm.etools.fm.ui", "success");
        }
        catch (InterruptedException ie) {
            FMUIPlugin.getDefault().removeDSEditSession((IZRL)this.db2Options.getTable());
            return new Status(0, "com.ibm.etools.fm.ui", "cancelled");
        }
    }

    private IStatus runIms(IHowIsGoing monitor) {
        try {
            FMUIPlugin.getDefault().addNewDSEditSession(this.imsOptions.getImsResource());
            ConnectionUtilities.getLogin((TheHost)new TheHost(new HostDetails(this.imsOptions.getSystem())), (IHowIsGoing)monitor);
            if (!this.checkServerVersionForIms(this.imsOptions.getSystem(), monitor)) {
                FMUIPlugin.getDefault().removeDSEditSession(this.imsOptions.getImsResource());
                this.editorStartOK = false;
                this.overallResult.setRC(8);
                return new Status(0, "com.ibm.etools.fm.ui", "checkServerVersionErr");
            }
            Result result = new Result();
            this.session = StartImsEditSessionOperation.execute(this.imsOptions, this.props, (Result<StringBuffer>)result, monitor);
            if (this.session == null || !result.isSuccessfulWithoutWarnings()) {
                FMUIPlugin.getDefault().removeDSEditSession(this.imsOptions.getImsResource());
                if (this.session != null) {
                    this.session.end(monitor);
                }
                this.editorStartOK = false;
                this.overallResult.setRC(result.getRC());
                this.overallResult.addSubResult(result);
                return new Status(0, "com.ibm.etools.fm.ui", "editStartErr");
            }
            Result<StringBuffer> getKeyResult = StartImsEditSessionOperation.retrieveImsKeyPosition(this.session, monitor);
            if (!getKeyResult.isSuccessfulWithoutWarnings()) {
                FMUIPlugin.getDefault().removeDSEditSession(this.imsOptions.getImsResource());
                this.session.end(monitor);
                this.editorStartOK = false;
                this.overallResult.setRC(8);
                return new Status(0, "com.ibm.etools.fm.ui", "getImsKeyPosErr");
            }
            final DbposType initDbpos = ImsKeyPositionOptionsUtil.load((String)((StringBuffer)getKeyResult.getOutput()).toString(), (String)this.imsOptions.getSystem().getConnectionName());
            if (initDbpos == null) {
                FMUIPlugin.getDefault().removeDSEditSession(this.imsOptions.getImsResource());
                this.session.end(monitor);
                this.editorStartOK = false;
                this.overallResult.setRC(8);
                PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.OpenFormattedEditorJob_6, this.imsOptions.getImsResource().getFormattedName()), (String)this.overallResult.dumpOutputAndMessages(true));
                return new Status(0, "com.ibm.etools.fm.ui", "parseImsKeyPosErr");
            }
            ImsSegmentsInformation segInfo = new ImsSegmentsInformation(initDbpos);
            this.session.setImsSegInfo(segInfo);
            final AtomicBoolean startEditor = new AtomicBoolean(false);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ImsKeyPositioningDialog dialog = new ImsKeyPositioningDialog(OpenFormattedEditorJob.this.session, OpenFormattedEditorJob.this.imsOptions, initDbpos, false);
                    if (dialog.open() != 0) {
                        startEditor.set(false);
                    } else {
                        startEditor.set(true);
                    }
                }
            });
            if (!startEditor.get()) {
                FMUIPlugin.getDefault().removeDSEditSession(this.imsOptions.getImsResource());
                this.session.end(monitor);
                this.editorStartOK = false;
                this.overallResult.setRC(8);
                this.overallResult.add(Messages.OpenFormattedEditorJob_0);
                return new Status(0, "com.ibm.etools.fm.ui", "keySetCancelByUser");
            }
            IFile dataSetFile = this.session.getCacheFile();
            if (dataSetFile == null) {
                String errMsg = "";
                errMsg = this.imsOptions.isEditSession() ? MessageFormat.format(Messages.OpenAsFormatted_EDIT_XML_ERROR, this.imsOptions.getDatabase() != null ? this.imsOptions.getDatabase().getName() : this.imsOptions.getPcb().getName()) : MessageFormat.format(Messages.OpenAsFormatted_BROWSE_XML_ERROR, this.imsOptions.getDatabase() != null ? this.imsOptions.getDatabase().getName() : this.imsOptions.getPcb().getName());
                PDDialogs.openErrorThreadSafe((String)errMsg);
                if (this.actionItem != null) {
                    this.actionItem.setErrorToolTipText(errMsg);
                }
                FMUIPlugin.getDefault().removeDSEditSession(this.imsOptions.getImsResource());
                this.session.end(monitor);
                this.editorStartOK = false;
                this.overallResult.setRC(8);
                this.overallResult.add(errMsg);
                return new Status(0, "com.ibm.etools.fm.ui", "editStartErr2");
            }
            monitor.worked(1);
            if (!this.loadTemplate(monitor)) {
                FMUIPlugin.getDefault().removeDSEditSession(this.imsOptions.getImsResource());
                this.session.end(monitor);
                this.editorStartOK = false;
                this.overallResult.setRC(8);
                String errMsg = MessageFormat.format(Messages.OpenFormattedEditorJob_1, this.imsOptions.getTemplate().getFormattedName(), this.imsOptions.getImsResource().getFormattedName());
                this.overallResult.add(errMsg);
                return new Status(0, "com.ibm.etools.fm.ui", "templateReadErr");
            }
            monitor.worked(1);
            if (!SendShowCommandOperation.sendImsDefaults(this.session, monitor)) {
                FMUIPlugin.getDefault().removeDSEditSession(this.imsOptions.getImsResource());
                this.session.end(monitor);
                this.editorStartOK = false;
                return new Status(0, "com.ibm.etools.fm.ui", "showCmdErr");
            }
            if (!this.readRecords(monitor)) {
                FMUIPlugin.getDefault().removeDSEditSession(this.imsOptions.getImsResource());
                this.session.end(monitor);
                this.editorStartOK = false;
                this.overallResult.setRC(8);
                String errMsg = MessageFormat.format(Messages.OpenFormattedEditorJob_10, this.imsOptions.getImsResource().getFormattedName());
                this.overallResult.add(errMsg);
                return new Status(0, "com.ibm.etools.fm.ui", "readDataErr");
            }
            this.editorStartOK = true;
            return new Status(0, "com.ibm.etools.fm.ui", "success");
        }
        catch (InterruptedException ie) {
            FMUIPlugin.getDefault().removeDSEditSession(this.imsOptions.getImsResource());
            if (this.session != null) {
                this.session.end(monitor);
            }
            return new Status(0, "com.ibm.etools.fm.ui", "cancelled");
        }
    }

    private boolean checkServerVersionForIms(IPDHost pdHost, IHowIsGoing monitor) throws InterruptedException {
        try {
            FMHost fmHost = (FMHost)pdHost.getFMHostSystem();
            fmHost.loadServerVersion(pdHost, monitor);
        }
        catch (CommunicationException ce) {
            String errMsg = Messages.OpenFormattedEditorJob_2;
            this.logger.error((Object)errMsg, (Throwable)ce);
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return false;
        }
        try {
            ((FMHost)pdHost.getFMHostSystem()).ensureSupported(this.imsOptions.getSystem(), FMFeature.IMS_EDIT);
            return true;
        }
        catch (ServerTooOldException stoe) {
            PDDialogs.openErrorThreadSafe((String)stoe.getMessage());
            return false;
        }
    }

    private boolean loadTemplate(IHowIsGoing monitor) throws InterruptedException {
        block6: {
            if (this.sessionType == AbstractSessionFormatted.SessionType.BASE && this.baseOptions.getaTemplate() == null) {
                return true;
            }
            this.templateCachedFile = GetTemplateOperation.execute(this.session, monitor);
            if (this.templateCachedFile != null) break block6;
            return false;
        }
        try {
            this.templateCachedFile.refreshLocal(1, (IProgressMonitor)monitor.getMonitor());
            return true;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            IZRL aTemplate = this.sessionType == AbstractSessionFormatted.SessionType.BASE ? this.baseOptions.getaTemplate() : this.db2Options.getTemplate();
            String errMsg = MessageFormat.format(Messages.FormattedEditor_LOAD_TEMPL_ERR, aTemplate.getFormattedName());
            this.logger.error((Object)errMsg, (Throwable)e);
            PDDialogs.openErrorThreadSafe((String)errMsg);
            if (this.actionItem != null) {
                this.actionItem.setErrorToolTipText(errMsg);
            }
            return false;
        }
    }

    private boolean readRecords(IHowIsGoing monitor) throws InterruptedException {
        Result readResult = new Result((Object)new StringBuffer());
        this.cachedFile = this.session.readRecords(monitor, readResult, FormattedEditorPreferencePage.getRecordCacheSize());
        if (this.cachedFile == null || !readResult.isSuccessfulWithoutWarnings()) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FMIFormattedDataEditor_EDITOT_INIT_ERR_MSG, "File Init Failure"), (String)readResult.getMessagesCombined().toString());
            if (this.actionItem != null) {
                this.actionItem.setErrorToolTipText(readResult.getMessagesCombined().toString());
            }
            return false;
        }
        return true;
    }

    private void registerPostJobAction() {
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (OpenFormattedEditorJob.this.editorStartOK) {
                    FMEditorInputWithTemplate fmiInput = null;
                    if (OpenFormattedEditorJob.this.sessionType == AbstractSessionFormatted.SessionType.BASE) {
                        BaseEditorOptions baseOptions = OpenFormattedEditorJob.this.session.getBaseEditOptions();
                        fmiInput = new FMEditorInputWithTemplate(OpenFormattedEditorJob.this.session.getCacheFile(), OpenFormattedEditorJob.this.props, baseOptions.getaResource(), OpenFormattedEditorJob.this.session, baseOptions.isEditSession(), OpenFormattedEditorJob.this.templateCachedFile, baseOptions.getaTemplate());
                    } else if (OpenFormattedEditorJob.this.sessionType == AbstractSessionFormatted.SessionType.DB2) {
                        Db2EditOptions db2Options = OpenFormattedEditorJob.this.session.getDb2EditOptions();
                        fmiInput = new FMEditorInputWithTemplate(OpenFormattedEditorJob.this.session.getCacheFile(), OpenFormattedEditorJob.this.props, (IZRL)db2Options.getTable(), OpenFormattedEditorJob.this.session, db2Options.isEdit(), OpenFormattedEditorJob.this.templateCachedFile, db2Options.getTemplate());
                    } else if (OpenFormattedEditorJob.this.sessionType == AbstractSessionFormatted.SessionType.IMS) {
                        ImsEditorOptions imsOptions = OpenFormattedEditorJob.this.session.getImsEditOptions();
                        fmiInput = new FMEditorInputWithTemplate(OpenFormattedEditorJob.this.session.getCacheFile(), OpenFormattedEditorJob.this.props, imsOptions.getImsResource(), OpenFormattedEditorJob.this.session, imsOptions.isEditSession(), OpenFormattedEditorJob.this.templateCachedFile, (IZRL)imsOptions.getTemplate());
                    } else {
                        PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.OpenFormattedEditorJob_3, OpenFormattedEditorJob.this.sessionType.toString()));
                        return;
                    }
                    EditorManagement.openFormattedEditorFromWorkerThread(OpenFormattedEditorJob.this.session.getCacheFile(), fmiInput, (IProgressMonitor)new NullProgressMonitor());
                    if (OpenFormattedEditorJob.this.actionItem != null) {
                        OpenFormattedEditorJob.this.actionItem.setErrorToolTipText(null);
                    }
                } else if (OpenFormattedEditorJob.this.sessionType == AbstractSessionFormatted.SessionType.BASE) {
                    final BaseEditorOptions baseOptions = OpenFormattedEditorJob.this.session.getBaseEditOptions();
                    FMUIPlugin.getDefault().removeDSEditSession(baseOptions.getaResource());
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).OpenFormattedEditorJob.this.backupTemplate != null && PDDialogs.openQuestion((String)MessageFormat.format(Messages.OpenAsFormatted_EDIT_ERR_BACKUP_TEMPL, baseOptions.getaResource().getFormattedName(), baseOptions.getaTemplate() != null ? baseOptions.getaTemplate().getFormattedName() : "", (this).OpenFormattedEditorJob.this.backupTemplate.getFormattedName()))) {
                                baseOptions.setaTemplate((this).OpenFormattedEditorJob.this.backupTemplate);
                                OpenFormattedEditorJob job = new OpenFormattedEditorJob((this).OpenFormattedEditorJob.this.props, baseOptions, null);
                                job.schedule();
                                return;
                            }
                        }
                    });
                } else if (OpenFormattedEditorJob.this.sessionType == AbstractSessionFormatted.SessionType.DB2) {
                    final Db2EditOptions db2Options = OpenFormattedEditorJob.this.session.getDb2EditOptions();
                    FMUIPlugin.getDefault().removeDSEditSession((IZRL)db2Options.getTable());
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).OpenFormattedEditorJob.this.backupTemplate != null && PDDialogs.openQuestion((String)MessageFormat.format(Messages.OpenAsFormatted_EDIT_ERR_BACKUP_TEMPL, db2Options.getTable().getFormattedName(), db2Options.getTemplate() != null ? db2Options.getTemplate().getFormattedName() : "", (this).OpenFormattedEditorJob.this.backupTemplate.getFormattedName()))) {
                                db2Options.setTemplate((this).OpenFormattedEditorJob.this.backupTemplate);
                                OpenFormattedEditorJob job = new OpenFormattedEditorJob((this).OpenFormattedEditorJob.this.props, db2Options, (this).OpenFormattedEditorJob.this.backupTemplate, db2Options.getTable().getPersistentProperty("encoding"), db2Options.getTable().getPersistentProperty("dbcsEncoding"), db2Options.getTable().getPersistentProperty("bidiFormat"));
                                job.schedule();
                                return;
                            }
                        }
                    });
                } else if (OpenFormattedEditorJob.this.sessionType == AbstractSessionFormatted.SessionType.IMS) {
                    if (OpenFormattedEditorJob.this.session != null) {
                        ImsEditorOptions imsOptions = OpenFormattedEditorJob.this.session.getImsEditOptions();
                        FMUIPlugin.getDefault().removeDSEditSession(imsOptions.getImsResource());
                    }
                } else {
                    PDDialogs.openErrorThreadSafe((String)("Failed to start a browse/edit session for the unknown session type: " + OpenFormattedEditorJob.this.sessionType.toString()));
                }
            }
        });
    }

    public Result<StringBuffer> getDb2ImsOverallResult() {
        return this.overallResult;
    }

    public boolean editorStartOK() {
        return this.editorStartOK;
    }
}

