/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted;

import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;

public class NavigationSpecification {
    public static final NavigationSpecification TOP = new NavigationSpecification(LocationType.TOP);
    public static final NavigationSpecification BOTTOM = new NavigationSpecification(LocationType.BOTTOM);
    public static final NavigationSpecification JUST_FOCUS = new NavigationSpecification(LocationType.JUST_FOCUS);
    private LocationType locationSpec = LocationType.TOP;
    private DisplayLine aRecord = null;
    private int columnNumber = 0;
    private int recordOffset = 0;

    private NavigationSpecification(LocationType locSpec) {
        this.locationSpec = locSpec;
        this.aRecord = null;
        this.columnNumber = 0;
        this.recordOffset = 0;
    }

    public NavigationSpecification(DisplayLine aLine) {
        this.locationSpec = LocationType.RECORD_NUMBER;
        this.aRecord = aLine;
    }

    public NavigationSpecification(DisplayLine aLine, int columnNumberOrOffset, boolean isColumnNumber) {
        if (isColumnNumber) {
            this.locationSpec = LocationType.COLUMN_NUMBER;
            this.aRecord = aLine;
            this.columnNumber = columnNumberOrOffset;
        } else {
            this.locationSpec = LocationType.RECORD_OFFSET;
            this.aRecord = aLine;
            this.recordOffset = columnNumberOrOffset;
        }
    }

    public NavigationSpecification(int columnNumber, int columnCursorLocation) {
        this.locationSpec = LocationType.COLUMN_CURSOR_OFFSET;
        this.columnNumber = columnNumber;
        this.recordOffset = columnCursorLocation;
    }

    public LocationType getLocationType() {
        return this.locationSpec;
    }

    public DisplayLine getRecordToken() {
        return this.aRecord;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getOffset() {
        return this.recordOffset;
    }

    public String toString() {
        if (this.locationSpec == LocationType.TOP) {
            return "TOP";
        }
        if (this.locationSpec == LocationType.BOTTOM) {
            return "BOTTOM";
        }
        if (this.locationSpec == LocationType.RECORD_NUMBER) {
            Object msg = "RECORD_NUMBER: ";
            msg = this.aRecord != null ? (String)msg + this.aRecord.getRecord().getRecno() : (String)msg + String.valueOf(this.aRecord);
            return msg;
        }
        if (this.locationSpec == LocationType.COLUMN_NUMBER) {
            Object msg = "COLUMN_NUMBER: recno=";
            msg = this.aRecord != null ? (String)msg + this.aRecord.getRecord().getRecno() : (String)msg + String.valueOf(this.aRecord);
            return (String)msg + " column=" + this.columnNumber;
        }
        if (this.locationSpec == LocationType.RECORD_OFFSET) {
            Object msg = "RECORD_OFFSET: recno=";
            msg = this.aRecord != null ? (String)msg + this.aRecord.getRecord().getRecno() : (String)msg + String.valueOf(this.aRecord);
            return (String)msg + " offset=" + this.recordOffset;
        }
        if (this.locationSpec == LocationType.JUST_FOCUS) {
            return "JUST_FOCUS";
        }
        if (this.locationSpec == LocationType.COLUMN_CURSOR_OFFSET) {
            return "COLUMN_CURSOR_OFFSET: column=" + this.columnNumber + " cursor=" + this.recordOffset;
        }
        return "ERROR: unknown location specification!";
    }

    public static enum LocationType {
        TOP,
        BOTTOM,
        RECORD_NUMBER,
        COLUMN_NUMBER,
        RECORD_OFFSET,
        JUST_FOCUS,
        COLUMN_CURSOR_OFFSET;

    }
}

