/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted;

import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;

public class NavigationAssistProposalProvider
extends SimpleContentProposalProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private char assistIndicator;

    public NavigationAssistProposalProvider(char assistIndicator) {
        super(new String[0]);
        this.assistIndicator = assistIndicator;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        NavCmds[] cmds = NavCmds.values();
        IContentProposal[] proposals = new NavigationContentProposal[cmds.length];
        int i = 0;
        while (i < cmds.length) {
            proposals[i] = new NavigationContentProposal(cmds[i], this.assistIndicator);
            ++i;
        }
        return proposals;
    }

    public static enum NavCmds {
        KEY("KEY", "KEY key", false),
        TOP("TOP", "TOP", true),
        BOT("BOT", "BOT", true),
        UP("UP", "UP nn or -nn", false),
        DOWN("DOWN", "DOWN nn or +nn", false),
        LOCATE("LOCATE", "LOCATE nn", false);

        private String cmd;
        private String description;
        private boolean doIt;

        private NavCmds(String cmd, String description, boolean doIt) {
            this.cmd = cmd;
            this.description = description;
            this.doIt = doIt;
        }

        public String getCmd() {
            return this.cmd;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean getDoIt() {
            return this.doIt;
        }

        public String toString() {
            return this.cmd;
        }
    }

    private static class NavigationContentProposal
    implements IContentProposal {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private NavCmds navCmd;
        private char assistIndicator;

        public NavigationContentProposal(NavCmds navCmd, char assistIndicator) {
            this.navCmd = navCmd;
            this.assistIndicator = assistIndicator;
        }

        public String getContent() {
            return this.navCmd.getCmd() + String.valueOf(this.navCmd.getDoIt() ? "" : Character.valueOf(this.assistIndicator));
        }

        public int getCursorPosition() {
            return this.navCmd.getCmd().length() + (this.navCmd.getDoIt() ? 0 : 1);
        }

        public String getDescription() {
            return this.navCmd.getDescription();
        }

        public String getLabel() {
            return this.navCmd.getCmd();
        }
    }
}

