/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FMEditSessionProperties;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.contents.ExcludedRecordsShadowGroup;
import com.ibm.etools.fm.editor.formatted.contents.NotSelectedRecordShadowLine;
import com.ibm.etools.fm.editor.formatted.contents.NotSelectedRecordsGroup;
import com.ibm.etools.fm.editor.formatted.contents.SuppressedRecordShadowLine;
import com.ibm.etools.fm.editor.formatted.contents.SuppressedRecordsShadowGroup;
import com.ibm.etools.fm.editor.formatted.dialogs.FieldInformation;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPageUtility;
import com.ibm.etools.fm.model.formatted.HdrType;
import com.ibm.etools.fm.model.formatted.HdrfldType;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.util.DataConversionUtils;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.TableColumn;

public class FormattedEditorUtility {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(FormattedEditorUtility.class);
    private static final String HEX_CHARACTERS = "[0-9A-Fa-f]*";
    public static final Pattern HEX_CHARACTERS_REGEXP = Pattern.compile("[0-9A-Fa-f]*", 2);
    private static final String DIGIT_CHARACTERS = "[0-9]*";
    public static final Pattern DIGIT_CHARACTERS_REGEXP = Pattern.compile("[0-9]*", 2);
    public static final String NON_DISPLAY_CHARACTERS = "[\\u0000-\\u001F\\u007F-\\u009F\\r\\n]";
    public static final byte[] PAD_ZERO_BYTES = new byte[2];
    public static final String PAD_HEX_ZERO = "00";
    public static final char PAD_ZERO = '0';

    public static String getSpaceHexValue(String encoding) {
        Objects.requireNonNull(encoding, "Must specify a non-null encoding.");
        try {
            byte[] newHexValueBytes = " ".getBytes(encoding);
            String hexString = DataConversionUtils.getHexString((byte[])newHexValueBytes);
            return hexString;
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.FormattedEditorUtility_GetSpaceHexValueEncodingError, encoding);
            logger.error((Object)errMsg, (Throwable)e);
            return PAD_HEX_ZERO;
        }
    }

    public static TableViewerColumn createTableViewerColumn(String title, int bound, TableViewer viewer, int alignment) {
        Objects.requireNonNull(viewer, "Must specify a non-null Viewer.");
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        column.setAlignment(alignment);
        return viewerColumn;
    }

    public static String getDescription(SuppressedRecordsShadowGroup aGroup, FormattedEditor editor2) {
        int tempNo;
        Objects.requireNonNull(aGroup, "Must specify a non-null aGroup.");
        Objects.requireNonNull(editor2, "Must specify a non-null editor.");
        String recNoStr = aGroup.getRecord().getHex();
        if (recNoStr != null && recNoStr.length() > 12) {
            recNoStr = recNoStr.substring(0, 12);
            try {
                byte[] byteValue = DataConversionUtils.getEBCDICData((String)recNoStr);
                recNoStr = new String(byteValue, editor2.getResource().getPersistentProperty("encoding")).replaceAll("-| ", "");
            }
            catch (UnsupportedEncodingException e) {
                recNoStr = "";
            }
        } else {
            recNoStr = "";
        }
        int n = tempNo = aGroup.getRecord().isSetSet() ? aGroup.getRecord().getSet() : 1;
        if (editor2.getLayout(aGroup.getRecord()) != null) {
            String layoutName = editor2.getLayoutName(editor2.getLayout(aGroup.getRecord()).getId());
            if (layoutName != null) {
                return MessageFormat.format(Messages.FormattedPageTableUtility_GROUP_SUP_REC_INFO, recNoStr, layoutName, tempNo);
            }
            return MessageFormat.format(Messages.FormattedPageTableUtility_GROUP_SUP_REC, recNoStr, tempNo);
        }
        return MessageFormat.format(Messages.FormattedPageTableUtility_GROUP_SUP_REC, recNoStr, tempNo);
    }

    public static String getDescription(SuppressedRecordShadowLine aLine, FormattedEditor editor2) {
        Objects.requireNonNull(aLine, "Must specify a non-null aLine.");
        Objects.requireNonNull(editor2, "Must specify a non-null editor.");
        if (editor2.getLayout(aLine.getRecord()) != null) {
            String layoutName = editor2.getLayoutName(editor2.getLayout(aLine.getRecord()).getId());
            if (layoutName != null) {
                return MessageFormat.format(Messages.FormattedPageTableUtility_SUP_REC_INFO, aLine.getRecord().getRecno(), layoutName);
            }
            return MessageFormat.format(Messages.FormattedPageTableUtility_SUP_REC, aLine.getRecord().getRecno());
        }
        return MessageFormat.format(Messages.FormattedPageTableUtility_SUP_REC, aLine.getRecord().getRecno());
    }

    public static String getDescription(NotSelectedRecordsGroup aGroup, FormattedEditor editor2) {
        Objects.requireNonNull(aGroup, "Must specify a non-null aGroup.");
        Objects.requireNonNull(editor2, "Must specify a non-null editor.");
        try {
            byte[] byteValue = DataConversionUtils.getEBCDICData((String)aGroup.getRecord().getHex());
            return new String(byteValue, editor2.getResource().getPersistentProperty("encoding"));
        }
        catch (UnsupportedEncodingException e) {
            String errMsg = MessageFormat.format(Messages.FormattedPageTableUtility_CONV_ERR, aGroup.getRecord().getRecno(), editor2.getResource().getPersistentProperty("encoding"), aGroup.getRecord().getHex());
            PDDialogs.openErrorThreadSafe((String)errMsg, (Throwable)e);
            return errMsg;
        }
    }

    public static String getDescription(NotSelectedRecordShadowLine aLine, FormattedEditor editor2) {
        Objects.requireNonNull(aLine, "Must specify a non-null aLine.");
        Objects.requireNonNull(editor2, "Must specify a non-null editor.");
        if (editor2.getLayout(aLine.getRecord()) != null) {
            String layoutName = editor2.getLayoutName(editor2.getLayout(aLine.getRecord()).getId());
            if (layoutName != null) {
                return MessageFormat.format(Messages.FormattedPageTableUtility_NOT_SEL_REC_INFO, aLine.getRecord().getRecno(), layoutName);
            }
            return MessageFormat.format(Messages.FormattedPageTableUtility_NOT_SEL_REC, aLine.getRecord().getRecno());
        }
        return MessageFormat.format(Messages.FormattedPageTableUtility_NOT_SEL_REC, aLine.getRecord().getRecno());
    }

    public static String getDescription(ExcludedRecordsShadowGroup aGroup, FormattedEditor editor2) {
        Objects.requireNonNull(aGroup, "Must specify a non-null aGroup.");
        Objects.requireNonNull(editor2, "Must specify a non-null editor.");
        try {
            byte[] byteValue = DataConversionUtils.getEBCDICData((String)aGroup.getRecord().getHex());
            return new String(byteValue, editor2.getResource().getPersistentProperty("encoding"));
        }
        catch (UnsupportedEncodingException e) {
            String errMsg = MessageFormat.format(Messages.FormattedPageTableUtility_CONV_ERR, aGroup.getRecord().getRecno(), editor2.getResource().getPersistentProperty("encoding"), aGroup.getRecord().getHex());
            PDDialogs.openErrorThreadSafe((String)errMsg, (Throwable)e);
            return errMsg;
        }
    }

    public static String checkRecordLength(String hexString, FMEditSessionProperties props, RecType aRecord, boolean fixLenErr, String hexCharValue) {
        Objects.requireNonNull(props, "Must specify a non-null props.");
        if (props.isInplaceEdit()) {
            if (hexString.length() == aRecord.getLen() * 2) {
                return hexString;
            }
            if (hexString.length() < aRecord.getLen() * 2) {
                if (fixLenErr) {
                    return FormattedEditorUtility.addPadding(hexString, aRecord.getLen(), hexCharValue);
                }
                return null;
            }
            if (fixLenErr) {
                return hexString.substring(0, aRecord.getLen() * 2);
            }
            return null;
        }
        if (props.isFixedLen()) {
            if (hexString.length() <= props.getMaxRECL() * 2) {
                return FormattedEditorUtility.addPadding(hexString, props.getMaxRECL(), hexCharValue);
            }
            if (fixLenErr) {
                return hexString.substring(0, props.getMaxRECL() * 2);
            }
            return null;
        }
        int maxLen = props.getMaxRECL();
        if (hexString.length() / 2 <= maxLen) {
            if (hexString.isEmpty()) {
                return FormattedEditorUtility.addPadding(hexString, props.getMinRECL(), hexCharValue);
            }
            return hexString;
        }
        if (fixLenErr) {
            return hexString.substring(0, maxLen * 2);
        }
        return null;
    }

    public static String checkAndFixFieldLength(String hexString, int minLen, int maxLen, String hexCharValue) {
        Objects.requireNonNull(hexString, "Must specify a non-null hexString.");
        if (hexString.length() < minLen * 2) {
            return FormattedEditorUtility.addPadding(hexString, minLen, hexCharValue);
        }
        if (hexString.length() > maxLen * 2) {
            return hexString.substring(0, maxLen * 2);
        }
        return hexString;
    }

    private static String addPadding(String hexString, int maxLen, String hexCharValue) {
        StringBuilder sb = new StringBuilder(maxLen * 2);
        int paddSize = maxLen - hexString.length() / 2;
        sb.append(hexString);
        int i = 0;
        while (i < paddSize) {
            sb.append(hexCharValue);
            ++i;
        }
        return sb.toString();
    }

    public static String checkRecordLengthOfString(String aString, FMEditSessionProperties props, RecType aRecord, char padChar, boolean fixLengthErr) {
        int max;
        Objects.requireNonNull(props, "Must specify a non-null props.");
        if (props.isFixedLen()) {
            if (aString.length() <= props.getMaxRECL()) {
                return FormattedEditorUtility.addPaddingForString(aString, props.getMaxRECL(), padChar);
            }
            if (fixLengthErr) {
                return aString.substring(0, props.getMaxRECL());
            }
            return null;
        }
        int n = max = props.isInplaceEdit() ? aRecord.getLen() : props.getMaxRECL();
        if (aString.length() <= max) {
            if (aString.isEmpty()) {
                return FormattedEditorUtility.addPaddingForString(aString, props.getMinRECL(), padChar);
            }
            return aString;
        }
        if (fixLengthErr) {
            return aString.substring(0, max);
        }
        return null;
    }

    public static String addPaddingForString(String aString, int maxLen, char padChar) {
        Objects.requireNonNull(aString, "Must specify a non-null aString.");
        StringBuilder sb = new StringBuilder(maxLen);
        int paddSize = maxLen - aString.length();
        sb.append(aString);
        int i = 0;
        while (i < paddSize) {
            sb.append(padChar);
            ++i;
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String addSpacePaddingForString(String aString, int maxLen, String encoding) {
        Objects.requireNonNull(aString, "Must specify a non-null aString.");
        try {
            aStringHexValueBytes = aString.getBytes(encoding);
            aStringHexValue = DataConversionUtils.getHexString((byte[])aStringHexValueBytes);
            if (aStringHexValue.length() / 2 > maxLen) {
                return aString.substring(0, maxLen * 2);
            }
            if (aString.length() == maxLen) {
                return aString;
            }
            hexSpaceBytes = " ".getBytes(encoding);
            hexSpaceStr = DataConversionUtils.getHexString((byte[])hexSpaceBytes);
            newHexValueBytes = aString.getBytes(encoding);
            hexString = DataConversionUtils.getHexString((byte[])newHexValueBytes);
            sb = new StringBuffer(hexString);
            whiteSpaceCount = maxLen - aStringHexValue.length() / 2;
            i = 0;
            while (i < whiteSpaceCount) {
                sb.append(hexSpaceStr);
                ++i;
            }
            byteValue = DataConversionUtils.getEBCDICData((String)sb.toString());
            return new String(byteValue, encoding);
        }
        catch (Exception e) {
            errMsg = MessageFormat.format(Messages.FormattedEditorUtility_GetSpaceHexValueEncodingError, new Object[]{encoding});
            FormattedEditorUtility.logger.error((Object)errMsg, (Throwable)e);
            zeroStr = "00";
            sb = new StringBuffer(aString);
            i = 0;
            ** while (i < maxLen - aString.length())
        }
lbl-1000:
        // 1 sources

        {
            sb.append(zeroStr);
            ++i;
            continue;
        }
lbl35:
        // 1 sources

        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String addSpaceDBCSPaddingForString(String aString, int maxLen, String encoding) {
        Objects.requireNonNull(aString, "Must specify a non-null aString.");
        try {
            aStringHexValueBytes = aString.getBytes(encoding);
            aStringHexValue = DataConversionUtils.getHexString((byte[])aStringHexValueBytes);
            if (aStringHexValue.length() / 2 > maxLen) {
                return aString.substring(0, maxLen * 2);
            }
            if (aString.length() == maxLen) {
                return aString;
            }
            hexSpaceBytes = " ".getBytes(encoding);
            hexSpaceStr = DataConversionUtils.getHexString((byte[])hexSpaceBytes);
            if (aString.isEmpty()) {
                sb = new StringBuffer("0E");
            } else {
                newHexValueBytes = aString.getBytes(encoding);
                hexString = DataConversionUtils.getHexString((byte[])newHexValueBytes);
                sb = new StringBuffer(hexString.substring(0, hexString.length() - 2));
            }
            whiteSpaceCount = maxLen - aStringHexValue.length() / 2;
            i = 0;
            while (i < whiteSpaceCount) {
                sb.append(hexSpaceStr);
                ++i;
            }
            sb.append("0F");
            byteValue = DataConversionUtils.getEBCDICData((String)sb.toString());
            return new String(byteValue, encoding);
        }
        catch (Exception e) {
            errMsg = MessageFormat.format(Messages.FormattedEditorUtility_GetSpaceHexValueEncodingError, new Object[]{encoding});
            FormattedEditorUtility.logger.error((Object)errMsg, (Throwable)e);
            zeroStr = "00";
            sb = new StringBuffer(aString);
            i = 0;
            ** while (i < maxLen - aString.length())
        }
lbl-1000:
        // 1 sources

        {
            sb.append(zeroStr);
            ++i;
            continue;
        }
lbl40:
        // 1 sources

        return sb.toString();
    }

    public static byte[] addPaddingForHexString(byte[] hexByteValue, int length) {
        Objects.requireNonNull(hexByteValue, "Must specify a non-null hexByteValue.");
        if (hexByteValue.length >= length) {
            return hexByteValue;
        }
        byte[] newByteValue = new byte[length];
        System.arraycopy(hexByteValue, 0, newByteValue, 0, hexByteValue.length);
        return newByteValue;
    }

    public static ArrayList<FieldInformation> getCurrentFieldInformation(IFMEditor editor2) {
        Objects.requireNonNull(editor2, "Must specify a non-null editor.");
        ArrayList<FieldInformation> infoList = new ArrayList<FieldInformation>();
        TemplateType aTemplate = editor2.getCurrentTemplate();
        if (aTemplate == null) {
            return infoList;
        }
        HdrType header = editor2.getCurrentTableHeader(editor2.getActiveLayoutID());
        EList columns = header.getHdrfld();
        int i = 0;
        while (i < columns.size()) {
            HdrfldType aColumn = (HdrfldType)columns.get(i);
            Symboltype aSymbol = FormattedPageUtility.getSymbol(header, aColumn, aTemplate);
            FieldInformation info = new FieldInformation(header, aColumn, aSymbol, i, editor2.getSessionIdentifier().getSessionType(), editor2.getSystem());
            infoList.add(info);
            ++i;
        }
        return infoList;
    }

    public static void dumpCurrentEditorContents(FormattedEditor editor2) {
        Objects.requireNonNull(editor2, "Must specify a non-null editor.");
        logger.debug((Object)("######## Contents for Resource=" + editor2.getResource().getFormattedName() + " #############"));
        ArrayList<DisplayLine> lines = editor2.getCurrentEditorContents();
        int i = 0;
        while (i < lines.size()) {
            DisplayLine dl = lines.get(i);
            logger.debug((Object)(i + ": recno=" + dl.getRecord().getRecno() + " token=" + dl.getRecord().getToken() + " seq=" + dl.getRecord().getSeq() + " seg=" + dl.getRecord().getSeg() + " new?=" + dl.getRecord().isSetNew() + " chg?=" + dl.getRecord().isSetChg() + " insert=" + dl.getRecord().isSetInsert() + " hex=" + dl.getRecord().getHex() + " " + dl.getClass().getName()));
            ++i;
        }
        logger.debug((Object)("######## End of contents for Resource=" + editor2.getResource().getFormattedName() + " #############"));
    }

    public static void dumpCurrentEditorContents(ArrayList<String> lines) {
        Objects.requireNonNull(lines, "Must specify a non-null lines.");
        logger.debug((Object)"######## Current CHAR mode editor contents #############");
        int i = 0;
        while (i < lines.size()) {
            logger.debug((Object)(i + ": [" + lines.get(i) + "]"));
            ++i;
        }
        logger.debug((Object)"######## End of current CHAR mode editor contents ##############");
    }
}

