/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.pages.single.SingleView;
import com.ibm.pdtools.common.component.core.util.PDBiDiHelpers;
import com.ibm.pdtools.common.component.core.util.PDBidiFormat;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.StatusLineContributionItem;

public class FormattedEditorActionBarContributor
extends BasicTextEditorActionContributor
implements IPropertyListener {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private FormattedEditor editor = null;
    private StatusLineContributionItem overwriteModeContributor = null;
    private StatusLineContributionItem currentCodepageContributor = null;
    private StatusLineContributionItem bidiTextDirectionContributor = null;
    private StatusLineContributionItem bidiTextLayoutContributor = null;

    public void setActiveEditor(IEditorPart part) {
        String enc;
        if (!(part instanceof FormattedEditor)) {
            this.editor = null;
            return;
        }
        this.editor = (FormattedEditor)part;
        if (this.editor.isAllActionsDisabled()) {
            return;
        }
        this.editor.addPropertyListener(this);
        if (this.editor.isInsertMode()) {
            this.overwriteModeContributor.setText(Messages.FormattedEditorActionBarContributor_INSERT);
        } else {
            this.overwriteModeContributor.setText(Messages.FormattedEditorActionBarContributor_OVERWRITE);
        }
        IZRL resource = this.editor.getResource();
        if (resource != null && (enc = resource.getPersistentProperty("encoding")) != null && !enc.isEmpty()) {
            String bidi;
            this.currentCodepageContributor.setText(enc);
            if (PDBiDiHelpers.isBidiCharset((String)enc) && (bidi = resource.getPersistentProperty("bidiFormat")) != null) {
                PDBidiFormat bformat = PDBidiFormat.parse((String)bidi);
                this.bidiTextDirectionContributor.setText(bformat.getDirection().name());
                this.bidiTextLayoutContributor.setText(bformat.getLayout().name());
            }
        }
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        super.contributeToStatusLine(statusLineManager);
        this.overwriteModeContributor = new StatusLineContributionItem("FormattedEditorActionBarContributor.overwriteMode", true, 10);
        this.overwriteModeContributor.setActionHandler((IAction)new Action(){

            public void run() {
                FormattedEditorActionBarContributor.this.editor.setInsertMode(!FormattedEditorActionBarContributor.this.editor.isInsertMode());
                if (FormattedEditorActionBarContributor.this.editor.isInsertMode()) {
                    FormattedEditorActionBarContributor.this.overwriteModeContributor.setText(Messages.FormattedEditorActionBarContributor_INSERT);
                } else {
                    FormattedEditorActionBarContributor.this.overwriteModeContributor.setText(Messages.FormattedEditorActionBarContributor_OVERWRITE);
                }
            }
        });
        statusLineManager.add((IContributionItem)this.overwriteModeContributor);
        this.currentCodepageContributor = new StatusLineContributionItem("FormattedEditorActionBarContributor.codepage", true, 10);
        statusLineManager.add((IContributionItem)this.currentCodepageContributor);
        this.bidiTextDirectionContributor = new StatusLineContributionItem("FormattedEditorActionBarContributor.textDirection", true, 10);
        statusLineManager.add((IContributionItem)this.bidiTextDirectionContributor);
        this.bidiTextLayoutContributor = new StatusLineContributionItem("FormattedEditorActionBarContributor.textLayout", true, 10);
        statusLineManager.add((IContributionItem)this.bidiTextLayoutContributor);
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 2050 && source instanceof FormattedEditor && this.editor == source) {
            if (this.editor.isInsertMode()) {
                this.overwriteModeContributor.setText(Messages.FormattedEditorActionBarContributor_INSERT);
                SingleView.updateInsertMode((FormattedEditor)source);
            } else {
                this.overwriteModeContributor.setText(Messages.FormattedEditorActionBarContributor_OVERWRITE);
                SingleView.updateInsertMode((FormattedEditor)source);
            }
        }
    }
}

