/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorage;
import com.ibm.etools.fm.core.model.cics.CicsTransientData;
import com.ibm.etools.fm.editor.formatted.BottomNavigationBar;
import com.ibm.etools.fm.editor.formatted.EditorActionManager;
import com.ibm.etools.fm.editor.formatted.FMEditSessionProperties;
import com.ibm.etools.fm.editor.formatted.FMEditorInputWithTemplate;
import com.ibm.etools.fm.editor.formatted.FormattedEditorContext;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.IFormattedEditorPage;
import com.ibm.etools.fm.editor.formatted.NavigationSpecification;
import com.ibm.etools.fm.editor.formatted.OpenFormattedEditorJob;
import com.ibm.etools.fm.editor.formatted.TopNavigationBar;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLineUtility;
import com.ibm.etools.fm.editor.formatted.contents.EmptyRecordsShadowGroup;
import com.ibm.etools.fm.editor.formatted.contents.ExcludedRecordsShadowGroup;
import com.ibm.etools.fm.editor.formatted.contents.HexRecordWrapper;
import com.ibm.etools.fm.editor.formatted.contents.NotSelectedRecordShadowLine;
import com.ibm.etools.fm.editor.formatted.contents.NotSelectedRecordsGroup;
import com.ibm.etools.fm.editor.formatted.contents.ShadowGroup;
import com.ibm.etools.fm.editor.formatted.contents.SuppressedRecordShadowLine;
import com.ibm.etools.fm.editor.formatted.contents.SuppressedRecordsShadowGroup;
import com.ibm.etools.fm.editor.formatted.dialogs.ISortCriteria;
import com.ibm.etools.fm.editor.formatted.handler.PageDown;
import com.ibm.etools.fm.editor.formatted.handler.PageUp;
import com.ibm.etools.fm.editor.formatted.pages.advanced.AdvancedModePage;
import com.ibm.etools.fm.editor.formatted.pages.charmode.CharModePage;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPage;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPageUtility;
import com.ibm.etools.fm.editor.formatted.pages.single.SingleView;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.model.formatted.EditType;
import com.ibm.etools.fm.model.formatted.FieldType;
import com.ibm.etools.fm.model.formatted.HdrType;
import com.ibm.etools.fm.model.formatted.HdrfldType;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.formatted.util.EditorDataSerializeUtils;
import com.ibm.etools.fm.model.template.CreateType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.ZRLSaveAsDialog;
import com.ibm.etools.fm.ui.history.action.OpenAsFormattedEditorActionItem;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.EclipseUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsTreeUpdater;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.progress.UIJob;

public class FormattedEditor
extends MultiPageEditorPart
implements ISaveablePart2,
IFMEditor {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(FormattedEditor.class);
    public static final String ID = "com.ibm.etools.fm.editor.formatted.FormattedEditor";
    public static final String SUPRESSED_ICON = "icons/SuppressRecord_1.gif";
    public static final String EXCLUDED_ICON = "icons/excluded_icon.gif";
    public static final String UNSELECTED_ICON = "icons/unselected_icon.gif";
    public static final String EMPTY_ICON = "icons/UnselectedRecord_2.gif";
    public static final String SORT_ICON = "icons/sort.gif";
    public static final String HEX_MODE_ICON = "icons/convertto_hexdec2.gif";
    public static final String APPLY_TEMPLATE_ICON = "icons/applyTemplate.gif";
    public static final String EXECUTE_COMMAND_ICON = "icons/run.gif";
    public static final String WINDOW_UP_ICON = "icons/windowup.gif";
    public static final String WINDOW_DOWN_ICON = "icons/windowdown.gif";
    public static final String WINDOW_RIGHT_ICON = "icons/windowright.gif";
    public static final String WINDOW_LEFT_ICON = "icons/windowleft.gif";
    public static final String NEW_RECORD_ICON = "icons/NewRecord.gif";
    public static final String CHANGED_RECORD_ICON = "icons/ChangedRecord.gif";
    public static final String DELETE_ICON = "icons/delete.gif";
    public static final String VALIDATE_ICON = "icons/SelectedRecord_1.gif";
    public static final String REFRESH_ICON = "icons/refresh.gif";
    public static final String FIND_ICON = "icons/search.gif";
    public static final String SHOW_ICON = "icons/tgl_obj_1-2c.gif";
    public static final String EXCLUDE_ICON = "icons/UnselectedRecord_1.gif";
    public static final String INCLUDE_ICON = "icons/resetExclude.gif";
    public static final String LOCATE_COLUMN_ICON = "icons/SuppressRecord_1.gif";
    public static final String SWITCH_EDITOR_MODE_ICON = "icons/switch.gif";
    public static final String SWITCH_ADVANCED_EDITOR_MODE_ICON = "icons/switch.gif";
    public static final String ADD_ICON = "icons/add.gif";
    public static final String MOVE_UP_ICON = "icons/moveup.gif";
    public static final String MOVE_DOWN_ICON = "icons/movedown.gif";
    public static final String EDIT_FIELD_ICON = "icons/editfield.gif";
    public static final String SQL_ERROR_ICON = "icons/sqlErr.gif";
    public static final String REDIT_ERROR_ICON = "icons/redit.gif";
    public static final String FORMATTED_EDITOR_ICON = "icons/tree/action_history/formattededit.gif";
    public static final String SELECT_ALL_ICON = "icons/selectall.png";
    public static final String DESELECT_ALL_ICON = "icons/deselectall.png";
    public static final int PROP_NEW_DATA = 2048;
    public static final int PROP_HEX = 2049;
    public static final int PROP_OVERWRITE = 2050;
    public static final int PROP_CLOSE_FIND = 2051;
    private FMEditorInputWithTemplate fmiEditorInput = null;
    private EditType currentContents = null;
    private ArrayList<DisplayLine> cachedContents = null;
    private TemplateType template = null;
    private IFMEditor.EditorMode currentActiveMode = IFMEditor.EditorMode.CHARACTER;
    private boolean isEditorDirty = false;
    private EditorActionManager actionManager = null;
    private boolean disableAllActions = false;
    private IFormattedEditorPage currentPage = null;
    private int currentColumn = 1;
    private boolean insertMode = true;
    private boolean searchRunning = false;
    private ArrayList<ISortCriteria> sortCriteriaList = new ArrayList();
    private TopNavigationBar topNavigationBar = null;
    private boolean needScrolling = false;
    private boolean scrollInAction = false;
    private boolean showNotSelectedRecords = false;
    private boolean showSuppressedRecords = false;
    private boolean showLengthErrorRecords = true;
    private boolean displayShadowExcludedGroup = true;
    private boolean displayShadowNotSelectedGroup = true;
    private boolean displayShadowSuppressedGroup = true;
    private boolean hexOn = false;
    private int showFromColumnIndex = 0;
    private boolean db2SaveIssued = false;
    private FormattedEditorContext editorContext;
    private boolean busyNow = false;
    private IEditorSite editorSite;
    private Map<String, String> colNoToValuesMap;
    private boolean findActive = false;
    private boolean segmented = false;

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        IEditorReference[] existingEditor;
        boolean newState;
        boolean initialState;
        super.init(site, editorInput);
        this.editorSite = site;
        this.colNoToValuesMap = new HashMap<String, String>();
        if (!(editorInput instanceof FMEditorInputWithTemplate)) {
            String errMsg = MessageFormat.format(Messages.FMIFormattedDataEditor_INVALID_INPUT_ERR_MSG, editorInput.getClass().getName());
            logger.error((Object)errMsg);
            PDDialogs.openErrorThreadSafe((String)errMsg);
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
            return;
        }
        this.fmiEditorInput = (FMEditorInputWithTemplate)editorInput;
        if (this.fmiEditorInput.isEditSession() && this.fmiEditorInput.getResource() instanceof MessageQueue && !(initialState = FormattedEditorPreferencePage.hideMqInformational()) && initialState != (newState = PDDialogs.openWarningWithToggleThreadSafe((String)Messages.FMDialogWithText_INFORMATION, (String)Messages.FMIFormattedDataEditor_MQ_WARNING, (String)Messages.FMIFormattedDataEditor_MQ_WARNING_DND, (boolean)false))) {
            IPreferenceStore store = FMUIPlugin.getDefault().getPreferenceStore();
            store.setValue("editorMqInformational", newState);
        }
        if ((existingEditor = this.getSite().getWorkbenchWindow().getActivePage().findEditors(editorInput, this.getSite().getId(), 3)) != null && existingEditor.length > 0) {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FMIFormattedDataEditor_DUP_INSTANCE, this.fmiEditorInput.getResource().getFormattedName(), this.fmiEditorInput.getTemplateResource() != null ? this.fmiEditorInput.getTemplateResource().getFormattedName() : Messages.NONE));
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
            return;
        }
        this.initShowAndGroupOptions();
        this.getSessionProperties().dumpEditSessionProperties(this.getResource(), this.getTemplateResource());
        this.actionManager = new EditorActionManager();
        EclipseUtils.retestEclipseProperty((String)"com.ibm.etools.fm.ui.editor", (String)"actionsEnabled");
        this.initEditSession();
        this.setPartName(this.fmiEditorInput.getName());
        SingleView.displayCurrentRecord(this, this.getCurrentEditorContents().isEmpty() ? null : this.getCurrentEditorContents().get(0));
        this.editorContext = new FormattedEditorContext(this.getSite());
    }

    private void initShowAndGroupOptions() {
        this.showNotSelectedRecords = FormattedEditorPreferencePage.showNotSelectedRecords();
        this.showSuppressedRecords = FormattedEditorPreferencePage.showSuppressedRecords();
        this.showLengthErrorRecords = FormattedEditorPreferencePage.showLengthErrorRecords();
        this.displayShadowExcludedGroup = FormattedEditorPreferencePage.displayShadowLinesForEx();
        this.displayShadowNotSelectedGroup = FormattedEditorPreferencePage.displayShadowLinesForNot();
        this.displayShadowSuppressedGroup = FormattedEditorPreferencePage.displayShadowLinesForSup();
        this.hexOn = FormattedEditorPreferencePage.useHexMode();
    }

    public void notifyTemplateChanged(final FormattedEditor notifier, final IZRL zrl) {
        if (notifier != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BottomNavigationBar.newTemplateAssociation(notifier, zrl);
                }
            });
        }
    }

    public void dispose() {
        if (this.getSessionIdentifier().getBaseEditOptions() != null && this.getSessionIdentifier().getBaseEditOptions().isTemplateDirty()) {
            boolean confirm = PDDialogs.openConfirmThreadSafe((String)Messages.Confirm, (String)Messages.TemplateEditor_RunTempSaveConfirm);
            this.setDirty(false);
            if (confirm) {
                TemplateEditorUtilities.openTemplateEditSession(this.getTemplateResource(), null, this.fmiEditorInput.getSessionIdentifer().getBaseEditOptions().getDynamicTemplateFlag(), this.fmiEditorInput.getSessionIdentifer().getBaseEditOptions().getRunTempKey());
            } else if (this.getSessionIdentifier().getBaseEditOptions().getDynamicTemplateFlag()) {
                this.notifyTemplateChanged(this, null);
            }
            if (this.getSessionIdentifier().getBaseEditOptions().getDynamicTemplateFlag()) {
                this.getSessionIdentifier().getBaseEditOptions().setDynamicTemplateFlag(false);
                this.getSessionIdentifier().getBaseEditOptions().setaTemplate(null);
            }
        }
        this.saveFMPreferenceStore();
        if (this.getCurrentEditorMode() == IFMEditor.EditorMode.CHARACTER) {
            page = (CharModePage)this.getCurrentPage();
            ((CharModePage)page).resetToggleState();
        } else if (this.getCurrentEditorMode() == IFMEditor.EditorMode.ADVANCED) {
            page = (AdvancedModePage)this.getCurrentPage();
            ((AdvancedModePage)page).resetToggleState();
        } else {
            page = (FormattedPage)this.getCurrentPage();
            ((FormattedPage)page).resetToggleState();
        }
        final AtomicBoolean performFile = new AtomicBoolean(false);
        if (!(!this.db2SaveIssued || this.getSessionProperties().isAllRecdsLoaded() && this.getSessionIdentifier().getDb2EditOptions().getEditorOptions().getCOMSAVE())) {
            if (PDDialogs.openQuestion((String)Messages.FMPlugin_QUESTION_TITLE, (String)Messages.FMIFormattedDataEditor_DB2_FILE_CONFIRM)) {
                performFile.set(true);
            } else {
                performFile.set(false);
            }
        }
        Job disposing = new Job(Messages.FormattedEditor_Closing){

            public IStatus run(IProgressMonitor monitor) {
                if (FormattedEditor.this.fmiEditorInput.getSessionIdentifer().getBaseEditOptions() != null) {
                    FormattedEditor.this.fmiEditorInput.getSessionIdentifer().getBaseEditOptions().setRunTempKey(null);
                    FMUIPlugin.getDefault().removeRunTempEntry(FormattedEditor.this.fmiEditorInput.getSessionIdentifer().getBaseEditOptions().getRunTempKey());
                }
                FMUIPlugin.getDefault().removeDSEditSession(FormattedEditor.this.fmiEditorInput.getResource());
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                FormattedEditor.this.fmiEditorInput.getSessionIdentifer().removeCacheFile(howIsGoing);
                if (performFile.get()) {
                    FormattedEditor.this.fmiEditorInput.getSessionIdentifer().file(howIsGoing);
                } else {
                    FormattedEditor.this.fmiEditorInput.getSessionIdentifer().end(howIsGoing);
                }
                return Status.OK_STATUS;
            }
        };
        disposing.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    String errMsg = MessageFormat.format(Messages.FMIFormattedDataEditor_DISPOSE_EX, FormattedEditor.this.fmiEditorInput.getResource(), FormattedEditor.this.getTemplateResource() == null ? Messages.NONE : FormattedEditor.this.getTemplateResource().getFormattedName());
                    logger.error((Object)errMsg);
                }
            }
        });
        disposing.setUser(true);
        disposing.schedule();
        SingleView.clearCurrentContents(this);
        OpenAsFormattedEditorActionItem.refreshIconDecorations();
        this.firePropertyChange(2051);
        if (this.getTemplateResource() != null) {
            FormattedPageUtility.clearEncodingErrors(this.getResource());
        }
        this.editorContext.disable();
        try {
            super.dispose();
        }
        catch (NullPointerException e) {
            logger.error((Object)"Null pointer exception thrown while disposing the File Manager formatted Editor: ", (Throwable)e);
        }
    }

    protected void createPages() {
        if (this.fmiEditorInput.getTemplateResource() != null) {
            this.createFormattedModePage();
        } else {
            this.createCharModePage();
        }
        this.setActivePage(0);
        this.currentPage.setCursor(NavigationSpecification.TOP);
        this.editorContext.enable();
        this.addPreferenceChangeListener();
    }

    private void addPreferenceChangeListener() {
        IPropertyChangeListener preferenceChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (!event.getProperty().equals("fe.font")) {
                    FormattedEditor.this.refreshContent();
                }
            }
        };
        JFaceResources.getColorRegistry().addListener(preferenceChangeListener);
        JFaceResources.getFontRegistry().addListener(preferenceChangeListener);
    }

    public void setFocus() {
        super.setFocus();
        if (this.currentPage != null) {
            ICommandService commandService;
            Command cmd;
            State state;
            this.currentPage.setCursor(NavigationSpecification.JUST_FOCUS);
            SingleView.displayCurrentRecord(this, this.getCurrentLine());
            if (this.currentPage instanceof CharModePage && (state = (cmd = (commandService = (ICommandService)this.editorSite.getService(ICommandService.class)).getCommand("com.ibm.etools.fm.ui.model.commands.toggleBlock")).getState("org.eclipse.ui.commands.toggleState")) != null) {
                state.setValue((Object)((CharModePage)this.currentPage).getBlockSelection());
            }
        }
    }

    @Override
    public void setCursor(NavigationSpecification navSpec) {
        this.currentPage.setCursor(navSpec);
    }

    public int promptToSaveOnClose() {
        if (this.isAllActionsDisabled()) {
            return 1;
        }
        MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), Messages.FormattedEditor_0, null, MessageFormat.format(Messages.FormattedEditor_1, this.getResource().getFormattedName()), 6, new String[]{JFaceResources.getString((String)"yes"), JFaceResources.getString((String)"no"), JFaceResources.getString((String)"cancel")}, 0);
        int result = dialog.open();
        if (result == 0) {
            if (this.attemptToSave()) {
                return 1;
            }
            return 2;
        }
        if (result == 1) {
            return 1;
        }
        return 2;
    }

    private boolean attemptToSave() {
        int[] selection = this.getSelection();
        if (!this.updateDirtyContents()) {
            return false;
        }
        if (this.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            this.db2SaveIssued = true;
        }
        final Result result = new Result((Object)new StringBuffer());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.FormattedEditor_SAVE_OP, FormattedEditor.this.getResource().getFormattedName()), 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    Result rsb = FormattedEditor.this.getSessionIdentifier().save(howIsGoing);
                    result.copy(rsb);
                    monitor.worked(1);
                    FormattedEditor.this.loadRecordsFromHost(howIsGoing);
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_OP_EX, this.getResource().getFormattedName()), (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            PDDialogs.openErrorThreadSafe((String)Messages.FMPlugin_WARNING_TITLE, (String)Messages.EditorAction_CACELLED);
            this.disableEditorActions();
            return false;
        }
        if (result.getRC() > 4) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_OP_ERR, this.getResource().getFormattedName()), (String)result.getMessagesCombined().toString());
            return false;
        }
        this.setDirty(false);
        this.setSelection(selection);
        this.setFocus();
        return true;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.isAllActionsDisabled()) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_ALL_DISABLED);
            return;
        }
        this.attemptToSave();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSaveAs() {
        Result allResult;
        IZRL targetResource;
        block37: {
            if (this.isAllActionsDisabled()) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_ALL_DISABLED);
                return;
            }
            String[] errors = null;
            try {
                errors = this.currentPage.validateContents();
            }
            catch (InterruptedException e1) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
                this.disableEditorActions();
                return;
            }
            if (errors != null && !PDDialogs.openQuestion((String)Messages.FMPlugin_QUESTION_TITLE, (String)errors[0], (String)errors[1])) {
                return;
            }
            this.currentPage.updateHostEditorChain();
            ZRLSaveAsDialog dialog = new ZRLSaveAsDialog(this.getResource().getSystem(), this.getResource());
            if (dialog.open() != 0) {
                return;
            }
            targetResource = dialog.getSelectedResource();
            if (targetResource.getFormattedName().equals(this.getResource().getFormattedName())) {
                if (!this.isEditSession()) {
                    PDDialogs.openInfoThreadSafe((String)Messages.FormattedEditor_SAVE_AS_SAME_TARGET_VIEW);
                    this.doSaveAs();
                    return;
                }
                if (PDDialogs.openQuestion((String)Messages.FormattedEditor_SAVE_AS_SAME_TARGET)) {
                    this.doSave((IProgressMonitor)new NullProgressMonitor());
                    return;
                }
                this.doSaveAs();
                return;
            }
            allResult = new Result((Object)new StringBuffer());
            try {
                Result<StringBuffer> infoResult = ZrlLoaderDialogUtils.retrieveInformation(targetResource);
                if (targetResource instanceof DataSetOrMember) {
                    DataSetOrMember targetDSOM = (DataSetOrMember)targetResource;
                    if (!infoResult.isSuccessfulWithoutWarnings()) {
                        PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_AS_TARGET_ERR, targetDSOM.getFormattedName()), (String)infoResult.getMessagesCombined().toString());
                        return;
                    }
                    if (targetDSOM.getConfirmedExists()) {
                        if (!PDDialogs.openQuestion((String)MessageFormat.format(Messages.FormattedEditor_SAVE_AS_TARGET_EXIST, targetDSOM.getFormattedName()))) {
                            return;
                        }
                        break block37;
                    }
                    if (this.getResource() instanceof MessageQueue) {
                        PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_AS_NO_TARGET_EXIST_MQ, targetDSOM.getFormattedName()));
                        this.doSaveAs();
                        return;
                    }
                    if (this.getResource() instanceof UssFile) {
                        PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_AS_NO_TARGET_EXIST_USS, targetDSOM.getFormattedName()));
                        this.doSaveAs();
                        return;
                    }
                    if (this.getResource() instanceof CicsTransientData) {
                        PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_AS_NO_TARGET_EXIST_CICS_TD, targetDSOM.getFormattedName()));
                        this.doSaveAs();
                        return;
                    }
                    if (this.getResource() instanceof CicsTemporaryStorage) {
                        PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_AS_NO_TARGET_EXIST_CICS_TS, targetDSOM.getFormattedName()));
                        this.doSaveAs();
                        return;
                    }
                    if (this.getResource() instanceof CicsFile && targetDSOM.asMember() != null) {
                        PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_AS_NO_TARGET_EXIST_CICS_FILE_TO_MEMBER, targetDSOM.getFormattedName()));
                        this.doSaveAs();
                        return;
                    }
                    if (this.getResource() instanceof DataSetOrMember) {
                        DataSetOrMember currentDSOM = (DataSetOrMember)this.getResource();
                        if (currentDSOM.asMember() != null && targetDSOM.asMember() == null) {
                            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_AS_MEMBER_TO_NON_MEMBER_NOT_ALLOWED, targetDSOM.getFormattedName()));
                            this.doSaveAs();
                            return;
                        }
                        if (currentDSOM.asMember() == null && targetDSOM.asMember() != null) {
                            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_AS_NON_MEMBER_TO_MEMBER_NOT_ALLOWED, targetDSOM.getFormattedName()));
                            this.doSaveAs();
                            return;
                        }
                    }
                    break block37;
                }
                if (targetResource instanceof MessageQueue) {
                    if (!infoResult.isSuccessfulWithoutWarnings() || !((MessageQueue)targetResource).getConfirmedExists()) {
                        PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_AS_NO_MQQDEFINED, targetResource.getFormattedName()));
                        this.doSaveAs();
                        return;
                    }
                    break block37;
                }
                if (targetResource instanceof UssFile) {
                    if (!infoResult.isSuccessfulWithoutWarnings() || !((UssFile)targetResource).getConfirmedExists()) {
                        PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_AS_NO_USSFILEDEFINED, targetResource.getFormattedName()));
                        this.doSaveAs();
                        return;
                    }
                    break block37;
                }
                if (targetResource instanceof CicsFile) {
                    PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_AS_NO_CICS_FILE_DEFINED, targetResource.getFormattedName()));
                    this.doSaveAs();
                    return;
                }
                if (targetResource instanceof CicsTransientData) {
                    if (!infoResult.isSuccessfulWithoutWarnings() || !((CicsTransientData)targetResource).getConfirmedExists()) {
                        PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_AS_NO_CICS_TD_DEFINED, targetResource.getFormattedName()));
                        this.doSaveAs();
                        return;
                    }
                } else if (!(targetResource instanceof CicsTemporaryStorage)) {
                    PDDialogs.openErrorThreadSafe((String)Messages.FMPlugin_INFO_TITLE, (String)MessageFormat.format(Messages.FormattedEditor_UNSUPPORTED_TARGET_TYPE, targetResource.getFormattedName()));
                    this.doSaveAs();
                    return;
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.FormattedEditor_SAVE_AS_OP, FormattedEditor.this.getResource().getFormattedName(), targetResource.getFormattedName()), 1);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    Result result = FormattedEditor.this.getSessionIdentifier().saveAs(targetResource, howIsGoing);
                    if (!result.isSuccessfulWithoutWarnings()) {
                        allResult.copy(result);
                        return;
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InterruptedException ie) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
            this.disableEditorActions();
            return;
        }
        catch (Exception e) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_AS_OP_EX, this.getResource().getFormattedName(), targetResource.getFormattedName()), (Throwable)e);
            return;
        }
        if (allResult.hasError()) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_AS_OP_ERR, this.getResource().getFormattedName(), targetResource.getFormattedName()), (String)allResult.getMessagesCombined().toString());
            return;
        }
        if (FMUIPlugin.getDefault().dsEditSessionExist(targetResource)) {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_AS_OKTARGET_EXIST, targetResource.getFormattedName()));
            this.setDirty(false);
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
            PDSystemsTreeUpdater.refreshAllRelatedTo((Object)targetResource);
        } else {
            this.setDirty(false);
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
            BaseEditorOptions options = this.getSessionIdentifier().getBaseEditOptions().clone();
            options.setaResource(targetResource);
            OpenFormattedEditorJob job = new OpenFormattedEditorJob(this.getSessionProperties(), options, null);
            job.schedule();
            PDSystemsTreeUpdater.refreshAllRelatedTo((Object)targetResource);
        }
        OpenAsFormattedEditorActionItem.refreshIconDecorations();
    }

    public boolean isSaveAsAllowed() {
        return this.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.BASE;
    }

    private void createCharModePage() {
        boolean blockSelection = false;
        if (this.currentPage instanceof CharModePage) {
            blockSelection = ((CharModePage)this.currentPage).getBlockSelection();
        }
        this.currentActiveMode = IFMEditor.EditorMode.CHARACTER;
        Composite pageParent = GUI.composite((Composite)this.getContainer(), (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Composite topComposite = GUI.composite((Composite)pageParent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.topNavigationBar = new TopNavigationBar(this);
        this.topNavigationBar.createControl(topComposite);
        Composite contentComposite = GUI.composite((Composite)pageParent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.currentPage = new CharModePage(this, contentComposite, this.topNavigationBar, blockSelection);
        Composite botComposite = GUI.composite((Composite)pageParent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        BottomNavigationBar.createBottomNavigationComposite(botComposite, this);
        int index = this.getPageCount();
        this.addPage(index, (Control)pageParent);
        this.setPageText(index, IFMEditor.EditorMode.CHARACTER.name());
        this.addPropertyListener(this.currentPage);
    }

    private void createFormattedModePage() {
        this.currentActiveMode = IFMEditor.EditorMode.FORMATTED;
        Composite pageParent = GUI.composite((Composite)this.getContainer(), (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Composite topComposite = GUI.composite((Composite)pageParent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.topNavigationBar = new TopNavigationBar(this);
        this.topNavigationBar.createControl(topComposite);
        Composite contentComposite = GUI.composite((Composite)pageParent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.currentPage = new FormattedPage(this, contentComposite, this.showFromColumnIndex, FormattedEditorPreferencePage.getMaxColumnNo());
        if (((FormattedPage)this.currentPage).getCurrentShowFromHeldColumnIndex() >= 0) {
            this.topNavigationBar.setColumnNoText(((FormattedPage)this.currentPage).getCurrentShowFromHeldColumnIndex() + 1);
        } else if (((FormattedPage)this.currentPage).getCurrentShowFromOtherColumnIndex() >= 0) {
            this.topNavigationBar.setColumnNoText(((FormattedPage)this.currentPage).getCurrentShowFromOtherColumnIndex() + 1);
        }
        Composite botComposite = GUI.composite((Composite)pageParent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        BottomNavigationBar.createBottomNavigationComposite(botComposite, this);
        int index = this.getPageCount();
        this.addPage(index, (Control)pageParent);
        this.setPageText(index, IFMEditor.EditorMode.FORMATTED.name());
        this.addPropertyListener(this.currentPage);
    }

    private void createAdvancedModePage() {
        this.currentActiveMode = IFMEditor.EditorMode.ADVANCED;
        Composite pageParent = GUI.composite((Composite)this.getContainer(), (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Composite topComposite = GUI.composite((Composite)pageParent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        Composite contentComposite = GUI.composite((Composite)pageParent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.currentPage = new AdvancedModePage(this, contentComposite, this.showFromColumnIndex, FormattedEditorPreferencePage.getMaxColumnNo());
        Composite botComposite = GUI.composite((Composite)pageParent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        BottomNavigationBar.createBottomNavigationComposite(botComposite, this);
        int index = this.getPageCount();
        this.addPage(index, (Control)pageParent);
        this.setPageText(index, IFMEditor.EditorMode.ADVANCED.name());
        this.addPropertyListener(this.currentPage);
    }

    public void goRight() {
        this.showFromColumnIndex = this.currentActiveMode == IFMEditor.EditorMode.FORMATTED ? (this.showFromColumnIndex += FormattedEditorPreferencePage.getMaxColumnNo()) : (this.showFromColumnIndex += FormattedEditorPreferencePage.getMaxCharacterNo());
        this.refreshContent();
    }

    public void goLeft() {
        this.showFromColumnIndex = this.currentActiveMode == IFMEditor.EditorMode.FORMATTED ? (this.showFromColumnIndex -= FormattedEditorPreferencePage.getMaxColumnNo()) : (this.showFromColumnIndex -= FormattedEditorPreferencePage.getMaxCharacterNo());
        this.refreshContent();
    }

    public void startFromColumn(String columnNoText) {
        try {
            int tempInt = columnNoText != null && columnNoText.trim().length() > 0 ? Integer.parseInt(columnNoText) - 1 : 0;
            this.startFromColumn(tempInt);
        }
        catch (Exception e) {
            this.topNavigationBar.setColumnNoText(this.showFromColumnIndex + 1);
        }
    }

    public void startFromColumn(int columnNo) {
        try {
            if (columnNo != this.showFromColumnIndex) {
                this.showFromColumnIndex = columnNo;
                this.refreshContent();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void refreshContent() {
        if (this.showFromColumnIndex < 0) {
            this.showFromColumnIndex = 0;
        }
        this.showFromColumnIndex = this.currentPage instanceof FormattedPage ? ((FormattedPage)this.currentPage).refreshContent(this.showFromColumnIndex, FormattedEditorPreferencePage.getMaxColumnNo()) : ((CharModePage)this.currentPage).refreshContent(this.showFromColumnIndex);
        this.topNavigationBar.setColumnNoText(this.showFromColumnIndex + 1);
    }

    @Override
    public AbstractSessionFormatted getSessionIdentifier() {
        return this.fmiEditorInput.getSessionIdentifer();
    }

    @Override
    public IZRL getResource() {
        return this.fmiEditorInput.getResource();
    }

    @Override
    public IZRL getTemplateResource() {
        return this.fmiEditorInput.getTemplateResource();
    }

    @Override
    public boolean isEditSession() {
        return this.fmiEditorInput.isEditSession();
    }

    public boolean isSortRunning() {
        return this.getSessionProperties().isAllRecdsLoaded();
    }

    @Override
    public FMEditSessionProperties getSessionProperties() {
        return this.fmiEditorInput.getEditSessionProperties();
    }

    @Override
    public void setShowNotSelectedRecords(boolean newValue) {
        if (this.showNotSelectedRecords != newValue) {
            this.showNotSelectedRecords = newValue;
            this.cachedContents = null;
        }
    }

    @Override
    public boolean isShowNotSelectedRecords() {
        return this.showNotSelectedRecords;
    }

    @Override
    public void setShowSuppressedRecords(boolean newValue) {
        if (this.showSuppressedRecords != newValue) {
            this.showSuppressedRecords = newValue;
            this.cachedContents = null;
        }
    }

    @Override
    public boolean isShowSuppressedRecords() {
        return this.showSuppressedRecords;
    }

    @Override
    public void setShowLengthErrorRecords(boolean newValue) {
        if (this.showLengthErrorRecords != newValue) {
            this.showLengthErrorRecords = newValue;
            this.cachedContents = null;
        }
    }

    @Override
    public boolean isShowLengthErrorRecords() {
        return this.showLengthErrorRecords;
    }

    @Override
    public void setDisplayShdowLinesForEx(boolean newValue) {
        if (this.displayShadowExcludedGroup != newValue) {
            this.displayShadowExcludedGroup = newValue;
            this.cachedContents = null;
        }
    }

    @Override
    public boolean isDisplayShadowLinesForEx() {
        return this.displayShadowExcludedGroup;
    }

    @Override
    public void setDisplayShdowLinesForNot(boolean newValue) {
        if (this.displayShadowNotSelectedGroup != newValue) {
            this.displayShadowNotSelectedGroup = newValue;
            this.cachedContents = null;
        }
    }

    @Override
    public boolean isDisplayShadowLinesForNot() {
        return this.displayShadowNotSelectedGroup;
    }

    @Override
    public void setDisplayShdowLinesForSup(boolean newValue) {
        if (this.displayShadowSuppressedGroup != newValue) {
            this.displayShadowSuppressedGroup = newValue;
            this.cachedContents = null;
        }
    }

    @Override
    public boolean isDisplayShadowLinesForSup() {
        return this.displayShadowSuppressedGroup;
    }

    @Override
    public boolean isHexMode() {
        return this.hexOn;
    }

    @Override
    public void setHexMode(boolean newValue) {
        if (newValue != this.isHexMode()) {
            this.hexOn = newValue;
            this.cachedContents = null;
            this.firePropertyChange(2049);
            return;
        }
    }

    public EditType getActiveModel() {
        return this.currentContents;
    }

    @Override
    public HdrType getCurrentTableHeader(int layoutID) {
        return FormattedEditor.getCurrentTableHeader(this.getActiveModel(), layoutID);
    }

    public static HdrType getCurrentTableHeader(EditType editType, int layoutID) {
        if (editType == null) {
            return null;
        }
        EList layouts = editType.getHdr();
        for (HdrType hdrType : layouts) {
            if (hdrType.getId() != layoutID) continue;
            return hdrType;
        }
        return null;
    }

    @Override
    public ArrayList<DisplayLine> getCurrentEditorContents() {
        if (this.cachedContents != null) {
            return this.cachedContents;
        }
        this.cachedContents = new ArrayList();
        if (this.getActiveModel() == null) {
            return this.cachedContents;
        }
        EList recs = this.getActiveModel().getRec();
        int i = 0;
        while (i < recs.size()) {
            RecType aRec = (RecType)recs.get(i);
            DisplayLine dl = FormattedEditor.prepareDisplayLine(aRec, this.fmiEditorInput.getResource(), this.getActiveLayoutID());
            if (dl != null) {
                this.cachedContents.add(dl);
                if (this.isHexMode()) {
                    HexRecordWrapper hexWrapper = new HexRecordWrapper(this.fmiEditorInput.getResource(), dl, true);
                    dl.addHexRecordWrapper(hexWrapper);
                    this.cachedContents.add(hexWrapper);
                    hexWrapper = new HexRecordWrapper(this.fmiEditorInput.getResource(), dl, false);
                    this.cachedContents.add(hexWrapper);
                    dl.addHexRecordWrapper(hexWrapper);
                }
            }
            ++i;
        }
        return this.cachedContents;
    }

    public static DisplayLine prepareDisplayLine(RecType aRec, IZRL aResource, int activeLayoutID) {
        Objects.requireNonNull(aRec, "Must specify a non-null aRec.");
        DisplayLine dl = null;
        dl = aRec.isSetNot() || aRec.isNot() ? new NotSelectedRecordsGroup(aResource, aRec) : (aRec.isSetSup() || aRec.isSup() ? new SuppressedRecordsShadowGroup(aResource, aRec) : (aRec.isSetExc() || aRec.isExc() ? new ExcludedRecordsShadowGroup(aResource, aRec) : (aRec.isSetOldEmpty() || aRec.isOldEmpty() || aRec.isSetDel() || aRec.isDel() ? new EmptyRecordsShadowGroup(aResource, aRec) : (aRec.isSetWasNot() || aRec.isWasNot() ? (aRec.getId() == activeLayoutID || aRec.getId() == 0 ? new DisplayLine(aResource, aRec) : new NotSelectedRecordShadowLine(aResource, aRec)) : (aRec.isSetWasSup() || aRec.isWasSup() ? new SuppressedRecordShadowLine(aResource, aRec) : new DisplayLine(aResource, aRec))))));
        return dl;
    }

    public Layouttype getLayout(RecType aRecord) {
        TemplateType aTemplate = this.getCurrentTemplate();
        if (aTemplate == null) {
            return null;
        }
        if (!aRecord.isSetId()) {
            return null;
        }
        int layoutID = aRecord.getId();
        EList layouts = aTemplate.getLayout();
        int i = 0;
        while (i < layouts.size()) {
            Layouttype aLayout = (Layouttype)layouts.get(i);
            if (aLayout.getId() == layoutID) {
                return aLayout;
            }
            ++i;
        }
        return null;
    }

    @Override
    public RecType getTopRecord() {
        ArrayList<DisplayLine> contents = this.getCurrentEditorContents();
        if (contents.isEmpty()) {
            return null;
        }
        return contents.get(0).getRecord();
    }

    public int getIndexOf(int recordNumber) {
        ArrayList<DisplayLine> contents = this.getCurrentEditorContents();
        int i = 0;
        while (i < contents.size()) {
            DisplayLine dl = contents.get(i);
            if (dl.getRecord().getRecno() == recordNumber) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getIndexOf(RecType recordToken) {
        ArrayList<DisplayLine> contents = this.getCurrentEditorContents();
        int i = 0;
        while (i < contents.size()) {
            DisplayLine dl = contents.get(i);
            if (dl.getRecord().getToken().equalsIgnoreCase(recordToken.getToken())) {
                if (recordToken.isSetSeg()) {
                    if (dl.getRecord().isSetSeg() && recordToken.getSeg() == dl.getRecord().getSeg()) {
                        return i;
                    }
                } else if (recordToken.isSetSeq()) {
                    if (dl.getRecord().isSetSeq() && recordToken.getSeq() == dl.getRecord().getSeq()) {
                        return i;
                    }
                } else {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    @Override
    public RecType getLastVisibleRecord() {
        ArrayList<DisplayLine> contents = this.getCurrentEditorContents();
        if (contents.isEmpty()) {
            return null;
        }
        return contents.get(contents.size() - 1).getRecord();
    }

    @Override
    public TemplateType getCurrentTemplate() {
        return this.template;
    }

    @Override
    public int getActiveLayoutID() {
        if (this.currentContents == null) {
            return -1;
        }
        return this.currentContents.getId();
    }

    public Layouttype getActiveLayout() {
        if (this.template == null) {
            return null;
        }
        int activeLayoutID = this.getActiveLayoutID();
        if (activeLayoutID == -1) {
            return null;
        }
        EList layouts = this.template.getLayout();
        int i = 0;
        while (i < layouts.size()) {
            Layouttype aLayout = (Layouttype)layouts.get(i);
            if (aLayout.getId() == activeLayoutID) {
                return aLayout;
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getLayoutName(int layoutID) {
        if (this.template == null) {
            return null;
        }
        EList layouts = this.template.getLayout();
        int i = 0;
        while (i < layouts.size()) {
            Layouttype aLayout = (Layouttype)layouts.get(i);
            if (aLayout.getId() == layoutID) {
                return ((Symboltype)aLayout.getSymbol().get(0)).getName(this.getSystem());
            }
            ++i;
        }
        return null;
    }

    private void saveFMPreferenceStore() {
        if (FMUIPlugin.getDefault().getPreferenceStore() instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)FMUIPlugin.getDefault().getPreferenceStore()).save();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    @Override
    public void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FormattedEditor.this.firePropertyChange(2048);
            }
        });
    }

    public void setActiveLayout(final int layoutID, final String layoutName) {
        UIJob setLayout = new UIJob(Messages.FormattedEditor_UpdatingActiveLayout){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(MessageFormat.format(Messages.FMIFormattedDataEditor_CHANGE_LAYOUT, layoutName), 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    Result result = FormattedEditor.this.fmiEditorInput.getSessionIdentifer().requestLayoutChange(layoutID, howIsGoing);
                    if (!result.isSuccessfulWithoutWarnings()) {
                        Status status = new Status(4, "com.ibm.etools.fm.ui", result.getMessagesCombined().toString());
                        return status;
                    }
                    monitor.worked(1);
                    if (!FormattedEditor.this.loadRecordsFromHost(howIsGoing)) {
                        Status status = new Status(4, "com.ibm.etools.fm.ui", Messages.FormattedEditor_FailedToLoadRecords);
                        return status;
                    }
                    try {
                        monitor.worked(1);
                    }
                    catch (InterruptedException e) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        setLayout.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().matches(8)) {
                    PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
                    FormattedEditor.this.disableEditorActions();
                } else if (event.getResult().matches(4)) {
                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FMIFormattedDataEditor_CHANGE_LAYOUT_ERR, layoutName), (String)event.getResult().getMessage());
                }
            }
        });
        setLayout.setUser(true);
        setLayout.schedule();
    }

    private void initEditSession() {
        UIJob init = new UIJob(Messages.FormattedEditor_InitBrowseEditSession){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                if (FormattedEditor.this.fmiEditorInput.getTemplateResource() != null && !FormattedEditor.this.loadTemplate(howIsGoing)) {
                    return new Status(4, "com.ibm.etools.fm.ui", MessageFormat.format(Messages.FormattedEditor_LOAD_TEMPL_ERR, FormattedEditor.this.fmiEditorInput.getTemplateResource().getFormattedName()));
                }
                FormattedEditor.this.readCachedRecords(howIsGoing);
                return Status.OK_STATUS;
            }
        };
        init.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    if (event.getResult().matches(4)) {
                        PDDialogs.openErrorThreadSafe((String)event.getResult().getMessage());
                    } else if (event.getResult().matches(8)) {
                        PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
                        FormattedEditor.this.disableEditorActions();
                    }
                    FormattedEditor.this.getSite().getPage().closeEditor((IEditorPart)FormattedEditor.this, false);
                }
            }
        });
        init.setUser(true);
        init.schedule();
    }

    @Override
    public boolean loadRecordsFromHost(IHowIsGoing monitor) throws InterruptedException {
        boolean bl;
        FileInputStream dataReader = null;
        try {
            Result readResult = new Result((Object)new StringBuffer());
            IFile newFile = this.fmiEditorInput.getSessionIdentifer().readRecords(monitor, readResult, FormattedEditorPreferencePage.getRecordCacheSize());
            if (newFile == null || !readResult.isSuccessfulWithoutWarnings()) {
                PDDialogs.openErrorThreadSafe((String)Messages.FormattedEditor_READ_RECORD_ERR, (String)readResult.getMessagesCombined().toString());
                return false;
            }
            newFile.refreshLocal(1, (IProgressMonitor)monitor.getMonitor());
            this.fmiEditorInput.setFile(newFile);
            bl = this.readCachedRecords(monitor);
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_LOAD_DATA, this.fmiEditorInput.getResource().getFormattedName()), (Throwable)e);
            return false;
        }
        finally {
            if (dataReader != null) {
                try {
                    dataReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadRecordsFromHostSetLocationFirst(IHowIsGoing monitor, RecType topRecord) throws InterruptedException {
        FileInputStream dataReader = null;
        try {
            Result cursorResult = this.fmiEditorInput.getSessionIdentifer().setCursorPosition(monitor, topRecord, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
            if (!cursorResult.isSuccessfulWithoutWarnings()) {
                PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SET_CURSOR_ERR, topRecord.getRecno(), topRecord.getSeq(), topRecord.getToken()), (String)cursorResult.getMessagesCombined().toString());
                return false;
            }
            Result readResult = new Result((Object)new StringBuffer());
            IFile newFile = this.fmiEditorInput.getSessionIdentifer().readRecords(monitor, readResult, FormattedEditorPreferencePage.getRecordCacheSize());
            if (newFile == null || !readResult.isSuccessfulWithoutWarnings()) {
                PDDialogs.openErrorThreadSafe((String)Messages.FormattedEditor_READ_RECORD_ERR, (String)readResult.getMessagesCombined().toString());
                return false;
            }
            newFile.refreshLocal(1, (IProgressMonitor)monitor.getMonitor());
            this.fmiEditorInput.setFile(newFile);
            boolean bl = this.readCachedRecords(monitor);
            return bl;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.FormattedEditor_LOAD_DATA, this.fmiEditorInput.getResource().getFormattedName());
            logger.error((Object)errMsg, (Throwable)e);
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return false;
        }
        finally {
            if (dataReader != null) {
                try {
                    dataReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean readCachedRecords(IHowIsGoing monitor) {
        FileInputStream dataReader = null;
        try {
            this.fmiEditorInput.getFile().refreshLocal(1, (IProgressMonitor)monitor.getMonitor());
            dataReader = new FileInputStream(this.fmiEditorInput.getFile().getLocation().toFile());
            this.currentContents = EditorDataSerializeUtils.load((InputStream)dataReader, (IZRL)this.getResource());
            FormattedEditor.prepareErrorFieldsInRecords(this.currentContents);
            this.currentContents.setTemplate(this.template);
            this.cachedContents = null;
            this.setStartPosition();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FormattedEditor.this.switchEditorMode(FormattedEditor.this.getCurrentEditorMode());
                    FormattedEditor.this.firePropertyChange(2048);
                }
            });
            return true;
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.FormattedEditor_LOAD_DATA, this.fmiEditorInput.getResource().getFormattedName());
            logger.error((Object)errMsg, (Throwable)e);
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return false;
        }
        finally {
            if (dataReader != null) {
                try {
                    dataReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void setStartPosition() {
        if (this.getActiveModel() == null || this.getActiveModel().getRec() == null) {
            return;
        }
        EList list = this.getActiveModel().getRec();
        int i = 0;
        while (i < list.size()) {
            RecType aRec = (RecType)list.get(i);
            if (aRec.isSetRecno()) {
                logger.debug((Object)("Setting the start record to " + aRec.getRecno()));
                this.fmiEditorInput.getEditSessionProperties().setCurrentStartPosition(aRec.getRecno());
                return;
            }
            ++i;
        }
        this.fmiEditorInput.getEditSessionProperties().setCurrentStartPosition(0);
    }

    private boolean loadTemplate(IHowIsGoing monitor) {
        try {
            this.fmiEditorInput.getTemplateFile().refreshLocal(1, (IProgressMonitor)monitor.getMonitor());
            this.template = TemplateSerializeUtils.load((IFile)this.fmiEditorInput.getTemplateFile(), (IZRL)this.getResource());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void prepareErrorFieldsInRecords(EditType newEditContent) {
        if (newEditContent == null || newEditContent.getRec().isEmpty()) {
            return;
        }
        EList records = newEditContent.getRec();
        for (RecType aRec : records) {
            EList fields = aRec.getField();
            if (fields == null) continue;
            for (FieldType aField : fields) {
                if (!aField.isSetError() || !aField.isError()) continue;
                aRec.setFieldsInError(aField);
            }
        }
    }

    public FMEditorInputWithTemplate getEditorInput() {
        return this.fmiEditorInput;
    }

    @Override
    public void switchEditorMode(IFMEditor.EditorMode mode) {
        if (this.getContainer() == null) {
            return;
        }
        if (this.currentPage != null) {
            this.removePropertyListener(this.currentPage);
            this.removePage(0);
            if (this.currentPage instanceof CharModePage && mode != IFMEditor.EditorMode.CHARACTER) {
                CharModePage page = (CharModePage)this.currentPage;
                page.resetToggleState();
            }
        }
        if (IFMEditor.EditorMode.CHARACTER == mode) {
            this.currentActiveMode = IFMEditor.EditorMode.CHARACTER;
            this.createCharModePage();
        } else if (IFMEditor.EditorMode.FORMATTED == mode) {
            this.currentActiveMode = IFMEditor.EditorMode.FORMATTED;
            this.createFormattedModePage();
        } else if (IFMEditor.EditorMode.ADVANCED == mode) {
            this.currentActiveMode = IFMEditor.EditorMode.ADVANCED;
            this.createAdvancedModePage();
        } else {
            this.currentActiveMode = IFMEditor.EditorMode.CHARACTER;
            this.createCharModePage();
        }
        EclipseUtils.retestEclipseProperty((String)"com.ibm.etools.fm.ui.editor", (String)"actionsEnabled");
        this.setActivePage(0);
        this.currentPage.setCursor(NavigationSpecification.TOP);
    }

    @Override
    public IFMEditor.EditorMode getCurrentEditorMode() {
        return this.currentActiveMode;
    }

    public IFormattedEditorPage getCurrentPage() {
        return this.currentPage;
    }

    public FormattedEditor getEditor() {
        return this;
    }

    public boolean isDirty() {
        return this.isEditorDirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.isEditorDirty = dirty;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FormattedEditor.this.firePropertyChange(257);
            }
        });
    }

    @Override
    public boolean updateDirtyContents() {
        boolean insertModeStatus = this.isInsertMode();
        this.setInsertMode(true);
        int[] selection = this.getSelection();
        boolean selectionChanged = false;
        try {
            if (this.isDirty()) {
                selectionChanged = true;
                IFormattedEditorPage currentPageTemp = this.getCurrentPage();
                String[] errors = null;
                try {
                    errors = currentPageTemp.validateContents();
                }
                catch (InterruptedException e) {
                    PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
                    this.disableEditorActions();
                    if (!insertModeStatus) {
                        this.setInsertMode(insertModeStatus);
                    }
                    if (selectionChanged) {
                        this.setSelection(selection);
                    }
                    return false;
                }
                if (errors != null && !PDDialogs.openQuestion((String)Messages.FMPlugin_QUESTION_TITLE, (String)errors[0], (String)errors[1])) {
                    return false;
                }
                boolean bl = currentPageTemp.updateHostEditorChain();
                return bl;
            }
            return true;
        }
        finally {
            if (!insertModeStatus) {
                this.setInsertMode(insertModeStatus);
            }
            if (selectionChanged) {
                this.setSelection(selection);
            }
        }
    }

    public EditorActionManager getActionManager() {
        return this.actionManager;
    }

    public boolean isInsertMode() {
        return this.insertMode;
    }

    public void setInsertMode(boolean insertMode) {
        this.insertMode = insertMode;
        this.firePropertyChange(2050);
    }

    @Override
    public boolean isSearchActive() {
        return this.searchRunning;
    }

    @Override
    public void setSearchActive(boolean active) {
        this.searchRunning = active;
    }

    public ArrayList<ISortCriteria> getCurrentSortCriteria() {
        return this.sortCriteriaList;
    }

    public void setSortCriteria(ArrayList<ISortCriteria> newCriteriaList) {
        this.sortCriteriaList = newCriteriaList;
    }

    @Override
    public ArrayList<RecType> getSelectedNonShadowLines() {
        return this.getCurrentPage().getSelectedNonShadowLines();
    }

    @Override
    public void updateLocationInformation(int caretPosition) {
        String current = Messages.FormattedEditor_UNKNOWN;
        Object total = Messages.FormattedEditor_UNKNOWN;
        ArrayList<DisplayLine> contents = this.getCurrentEditorContents();
        if (contents == null || contents.isEmpty()) {
            if (this.topNavigationBar != null) {
                if (this.getSessionProperties().getNumRecords() >= 0) {
                    total = "" + this.getSessionProperties().getNumRecords();
                }
                this.topNavigationBar.setLocationText(current, (String)total);
                this.topNavigationBar.setCursorLocationText(null);
            }
            return;
        }
        if (this.topNavigationBar != null) {
            if (this.getSessionProperties().getNumRecords() >= 0) {
                total = "" + this.getSessionProperties().getNumRecords();
            }
            DisplayLine selectedLine = null;
            int[] selection = this.getSelection();
            if (selection != null && selection.length != 0 && selection[0] < this.getCurrentEditorContents().size()) {
                selectedLine = contents.get(selection[0]);
            }
            if (caretPosition != -1) {
                current = DisplayLineUtility.formatForDisplay(selectedLine, this.showFromColumnIndex + caretPosition);
                this.topNavigationBar.setCursorLocationText("" + caretPosition);
            } else {
                current = DisplayLineUtility.formatForDisplay(selectedLine, caretPosition);
                this.topNavigationBar.setCursorLocationText(null);
            }
            this.topNavigationBar.setLocationText(current, (String)total);
            return;
        }
    }

    public void updateCursorLocation(String cursorLocation) {
        this.topNavigationBar.setCursorLocationText(cursorLocation);
    }

    @Override
    public int[] getSelection() {
        if (this.currentPage != null) {
            return this.currentPage.getSelectedLines();
        }
        return null;
    }

    @Override
    public void setSelection(int[] selection) {
        if (this.getCurrentEditorContents().isEmpty()) {
            return;
        }
        if (this.currentPage.setSelectedLines(selection) && selection != null && selection.length > 0) {
            SingleView.displayCurrentRecord(this, this.getCurrentEditorContents().get(selection[0]));
        }
    }

    @Override
    public void disableEditorActions() {
        this.disableAllActions = true;
        EclipseUtils.retestEclipseProperty((String)"com.ibm.etools.fm.ui.editor", (String)"actionsEnabled");
        if (PDPlatformUIUtils.view.showView((String)"com.ibm.etools.fm.editor.formatted.pages.single.SingleView") == null) {
            logger.error((Object)"Exception thrown while trying to open Properties view. See log for further details.");
        }
        this.currentPage.setCursor(NavigationSpecification.TOP);
    }

    @Override
    public boolean isAllActionsDisabled() {
        return this.disableAllActions;
    }

    public DisplayLine getCurrentLine() {
        int[] selectedLines = this.getSelection();
        if (selectedLines == null || selectedLines.length == 0) {
            return null;
        }
        if (selectedLines[0] >= this.getCurrentEditorContents().size()) {
            return null;
        }
        return this.getCurrentEditorContents().get(selectedLines[0]);
    }

    public DisplayLine getNextLine(boolean ignoreHexLines) {
        int[] selectedLines = this.getCurrentPage().getSelectedLines();
        if (selectedLines == null || selectedLines.length == 0) {
            if (this.getCurrentEditorContents().size() > 0) {
                this.setSelection(new int[1]);
                return this.getCurrentEditorContents().get(0);
            }
            return null;
        }
        if (ignoreHexLines && this.isHexMode()) {
            int itemIndex;
            int firstSelection = selectedLines[0];
            DisplayLine selectedRecordLine = this.getCurrentEditorContents().get(firstSelection);
            if (selectedRecordLine instanceof HexRecordWrapper) {
                selectedRecordLine = ((HexRecordWrapper)selectedRecordLine).getDisplayLine();
            }
            if ((itemIndex = this.getIndexOf(selectedRecordLine)) == this.getCurrentEditorContents().size() - 3) {
                PageDown action = new PageDown();
                Result<StringBuffer> result = action.run(this);
                if (result != null && result.isSuccessfulWithoutWarnings() && this.getCurrentEditorContents().size() > 0) {
                    return this.getCurrentEditorContents().get(0);
                }
                if (this.getCurrentEditorContents() != null && this.getCurrentEditorContents().size() > 0) {
                    int[] newSelection = new int[]{this.getCurrentEditorContents().size() - 3};
                    this.getCurrentPage().setSelectedLines(newSelection);
                    return this.getCurrentEditorContents().get(this.getCurrentEditorContents().size() - 3);
                }
                return null;
            }
            int[] newSelection = new int[]{itemIndex + 3};
            this.getCurrentPage().setSelectedLines(newSelection);
            return this.getCurrentEditorContents().get(itemIndex + 3);
        }
        int firstSelection = selectedLines[0];
        if (firstSelection == this.getCurrentEditorContents().size() - 1) {
            PageDown action = new PageDown();
            Result<StringBuffer> result = action.run(this);
            if (result != null && result.isSuccessfulWithoutWarnings() && this.getCurrentEditorContents().size() > 0) {
                return this.getCurrentEditorContents().get(0);
            }
            if (this.getCurrentEditorContents() != null && this.getCurrentEditorContents().size() > 0) {
                int[] newSelection = new int[]{this.getCurrentEditorContents().size() - 1};
                this.getCurrentPage().setSelectedLines(newSelection);
                return this.getCurrentEditorContents().get(this.getCurrentEditorContents().size() - 1);
            }
            return null;
        }
        int[] newSelection = new int[]{firstSelection + 1};
        this.getCurrentPage().setSelectedLines(newSelection);
        return this.getCurrentEditorContents().get(firstSelection + 1);
    }

    public DisplayLine getPreviousLine(boolean ignoreHexLines) {
        int[] selectedLines = this.getCurrentPage().getSelectedLines();
        if (selectedLines == null || selectedLines.length == 0) {
            if (this.getCurrentEditorContents().size() > 0) {
                this.setSelection(new int[1]);
                return this.getCurrentEditorContents().get(0);
            }
            return null;
        }
        if (ignoreHexLines && this.isHexMode()) {
            int itemIndex;
            int firstSelection = selectedLines[0];
            DisplayLine selectedRecordLine = this.getCurrentEditorContents().get(firstSelection);
            if (selectedRecordLine instanceof HexRecordWrapper) {
                selectedRecordLine = ((HexRecordWrapper)selectedRecordLine).getDisplayLine();
            }
            if ((itemIndex = this.getIndexOf(selectedRecordLine)) == 0) {
                PageUp action = new PageUp();
                Result<StringBuffer> result = action.run(this);
                if (result != null && result.isSuccessfulWithoutWarnings() && this.getCurrentEditorContents().size() > 0) {
                    return this.getCurrentEditorContents().get(this.getCurrentEditorContents().size() - 3);
                }
                return null;
            }
            int[] newSelection = new int[]{itemIndex - 3};
            this.getCurrentPage().setSelectedLines(newSelection);
            return this.getCurrentEditorContents().get(itemIndex - 3);
        }
        int firstSelection = selectedLines[0];
        if (firstSelection == 0) {
            PageUp action = new PageUp();
            Result<StringBuffer> result = action.run(this);
            if (result != null && result.isSuccessfulWithoutWarnings() && this.getCurrentEditorContents().size() > 0) {
                return this.getCurrentEditorContents().get(this.getCurrentEditorContents().size() - 1);
            }
            return null;
        }
        int[] newSelection = new int[]{firstSelection - 1};
        this.getCurrentPage().setSelectedLines(newSelection);
        return this.getCurrentEditorContents().get(firstSelection - 1);
    }

    public boolean isNeedScrolling() {
        return this.needScrolling;
    }

    public void setNeedScrolling(boolean needScrolling) {
        this.needScrolling = needScrolling;
    }

    public boolean isScrollInAction() {
        return this.scrollInAction;
    }

    public void setScrollInAction(boolean scrollInAction) {
        this.scrollInAction = scrollInAction;
    }

    public boolean updateHexValue(DisplayLine dl, String newHexValue) {
        if (dl == null) {
            return false;
        }
        if (dl instanceof ShadowGroup) {
            return false;
        }
        int index = this.getIndexOf(dl);
        if (index == -1) {
            return false;
        }
        dl.getRecord().setHex(newHexValue);
        dl.getRecord().setChg(true);
        dl.getRecord().updateOnHostRequired(true);
        this.setDirty(true);
        int[] currentSelection = new int[]{index};
        this.refresh();
        this.setSelection(currentSelection);
        return true;
    }

    public int getIndexOf(DisplayLine dl) {
        ArrayList<DisplayLine> list = this.getCurrentEditorContents();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) == dl) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean updateFieldValue(DisplayLine dl, int fieldIndex, String newValue, boolean hexUpdate) {
        if (this.getTemplateResource() == null) {
            logger.debug((Object)"Cannot update a field without a template.");
            return false;
        }
        if (dl instanceof ShadowGroup) {
            logger.debug((Object)"Cannot update shadowline!");
            return false;
        }
        FieldType aField = FormattedPageUtility.getField(dl.getRecord(), fieldIndex + 1);
        if (aField == null) {
            logger.debug((Object)"No field to update..");
            return false;
        }
        int index = this.getIndexOf(dl);
        if (index == -1) {
            return false;
        }
        HdrType headers = this.getCurrentTableHeader(dl.getRecord().getId());
        HdrfldType aHeader = (HdrfldType)headers.getHdrfld().get(fieldIndex);
        Symboltype aSymbol = FormattedPageUtility.getSymbol(dl.getRecord(), aHeader, this.getCurrentTemplate());
        int maxFieldLen = FormattedPageUtility.getFieldMaxLen(this.getSessionProperties(), dl.getRecord(), aSymbol, aHeader);
        int minFieldLen = FormattedPageUtility.getFieldMinLength(this.getSessionProperties(), dl.getRecord(), aSymbol, aHeader);
        if (maxFieldLen == -1) {
            return false;
        }
        logger.debug((Object)("Current column is at " + fieldIndex + ". start=" + (aHeader.isSetStart() ? aHeader.getStart() : aSymbol.getStart()) + " length=" + (aSymbol.isSetLength() ? aSymbol.getLength() : aHeader.getLen()) + " type=" + aSymbol.getType().getName()));
        if (dl instanceof HexRecordWrapper && hexUpdate) {
            if (aSymbol.getCreate().equals((Object)CreateType.VC)) {
                hexValue = newValue;
                HexRecordWrapper hrw = (HexRecordWrapper)dl;
                String oldHexValue = FormattedPageUtility.getHexHighOrLowValueVC(this.getSessionProperties(), hrw, aSymbol, aField, aHeader);
                if (!oldHexValue.equals(hexValue)) {
                    FormattedPageUtility.setHexHighOrLowValueVC(this.getSessionProperties(), hrw, aSymbol, aField, aHeader, hexValue);
                    dl.getRecord().updateOnHostRequired(true);
                    this.setDirty(true);
                    aField.setFieldUpdatedLocally(true, true);
                }
            } else {
                hexValue = newValue;
                HexRecordWrapper hrw = (HexRecordWrapper)dl;
                String oldHexValue = FormattedPageUtility.getHexHighOrLowValue(this.getSessionProperties(), hrw, aSymbol, aField, aHeader);
                if (!oldHexValue.equals(hexValue)) {
                    if (hexValue.length() < minFieldLen) {
                        hexValue = FormattedEditorUtility.addPaddingForString(hexValue, minFieldLen, '0');
                    }
                    FormattedPageUtility.setHexHighOrLowValue(this.getSessionProperties(), hrw, aSymbol, aField, aHeader, hexValue);
                    dl.getRecord().updateOnHostRequired(true);
                    this.setDirty(true);
                    aField.setFieldUpdatedLocally(true, true);
                }
            }
        } else if (!hexUpdate) {
            String textValue = newValue;
            if (FormattedPageUtility.isDb2NullableField(this.getEditor(), aSymbol)) {
                FormattedPageUtility.updateDb2NullableFieldIfRequired(this.getEditor(), textValue, aSymbol, dl.getRecord(), aField, aHeader, true);
            } else if (FormattedPageUtility.performLocalStrProc(aSymbol)) {
                String oldTexValue = FormattedPageUtility.getANValue(this.getSessionProperties(), dl.getRecord(), aSymbol, aField, aHeader, false, this.getResource());
                if (!textValue.equals(oldTexValue)) {
                    String errMsg = FormattedPageUtility.updateHexValue(this.getSessionProperties(), dl.getRecord(), aField, aHeader, this.getCurrentTemplate(), textValue, this.getResource(), aSymbol);
                    if (errMsg != null) {
                        PDDialogs.openErrorThreadSafe((String)errMsg);
                    } else {
                        dl.getRecord().setChg(true);
                        dl.getRecord().updateOnHostRequired(true);
                        this.setDirty(true);
                        aField.setFieldUpdatedLocally(true, false);
                    }
                }
            } else if (FormattedPageUtility.performAnVcStrProc(aSymbol)) {
                String oldTexValue = FormattedPageUtility.getPliVCValue(this.getSessionProperties(), dl.getRecord(), aSymbol, aField, aHeader, this.getResource(), true);
                if (!textValue.equals(oldTexValue)) {
                    String errMsg = FormattedPageUtility.updateHexValue(this.getSessionProperties(), dl.getRecord(), aField, aHeader, this.getCurrentTemplate(), textValue, this.getResource(), aSymbol);
                    if (errMsg != null) {
                        PDDialogs.openErrorThreadSafe((String)errMsg);
                    } else {
                        dl.getRecord().setChg(true);
                        dl.getRecord().updateOnHostRequired(true);
                        this.setDirty(true);
                        aField.setFieldUpdatedLocally(true, false);
                    }
                }
            } else if (aSymbol.getCreate().equals((Object)CreateType.VC)) {
                String oldTexValue = FormattedPageUtility.getVCValue(this.getSessionProperties(), this.getSessionIdentifier().getDb2EditOptions().getEditorOptions(), dl.getRecord(), aSymbol, aField, aHeader, this.getResource(), true);
                if (!textValue.equals(oldTexValue)) {
                    String errMsg = FormattedPageUtility.updateVCHexValue(this.getSessionProperties(), this.getSessionIdentifier().getDb2EditOptions().getEditorOptions(), dl.getRecord(), aField, aHeader, this.getCurrentTemplate(), textValue, aSymbol, this.getResource());
                    if (errMsg != null) {
                        PDDialogs.openErrorThreadSafe((String)errMsg);
                    } else {
                        dl.getRecord().setChg(true);
                        dl.getRecord().updateOnHostRequired(true);
                        this.setDirty(true);
                        aField.setFieldUpdatedLocally(true, false);
                    }
                }
            } else if (!textValue.equals(aField.getValue())) {
                aField.setValue(textValue);
                dl.getRecord().setChg(true);
                dl.getRecord().updateOnHostRequired(true);
                this.setDirty(true);
                aField.setFieldUpdatedLocally(true, false);
            }
        } else {
            logger.error((Object)("Invalid request for field update. LineType: " + dl.getClass().getName() + " fieldIndex=" + fieldIndex + " newValue: " + newValue + " hexUpdate? " + hexUpdate));
            return false;
        }
        if (IFMEditor.EditorMode.FORMATTED != this.getCurrentEditorMode() && IFMEditor.EditorMode.ADVANCED != this.getCurrentEditorMode()) {
            this.switchEditorMode(IFMEditor.EditorMode.FORMATTED);
        }
        int[] currentSelection = new int[]{index};
        this.refresh();
        this.setSelection(currentSelection);
        return true;
    }

    @Override
    public int getCursorIndexOnSelectedLine() {
        return this.getCurrentPage().getCursorIndexOnSelectedLine();
    }

    @Override
    public Shell getEditorShell() {
        return this.getEditorSite().getShell();
    }

    public int getShowFromColumnIndex() {
        return this.showFromColumnIndex;
    }

    public void setSegmentedStatus(boolean segmented) {
        this.segmented = segmented;
        this.topNavigationBar.setSegmented(segmented);
    }

    public boolean isSegmented() {
        return this.segmented;
    }

    @Override
    public IPDHost getSystem() {
        return this.fmiEditorInput != null ? this.fmiEditorInput.getSystem() : null;
    }

    @Override
    public boolean isBusyNow() {
        return this.busyNow;
    }

    @Override
    public void setBusyNow(boolean busyNow) {
        this.busyNow = busyNow;
    }

    public String getSelectedText() {
        IFormattedEditorPage currentPage = this.getCurrentPage();
        return currentPage != null ? currentPage.getSelectedText() : "";
    }

    public int getCurrentColumn() {
        return this.currentColumn;
    }

    public void setCurrentColumn(int curcol) {
        this.currentColumn = curcol;
    }

    public void removeDynamic(IZRL aNewTemplate) {
        this.getSessionIdentifier().getBaseEditOptions().setDynamicTemplateFlag(false);
        this.getSessionIdentifier().getBaseEditOptions().setRunTempKey(null);
        this.getSessionIdentifier().getBaseEditOptions().setaTemplate(aNewTemplate);
        this.getSessionIdentifier().getBaseEditOptions().setTemplateDirty(false);
    }

    public Map<String, String> getColNoToValuesMap() {
        return this.colNoToValuesMap;
    }

    @Override
    public void setFindActive(boolean findActive) {
        this.findActive = findActive;
    }

    @Override
    public boolean isFindModeActive() {
        return this.findActive;
    }
}

