/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted;

import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.pages.advanced.AdvancedModePage;
import com.ibm.etools.fm.editor.formatted.pages.charmode.CharModePage;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EditorPropertyTester
extends PropertyTester {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(EditorPropertyTester.class);
    public static final String NAMESPACE = "com.ibm.etools.fm.ui.editor";
    public static final String PROPERTY_IS_EDIT_MODE = "isEditMode";
    public static final String PROPERTY_IS_INPLACE_EDIT = "isInplaceEdit";
    public static final String PROPERTY_IS_PSEUDODEL_ENABLED = "isPseudoDelEnabled";
    public static final String PROPERTY_IS_REFRESH_COMMAND_AVAILABLE = "isRefreshCommandAvailable";
    public static final String PROPERTY_IS_TEMPLATE_BEING_USED = "isTemplateBeingUsed";
    public static final String PROPERTY_IS_ALL_RECDS_LOADED = "isAllRecdsLoaded";
    public static final String PROPERTY_IS_DB2_EDIT_SESSION = "isDB2EditSession";
    public static final String PROPERTY_ACTIONS_ENABLED = "actionsEnabled";
    public static final String PROPERTY_IS_TEXT_SELECTED_IN_EDITOR = "isTextSelectedInEditor";
    public static final String PROPERTY_IS_CHAR_MODE_PAGE = "isCharModePage";
    public static final String PROPERTY_IS_VALID_FOR_REC_LEN = "isValidFMModeForRecLen";
    public static final String PROPERTY_IS_ADVANCED_TABLE_MODE_PAGE = "isAdvancedModePage";
    public static final String PROPERTY_SEGMENTED = "isSegmented";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean status = false;
        if (PROPERTY_IS_EDIT_MODE.equals(property)) {
            status = EditorPropertyTester.isEditSession();
        } else if (PROPERTY_IS_INPLACE_EDIT.equals(property)) {
            status = EditorPropertyTester.isInplaceEdit();
        } else if (PROPERTY_IS_PSEUDODEL_ENABLED.equals(property)) {
            status = EditorPropertyTester.isPseudoDelEnabled();
        } else if (PROPERTY_IS_REFRESH_COMMAND_AVAILABLE.equals(property)) {
            status = EditorPropertyTester.isRefreshCommandAvailable();
        } else if (PROPERTY_IS_TEMPLATE_BEING_USED.equals(property)) {
            status = EditorPropertyTester.isTemplateBeingUsed();
        } else if (PROPERTY_IS_ALL_RECDS_LOADED.equals(property)) {
            status = EditorPropertyTester.isAllRecdsLoaded();
        } else if (PROPERTY_IS_DB2_EDIT_SESSION.equals(property)) {
            status = EditorPropertyTester.isDB2EditSession();
        } else if (PROPERTY_ACTIONS_ENABLED.equals(property)) {
            status = EditorPropertyTester.isAllActionsEnabled();
        } else if (PROPERTY_IS_TEXT_SELECTED_IN_EDITOR.equals(property)) {
            status = EditorPropertyTester.isTextSelectedInEditor();
        } else if (PROPERTY_IS_CHAR_MODE_PAGE.equals(property)) {
            status = EditorPropertyTester.isCharModePage();
        } else if (PROPERTY_IS_VALID_FOR_REC_LEN.equals(property)) {
            status = EditorPropertyTester.isValidFMModeForRecLen();
        } else if (PROPERTY_IS_ADVANCED_TABLE_MODE_PAGE.equals(property)) {
            status = EditorPropertyTester.isAdvancedModePage();
        } else if (PROPERTY_SEGMENTED.equals(property)) {
            status = EditorPropertyTester.isSegmented();
        } else {
            logger.trace((Object)("Can't test for property=" + property));
        }
        return status;
    }

    private static boolean isAllActionsEnabled() {
        FormattedEditor editor = EditorPropertyTester.getEditor();
        boolean status = false;
        if (editor != null) {
            boolean bl = status = !editor.isAllActionsDisabled();
            if (editor.getCurrentPage() instanceof AdvancedModePage) {
                status = false;
            }
        }
        return status;
    }

    private static boolean isDB2EditSession() {
        FormattedEditor editor = EditorPropertyTester.getEditor();
        boolean status = false;
        if (editor != null) {
            status = editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2;
        }
        return status;
    }

    private static boolean isAllRecdsLoaded() {
        FormattedEditor editor = EditorPropertyTester.getEditor();
        boolean status = false;
        if (editor != null) {
            status = editor.getSessionProperties().isAllRecdsLoaded();
        }
        return status;
    }

    private static boolean isTemplateBeingUsed() {
        FormattedEditor editor = EditorPropertyTester.getEditor();
        boolean status = false;
        if (editor != null) {
            status = editor.getTemplateResource() != null;
        }
        return status;
    }

    private static boolean isRefreshCommandAvailable() {
        FormattedEditor editor = EditorPropertyTester.getEditor();
        boolean status = false;
        if (editor != null) {
            status = editor.getSessionProperties().isRefreshCommandAvailable();
        }
        return status;
    }

    private static boolean isPseudoDelEnabled() {
        FormattedEditor editor = EditorPropertyTester.getEditor();
        boolean status = false;
        if (editor != null) {
            status = editor.getSessionProperties().isPseudoDelEnabled();
        }
        return status;
    }

    private static boolean isInplaceEdit() {
        FormattedEditor editor = EditorPropertyTester.getEditor();
        boolean status = false;
        if (editor != null) {
            status = editor.getSessionProperties().isInplaceEdit();
        }
        return status;
    }

    private static boolean isEditSession() {
        FormattedEditor editor = EditorPropertyTester.getEditor();
        boolean status = false;
        if (editor != null) {
            status = editor.isEditSession();
        }
        return status;
    }

    private static boolean isTextSelectedInEditor() {
        FormattedEditor editor = EditorPropertyTester.getEditor();
        return editor != null && !editor.getSelectedText().trim().isEmpty();
    }

    private static FormattedEditor getEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow activeWindow;
        FormattedEditor editor = null;
        IEditorPart editorPart = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWindow = workbench.getActiveWorkbenchWindow()) != null && (page = activeWindow.getActivePage()) != null && (editorPart = page.getActiveEditor()) instanceof FormattedEditor) {
            editor = (FormattedEditor)editorPart;
        }
        return editor;
    }

    private static boolean isCharModePage() {
        FormattedEditor editor = EditorPropertyTester.getEditor();
        boolean status = false;
        if (editor != null) {
            status = editor.getCurrentPage() instanceof CharModePage;
        }
        return status;
    }

    private static boolean isValidFMModeForRecLen() {
        FormattedEditor editor = EditorPropertyTester.getEditor();
        boolean status = false;
        if (editor != null && editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.BASE) {
            status = true;
        }
        return status;
    }

    private static boolean isAdvancedModePage() {
        FormattedEditor editor = EditorPropertyTester.getEditor();
        boolean status = false;
        if (editor != null) {
            status = editor.getCurrentPage() instanceof AdvancedModePage;
        }
        return status;
    }

    private static boolean isSegmented() {
        FormattedEditor editor = EditorPropertyTester.getEditor();
        boolean status = false;
        if (editor != null) {
            status = editor.getCurrentEditorMode() == IFMEditor.EditorMode.FORMATTED ? true : editor.isSegmented();
        }
        return status;
    }
}

