/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.dialogs.FieldInformation;
import com.ibm.etools.fm.editor.template.TemplateEditor;
import com.ibm.etools.fm.editor.template2.TemplateEditor2;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;

public class ColumnSelectAssistProposalProvider
extends SimpleContentProposalProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private FormattedEditor editor;

    public ColumnSelectAssistProposalProvider(FormattedEditor editor) {
        super(ColumnSelectAssistProposalProvider.getSymbols(editor));
        this.editor = editor;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList<SymbolContentProposal> list = new ArrayList<SymbolContentProposal>();
        String prefix = ColumnSelectAssistProposalProvider.getPrefix(contents, position);
        ArrayList<FieldInformation> fields = FormattedEditorUtility.getCurrentFieldInformation(this.editor);
        int i = 0;
        while (i < fields.size()) {
            String refName = ColumnSelectAssistProposalProvider.info2Display(this.editor, fields.get(i), i);
            if (refName.startsWith(prefix)) {
                list.add(new SymbolContentProposal(this.editor, fields.get(i), i, position, prefix));
            }
            ++i;
        }
        IContentProposal[] proposals = new SymbolContentProposal[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            proposals[i2] = (SymbolContentProposal)list.get(i2);
            ++i2;
        }
        return proposals;
    }

    private static String getPrefix(String contents, int position) {
        Object prefix = "";
        int i = position;
        while (i != 0) {
            char c = contents.charAt(i - 1);
            if (c == ' ') {
                return prefix;
            }
            prefix = c + (String)prefix;
            --i;
        }
        return prefix;
    }

    private static String[] getSymbols(FormattedEditor editor) {
        ArrayList<FieldInformation> fields = FormattedEditorUtility.getCurrentFieldInformation(editor);
        String[] symbols = new String[fields.size()];
        int i = 0;
        while (i < fields.size()) {
            FieldInformation aField = fields.get(i);
            symbols[i] = ColumnSelectAssistProposalProvider.info2Display(editor, aField, i);
            ++i;
        }
        return symbols;
    }

    private static String info2InsertValue(FormattedEditor editor, FieldInformation aField, int index) {
        if (aField.getName().indexOf(40) != -1) {
            String arrayLoc = aField.getName().substring(aField.getName().indexOf(40));
            return TemplateEditor.getFieldReferenceNumberForDisplay(editor.getActiveLayout(), aField.getSymbol(), true) + arrayLoc + ":";
        }
        if (editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            return TemplateEditor2.getFieldReferenceNumberForDisplay(editor.getActiveLayout(), aField.getSymbol()) + ":";
        }
        return TemplateEditor.getFieldReferenceNumberForDisplay(editor.getActiveLayout(), aField.getSymbol(), true) + ":";
    }

    private static String info2Display(FormattedEditor editor, FieldInformation aField, int index) {
        if (editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            return TemplateEditor2.getFieldReferenceNumberForDisplay(editor.getActiveLayout(), aField.getSymbol()) + ": " + aField.getName();
        }
        return TemplateEditor.getFieldReferenceNumberForDisplay(editor.getActiveLayout(), aField.getSymbol(), true) + ": " + aField.getName();
    }

    private static class SymbolContentProposal
    implements IContentProposal {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private FormattedEditor editor;
        private FieldInformation aFieldInfo;
        private int index = 0;
        private int cursorPosition = 0;
        private int selectedItemLength = 0;
        private String prefix = "";

        public SymbolContentProposal(FormattedEditor editor, FieldInformation aFieldInfo, int index, int cursorPosition, String prefix) {
            this.editor = editor;
            this.aFieldInfo = aFieldInfo;
            this.index = index;
            this.cursorPosition = cursorPosition;
            this.prefix = prefix;
        }

        public String getContent() {
            String value = ColumnSelectAssistProposalProvider.info2InsertValue(this.editor, this.aFieldInfo, this.index);
            value = value.substring(this.prefix.length());
            this.selectedItemLength = value.length();
            return value;
        }

        public int getCursorPosition() {
            return this.cursorPosition + this.selectedItemLength;
        }

        public String getDescription() {
            StringBuffer sb = new StringBuffer();
            sb.append(MessageFormat.format(Messages.LayoutAssistProposalProvider_FIELD_COLUMN, this.aFieldInfo.getSymbol().getName(this.editor.getSystem())) + "\n");
            if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.BASE) {
                sb.append(MessageFormat.format(Messages.LayoutAssistProposalProvider_TYPE_COLUMN, this.aFieldInfo.getSymbol().getType().getLiteral()) + "\n");
                sb.append(MessageFormat.format(Messages.LayoutAssistProposalProvider_REF_COLUMN, ColumnSelectAssistProposalProvider.info2Display(this.editor, this.aFieldInfo, this.index)) + "\n");
                sb.append(MessageFormat.format(Messages.LayoutAssistProposalProvider_LEVEL_COLUMN, this.aFieldInfo.getSymbol().getLvl()) + "\n");
                sb.append(MessageFormat.format(Messages.LayoutAssistProposalProvider_FIELD_COLUMN, this.aFieldInfo.getSymbol().getName(this.editor.getSystem())) + "\n");
                sb.append(MessageFormat.format(Messages.LayoutAssistProposalProvider_TYPE_COLUMN, this.aFieldInfo.getSymbol().getType().getLiteral()) + "\n");
                sb.append(MessageFormat.format(Messages.LayoutAssistProposalProvider_START_COLUMN, this.aFieldInfo.getSymbol().getStart()) + "\n");
                sb.append(MessageFormat.format(Messages.LayoutAssistProposalProvider_LEN_COLUMN, this.aFieldInfo.getSymbol().getLength()) + "\n");
            } else if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
                sb.append(MessageFormat.format(Messages.LayoutAssistProposalProvider_TYPE_COLUMN, this.aFieldInfo.getSymbol().getDb2typ()) + "\n");
            }
            return sb.toString();
        }

        public String getLabel() {
            return ColumnSelectAssistProposalProvider.info2Display(this.editor, this.aFieldInfo, this.index);
        }
    }
}

