/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DummyDataSet;
import com.ibm.etools.fm.core.model.DummyMember;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.model.db2.Db2TemplateOptions;
import com.ibm.etools.fm.editor.formatted.FMEditorInputWithTemplate;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.handler.NewTemplate;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.editor.template2.TemplateEditorUtilities2;
import com.ibm.etools.fm.model.formatted.EditType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.ResourceLookupDialog;
import com.ibm.etools.fm.ui.util.RemoteServicesUI;
import com.ibm.etools.fm.ui.widget.ResourceContentProposals;
import com.ibm.etools.fm.ui.widget.SystemSelectionCombo;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BottomNavigationBar {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final long POPUP_ENTER_FILTER_TIME = 250L;
    protected static final PDLogger logger = PDLogger.get(BottomNavigationBar.class);

    public static void createBottomNavigationComposite(Composite parent, FormattedEditor editor) {
        Objects.requireNonNull(parent, "Must specify a non-null parent.");
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false, (int)0), (Object)GUI.grid.d.fillAll());
        BottomNavigationBar.createLayoutCombo(composite, editor);
        BottomNavigationBar.createTemplateComposite(composite, editor);
    }

    private static void createTemplateComposite(Composite parent, final FormattedEditor editor) {
        Composite templateComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)7, (boolean)false, (int)0), (Object)GUI.grid.d.fillH((int)1, (int)150));
        final ComboViewer templateSystemComboViewer = SystemSelectionCombo.createSystemLabelAndComboViewer(templateComposite, new HashSet<IPDHost>(RegistryLocator.instance().getHostRegistry().all()), editor.getTemplateResource() != null ? editor.getTemplateResource().getSystem() : editor.getSystem());
        GUI.label.left((Composite)templateComposite, (String)Messages.Template, (Object)GUI.grid.d.left1());
        final ComboViewer templateComboViewer = new ComboViewer(GUI.combo.editable((Composite)templateComposite, (Object)GUI.grid.d.fillH((int)1, (int)50)));
        templateSystemComboViewer.getCombo().setToolTipText(Messages.BottomNavigationBar_SystemToolTip);
        templateSystemComboViewer.getCombo().setEnabled(true);
        String remoteTemplateName = "";
        IZRL aTemplate = editor.getTemplateResource();
        if (aTemplate != null) {
            remoteTemplateName = aTemplate.getFormattedName();
        }
        final IHostProvider selectedHost = new IHostProvider(){

            public IPDHost getSystem() {
                IStructuredSelection selection = (IStructuredSelection)templateSystemComboViewer.getSelection();
                IPDHost selectedSystem = selection == null || selection.isEmpty() ? editor.getResource().getSystem() : (IPDHost)selection.getFirstElement();
                return selectedSystem;
            }
        };
        ResourceContentProposals templateComboRcp = ResourceContentProposals.addTo(templateComboViewer.getCombo(), selectedHost, BottomNavigationBar.class.getName() + "Resource", FMHost.getPermittedTemplateResourceType((IPDHost)selectedHost.getSystem()));
        final AtomicLong lastTemplatePopupCloseTime = new AtomicLong();
        templateComboRcp.getAdapter().addContentProposalListener(new IContentProposalListener2(){

            public void proposalPopupOpened(ContentProposalAdapter adapter) {
            }

            public void proposalPopupClosed(ContentProposalAdapter adapter) {
                lastTemplatePopupCloseTime.set(System.currentTimeMillis());
            }
        });
        List prevValues = FMHost.getSystem((IPDHost)editor.getResource().getSystem()).getTemplateAssociations(editor.getResource());
        if (prevValues.size() > 0) {
            ComboValueSaver.getInstance((Combo)templateComboViewer.getCombo()).setCustomItems(prevValues.toArray(new String[0]), false, false);
        }
        templateComboViewer.getCombo().setText(remoteTemplateName);
        Button lookupButton = GUI.button.push((Composite)templateComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/search.gif"), (String)Messages.BottomNavigationBar_LOOKUP_TIP, (Object)GUI.grid.d.left1());
        final Button editTemplateButton = GUI.button.push((Composite)templateComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/templateEditor.gif"), (String)Messages.BottomNavigationBar_EDIT_TMPL_TIP, (Object)GUI.grid.d.left1());
        final Button applyTemplateButton = GUI.button.push((Composite)templateComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/applyTemplate.gif"), (String)Messages.BottomNavigationBar_APPLY_TEMPLATE_TIP, (Object)GUI.grid.d.left1());
        lookupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceLookupDialog dialog = new ResourceLookupDialog(selectedHost.getSystem(), true, FMHost.getPermittedTemplateResourceType((IPDHost)selectedHost.getSystem()));
                String initValue = templateComboViewer.getCombo().getText();
                if (BottomNavigationBar.isDummyTemplate(editor, templateComboViewer.getCombo().getText())) {
                    initValue = "";
                }
                dialog.setInitialFilter(initValue);
                if (dialog.open() == 0) {
                    if (dialog.getSelectedResource() instanceof DataSetOrMember) {
                        editor.getEditorInput().setTemplateResource((DataSetOrMember)dialog.getSelectedResource());
                    }
                    BottomNavigationBar.setTemplateAssociation(editor, dialog.getSelectedSystem(), templateComboViewer, editTemplateButton, applyTemplateButton, false);
                }
            }
        });
        applyTemplateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BottomNavigationBar.setTemplateAssociation(editor, selectedHost.getSystem(), templateComboViewer, editTemplateButton, applyTemplateButton, true);
            }
        });
        editTemplateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BottomNavigationBar.editSelectedTemplate(editor, selectedHost.getSystem(), templateComboViewer.getCombo().getText().toUpperCase());
                BottomNavigationBar.validateTemplate(editor, templateComboViewer.getCombo(), editTemplateButton, applyTemplateButton);
            }
        });
        KeyAdapter templateComboKeyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                BottomNavigationBar.validateTemplate(editor, templateComboViewer.getCombo(), editTemplateButton, applyTemplateButton);
                if ((e.character == '\r' || e.character == '\n') && System.currentTimeMillis() > lastTemplatePopupCloseTime.get() + 250L) {
                    if (editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2 && DummyDataSet.isDummyDataSetOrMember((IZRL)editor.getSessionIdentifier().getDb2EditOptions().getTemplate()) && templateComboViewer.getCombo().getText().trim().isEmpty()) {
                        return;
                    }
                    BottomNavigationBar.setTemplateAssociation(editor, selectedHost.getSystem(), templateComboViewer, editTemplateButton, applyTemplateButton, false);
                }
            }
        };
        templateComboViewer.getCombo().addKeyListener((KeyListener)templateComboKeyAdapter);
        templateComboViewer.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BottomNavigationBar.validateTemplate(editor, templateComboViewer.getCombo(), editTemplateButton, applyTemplateButton);
            }
        });
        BottomNavigationBar.validateTemplate(editor, templateComboViewer.getCombo(), editTemplateButton, applyTemplateButton);
    }

    private static void setTemplateAssociation(FormattedEditor editor, IPDHost templateSystem, ComboViewer templateComboViewer, Button editTemplateButton, Button applyTemplateButton, boolean applyFromEditor) {
        if (RemoteServicesUI.validateRemoteSystem(editor.getSystem(), templateSystem)) {
            String templateName = templateComboViewer.getCombo().getText().toUpperCase();
            IZRL aNewTemplate = BottomNavigationBar.validateTemplateName(templateSystem, templateName, editor);
            if (editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.BASE && editor.getSessionIdentifier().getBaseEditOptions() != null && editor.getSessionIdentifier().getBaseEditOptions().getRunTempKey() != null) {
                aNewTemplate = BottomNavigationBar.verifyTemplateChange(editor, aNewTemplate);
                if (editor.getSessionIdentifier().getBaseEditOptions().getRunTempKey() != null) {
                    TemplateEditorUtilities.openTemplateEditSession(aNewTemplate, editor, editor.getSessionIdentifier().getBaseEditOptions().getDynamicTemplateFlag(), editor.getSessionIdentifier().getBaseEditOptions().getRunTempKey());
                    return;
                }
            }
            if (!BottomNavigationBar.newTemplateAssociation(editor, templateSystem, templateName)) {
                if (editor.getTemplateResource() != null) {
                    templateComboViewer.getCombo().setText(editor.getTemplateResource().getFormattedName());
                } else {
                    templateComboViewer.getCombo().setText("");
                }
                BottomNavigationBar.validateTemplate(editor, templateComboViewer.getCombo(), editTemplateButton, applyTemplateButton);
            }
        } else {
            PDDialogs.openErrorThreadSafe((String)Messages.BottomNavigationBar_InvalidTemplateOrSystem);
        }
        if (applyFromEditor && editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            editor.getSessionIdentifier().getDb2EditOptions().setGenRep(false);
        }
    }

    private static void validateTemplate(FormattedEditor editor, Combo templateCombo, Button editTemplateButton, Button applyTemplateButton) {
        String value = templateCombo.getText().trim();
        if (ZRLs.isParseable((IPDHost)editor.getResource().getSystem(), (String)value)) {
            editTemplateButton.setEnabled(true);
            applyTemplateButton.setEnabled(true);
        } else {
            editTemplateButton.setEnabled(false);
            applyTemplateButton.setEnabled(false);
        }
    }

    private static boolean isDummyTemplate(FormattedEditor editor, String templateName) {
        return editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2 && "FM Generated Template".equalsIgnoreCase(templateName);
    }

    private static boolean newTemplateAssociation(FormattedEditor editor, IPDHost userEnteredTemplateSystem, String userEnteredTemplateName) {
        if (BottomNavigationBar.isDummyTemplate(editor, userEnteredTemplateName)) {
            return false;
        }
        if (!ZRLs.isParseable((IPDHost)userEnteredTemplateSystem, (String)userEnteredTemplateName)) {
            return false;
        }
        try {
            IZRL aNewTemplate = null;
            if (userEnteredTemplateName != null && userEnteredTemplateName.length() > 0) {
                aNewTemplate = ZRLs.parseZRL((IPDHost)userEnteredTemplateSystem, (String)userEnteredTemplateName);
            }
            return BottomNavigationBar.newTemplateAssociation(editor, aNewTemplate);
        }
        catch (IllegalArgumentException e) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FmiFormattedEditorToolbar_TEMPLATE_ASSOC_ERR_MSG, userEnteredTemplateName));
            return false;
        }
    }

    public static boolean newTemplateAssociation(FormattedEditor editor, IZRL userEnteredTemplate) {
        if (editor.getTemplateResource() == null && userEnteredTemplate == null) {
            return false;
        }
        if (editor.isDirty() && !PDDialogs.openQuestion((String)Messages.BottomNavigationBar_TEMPL_SWITCH)) {
            return false;
        }
        IZRL validatedTemplate = null;
        if (userEnteredTemplate != null && (validatedTemplate = BottomNavigationBar.validateTemplateName(userEnteredTemplate.getSystem(), userEnteredTemplate.getFormattedName(), editor)) == null) {
            return false;
        }
        if (validatedTemplate != null) {
            FMEditorInputWithTemplate fmEditorInput = editor.getEditorInput();
            IZRL aNewTemplate = null;
            aNewTemplate = fmEditorInput.getResource() instanceof Db2Table ? BottomNavigationBar.verifyTemplateChangeForDB2(editor, validatedTemplate) : BottomNavigationBar.verifyTemplateChange(editor, validatedTemplate);
            if (!aNewTemplate.getFormattedName().equals(validatedTemplate.getFormattedName())) {
                TemplateEditorUtilities.openTemplateEditSession(aNewTemplate, editor, editor.getSessionIdentifier().getBaseEditOptions().getDynamicTemplateFlag(), editor.getSessionIdentifier().getBaseEditOptions().getRunTempKey());
                return false;
            }
            FMHost.getSystem((IPDHost)editor.getResource().getSystem()).addTemplateAssociation(editor.getResource(), validatedTemplate);
        } else {
            FMHost.getSystem((IPDHost)editor.getResource().getSystem()).setCurrentTemplateAssociationToNoTemplate(editor.getResource());
        }
        if (userEnteredTemplate == null && editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            validatedTemplate = DummyMember.createDummyMember((IPDHost)editor.getResource().getSystem());
        }
        NewTemplate newTemplateHandler = editor.getSessionIdentifier().getBaseEditOptions() != null && editor.getSessionIdentifier().getBaseEditOptions().getRunTempKey() != null ? new NewTemplate(validatedTemplate, editor.getTemplateResource(), editor.getSessionIdentifier().getBaseEditOptions().getRunTempKey()) : new NewTemplate(validatedTemplate, editor.getTemplateResource());
        newTemplateHandler.run(editor);
        return true;
    }

    protected static void createLayoutCombo(Composite parent, final FormattedEditor editor) {
        if (editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            return;
        }
        Composite layoutComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false, (int)0), (Object)GUI.grid.d.fillH((int)1, (int)100));
        GUI.label.left((Composite)layoutComposite, (String)Messages.TopNavigationBar_LAYOUT, (Object)GUI.grid.d.left1());
        final Combo layoutCombo = GUI.combo.readOnly((Composite)layoutComposite, (Object)GUI.grid.d.fillH((int)1, (int)50), (Object[])new String[0]);
        EditType input = editor.getActiveModel();
        if (input != null && input.getAssocitedTemplate() != null) {
            EList layouts = input.getAssocitedTemplate().getLayout();
            int i = 0;
            while (i < layouts.size()) {
                Layouttype l2 = (Layouttype)layouts.get(i);
                layoutCombo.add(((Symboltype)l2.getSymbol().get(0)).getName(editor.getSystem()));
                layoutCombo.setData("" + i, (Object)l2.getId());
                ++i;
            }
            layoutCombo.setData((Object)layouts);
            layoutCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!editor.updateDirtyContents()) {
                        return;
                    }
                    String layout = layoutCombo.getText();
                    if (editor.getActiveLayoutID() == Integer.parseInt(layoutCombo.getData("" + layoutCombo.getSelectionIndex()).toString())) {
                        return;
                    }
                    editor.setActiveLayout(Integer.parseInt(layoutCombo.getData("" + layoutCombo.getSelectionIndex()).toString()), layout);
                }
            });
            if (editor.getActiveLayoutID() == -1) {
                layoutCombo.select(0);
            } else {
                i = 0;
                while (i < layoutCombo.getItemCount()) {
                    if (Integer.parseInt(layoutCombo.getData("" + i).toString()) == editor.getActiveLayoutID()) {
                        layoutCombo.select(i);
                    }
                    ++i;
                }
            }
        }
        if (editor.getTemplateResource() == null) {
            layoutCombo.setEnabled(false);
        }
    }

    private static void editSelectedTemplate(FormattedEditor editor, IPDHost templateSystem, String templateName) {
        if (templateName.isEmpty()) {
            PDDialogs.openInfoThreadSafe((String)Messages.BottomNavigationBar_NO_TEMPLATE);
            return;
        }
        if (BottomNavigationBar.isDummyTemplate(editor, templateName)) {
            PDDialogs.openInfoThreadSafe((String)Messages.BottomNavigationBar_DUMMY_TEMPLATE_EDIT_ERROR);
            return;
        }
        IZRL aNewTemplate = BottomNavigationBar.validateTemplateName(templateSystem, templateName, editor);
        if (aNewTemplate == null) {
            return;
        }
        if (FMUIPlugin.getDefault().templateEditSessionExist(aNewTemplate)) {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.OpenAsTemplate_DUP_SESSION, aNewTemplate.getFormattedName()));
            return;
        }
        if (editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.BASE) {
            if (editor.getSessionIdentifier().getBaseEditOptions() != null && editor.getSessionIdentifier().getBaseEditOptions().getRunTempKey() != null) {
                aNewTemplate = BottomNavigationBar.verifyTemplateChange(editor, aNewTemplate);
                TemplateEditorUtilities.openTemplateEditSession(aNewTemplate, editor, editor.getSessionIdentifier().getBaseEditOptions().getDynamicTemplateFlag(), editor.getSessionIdentifier().getBaseEditOptions().getRunTempKey());
            } else {
                TemplateEditorUtilities.openTemplateEditSession(aNewTemplate, editor);
            }
        } else {
            Db2TemplateOptions db2TempOpts = new Db2TemplateOptions();
            db2TempOpts.setTable(editor.getSessionIdentifier().getDb2EditOptions().getTable());
            db2TempOpts.setTemplate(aNewTemplate);
            TemplateEditorUtilities2.openTemplateEditSession(db2TempOpts);
        }
    }

    private static IZRL validateTemplateName(IPDHost templateSystem, String templateName, FormattedEditor editor) {
        if (templateName.isEmpty() || !ZRLs.isParseable((IPDHost)editor.getResource().getSystem(), (String)templateName)) {
            PDDialogs.openInfoThreadSafe((String)Messages.BottomNavigationBar_NO_TEMPLATE);
            return null;
        }
        if (editor.getTemplateResource() != null && editor.getTemplateResource().getFormattedName().equalsIgnoreCase(templateName)) {
            return editor.getTemplateResource();
        }
        try {
            IZRL aNewTemplate;
            String result;
            if (!ZRLs.isParseable((IPDHost)editor.getResource().getSystem(), (String)templateName)) {
                PDDialogs.openInfoThreadSafe((String)Messages.BottomNavigationBar_NO_TEMPLATE);
            }
            if ((result = TemplateEditorUtilities.okAsTemplate(aNewTemplate = ZRLs.parseZRL((IPDHost)templateSystem, (String)templateName), true, null)) == null) {
                return aNewTemplate;
            }
            PDDialogs.openInfoThreadSafe((String)result);
            return null;
        }
        catch (InvocationTargetException e) {
            String errMsg = MessageFormat.format("Exception thrown while checking the status of specified template: {0}. See log for further information.", templateName);
            logger.error((Object)errMsg, (Throwable)e);
            PDDialogs.openInfoThreadSafe((String)errMsg);
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private static IZRL verifyTemplateChange(FormattedEditor editor, IZRL aNewTemplate) {
        IZRL aTemplate = aNewTemplate;
        if (editor.getSessionIdentifier().getBaseEditOptions().getaTemplate() != null && !aNewTemplate.getFormattedName().equals(editor.getSessionIdentifier().getBaseEditOptions().getaTemplate().getFormattedName()) && (editor.getSessionIdentifier().getBaseEditOptions().getDynamicTemplateFlag() || editor.getSessionIdentifier().getBaseEditOptions().getRunTempKey() != null)) {
            boolean confirm = PDDialogs.openConfirmThreadSafe((String)Messages.Confirm, (String)Messages.TemplateEditor_RunTempSaveConfirm);
            if (!confirm) {
                editor.removeDynamic(aNewTemplate);
            } else {
                aTemplate = editor.getSessionIdentifier().getBaseEditOptions().getaTemplate();
            }
        }
        return aTemplate;
    }

    private static IZRL verifyTemplateChangeForDB2(FormattedEditor editor, IZRL aNewTemplate) {
        IZRL aTemplate = aNewTemplate;
        if (editor.getSessionIdentifier().getDb2EditOptions().getTemplate() != null && !aNewTemplate.getFormattedName().equals(editor.getSessionIdentifier().getDb2EditOptions().getTemplate().getFormattedName()) && (editor.getSessionIdentifier().getBaseEditOptions().getDynamicTemplateFlag() || editor.getSessionIdentifier().getBaseEditOptions().getRunTempKey() != null)) {
            boolean confirm = PDDialogs.openConfirmThreadSafe((String)Messages.Confirm, (String)Messages.TemplateEditor_RunTempSaveConfirm);
            if (!confirm) {
                editor.removeDynamic(aNewTemplate);
            } else {
                aTemplate = editor.getSessionIdentifier().getBaseEditOptions().getaTemplate();
            }
        }
        return aTemplate;
    }
}

