/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class BaseEditorOptionsPropertySource
implements IPropertySource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(BaseEditorOptionsPropertySource.class);
    private BaseEditorOptions model;
    private IPropertyDescriptor[] propertyDescriptors;
    private String resource = "resource";
    private String template = "template";
    private String encoding = "encoding";
    private String dbcsEncoding = "dbcsEncoding";
    private String bidiFormat = "bidiFormat";
    private String volumeSerialValue = "volumeSerialValue";
    private String templateProcessingOptionType = "templateProcessingOptionType";
    private String startPositionType = "startPositionType";
    private String startPositionValue = "startPositionValue";
    private String binaryReclenValue = "binaryReclenValue";
    private String processingOptionValue = "processingOptionValue";
    private String inplaceEditValue = "inplaceEditValue";
    private String recordSamplingValue = "recordSampling";
    private String includeOnlySelectedValue = "includeOnlySelectedValue";
    private String includePhysicalRecordValue = "includePhysicalRecordValue";
    private String skipPhysicalRecordValue = "skipPhysicalRecordValue";
    private String recordLimitValue = "recordLimitValue";
    private String editView = "editView";
    private String ioExitValue = "ioExitValue";

    public BaseEditorOptionsPropertySource(BaseEditorOptions model) {
        this.model = model;
        this.init();
    }

    public void setModel(BaseEditorOptions model) {
        this.model = model;
    }

    private void init() {
        ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
        temp.add(new PropertyDescriptor((Object)this.resource, Messages.EditorOptionDialog_DSNPATH));
        temp.add(new PropertyDescriptor((Object)this.template, Messages.OpenAsFormattedEditorActionItem_TEMPLATE));
        temp.add(new PropertyDescriptor((Object)this.encoding, Messages.EditorOptionDialog_ENCODING));
        temp.add(new PropertyDescriptor((Object)this.dbcsEncoding, Messages.BaseEditorOptionsPropertySource_DBCS_ENCODING));
        temp.add(new PropertyDescriptor((Object)this.bidiFormat, Messages.BaseEditorOptionsPropertySource_BIDI_FORMAT));
        temp.add(new PropertyDescriptor((Object)this.volumeSerialValue, Messages.EditorOptionDialog_VOLUME_SERIAL));
        temp.add(new PropertyDescriptor((Object)this.templateProcessingOptionType, Messages.OpenAsFormattedEditorActionItem_TEMPLATE_PROCESSING_OPTION));
        temp.add(new PropertyDescriptor((Object)this.startPositionType, Messages.EditorOptionDialog_START_POS_TYPE));
        temp.add(new PropertyDescriptor((Object)this.startPositionValue, Messages.EditorOptionDialog_START_POS));
        temp.add(new PropertyDescriptor((Object)this.binaryReclenValue, Messages.EditorOptionDialog_RECLEN));
        temp.add(new PropertyDescriptor((Object)this.processingOptionValue, Messages.OpenAsFormattedEditorActionItem_PROCESSING_OPTION_VALUE));
        temp.add(new PropertyDescriptor((Object)this.inplaceEditValue, Messages.EditorOptionDialog_INPLACE_EDIT));
        temp.add(new PropertyDescriptor((Object)this.recordSamplingValue, Messages.EditorOptionDialog_REC_SAMP));
        temp.add(new PropertyDescriptor((Object)this.includeOnlySelectedValue, Messages.EditorOptionDialog_ONLY_SEL));
        temp.add(new PropertyDescriptor((Object)this.includePhysicalRecordValue, Messages.EditorOptionDialog_INC_PHY_REC));
        temp.add(new PropertyDescriptor((Object)this.skipPhysicalRecordValue, Messages.EditorOptionDialog_SKIP_PHY_REC));
        temp.add(new PropertyDescriptor((Object)this.recordLimitValue, Messages.EditorOptionDialog_REC_LIMIT));
        temp.add(new PropertyDescriptor((Object)this.editView, Messages.OpenAsFormattedEditorActionItem_EDIT_OR_VIEW));
        temp.add(new PropertyDescriptor((Object)this.ioExitValue, Messages.BaseEditorOptionsPropertySource_0));
        this.propertyDescriptors = (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public Object getPropertyValue(Object arg) {
        if (arg instanceof String) {
            String id = (String)arg;
            if (id.equals(this.resource)) {
                return this.model.getaResource().getFormattedName();
            }
            if (id.equals(this.template)) {
                if (this.model.getaTemplate() == null) {
                    return "";
                }
                return this.model.getaTemplate().getFormattedName();
            }
            if (id.equals(this.encoding)) {
                return this.model.getEncodingForSession();
            }
            if (id.equals(this.volumeSerialValue)) {
                return this.model.getaVolumeSerial();
            }
            if (id.equals(this.templateProcessingOptionType)) {
                return this.model.getTemplateProcessingType();
            }
            if (id.equals(this.startPositionType)) {
                return this.model.getStartType();
            }
            if (id.equals(this.startPositionValue)) {
                return this.model.getaStartPosition();
            }
            if (id.equals(this.binaryReclenValue)) {
                return this.model.getBinaryLength();
            }
            if (id.equals(this.inplaceEditValue)) {
                return this.model.isInplaceEdit();
            }
            if (id.equals(this.recordSamplingValue)) {
                return this.model.isRecordSampling();
            }
            if (!id.equals(this.processingOptionValue)) {
                if (id.equals(this.includeOnlySelectedValue)) {
                    return this.model.isOnlySelectedRecs();
                }
                if (id.equals(this.includePhysicalRecordValue)) {
                    if (!this.model.isRecordSampling()) {
                        return "";
                    }
                    return this.model.getIncludePhysicalRecords();
                }
                if (id.equals(this.skipPhysicalRecordValue)) {
                    if (!this.model.isRecordSampling()) {
                        return "";
                    }
                    return this.model.getSkipPhysicalRecords();
                }
                if (id.equals(this.recordLimitValue)) {
                    return this.model.getRecordLimit();
                }
                if (id.equals(this.editView)) {
                    return this.model.isEditSession() ? Messages.OpenAsFormattedEditorActionItem_EDIT_TYPE : Messages.OpenAsFormattedEditorActionItem_VIEW_TYPE;
                }
                if (id.equals(this.ioExitValue)) {
                    return this.model.getIoExitName() == null ? "" : this.model.getIoExitName();
                }
                if (id.equals(this.dbcsEncoding)) {
                    return this.model.getDbcsEncodingForSession();
                }
                if (id.equals(this.bidiFormat)) {
                    return this.model.getBidiFormat();
                }
                if (PDLoggerJhost.isTraceEnabled()) {
                    logger.trace((Object)MessageFormat.format("WARNING: Unhanded property id: {0} See {1}", id, this.getClass().getCanonicalName()));
                }
            }
        }
        return null;
    }

    public Object getEditableValue() {
        return null;
    }

    public boolean isPropertySet(Object arg0) {
        return false;
    }

    public void resetPropertyValue(Object arg0) {
    }

    public void setPropertyValue(Object arg0, Object arg1) {
    }
}

