/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.ui.dialog.Export2DesktopData;
import java.util.ArrayList;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class BaseEditorOptionsForExportPropertySource
implements IPropertySource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private BaseEditorOptions model;
    private Export2DesktopData exportData;
    private IPropertyDescriptor[] propertyDescriptors;
    private String resource = "resource";
    private String template = "template";
    private String encoding = "encoding";
    private String dbcsEncoding = "dbcsEncoding";
    private String volumeSerialValue = "volumeSerialValue";
    private String startPositionType = "startPositionType";
    private String startPositionValue = "startPositionValue";
    private String binaryReclenValue = "binaryReclenValue";
    private String recordSamplingValue = "recordSampling";
    private String includeOnlySelectedValue = "includeOnlySelectedValue";
    private String includePhysicalRecordValue = "includePhysicalRecordValue";
    private String skipPhysicalRecordValue = "skipPhysicalRecordValue";
    private String recordLimitValue = "recordLimitValue";
    private String outputFileNameKey = "outputFile";
    private String outputFormatKey = "outputFormat";
    private String printHeaderKey = "printHeader";
    private String ioExitKey = "ioExitValue";
    private String includeFillers = "includeFillers";
    private String includeRedefines = "includeRedefines";
    private String leadingBlanks = "leadingBlanks";
    private String trailingBlanks = "trailingBlanks";
    private String quotedValues = "quotedValues";
    private String singleQuotes = "singleQuotes";
    private String asisEncapsulation = "asisEncapsulation";

    public BaseEditorOptionsForExportPropertySource(BaseEditorOptions model, Export2DesktopData exportData) {
        this.model = model;
        this.exportData = exportData;
        this.init();
    }

    public void setModel(BaseEditorOptions model, Export2DesktopData exportData) {
        this.model = model;
        this.exportData = exportData;
    }

    private void init() {
        ArrayList<PropertyDescriptor> temp = new ArrayList<PropertyDescriptor>();
        temp.add(new PropertyDescriptor((Object)this.resource, Messages.EditorOptionDialog_DSNPATH));
        temp.add(new PropertyDescriptor((Object)this.template, Messages.OpenAsFormattedEditorActionItem_TEMPLATE));
        temp.add(new PropertyDescriptor((Object)this.encoding, Messages.EditorOptionDialog_ENCODING));
        temp.add(new PropertyDescriptor((Object)this.dbcsEncoding, Messages.EditorOptionDialog_GRAPHIC_ENCODING));
        temp.add(new PropertyDescriptor((Object)this.volumeSerialValue, Messages.EditorOptionDialog_VOLUME_SERIAL));
        temp.add(new PropertyDescriptor((Object)this.startPositionType, Messages.EditorOptionDialog_START_POS_TYPE));
        temp.add(new PropertyDescriptor((Object)this.startPositionValue, Messages.EditorOptionDialog_START_POS));
        temp.add(new PropertyDescriptor((Object)this.binaryReclenValue, Messages.EditorOptionDialog_RECLEN));
        temp.add(new PropertyDescriptor((Object)this.recordSamplingValue, Messages.EditorOptionDialog_REC_SAMP));
        temp.add(new PropertyDescriptor((Object)this.includeOnlySelectedValue, Messages.EditorOptionDialog_ONLY_SEL));
        temp.add(new PropertyDescriptor((Object)this.includePhysicalRecordValue, Messages.EditorOptionDialog_INC_PHY_REC));
        temp.add(new PropertyDescriptor((Object)this.skipPhysicalRecordValue, Messages.EditorOptionDialog_SKIP_PHY_REC));
        temp.add(new PropertyDescriptor((Object)this.recordLimitValue, Messages.EditorOptionDialog_REC_LIMIT));
        temp.add(new PropertyDescriptor((Object)this.outputFileNameKey, Messages.BaseEditorOptionsForExportPropertySource_0));
        temp.add(new PropertyDescriptor((Object)this.outputFormatKey, Messages.BaseEditorOptionsForExportPropertySource_1));
        temp.add(new PropertyDescriptor((Object)this.printHeaderKey, Messages.BaseEditorOptionsForExportPropertySource_2));
        temp.add(new PropertyDescriptor((Object)this.ioExitKey, Messages.BaseEditorOptionsForExportPropertySource_3));
        temp.add(new PropertyDescriptor((Object)this.includeFillers, Messages.ExportAbstractDialog_14));
        temp.add(new PropertyDescriptor((Object)this.includeRedefines, Messages.ExportAbstractDialog_16));
        temp.add(new PropertyDescriptor((Object)this.leadingBlanks, Messages.ExportAbstractDialog_20));
        temp.add(new PropertyDescriptor((Object)this.trailingBlanks, Messages.ExportAbstractDialog_22));
        temp.add(new PropertyDescriptor((Object)this.quotedValues, Messages.ExportAbstractDialog_26));
        temp.add(new PropertyDescriptor((Object)this.singleQuotes, Messages.ExportAbstractDialog_28));
        temp.add(new PropertyDescriptor((Object)this.asisEncapsulation, Messages.ExportAbstractDialog_18));
        this.propertyDescriptors = (IPropertyDescriptor[])temp.toArray(new PropertyDescriptor[0]);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public Object getPropertyValue(Object arg) {
        if (arg instanceof String) {
            String id = (String)arg;
            if (id.equals(this.resource)) {
                return this.model.getaResource().getFormattedName();
            }
            if (id.equals(this.template)) {
                if (this.model.getaTemplate() == null) {
                    return "";
                }
                return this.model.getaTemplate().getFormattedName();
            }
            if (id.equals(this.encoding)) {
                return this.model.getEncodingForSession();
            }
            if (id.equals(this.dbcsEncoding)) {
                return this.model.getDbcsEncodingForSession();
            }
            if (id.equals(this.volumeSerialValue)) {
                return this.model.getaVolumeSerial();
            }
            if (id.equals(this.startPositionType)) {
                return this.model.getStartType();
            }
            if (id.equals(this.startPositionValue)) {
                return this.model.getaStartPosition();
            }
            if (id.equals(this.binaryReclenValue)) {
                return this.model.getBinaryLength();
            }
            if (id.equals(this.recordSamplingValue)) {
                return this.model.isRecordSampling();
            }
            if (id.equals(this.includeOnlySelectedValue)) {
                return this.model.isOnlySelectedRecs();
            }
            if (id.equals(this.includePhysicalRecordValue)) {
                if (!this.model.isRecordSampling()) {
                    return "";
                }
                return this.model.getIncludePhysicalRecords();
            }
            if (id.equals(this.skipPhysicalRecordValue)) {
                if (!this.model.isRecordSampling()) {
                    return "";
                }
                return this.model.getSkipPhysicalRecords();
            }
            if (id.equals(this.recordLimitValue)) {
                return this.model.getRecordLimit();
            }
            if (id.equals(this.outputFileNameKey)) {
                return this.exportData.getOutputFileName();
            }
            if (id.equals(this.outputFormatKey)) {
                return this.exportData.getType().name();
            }
            if (id.equals(this.ioExitKey)) {
                return this.model.getIoExitName();
            }
            if (id.equals(this.printHeaderKey)) {
                return this.exportData.isPrintHeader();
            }
            if (id.equals(this.includeFillers)) {
                return this.exportData.isIncludeFillers();
            }
            if (id.equals(this.includeRedefines)) {
                return this.exportData.isIncludeRedefines();
            }
            if (id.equals(this.leadingBlanks)) {
                return this.exportData.isIncludeLeadingBlanks();
            }
            if (id.equals(this.trailingBlanks)) {
                return this.exportData.isIncludeTrailingBlanks();
            }
            if (id.equals(this.quotedValues)) {
                return this.exportData.isEncapsulate();
            }
            if (id.equals(this.singleQuotes)) {
                return this.exportData.isSingleQuotes();
            }
            if (id.equals(this.asisEncapsulation)) {
                return this.exportData.isAsisEncapsulation();
            }
        }
        return null;
    }

    public Object getEditableValue() {
        return null;
    }

    public boolean isPropertySet(Object arg0) {
        return false;
    }

    public void resetPropertyValue(Object arg0) {
    }

    public void setPropertyValue(Object arg0, Object arg1) {
    }
}

