/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ext.rse.integration.action;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.ext.rse.adapter.AdapterUtils;
import com.ibm.etools.fm.ext.rse.integration.subsystem.node.FMSubSystem;
import com.ibm.etools.fm.ui.views.systems.handlers.OpenFormatted;
import com.ibm.etools.fm.ui.views.systems.nodes.CicsResourceNode;
import com.ibm.etools.fm.ui.views.systems.nodes.MessageQueueNode;
import com.ibm.etools.zos.system.zOSSystem;
import com.ibm.ftt.resources.zos.filesystem.IMVSFileSystem;
import com.ibm.ftt.resources.zos.mapping.IMVSFileMappingRoot;
import com.ibm.ftt.rse.mvs.client.subsystems.MVSFileSubSystem;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.rse.ui.integration.action.PDExtensionHandler;
import com.ibm.pdtools.common.component.rse.ui.integration.action.util.PDSubSystemTreeUtil;
import com.ibm.pdtools.common.component.rse.ui.subsystem.node.PDSubSystemTree;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;

public class InvokeFormattedEditorMenuAction
extends PDExtensionHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(List<IZRL> selected) {
        if (selected.size() > 0) {
            IZRL resource = selected.get(0);
            if (selected.get(0) instanceof PDSubSystemTree) {
                PDSubSystemTree pdSubSystemTree = (PDSubSystemTree)selected.get(0);
                IHost rdzHost = pdSubSystemTree.getSubSystem().getHost();
                if (rdzHost == null) {
                    logger.error((Object)"Cannot find host information from selected resource");
                    throw new RuntimeException(Messages.RSEObjectHandler_NO_HOST);
                }
                SystemSignonInformation ssi = ((zOSSystem)rdzHost).getUserInformation();
                IPDHost host = AdapterUtils.getFMHost((IHost)rdzHost, (SystemSignonInformation)ssi, (String)InvokeFormattedEditorMenuAction.getEncoding(rdzHost));
                pdSubSystemTree.setSystem(host);
                SystemsTreeNode aNode = PDSubSystemTreeUtil.getFirstNonGrouperNode((SystemsTreeNode)pdSubSystemTree.getRseTreeNode());
                if (aNode instanceof CicsResourceNode || aNode instanceof MessageQueueNode) {
                    OpenFormatted.showFormattedEditorDialog((IPDHost)host, (IZRL)resource);
                } else {
                    OpenFormatted.doOpen((SystemsTreeNode)aNode, (IPDHost)host, (String)host.getCodePage());
                }
                return;
            }
            if (selected.get(0) instanceof FMSubSystem) {
                FMSubSystem pdSubSystem = (FMSubSystem)selected.get(0);
                SystemsTreeNode aNode = pdSubSystem.getFirstNonGrouperNode();
                OpenFormatted.doOpen((SystemsTreeNode)aNode, (IPDHost)pdSubSystem.getSystem(), (String)pdSubSystem.getSystem().getCodePage());
                return;
            }
            OpenFormatted.showFormattedEditorDialog((IPDHost)resource.getSystem(), (IZRL)resource);
        }
    }

    private static String getEncoding(IHost host) {
        String encoding = "";
        ISubSystem[] iSubSystemArray = host.getSubSystems();
        int n = iSubSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISubSystem sub = iSubSystemArray[n2];
            if (sub instanceof MVSFileSubSystem) {
                MVSFileSubSystem mvs = (MVSFileSubSystem)sub;
                try {
                    mvs.checkIsConnected((IProgressMonitor)new NullProgressMonitor());
                    encoding = mvs.getEncoding();
                    if (encoding != null) break;
                    IMVSFileSystem mvsSys = mvs.getFileSystem();
                    IMVSFileMappingRoot mRoot = mvsSys.getMappingRoot();
                    encoding = mRoot.getDefaultHostCodePage();
                }
                catch (SystemMessageException e) {
                    logger.error((Throwable)e);
                }
                break;
            }
            ++n2;
        }
        return encoding;
    }
}

