/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.models.compiler.util;

import com.ibm.etools.fm.models.compiler.Asmtype;
import com.ibm.etools.fm.models.compiler.Coboltype;
import com.ibm.etools.fm.models.compiler.CompileType;
import com.ibm.etools.fm.models.compiler.CompilerPackage;
import com.ibm.etools.fm.models.compiler.DocumentRoot;
import com.ibm.etools.fm.models.compiler.LangType1;
import com.ibm.etools.fm.models.compiler.Plitype;
import com.ibm.etools.fm.models.compiler.ReplaceType;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;

public class CompilerValidator
extends EObjectValidator {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final CompilerValidator INSTANCE = new CompilerValidator();
    public static final String DIAGNOSTIC_SOURCE = "com.ibm.etools.fm.models.compiler";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;
    public static final int MAXRC_TYPE__MIN__VALUE = 0;
    public static final int MAXRC_TYPE__MAX__VALUE = 99;
    public static final int MAXRC_TYPE1__MIN__VALUE = 0;
    public static final int MAXRC_TYPE1__MAX__VALUE = 99;
    public static final int MAXRC_TYPE2__MIN__VALUE = 0;
    public static final int MAXRC_TYPE2__MAX__VALUE = 99;

    protected EPackage getEPackage() {
        return CompilerPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateAsmtype((Asmtype)value, diagnostics, context);
            }
            case 1: {
                return this.validateCoboltype((Coboltype)value, diagnostics, context);
            }
            case 2: {
                return this.validateCompileType((CompileType)value, diagnostics, context);
            }
            case 3: {
                return this.validateDocumentRoot((DocumentRoot)value, diagnostics, context);
            }
            case 4: {
                return this.validatePlitype((Plitype)value, diagnostics, context);
            }
            case 5: {
                return this.validateReplaceType((ReplaceType)value, diagnostics, context);
            }
            case 6: {
                return this.validateLangType1((LangType1)((Object)value), diagnostics, context);
            }
            case 7: {
                return this.validateAsmlibType((String)value, diagnostics, context);
            }
            case 8: {
                return this.validateCbllibType((String)value, diagnostics, context);
            }
            case 9: {
                return this.validateLangType((String)value, diagnostics, context);
            }
            case 10: {
                return this.validateLangTypeObject((LangType1)((Object)value), diagnostics, context);
            }
            case 11: {
                return this.validateMaxrcType((Integer)value, diagnostics, context);
            }
            case 12: {
                return this.validateMaxrcType1((Integer)value, diagnostics, context);
            }
            case 13: {
                return this.validateMaxrcType2((Integer)value, diagnostics, context);
            }
            case 14: {
                return this.validateMaxrcTypeObject((Integer)value, diagnostics, context);
            }
            case 15: {
                return this.validateMaxrcTypeObject1((Integer)value, diagnostics, context);
            }
            case 16: {
                return this.validateMaxrcTypeObject2((Integer)value, diagnostics, context);
            }
            case 17: {
                return this.validatePlilibType((String)value, diagnostics, context);
            }
            case 18: {
                return this.validateRepfromType((String)value, diagnostics, context);
            }
            case 19: {
                return this.validateReptoType((String)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateAsmtype(Asmtype asmtype, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(asmtype, diagnostics, context);
    }

    public boolean validateCoboltype(Coboltype coboltype, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(coboltype, diagnostics, context);
    }

    public boolean validateCompileType(CompileType compileType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(compileType, diagnostics, context);
    }

    public boolean validateDocumentRoot(DocumentRoot documentRoot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(documentRoot, diagnostics, context);
    }

    public boolean validatePlitype(Plitype plitype, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(plitype, diagnostics, context);
    }

    public boolean validateReplaceType(ReplaceType replaceType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(replaceType, diagnostics, context);
    }

    public boolean validateLangType1(LangType1 langType1, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateAsmlibType(String asmlibType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateAsmlibType_MinLength(asmlibType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateAsmlibType_MaxLength(asmlibType, diagnostics, context);
        }
        return result;
    }

    public boolean validateAsmlibType_MinLength(String asmlibType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = asmlibType.length();
        boolean bl = result = length >= 1;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(CompilerPackage.Literals.ASMLIB_TYPE, asmlibType, length, 1, diagnostics, context);
        }
        return result;
    }

    public boolean validateAsmlibType_MaxLength(String asmlibType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = asmlibType.length();
        boolean bl = result = length <= 44;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(CompilerPackage.Literals.ASMLIB_TYPE, asmlibType, length, 44, diagnostics, context);
        }
        return result;
    }

    public boolean validateCbllibType(String cbllibType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateCbllibType_MinLength(cbllibType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateCbllibType_MaxLength(cbllibType, diagnostics, context);
        }
        return result;
    }

    public boolean validateCbllibType_MinLength(String cbllibType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = cbllibType.length();
        boolean bl = result = length >= 1;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(CompilerPackage.Literals.CBLLIB_TYPE, cbllibType, length, 1, diagnostics, context);
        }
        return result;
    }

    public boolean validateCbllibType_MaxLength(String cbllibType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = cbllibType.length();
        boolean bl = result = length <= 44;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(CompilerPackage.Literals.CBLLIB_TYPE, cbllibType, length, 44, diagnostics, context);
        }
        return result;
    }

    public boolean validateLangType(String langType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateLangTypeObject(LangType1 langTypeObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateMaxrcType(int maxrcType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateMaxrcType_Min(maxrcType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateMaxrcType_Max(maxrcType, diagnostics, context);
        }
        return result;
    }

    public boolean validateMaxrcType_Min(int maxrcType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = maxrcType >= 0;
        if (!result && diagnostics != null) {
            this.reportMinViolation(CompilerPackage.Literals.MAXRC_TYPE, maxrcType, 0, true, diagnostics, context);
        }
        return result;
    }

    public boolean validateMaxrcType_Max(int maxrcType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = maxrcType <= 99;
        if (!result && diagnostics != null) {
            this.reportMaxViolation(CompilerPackage.Literals.MAXRC_TYPE, maxrcType, 99, true, diagnostics, context);
        }
        return result;
    }

    public boolean validateMaxrcType1(int maxrcType1, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateMaxrcType1_Min(maxrcType1, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateMaxrcType1_Max(maxrcType1, diagnostics, context);
        }
        return result;
    }

    public boolean validateMaxrcType1_Min(int maxrcType1, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = maxrcType1 >= 0;
        if (!result && diagnostics != null) {
            this.reportMinViolation(CompilerPackage.Literals.MAXRC_TYPE1, maxrcType1, 0, true, diagnostics, context);
        }
        return result;
    }

    public boolean validateMaxrcType1_Max(int maxrcType1, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = maxrcType1 <= 99;
        if (!result && diagnostics != null) {
            this.reportMaxViolation(CompilerPackage.Literals.MAXRC_TYPE1, maxrcType1, 99, true, diagnostics, context);
        }
        return result;
    }

    public boolean validateMaxrcType2(int maxrcType2, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateMaxrcType2_Min(maxrcType2, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateMaxrcType2_Max(maxrcType2, diagnostics, context);
        }
        return result;
    }

    public boolean validateMaxrcType2_Min(int maxrcType2, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = maxrcType2 >= 0;
        if (!result && diagnostics != null) {
            this.reportMinViolation(CompilerPackage.Literals.MAXRC_TYPE2, maxrcType2, 0, true, diagnostics, context);
        }
        return result;
    }

    public boolean validateMaxrcType2_Max(int maxrcType2, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = maxrcType2 <= 99;
        if (!result && diagnostics != null) {
            this.reportMaxViolation(CompilerPackage.Literals.MAXRC_TYPE2, maxrcType2, 99, true, diagnostics, context);
        }
        return result;
    }

    public boolean validateMaxrcTypeObject(Integer maxrcTypeObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateMaxrcType1_Min(maxrcTypeObject, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateMaxrcType1_Max(maxrcTypeObject, diagnostics, context);
        }
        return result;
    }

    public boolean validateMaxrcTypeObject1(Integer maxrcTypeObject1, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateMaxrcType_Min(maxrcTypeObject1, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateMaxrcType_Max(maxrcTypeObject1, diagnostics, context);
        }
        return result;
    }

    public boolean validateMaxrcTypeObject2(Integer maxrcTypeObject2, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateMaxrcType2_Min(maxrcTypeObject2, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateMaxrcType2_Max(maxrcTypeObject2, diagnostics, context);
        }
        return result;
    }

    public boolean validatePlilibType(String plilibType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validatePlilibType_MinLength(plilibType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validatePlilibType_MaxLength(plilibType, diagnostics, context);
        }
        return result;
    }

    public boolean validatePlilibType_MinLength(String plilibType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = plilibType.length();
        boolean bl = result = length >= 1;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(CompilerPackage.Literals.PLILIB_TYPE, plilibType, length, 1, diagnostics, context);
        }
        return result;
    }

    public boolean validatePlilibType_MaxLength(String plilibType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = plilibType.length();
        boolean bl = result = length <= 44;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(CompilerPackage.Literals.PLILIB_TYPE, plilibType, length, 44, diagnostics, context);
        }
        return result;
    }

    public boolean validateRepfromType(String repfromType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateRepfromType_MinLength(repfromType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateRepfromType_MaxLength(repfromType, diagnostics, context);
        }
        return result;
    }

    public boolean validateRepfromType_MinLength(String repfromType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = repfromType.length();
        boolean bl = result = length >= 1;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(CompilerPackage.Literals.REPFROM_TYPE, repfromType, length, 1, diagnostics, context);
        }
        return result;
    }

    public boolean validateRepfromType_MaxLength(String repfromType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = repfromType.length();
        boolean bl = result = length <= 30;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(CompilerPackage.Literals.REPFROM_TYPE, repfromType, length, 30, diagnostics, context);
        }
        return result;
    }

    public boolean validateReptoType(String reptoType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateReptoType_MinLength(reptoType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateReptoType_MaxLength(reptoType, diagnostics, context);
        }
        return result;
    }

    public boolean validateReptoType_MinLength(String reptoType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = reptoType.length();
        boolean bl = result = length >= 1;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(CompilerPackage.Literals.REPTO_TYPE, reptoType, length, 1, diagnostics, context);
        }
        return result;
    }

    public boolean validateReptoType_MaxLength(String reptoType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = reptoType.length();
        boolean bl = result = length <= 30;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(CompilerPackage.Literals.REPTO_TYPE, reptoType, length, 30, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

