/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.models.compiler.util;

import com.ibm.etools.fm.models.compiler.Asmtype;
import com.ibm.etools.fm.models.compiler.Coboltype;
import com.ibm.etools.fm.models.compiler.CompileType;
import com.ibm.etools.fm.models.compiler.CompilerFactory;
import com.ibm.etools.fm.models.compiler.DocumentRoot;
import com.ibm.etools.fm.models.compiler.LangType1;
import com.ibm.etools.fm.models.compiler.Plitype;
import com.ibm.etools.fm.models.compiler.ReplaceType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLParserPool;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeResourceImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CompilerResourceImpl
extends XMLResourceImpl {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String OPTION_USE_DATA_CONVERTER = "USE_DATA_CONVERTER";
    protected static final XMLParserPool parserPool = new XMLParserPoolImpl();

    public CompilerResourceImpl(URI uri) {
        super(uri);
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        if (options != null && Boolean.TRUE.equals(options.get(OPTION_USE_DATA_CONVERTER))) {
            this.getContents().add((Object)CompilerResourceImpl.load(new InputSource(inputStream), (Map)options.get("PARSER_FEATURES"), (Map)options.get("PARSER_PROPERTIES"), Boolean.TRUE.equals(options.get("USE_LEXICAL_HANDLER"))).eContainer());
        } else {
            super.doLoad(inputStream, options);
        }
    }

    public void doLoad(InputSource inputSource, Map<?, ?> options) throws IOException {
        if (options != null && Boolean.TRUE.equals(options.get(OPTION_USE_DATA_CONVERTER))) {
            this.getContents().add((Object)CompilerResourceImpl.load(inputSource, (Map)options.get("PARSER_FEATURES"), (Map)options.get("PARSER_PROPERTIES"), Boolean.TRUE.equals(options.get("USE_LEXICAL_HANDLER"))).eContainer());
        } else {
            super.doLoad(inputSource, options);
        }
    }

    public static EObject load(InputSource inputSource, Map<String, Boolean> features, Map<String, ?> properties, boolean useLexicalHandler) throws IOException {
        HashMap<String, Boolean> requiredFeatures = new HashMap<String, Boolean>();
        requiredFeatures.put("http://xml.org/sax/features/namespaces", Boolean.TRUE);
        if (features != null) {
            requiredFeatures.putAll(features);
        }
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        SAXParser saxParser = null;
        try {
            saxParser = parserPool.get(requiredFeatures, properties, useLexicalHandler);
            FrameFactory.DocumentRootStackFrame documentRoot = FrameFactory.INSTANCE.pushDocumentRoot(null, null);
            XMLTypeResourceImpl.Handler handler = new XMLTypeResourceImpl.Handler((XMLTypeResourceImpl.StackFrame)documentRoot);
            saxParser.parse(inputSource, (DefaultHandler)handler);
            EObject eObject = (EObject)FrameFactory.INSTANCE.popDocumentRoot(documentRoot).eContents().get(0);
            return eObject;
        }
        catch (Exception exception) {
            throw new Resource.IOWrappedException(exception);
        }
        finally {
            parserPool.release(saxParser, requiredFeatures, properties, useLexicalHandler);
        }
    }

    public static final class FrameFactory {
        public static final FrameFactory INSTANCE = new FrameFactory();
        protected AsmtypeStackFrame asmtype;
        protected CoboltypeStackFrame coboltype;
        protected CompileTypeStackFrame compileType;
        protected DocumentRootStackFrame documentRoot;
        protected PlitypeStackFrame plitype;
        protected ReplaceTypeStackFrame replaceType;
        protected XMLTypeResourceImpl.DataFrame langType1;
        protected XMLTypeResourceImpl.DataFrame asmlibType;
        protected XMLTypeResourceImpl.DataFrame cbllibType;
        protected XMLTypeResourceImpl.DataFrame langType;
        protected XMLTypeResourceImpl.DataFrame langTypeObject;
        protected XMLTypeResourceImpl.DataFrame maxrcType;
        protected XMLTypeResourceImpl.DataFrame maxrcType1;
        protected XMLTypeResourceImpl.DataFrame maxrcType2;
        protected XMLTypeResourceImpl.DataFrame maxrcTypeObject;
        protected XMLTypeResourceImpl.DataFrame maxrcTypeObject1;
        protected XMLTypeResourceImpl.DataFrame maxrcTypeObject2;
        protected XMLTypeResourceImpl.DataFrame plilibType;
        protected XMLTypeResourceImpl.DataFrame repfromType;
        protected XMLTypeResourceImpl.DataFrame reptoType;

        public AsmtypeStackFrame pushAsmtype(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            AsmtypeStackFrame resultAsmtype = this.asmtype == null ? new AsmtypeStackFrame() : this.asmtype;
            this.asmtype = null;
            resultAsmtype.pushOnto(previous);
            resultAsmtype.handleAttributes(attributes);
            return resultAsmtype;
        }

        public Asmtype popAsmtype(AsmtypeStackFrame asmtype) {
            Asmtype resultAsmtypeValue = asmtype.popAsmtype();
            this.asmtype = asmtype;
            return resultAsmtypeValue;
        }

        public CoboltypeStackFrame pushCoboltype(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            CoboltypeStackFrame resultCoboltype = this.coboltype == null ? new CoboltypeStackFrame() : this.coboltype;
            this.coboltype = null;
            resultCoboltype.pushOnto(previous);
            resultCoboltype.handleAttributes(attributes);
            return resultCoboltype;
        }

        public Coboltype popCoboltype(CoboltypeStackFrame coboltype) {
            Coboltype resultCoboltypeValue = coboltype.popCoboltype();
            this.coboltype = coboltype;
            return resultCoboltypeValue;
        }

        public CompileTypeStackFrame pushCompileType(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            CompileTypeStackFrame resultCompileType = this.compileType == null ? new CompileTypeStackFrame() : this.compileType;
            this.compileType = null;
            resultCompileType.pushOnto(previous);
            resultCompileType.handleAttributes(attributes);
            return resultCompileType;
        }

        public CompileType popCompileType(CompileTypeStackFrame compileType) {
            CompileType resultCompileTypeValue = compileType.popCompileType();
            this.compileType = compileType;
            return resultCompileTypeValue;
        }

        public DocumentRootStackFrame pushDocumentRoot(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            DocumentRootStackFrame resultDocumentRoot = this.documentRoot == null ? new DocumentRootStackFrame() : this.documentRoot;
            this.documentRoot = null;
            resultDocumentRoot.pushOnto(previous);
            resultDocumentRoot.handleAttributes(attributes);
            return resultDocumentRoot;
        }

        public DocumentRoot popDocumentRoot(DocumentRootStackFrame documentRoot) {
            DocumentRoot resultDocumentRootValue = documentRoot.popDocumentRoot();
            this.documentRoot = documentRoot;
            return resultDocumentRootValue;
        }

        public PlitypeStackFrame pushPlitype(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            PlitypeStackFrame resultPlitype = this.plitype == null ? new PlitypeStackFrame() : this.plitype;
            this.plitype = null;
            resultPlitype.pushOnto(previous);
            resultPlitype.handleAttributes(attributes);
            return resultPlitype;
        }

        public Plitype popPlitype(PlitypeStackFrame plitype) {
            Plitype resultPlitypeValue = plitype.popPlitype();
            this.plitype = plitype;
            return resultPlitypeValue;
        }

        public ReplaceTypeStackFrame pushReplaceType(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            ReplaceTypeStackFrame resultReplaceType = this.replaceType == null ? new ReplaceTypeStackFrame() : this.replaceType;
            this.replaceType = null;
            resultReplaceType.pushOnto(previous);
            resultReplaceType.handleAttributes(attributes);
            return resultReplaceType;
        }

        public ReplaceType popReplaceType(ReplaceTypeStackFrame replaceType) {
            ReplaceType resultReplaceTypeValue = replaceType.popReplaceType();
            this.replaceType = replaceType;
            return resultReplaceTypeValue;
        }

        public XMLTypeResourceImpl.DataFrame pushLangType1(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            XMLTypeResourceImpl.DataFrame resultLangType1 = this.langType1 == null ? new XMLTypeResourceImpl.DataFrame() : this.langType1;
            this.langType1 = null;
            resultLangType1.pushOnto(previous);
            resultLangType1.handleAttributes(attributes);
            return resultLangType1;
        }

        public LangType1 popLangType1(XMLTypeResourceImpl.DataFrame langType1) {
            LangType1 resultLangType1Value = CompilerFactory.eINSTANCE.createLangType1(langType1.popValue());
            this.langType1 = langType1;
            return resultLangType1Value;
        }

        public XMLTypeResourceImpl.DataFrame pushAsmlibType(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            XMLTypeResourceImpl.DataFrame resultAsmlibType = this.asmlibType == null ? new XMLTypeResourceImpl.DataFrame() : this.asmlibType;
            this.asmlibType = null;
            resultAsmlibType.pushOnto(previous);
            resultAsmlibType.handleAttributes(attributes);
            return resultAsmlibType;
        }

        public String popAsmlibType(XMLTypeResourceImpl.DataFrame asmlibType) {
            String resultAsmlibTypeValue = CompilerFactory.eINSTANCE.createAsmlibType(asmlibType.popValue());
            this.asmlibType = asmlibType;
            return resultAsmlibTypeValue;
        }

        public XMLTypeResourceImpl.DataFrame pushCbllibType(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            XMLTypeResourceImpl.DataFrame resultCbllibType = this.cbllibType == null ? new XMLTypeResourceImpl.DataFrame() : this.cbllibType;
            this.cbllibType = null;
            resultCbllibType.pushOnto(previous);
            resultCbllibType.handleAttributes(attributes);
            return resultCbllibType;
        }

        public String popCbllibType(XMLTypeResourceImpl.DataFrame cbllibType) {
            String resultCbllibTypeValue = CompilerFactory.eINSTANCE.createCbllibType(cbllibType.popValue());
            this.cbllibType = cbllibType;
            return resultCbllibTypeValue;
        }

        public XMLTypeResourceImpl.DataFrame pushLangType(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            XMLTypeResourceImpl.DataFrame resultLangType = this.langType == null ? new XMLTypeResourceImpl.DataFrame() : this.langType;
            this.langType = null;
            resultLangType.pushOnto(previous);
            resultLangType.handleAttributes(attributes);
            return resultLangType;
        }

        public String popLangType(XMLTypeResourceImpl.DataFrame langType) {
            String resultLangTypeValue = CompilerFactory.eINSTANCE.createLangType(langType.popValue());
            this.langType = langType;
            return resultLangTypeValue;
        }

        public XMLTypeResourceImpl.DataFrame pushLangTypeObject(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            XMLTypeResourceImpl.DataFrame resultLangTypeObject = this.langTypeObject == null ? new XMLTypeResourceImpl.DataFrame() : this.langTypeObject;
            this.langTypeObject = null;
            resultLangTypeObject.pushOnto(previous);
            resultLangTypeObject.handleAttributes(attributes);
            return resultLangTypeObject;
        }

        public LangType1 popLangTypeObject(XMLTypeResourceImpl.DataFrame langTypeObject) {
            LangType1 resultLangTypeObjectValue = CompilerFactory.eINSTANCE.createLangTypeObject(langTypeObject.popValue());
            this.langTypeObject = langTypeObject;
            return resultLangTypeObjectValue;
        }

        public XMLTypeResourceImpl.DataFrame pushMaxrcType(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            XMLTypeResourceImpl.DataFrame resultMaxrcType = this.maxrcType == null ? new XMLTypeResourceImpl.DataFrame() : this.maxrcType;
            this.maxrcType = null;
            resultMaxrcType.pushOnto(previous);
            resultMaxrcType.handleAttributes(attributes);
            return resultMaxrcType;
        }

        public int popMaxrcType(XMLTypeResourceImpl.DataFrame maxrcType) {
            int resultMaxrcTypeValue = CompilerFactory.eINSTANCE.createMaxrcType(maxrcType.popValue());
            this.maxrcType = maxrcType;
            return resultMaxrcTypeValue;
        }

        public XMLTypeResourceImpl.DataFrame pushMaxrcType1(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            XMLTypeResourceImpl.DataFrame resultMaxrcType1 = this.maxrcType1 == null ? new XMLTypeResourceImpl.DataFrame() : this.maxrcType1;
            this.maxrcType1 = null;
            resultMaxrcType1.pushOnto(previous);
            resultMaxrcType1.handleAttributes(attributes);
            return resultMaxrcType1;
        }

        public int popMaxrcType1(XMLTypeResourceImpl.DataFrame maxrcType1) {
            int resultMaxrcType1Value = CompilerFactory.eINSTANCE.createMaxrcType1(maxrcType1.popValue());
            this.maxrcType1 = maxrcType1;
            return resultMaxrcType1Value;
        }

        public XMLTypeResourceImpl.DataFrame pushMaxrcType2(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            XMLTypeResourceImpl.DataFrame resultMaxrcType2 = this.maxrcType2 == null ? new XMLTypeResourceImpl.DataFrame() : this.maxrcType2;
            this.maxrcType2 = null;
            resultMaxrcType2.pushOnto(previous);
            resultMaxrcType2.handleAttributes(attributes);
            return resultMaxrcType2;
        }

        public int popMaxrcType2(XMLTypeResourceImpl.DataFrame maxrcType2) {
            int resultMaxrcType2Value = CompilerFactory.eINSTANCE.createMaxrcType2(maxrcType2.popValue());
            this.maxrcType2 = maxrcType2;
            return resultMaxrcType2Value;
        }

        public XMLTypeResourceImpl.DataFrame pushMaxrcTypeObject(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            XMLTypeResourceImpl.DataFrame resultMaxrcTypeObject = this.maxrcTypeObject == null ? new XMLTypeResourceImpl.DataFrame() : this.maxrcTypeObject;
            this.maxrcTypeObject = null;
            resultMaxrcTypeObject.pushOnto(previous);
            resultMaxrcTypeObject.handleAttributes(attributes);
            return resultMaxrcTypeObject;
        }

        public Integer popMaxrcTypeObject(XMLTypeResourceImpl.DataFrame maxrcTypeObject) {
            Integer resultMaxrcTypeObjectValue = CompilerFactory.eINSTANCE.createMaxrcTypeObject(maxrcTypeObject.popValue());
            this.maxrcTypeObject = maxrcTypeObject;
            return resultMaxrcTypeObjectValue;
        }

        public XMLTypeResourceImpl.DataFrame pushMaxrcTypeObject1(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            XMLTypeResourceImpl.DataFrame resultMaxrcTypeObject1 = this.maxrcTypeObject1 == null ? new XMLTypeResourceImpl.DataFrame() : this.maxrcTypeObject1;
            this.maxrcTypeObject1 = null;
            resultMaxrcTypeObject1.pushOnto(previous);
            resultMaxrcTypeObject1.handleAttributes(attributes);
            return resultMaxrcTypeObject1;
        }

        public Integer popMaxrcTypeObject1(XMLTypeResourceImpl.DataFrame maxrcTypeObject1) {
            Integer resultMaxrcTypeObject1Value = CompilerFactory.eINSTANCE.createMaxrcTypeObject1(maxrcTypeObject1.popValue());
            this.maxrcTypeObject1 = maxrcTypeObject1;
            return resultMaxrcTypeObject1Value;
        }

        public XMLTypeResourceImpl.DataFrame pushMaxrcTypeObject2(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            XMLTypeResourceImpl.DataFrame resultMaxrcTypeObject2 = this.maxrcTypeObject2 == null ? new XMLTypeResourceImpl.DataFrame() : this.maxrcTypeObject2;
            this.maxrcTypeObject2 = null;
            resultMaxrcTypeObject2.pushOnto(previous);
            resultMaxrcTypeObject2.handleAttributes(attributes);
            return resultMaxrcTypeObject2;
        }

        public Integer popMaxrcTypeObject2(XMLTypeResourceImpl.DataFrame maxrcTypeObject2) {
            Integer resultMaxrcTypeObject2Value = CompilerFactory.eINSTANCE.createMaxrcTypeObject2(maxrcTypeObject2.popValue());
            this.maxrcTypeObject2 = maxrcTypeObject2;
            return resultMaxrcTypeObject2Value;
        }

        public XMLTypeResourceImpl.DataFrame pushPlilibType(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            XMLTypeResourceImpl.DataFrame resultPlilibType = this.plilibType == null ? new XMLTypeResourceImpl.DataFrame() : this.plilibType;
            this.plilibType = null;
            resultPlilibType.pushOnto(previous);
            resultPlilibType.handleAttributes(attributes);
            return resultPlilibType;
        }

        public String popPlilibType(XMLTypeResourceImpl.DataFrame plilibType) {
            String resultPlilibTypeValue = CompilerFactory.eINSTANCE.createPlilibType(plilibType.popValue());
            this.plilibType = plilibType;
            return resultPlilibTypeValue;
        }

        public XMLTypeResourceImpl.DataFrame pushRepfromType(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            XMLTypeResourceImpl.DataFrame resultRepfromType = this.repfromType == null ? new XMLTypeResourceImpl.DataFrame() : this.repfromType;
            this.repfromType = null;
            resultRepfromType.pushOnto(previous);
            resultRepfromType.handleAttributes(attributes);
            return resultRepfromType;
        }

        public String popRepfromType(XMLTypeResourceImpl.DataFrame repfromType) {
            String resultRepfromTypeValue = CompilerFactory.eINSTANCE.createRepfromType(repfromType.popValue());
            this.repfromType = repfromType;
            return resultRepfromTypeValue;
        }

        public XMLTypeResourceImpl.DataFrame pushReptoType(XMLTypeResourceImpl.StackFrame previous, Attributes attributes) {
            XMLTypeResourceImpl.DataFrame resultReptoType = this.reptoType == null ? new XMLTypeResourceImpl.DataFrame() : this.reptoType;
            this.reptoType = null;
            resultReptoType.pushOnto(previous);
            resultReptoType.handleAttributes(attributes);
            return resultReptoType;
        }

        public String popReptoType(XMLTypeResourceImpl.DataFrame reptoType) {
            String resultReptoTypeValue = CompilerFactory.eINSTANCE.createReptoType(reptoType.popValue());
            this.reptoType = reptoType;
            return resultReptoTypeValue;
        }

        public static class AsmtypeStackFrame
        extends XMLTypeResourceImpl.StackFrame {
            protected Asmtype theAsmtype;
            protected XMLTypeResourceImpl.DataFrame asmlib;
            protected XMLTypeResourceImpl.DataFrame asmaddop;
            protected XMLTypeResourceImpl.DataFrame dbcs;
            protected XMLTypeResourceImpl.DataFrame maxrc;
            protected XMLTypeResourceImpl.DataFrame noalign;

            public void handleAttributes(Attributes attributes) {
                String theValue = attributes.getValue("", "asmaddop");
                if (theValue != null) {
                    this.theAsmtype.setAsmaddop(XMLTypeFactory.eINSTANCE.createString(theValue));
                }
                if ((theValue = attributes.getValue("", "dbcs")) != null) {
                    this.theAsmtype.setDbcs(XMLTypeFactory.eINSTANCE.createBoolean(theValue));
                }
                if ((theValue = attributes.getValue("", "maxrc")) != null) {
                    this.theAsmtype.setMaxrc(CompilerFactory.eINSTANCE.createMaxrcType1(theValue));
                }
                if ((theValue = attributes.getValue("", "noalign")) != null) {
                    this.theAsmtype.setNoalign(XMLTypeFactory.eINSTANCE.createBoolean(theValue));
                }
            }

            public XMLTypeResourceImpl.StackFrame startElement(String namespace, String localName, String qName, Attributes attributes) throws SAXException {
                if ("asmlib".equals(localName) && "".equals(namespace)) {
                    this.asmlib = INSTANCE.pushAsmlibType(this, attributes);
                    return this.asmlib;
                }
                return super.startElement(namespace, localName, qName, attributes);
            }

            public void endElement(XMLTypeResourceImpl.StackFrame child) throws SAXException {
                if (child == this.asmlib) {
                    this.theAsmtype.getAsmlib().add((Object)INSTANCE.popAsmlibType(this.asmlib));
                    this.asmlib = null;
                } else {
                    super.endElement(child);
                }
            }

            public void create() {
                this.theAsmtype = CompilerFactory.eINSTANCE.createAsmtype();
            }

            protected Asmtype popAsmtype() {
                this.pop();
                Asmtype resultAsmtypeValue = this.theAsmtype;
                this.theAsmtype = null;
                return resultAsmtypeValue;
            }
        }

        public static class CoboltypeStackFrame
        extends XMLTypeResourceImpl.StackFrame {
            protected Coboltype theCoboltype;
            protected ReplaceTypeStackFrame replace;
            protected XMLTypeResourceImpl.DataFrame cbllib;
            protected XMLTypeResourceImpl.DataFrame arith;
            protected XMLTypeResourceImpl.DataFrame cbladdop;
            protected XMLTypeResourceImpl.DataFrame dbcs;
            protected XMLTypeResourceImpl.DataFrame dpc;
            protected XMLTypeResourceImpl.DataFrame maxrc;
            protected XMLTypeResourceImpl.DataFrame mixedcase;

            public void handleAttributes(Attributes attributes) {
                String theValue = attributes.getValue("", "arith");
                if (theValue != null) {
                    this.theCoboltype.setArith(XMLTypeFactory.eINSTANCE.createBoolean(theValue));
                }
                if ((theValue = attributes.getValue("", "cbladdop")) != null) {
                    this.theCoboltype.setCbladdop(XMLTypeFactory.eINSTANCE.createString(theValue));
                }
                if ((theValue = attributes.getValue("", "dbcs")) != null) {
                    this.theCoboltype.setDbcs(XMLTypeFactory.eINSTANCE.createBoolean(theValue));
                }
                if ((theValue = attributes.getValue("", "dpc")) != null) {
                    this.theCoboltype.setDpc(XMLTypeFactory.eINSTANCE.createBoolean(theValue));
                }
                if ((theValue = attributes.getValue("", "maxrc")) != null) {
                    this.theCoboltype.setMaxrc(CompilerFactory.eINSTANCE.createMaxrcType2(theValue));
                }
                if ((theValue = attributes.getValue("", "mixedcase")) != null) {
                    this.theCoboltype.setMixedcase(XMLTypeFactory.eINSTANCE.createBoolean(theValue));
                }
            }

            public XMLTypeResourceImpl.StackFrame startElement(String namespace, String localName, String qName, Attributes attributes) throws SAXException {
                if ("replace".equals(localName) && "".equals(namespace)) {
                    this.replace = INSTANCE.pushReplaceType(this, attributes);
                    return this.replace;
                }
                if ("cbllib".equals(localName) && "".equals(namespace)) {
                    this.cbllib = INSTANCE.pushCbllibType(this, attributes);
                    return this.cbllib;
                }
                return super.startElement(namespace, localName, qName, attributes);
            }

            public void endElement(XMLTypeResourceImpl.StackFrame child) throws SAXException {
                if (child == this.replace) {
                    this.theCoboltype.getReplace().add((Object)INSTANCE.popReplaceType(this.replace));
                    this.replace = null;
                } else if (child == this.cbllib) {
                    this.theCoboltype.getCbllib().add((Object)INSTANCE.popCbllibType(this.cbllib));
                    this.cbllib = null;
                } else {
                    super.endElement(child);
                }
            }

            public void create() {
                this.theCoboltype = CompilerFactory.eINSTANCE.createCoboltype();
            }

            protected Coboltype popCoboltype() {
                this.pop();
                Coboltype resultCoboltypeValue = this.theCoboltype;
                this.theCoboltype = null;
                return resultCoboltypeValue;
            }
        }

        public static class CompileTypeStackFrame
        extends XMLTypeResourceImpl.StackFrame {
            protected CompileType theCompileType;
            protected CoboltypeStackFrame cobol;
            protected PlitypeStackFrame pli;
            protected AsmtypeStackFrame asm;
            protected XMLTypeResourceImpl.DataFrame lang;
            protected XMLTypeResourceImpl.DataFrame override;
            protected XMLTypeResourceImpl.DataFrame preserve;
            protected XMLTypeResourceImpl.DataFrame comma;

            public void handleAttributes(Attributes attributes) {
                String theValue = attributes.getValue("", "lang");
                if (theValue != null) {
                    this.theCompileType.setLang(CompilerFactory.eINSTANCE.createLangType1(theValue));
                }
                if ((theValue = attributes.getValue("", "override")) != null) {
                    this.theCompileType.setOverride(XMLTypeFactory.eINSTANCE.createBoolean(theValue));
                }
                if ((theValue = attributes.getValue("", "preserve")) != null) {
                    this.theCompileType.setPreserve(XMLTypeFactory.eINSTANCE.createBoolean(theValue));
                }
                if ((theValue = attributes.getValue("", "comma")) != null) {
                    this.theCompileType.setComma(XMLTypeFactory.eINSTANCE.createBoolean(theValue));
                }
            }

            public XMLTypeResourceImpl.StackFrame startElement(String namespace, String localName, String qName, Attributes attributes) throws SAXException {
                if ("cobol".equals(localName) && "".equals(namespace)) {
                    this.cobol = INSTANCE.pushCoboltype(this, attributes);
                    return this.cobol;
                }
                if ("pli".equals(localName) && "".equals(namespace)) {
                    this.pli = INSTANCE.pushPlitype(this, attributes);
                    return this.pli;
                }
                if ("asm".equals(localName) && "".equals(namespace)) {
                    this.asm = INSTANCE.pushAsmtype(this, attributes);
                    return this.asm;
                }
                return super.startElement(namespace, localName, qName, attributes);
            }

            public void endElement(XMLTypeResourceImpl.StackFrame child) throws SAXException {
                if (child == this.cobol) {
                    this.theCompileType.setCobol(INSTANCE.popCoboltype(this.cobol));
                    this.cobol = null;
                } else if (child == this.pli) {
                    this.theCompileType.setPli(INSTANCE.popPlitype(this.pli));
                    this.pli = null;
                } else if (child == this.asm) {
                    this.theCompileType.setAsm(INSTANCE.popAsmtype(this.asm));
                    this.asm = null;
                } else {
                    super.endElement(child);
                }
            }

            public void create() {
                this.theCompileType = CompilerFactory.eINSTANCE.createCompileType();
            }

            protected CompileType popCompileType() {
                this.pop();
                CompileType resultCompileTypeValue = this.theCompileType;
                this.theCompileType = null;
                return resultCompileTypeValue;
            }
        }

        public static class DocumentRootStackFrame
        extends XMLTypeResourceImpl.StackFrame {
            protected DocumentRoot theDocumentRoot;
            protected CompileTypeStackFrame compile;

            public void handleAttributes(Attributes attributes) {
            }

            public XMLTypeResourceImpl.StackFrame startElement(String namespace, String localName, String qName, Attributes attributes) throws SAXException {
                if ("compile".equals(localName) && "".equals(namespace)) {
                    this.compile = INSTANCE.pushCompileType(this, attributes);
                    return this.compile;
                }
                return super.startElement(namespace, localName, qName, attributes);
            }

            public void endElement(XMLTypeResourceImpl.StackFrame child) throws SAXException {
                if (child == this.compile) {
                    this.theDocumentRoot.setCompile(INSTANCE.popCompileType(this.compile));
                    this.compile = null;
                } else {
                    super.endElement(child);
                }
            }

            public void create() {
                this.theDocumentRoot = CompilerFactory.eINSTANCE.createDocumentRoot();
            }

            protected DocumentRoot popDocumentRoot() {
                this.pop();
                DocumentRoot resultDocumentRootValue = this.theDocumentRoot;
                this.theDocumentRoot = null;
                return resultDocumentRootValue;
            }
        }

        public static class PlitypeStackFrame
        extends XMLTypeResourceImpl.StackFrame {
            protected Plitype thePlitype;
            protected XMLTypeResourceImpl.DataFrame plilib;
            protected XMLTypeResourceImpl.DataFrame bin63;
            protected XMLTypeResourceImpl.DataFrame fixdec;
            protected XMLTypeResourceImpl.DataFrame graph;
            protected XMLTypeResourceImpl.DataFrame maxrc;
            protected XMLTypeResourceImpl.DataFrame pliaddop;
            protected XMLTypeResourceImpl.DataFrame unalign;

            public void handleAttributes(Attributes attributes) {
                String theValue = attributes.getValue("", "bin63");
                if (theValue != null) {
                    this.thePlitype.setBin63(XMLTypeFactory.eINSTANCE.createBoolean(theValue));
                }
                if ((theValue = attributes.getValue("", "fixdec")) != null) {
                    this.thePlitype.setFixdec(XMLTypeFactory.eINSTANCE.createBoolean(theValue));
                }
                if ((theValue = attributes.getValue("", "graph")) != null) {
                    this.thePlitype.setGraph(XMLTypeFactory.eINSTANCE.createBoolean(theValue));
                }
                if ((theValue = attributes.getValue("", "maxrc")) != null) {
                    this.thePlitype.setMaxrc(CompilerFactory.eINSTANCE.createMaxrcType(theValue));
                }
                if ((theValue = attributes.getValue("", "pliaddop")) != null) {
                    this.thePlitype.setPliaddop(XMLTypeFactory.eINSTANCE.createString(theValue));
                }
                if ((theValue = attributes.getValue("", "unalign")) != null) {
                    this.thePlitype.setUnalign(XMLTypeFactory.eINSTANCE.createBoolean(theValue));
                }
            }

            public XMLTypeResourceImpl.StackFrame startElement(String namespace, String localName, String qName, Attributes attributes) throws SAXException {
                if ("plilib".equals(localName) && "".equals(namespace)) {
                    this.plilib = INSTANCE.pushPlilibType(this, attributes);
                    return this.plilib;
                }
                return super.startElement(namespace, localName, qName, attributes);
            }

            public void endElement(XMLTypeResourceImpl.StackFrame child) throws SAXException {
                if (child == this.plilib) {
                    this.thePlitype.getPlilib().add((Object)INSTANCE.popPlilibType(this.plilib));
                    this.plilib = null;
                } else {
                    super.endElement(child);
                }
            }

            public void create() {
                this.thePlitype = CompilerFactory.eINSTANCE.createPlitype();
            }

            protected Plitype popPlitype() {
                this.pop();
                Plitype resultPlitypeValue = this.thePlitype;
                this.thePlitype = null;
                return resultPlitypeValue;
            }
        }

        public static class ReplaceTypeStackFrame
        extends XMLTypeResourceImpl.StackFrame {
            public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
            protected ReplaceType theReplaceType;
            protected XMLTypeResourceImpl.DataFrame repfrom;
            protected XMLTypeResourceImpl.DataFrame repto;

            public void handleAttributes(Attributes attributes) {
            }

            public XMLTypeResourceImpl.StackFrame startElement(String namespace, String localName, String qName, Attributes attributes) throws SAXException {
                if ("repfrom".equals(localName) && "".equals(namespace)) {
                    this.repfrom = INSTANCE.pushRepfromType(this, attributes);
                    return this.repfrom;
                }
                if ("repto".equals(localName) && "".equals(namespace)) {
                    this.repto = INSTANCE.pushReptoType(this, attributes);
                    return this.repto;
                }
                return super.startElement(namespace, localName, qName, attributes);
            }

            public void endElement(XMLTypeResourceImpl.StackFrame child) throws SAXException {
                if (child == this.repfrom) {
                    this.theReplaceType.setRepfrom(INSTANCE.popRepfromType(this.repfrom));
                    this.repfrom = null;
                } else if (child == this.repto) {
                    this.theReplaceType.setRepto(INSTANCE.popReptoType(this.repto));
                    this.repto = null;
                } else {
                    super.endElement(child);
                }
            }

            public void create() {
                this.theReplaceType = CompilerFactory.eINSTANCE.createReplaceType();
            }

            protected ReplaceType popReplaceType() {
                this.pop();
                ReplaceType resultReplaceTypeValue = this.theReplaceType;
                this.theReplaceType = null;
                return resultReplaceTypeValue;
            }
        }
    }
}

