/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.template.util;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.util.StringUtils;
import com.ibm.etools.fm.model.template.Bylinetype;
import com.ibm.etools.fm.model.template.CreateCtype;
import com.ibm.etools.fm.model.template.Criteriatype;
import com.ibm.etools.fm.model.template.Csettype;
import com.ibm.etools.fm.model.template.Datetimetype;
import com.ibm.etools.fm.model.template.DocumentRoot;
import com.ibm.etools.fm.model.template.Exitprogtype;
import com.ibm.etools.fm.model.template.MemberType;
import com.ibm.etools.fm.model.template.ReplaceType;
import com.ibm.etools.fm.model.template.Scrambletype;
import com.ibm.etools.fm.model.template.Sourcerangetype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateFactory;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.Translatetype;
import com.ibm.etools.fm.model.template.Valuetype;
import com.ibm.etools.fm.model.template.util.TemplateResourceFactoryImpl;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.xml.sax.InputSource;

public class TemplateSerializeUtils {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(TemplateSerializeUtils.class);

    public static TemplateType load(IFile file, IZRL aResource) throws CoreException {
        try {
            return TemplateSerializeUtils.load(new String(Files.readAllBytes(file.getLocation().toFile().toPath()), StandardCharsets.UTF_8), aResource, false);
        }
        catch (IOException e) {
            CoreException ce = new CoreException((IStatus)new Status(4, "com.ibm.etools.fm.core", MessageFormat.format(Messages.TemplateSerializeUtils_COULD_NOT_LOAD, TemplateSerializeUtils.convertToResourceURI(aResource).toString()), (Throwable)e));
            throw ce;
        }
    }

    private static TemplateType load(String str, IZRL aResource, boolean isLocalDummy) throws CoreException {
        String object;
        String s = str.replaceFirst("(<\\?xml version=\"1\\.0\" encoding=\\\"ISO-8859-1\"\\?\\>)", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        URI uri = TemplateSerializeUtils.convertToResourceURI(aResource);
        TemplateType template = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        TemplateResourceFactoryImpl factory = new TemplateResourceFactoryImpl();
        XMLResource resource = (XMLResource)factory.createResource(uri);
        resourceSet.getResources().add((Object)resource);
        try {
            Map loadOptions = resourceSet.getLoadOptions();
            resource.load(new InputSource(new StringReader(s)), loadOptions);
        }
        catch (IOException e) {
            CoreException ce = new CoreException((IStatus)new Status(4, "com.ibm.etools.fm.core", MessageFormat.format(Messages.TemplateSerializeUtils_COULD_NOT_LOAD, uri.toString()), (Throwable)e));
            throw ce;
        }
        for (Resource.Diagnostic diagnostic : resource.getErrors()) {
            logger.error((Object)MessageFormat.format("An error was detected while loading {0}: {1} : Line {2} Column {3}.", isLocalDummy ? "local dummy file" : uri.toString(), diagnostic.getMessage(), String.valueOf(diagnostic.getLine()), String.valueOf(diagnostic.getColumn())));
        }
        if (resource.getContents().get(0) instanceof DocumentRoot) {
            template = ((DocumentRoot)resource.getContents().get(0)).getTemplate();
        }
        if (template != null && aResource.getSystem().getCodePage() != aResource.getSystem().getCommunicationCodePage() && (object = template.getDb2object()) != null) {
            try {
                template.setDb2object(new String(object.getBytes(aResource.getSystem().getCommunicationCodePage()), aResource.getSystem().getCodePage()));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (template != null) {
            TemplateSerializeUtils.convertFmixFromHex(template, aResource.getSystem().getCodePage());
        }
        return template;
    }

    public static void convertFmixFromHex(TemplateType template, String codepage) {
        if (!template.isFmix()) {
            return;
        }
        TreeIterator iterator = template.eAllContents();
        while (iterator.hasNext()) {
            EObject obj = (EObject)iterator.next();
            if (obj instanceof Bylinetype) {
                ((Bylinetype)obj).setByval(StringUtils.parseHexString((String)((Bylinetype)obj).getByval(), (String)codepage));
                continue;
            }
            if (obj instanceof ReplaceType) {
                ((ReplaceType)obj).setRepfrom(StringUtils.parseHexString((String)((ReplaceType)obj).getRepfrom(), (String)codepage));
                ((ReplaceType)obj).setRepto(StringUtils.parseHexString((String)((ReplaceType)obj).getRepto(), (String)codepage));
                continue;
            }
            if (obj instanceof MemberType) {
                ((MemberType)obj).setSegdesc(StringUtils.parseHexString((String)((MemberType)obj).getSegdesc(), (String)codepage));
                continue;
            }
            if (obj instanceof CreateCtype) {
                ((CreateCtype)obj).setFiller(StringUtils.parseHexString((String)((CreateCtype)obj).getFiller(), (String)codepage));
                ((CreateCtype)obj).setPattern(StringUtils.parseHexString((String)((CreateCtype)obj).getPattern(), (String)codepage));
                ((CreateCtype)obj).setStart(StringUtils.parseHexString((String)((CreateCtype)obj).getStart(), (String)codepage));
                continue;
            }
            if (obj instanceof Exitprogtype) {
                ((Exitprogtype)obj).setName(StringUtils.parseHexString((String)((Exitprogtype)obj).getName(), (String)codepage));
                continue;
            }
            if (obj instanceof Symboltype) {
                ((Symboltype)obj).setName(StringUtils.parseHexString((String)((Symboltype)obj).getName(), (String)codepage));
                ((Symboltype)obj).setHeading(StringUtils.parseHexString((String)((Symboltype)obj).getHeading(), (String)codepage));
                continue;
            }
            if (obj instanceof Translatetype) {
                ((Translatetype)obj).setDsn(StringUtils.parseHexString((String)((Translatetype)obj).getDsn(), (String)codepage));
                continue;
            }
            if (obj instanceof Criteriatype) {
                ((Criteriatype)obj).setExp(StringUtils.parseHexString((String)((Criteriatype)obj).getExp(), (String)codepage));
                continue;
            }
            if (obj instanceof Csettype) {
                ((Csettype)obj).setDesc(StringUtils.parseHexString((String)((Csettype)obj).getDesc(), (String)codepage));
                continue;
            }
            if (obj instanceof Sourcerangetype) {
                ((Sourcerangetype)obj).setFromstr(StringUtils.parseHexString((String)((Sourcerangetype)obj).getFromstr(), (String)codepage));
                ((Sourcerangetype)obj).setTostr(StringUtils.parseHexString((String)((Sourcerangetype)obj).getTostr(), (String)codepage));
                continue;
            }
            if (obj instanceof Scrambletype) {
                ((Scrambletype)obj).setODPP(StringUtils.parseHexString((String)((Scrambletype)obj).getODPP(), (String)codepage));
                continue;
            }
            if (obj instanceof Datetimetype) {
                ((Datetimetype)obj).setIform(StringUtils.parseHexString((String)((Datetimetype)obj).getIform(), (String)codepage));
                ((Datetimetype)obj).setOform(StringUtils.parseHexString((String)((Datetimetype)obj).getOform(), (String)codepage));
                ((Datetimetype)obj).setBdate(StringUtils.parseHexString((String)((Datetimetype)obj).getBdate(), (String)codepage));
                ((Datetimetype)obj).setScrstart(StringUtils.parseHexString((String)((Datetimetype)obj).getScrstart(), (String)codepage));
                ((Datetimetype)obj).setScrend(StringUtils.parseHexString((String)((Datetimetype)obj).getScrend(), (String)codepage));
                continue;
            }
            if (!(obj instanceof Valuetype)) continue;
            ((Valuetype)obj).setDsn(StringUtils.parseHexString((String)((Valuetype)obj).getDsn(), (String)codepage));
            TemplateSerializeUtils.parseStringList(((Valuetype)obj).getSval(), codepage);
        }
        TemplateSerializeUtils.parseStringList(template.getDescribe(), codepage);
    }

    public static void convertFmixIntoHex(TemplateType template, String codepage) {
        if (!template.isFmix()) {
            return;
        }
        TreeIterator iterator = template.eAllContents();
        while (iterator.hasNext()) {
            EObject obj = (EObject)iterator.next();
            if (obj instanceof Bylinetype) {
                ((Bylinetype)obj).setByval(StringUtils.convertToHex((String)((Bylinetype)obj).getByval(), (String)codepage));
                continue;
            }
            if (obj instanceof ReplaceType) {
                ((ReplaceType)obj).setRepfrom(StringUtils.convertToHex((String)((ReplaceType)obj).getRepfrom(), (String)codepage));
                ((ReplaceType)obj).setRepto(StringUtils.convertToHex((String)((ReplaceType)obj).getRepto(), (String)codepage));
                continue;
            }
            if (obj instanceof MemberType) {
                ((MemberType)obj).setSegdesc(StringUtils.convertToHex((String)((MemberType)obj).getSegdesc(), (String)codepage));
                continue;
            }
            if (obj instanceof CreateCtype) {
                ((CreateCtype)obj).setFiller(StringUtils.convertToHex((String)((CreateCtype)obj).getFiller(), (String)codepage));
                ((CreateCtype)obj).setPattern(StringUtils.convertToHex((String)((CreateCtype)obj).getPattern(), (String)codepage));
                ((CreateCtype)obj).setStart(StringUtils.convertToHex((String)((CreateCtype)obj).getStart(), (String)codepage));
                continue;
            }
            if (obj instanceof Exitprogtype) {
                ((Exitprogtype)obj).setName(StringUtils.convertToHex((String)((Exitprogtype)obj).getName(), (String)codepage));
                continue;
            }
            if (obj instanceof Symboltype) {
                ((Symboltype)obj).setName(StringUtils.convertToHex((String)((Symboltype)obj).getName(), (String)codepage));
                ((Symboltype)obj).setHeading(StringUtils.convertToHex((String)((Symboltype)obj).getHeading(), (String)codepage));
                continue;
            }
            if (obj instanceof Translatetype) {
                ((Translatetype)obj).setDsn(StringUtils.convertToHex((String)((Translatetype)obj).getDsn(), (String)codepage));
                continue;
            }
            if (obj instanceof Criteriatype) {
                ((Criteriatype)obj).setExp(StringUtils.convertToHex((String)((Criteriatype)obj).getExp(), (String)codepage));
                continue;
            }
            if (obj instanceof Csettype) {
                ((Csettype)obj).setDesc(StringUtils.convertToHex((String)((Csettype)obj).getDesc(), (String)codepage));
                continue;
            }
            if (obj instanceof Sourcerangetype) {
                ((Sourcerangetype)obj).setFromstr(StringUtils.convertToHex((String)((Sourcerangetype)obj).getFromstr(), (String)codepage));
                ((Sourcerangetype)obj).setTostr(StringUtils.convertToHex((String)((Sourcerangetype)obj).getTostr(), (String)codepage));
                continue;
            }
            if (obj instanceof Scrambletype) {
                ((Scrambletype)obj).setODPP(StringUtils.convertToHex((String)((Scrambletype)obj).getODPP(), (String)codepage));
                continue;
            }
            if (obj instanceof Datetimetype) {
                ((Datetimetype)obj).setIform(StringUtils.convertToHex((String)((Datetimetype)obj).getIform(), (String)codepage));
                ((Datetimetype)obj).setOform(StringUtils.convertToHex((String)((Datetimetype)obj).getOform(), (String)codepage));
                ((Datetimetype)obj).setBdate(StringUtils.convertToHex((String)((Datetimetype)obj).getBdate(), (String)codepage));
                ((Datetimetype)obj).setScrstart(StringUtils.convertToHex((String)((Datetimetype)obj).getScrstart(), (String)codepage));
                ((Datetimetype)obj).setScrend(StringUtils.convertToHex((String)((Datetimetype)obj).getScrend(), (String)codepage));
                continue;
            }
            if (!(obj instanceof Valuetype)) continue;
            ((Valuetype)obj).setDsn(StringUtils.convertToHex((String)((Valuetype)obj).getDsn(), (String)codepage));
            TemplateSerializeUtils.convertStringList(((Valuetype)obj).getSval(), codepage);
        }
        TemplateSerializeUtils.convertStringList(template.getDescribe(), codepage);
    }

    private static void parseStringList(EList<String> list, String codepage) {
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            list.set(iterator.nextIndex(), (Object)StringUtils.parseHexString((String)((String)iterator.next()), (String)codepage));
        }
    }

    private static void convertStringList(EList<String> list, String codepage) {
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            list.set(iterator.nextIndex(), (Object)StringUtils.convertToHex((String)((String)iterator.next()), (String)codepage));
        }
    }

    public static TemplateType load(StringBuffer xmlTemplate, IZRL aResource) throws CoreException {
        Objects.requireNonNull(xmlTemplate, "Must provide a non-null xmlTemplate.");
        return TemplateSerializeUtils.load(xmlTemplate.toString(), aResource, true);
    }

    public static StringBuffer save(TemplateType template, IZRL aResource) throws CoreException {
        Objects.requireNonNull(aResource, "Must provide a non-null aResource.");
        TemplateType newTemplate = (TemplateType)EcoreUtil.copy((EObject)template);
        TemplateSerializeUtils.convertFmixIntoHex(newTemplate, aResource.getSystem().getCodePage());
        URI uri = TemplateSerializeUtils.convertToResourceURI(aResource);
        TemplateResourceFactoryImpl factory = new TemplateResourceFactoryImpl();
        XMLResource resource = (XMLResource)factory.createResource(uri);
        resource.setEncoding(aResource.getSystem().getCodePage());
        DocumentRoot root = TemplateFactory.eINSTANCE.createDocumentRoot();
        root.setTemplate(newTemplate);
        resource.getContents().add((Object)root);
        try {
            StringWriter writer = new StringWriter();
            resource.save((Writer)writer, new HashMap());
            String newXml = TemplateSerializeUtils.removeBadXML(writer.toString());
            if (PDLoggerJhost.isTraceEnabled()) {
                logger.trace((Object)newXml);
            }
            return new StringBuffer(newXml);
        }
        catch (IOException e) {
            CoreException ce = new CoreException((IStatus)new Status(4, "com.ibm.etools.fm.core", MessageFormat.format(Messages.TemplateSerializeUtils_COULD_NOT_SAVE, uri.toString()), (Throwable)e));
            throw ce;
        }
    }

    private static String removeBadXML(String XML) {
        XML = XML.replaceFirst("xmlns\\S*\\s", "");
        XML = XML.replaceAll("\\s*<\\S*\\sxsi:nil.*/>", "");
        return XML;
    }

    public static URI convertToResourceURI(IZRL aResource) {
        Objects.requireNonNull(aResource, "Must provide a non-null IZRL.");
        String name = aResource.getFormattedName();
        if (name.startsWith("#")) {
            name = "H".concat(name);
        }
        return URI.createURI((String)(aResource.getSystem().getConnectionName() + ":" + name));
    }

    public static boolean compareXML(IFile localFile, StringBuffer xmlBuffer) throws CoreException {
        try {
            String fileXML = new String(Files.readAllBytes(localFile.getLocation().toFile().toPath()));
            return fileXML.equals(xmlBuffer.toString());
        }
        catch (IOException e) {
            CoreException ce = new CoreException((IStatus)new Status(4, "com.ibm.etools.fm.core", Messages.TemplateSerializeUtils_COULD_NOT_LOAD, (Throwable)e));
            throw ce;
        }
    }
}

