/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.template.util;

import com.ibm.etools.fm.model.template.Bylinetype;
import com.ibm.etools.fm.model.template.Criteriatype;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.LparenType;
import com.ibm.etools.fm.model.template.RparenType;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateFactory;
import com.ibm.etools.fm.model.template.TypeType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;

public class TemplateModelUtils {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String DYNAMICFIELDNAME_DEFAULTPREFIX = "@@DT";
    public static final String DYNAMICFIELDNAME_LEN = "LEN";
    public static final String DYNAMIC01FIELDNAME = "DYN01";

    public static boolean isSymbolNumeric(Symboltype symbol) {
        boolean numeric = false;
        if (symbol != null) {
            TypeType type = symbol.getType();
            numeric = type != null && (type.equals((Object)TypeType.BI) || type.equals((Object)TypeType.PD) || type.equals((Object)TypeType.ZD) || type.equals((Object)TypeType.ZE) || type.equals((Object)TypeType.FE) || type.equals((Object)TypeType.FP));
        }
        return numeric;
    }

    public static Symboltype createNewDynamicField(Layouttype layout) {
        Objects.requireNonNull(layout, "Must provide a non-null layout.");
        Symboltype symbol = TemplateFactory.eINSTANCE.createSymboltype();
        int maxRef = 0;
        int relRef = 0;
        for (Symboltype s : layout.getSymbol()) {
            maxRef = Math.max(s.getRef(), maxRef);
            relRef = Math.max(TemplateModelUtils.getRelativeReferenceOfSymbol(s), relRef);
        }
        symbol.setLvl(2);
        symbol.setName(DYNAMICFIELDNAME_DEFAULTPREFIX + String.valueOf(relRef + 1));
        symbol.setRef(maxRef + 1);
        symbol.setType(TypeType.AN);
        symbol.setStart(0);
        symbol.setLength(0);
        symbol.setSeglen(false);
        return symbol;
    }

    private static void switchSymbolsInCriteria(Layouttype layout, int sym1, int sym2) {
        Objects.requireNonNull(layout, "Must provide a non-null layout.");
        for (Criteriatype c : layout.getCriteria()) {
            if (!c.isByfield()) continue;
            for (Bylinetype line : c.getByline()) {
                if (line.getSym() == sym1) {
                    line.setSym(sym2);
                    continue;
                }
                if (line.getSym() != sym2) continue;
                line.setSym(sym1);
            }
        }
    }

    public static int moveDynamicFieldUp(Layouttype layout, Symboltype field, IPDHost pdHost) {
        Objects.requireNonNull(layout, "Must provide a non-null layout.");
        int fieldIndex = layout.getSymbol().indexOf((Object)field);
        int prevIndex = fieldIndex - 1;
        if (prevIndex >= 1) {
            Symboltype prevField = (Symboltype)layout.getSymbol().get(prevIndex);
            if (prevField.getLvl() == 2) {
                int fieldRef = field.getRef();
                int prevRef = prevField.getRef();
                field.setRef(prevRef);
                prevField.setRef(fieldRef);
                TemplateModelUtils.switchSymbolsInCriteria(layout, fieldRef, prevRef);
                if (field.getName(pdHost).equals(DYNAMICFIELDNAME_DEFAULTPREFIX + String.valueOf(TemplateModelUtils.getRelativeReferenceOfSymbol(field) + 1))) {
                    field.setName(DYNAMICFIELDNAME_DEFAULTPREFIX + String.valueOf(TemplateModelUtils.getRelativeReferenceOfSymbol(field)));
                }
                if (prevField.getName(pdHost).equals(DYNAMICFIELDNAME_DEFAULTPREFIX + String.valueOf(TemplateModelUtils.getRelativeReferenceOfSymbol(prevField) - 1))) {
                    prevField.setName(DYNAMICFIELDNAME_DEFAULTPREFIX + String.valueOf(TemplateModelUtils.getRelativeReferenceOfSymbol(prevField)));
                }
                layout.getSymbol().move(fieldIndex, prevIndex);
                TemplateModelUtils.updateDynamicFieldStartAndLength(layout);
            }
            return prevIndex;
        }
        return fieldIndex;
    }

    public static int moveDynamicFieldDown(Layouttype layout, Symboltype field, IPDHost pdHost) {
        Objects.requireNonNull(layout, "Must provide a non-null layout.");
        int fieldIndex = layout.getSymbol().indexOf((Object)field);
        if (fieldIndex >= 0) {
            int nextIndex = fieldIndex + 1;
            if (nextIndex < layout.getSymbol().size()) {
                Symboltype nextField = (Symboltype)layout.getSymbol().get(nextIndex);
                if (nextField.getLvl() == 2) {
                    int fieldRef = field.getRef();
                    int nextRef = nextField.getRef();
                    field.setRef(nextRef);
                    nextField.setRef(fieldRef);
                    TemplateModelUtils.switchSymbolsInCriteria(layout, fieldRef, nextRef);
                    if (field.getName(pdHost).equals(DYNAMICFIELDNAME_DEFAULTPREFIX + String.valueOf(TemplateModelUtils.getRelativeReferenceOfSymbol(field) - 1))) {
                        field.setName(DYNAMICFIELDNAME_DEFAULTPREFIX + String.valueOf(TemplateModelUtils.getRelativeReferenceOfSymbol(field)));
                    }
                    if (nextField.getName(pdHost).equals(DYNAMICFIELDNAME_DEFAULTPREFIX + String.valueOf(TemplateModelUtils.getRelativeReferenceOfSymbol(nextField) + 1))) {
                        nextField.setName(DYNAMICFIELDNAME_DEFAULTPREFIX + String.valueOf(TemplateModelUtils.getRelativeReferenceOfSymbol(nextField)));
                    }
                    layout.getSymbol().move(nextIndex, fieldIndex);
                    TemplateModelUtils.updateDynamicFieldStartAndLength(layout);
                }
                return nextIndex;
            }
            return fieldIndex;
        }
        return 0;
    }

    protected static boolean justLParen(Bylinetype line) {
        boolean rightOn;
        Objects.requireNonNull(line, "Must provide a non-null line.");
        boolean leftOn = line.isSetLparen() && line.getLparen().getValue() == 0;
        boolean bl = rightOn = line.isSetRparen() && line.getRparen().getValue() == 0;
        return leftOn && !rightOn;
    }

    protected static boolean justRParen(Bylinetype line) {
        boolean rightOn;
        Objects.requireNonNull(line, "Must provide a non-null line.");
        boolean leftOn = line.isSetLparen() && line.getLparen().getValue() == 0;
        boolean bl = rightOn = line.isSetRparen() && line.getRparen().getValue() == 0;
        return !leftOn && rightOn;
    }

    /*
     * Unable to fully structure code
     */
    public static void removeDynamicFieldFromLayout(Layouttype layout, Symboltype field, IPDHost pdHost) {
        block14: {
            Objects.requireNonNull(layout, "Must provide a non-null layout.");
            Objects.requireNonNull(field, "Must provide a non-null field.");
            deletedFieldRef = field.getRef();
            if (!layout.getSymbol().contains((Object)field)) break block14;
            layout.getSymbol().remove((Object)field);
            for (Symboltype s : layout.getSymbol()) {
                if (s.getRef() <= deletedFieldRef) continue;
                oldref = s.getRef();
                newref = oldref - 1;
                s.setRef(newref);
                oldName = s.getName(pdHost);
                if (!oldName.equals("@@DT" + String.valueOf(TemplateModelUtils.getRelativeReferenceOfSymbol(s) + 1))) continue;
                s.setName("@@DT" + String.valueOf(TemplateModelUtils.getRelativeReferenceOfSymbol(s)));
            }
            removeList = new ArrayList<Criteriatype>();
            for (Criteriatype c : layout.getCriteria()) {
                block13: {
                    block15: {
                        if (!c.isByfield()) continue;
                        removeBylineList = new ArrayList<Bylinetype>();
                        refactorCriteria = false;
                        for (Bylinetype byline : c.getByline()) {
                            if (byline.getSym() == deletedFieldRef) {
                                removeBylineList.add(byline);
                                if (!byline.isSetOper()) continue;
                                refactorCriteria = true;
                                continue;
                            }
                            if (byline.getSym() <= deletedFieldRef) continue;
                            byline.setSym(byline.getSym() - 1);
                        }
                        if (!refactorCriteria) break block15;
                        sorted = new ArrayList<Bylinetype>((Collection<Bylinetype>)c.getByline());
                        Collections.sort(sorted, new Comparator<Bylinetype>(){

                            @Override
                            public int compare(Bylinetype o1, Bylinetype o2) {
                                if (o1.getSeq() > o2.getSeq()) {
                                    return 1;
                                }
                                if (o1.getSeq() < o2.getSeq()) {
                                    return -1;
                                }
                                return 0;
                            }
                        });
                        li = sorted.listIterator();
                        seqDecAmt = 0;
                        while (li.hasNext()) {
                            block16: {
                                cur = li.next();
                                cur.setSeq(cur.getSeq() - seqDecAmt);
                                if (!removeBylineList.contains(cur)) continue;
                                li.remove();
                                c.getByline().remove((Object)cur);
                                ++seqDecAmt;
                                if (!TemplateModelUtils.justLParen(cur)) break block16;
                                if (!li.hasNext()) ** GOTO lbl58
                                next = li.next();
                                li.previous();
                                if (TemplateModelUtils.justLParen(next) || !next.isSetOper()) {
                                    removeList.add(c);
                                } else {
                                    next.setLparen(LparenType.__);
                                    next.unsetRparen();
                                    continue;
lbl58:
                                    // 1 sources

                                    removeList.add(c);
                                }
                                break block13;
                            }
                            if (!TemplateModelUtils.justRParen(cur) || !li.hasPrevious()) continue;
                            prev = li.previous();
                            li.next();
                            if (TemplateModelUtils.justRParen(prev) || !prev.isSetOper()) {
                                removeList.add(c);
                                break block13;
                            }
                            prev.setRparen(RparenType.__);
                            prev.unsetLparen();
                        }
                        break block13;
                    }
                    if (removeBylineList.size() > 0) {
                        c.getByline().removeAll(removeBylineList);
                        sorted = new ArrayList<Bylinetype>((Collection<Bylinetype>)c.getByline());
                        Collections.sort(sorted, new Comparator<Bylinetype>(){

                            @Override
                            public int compare(Bylinetype o1, Bylinetype o2) {
                                if (o1.getSeq() > o2.getSeq()) {
                                    return 1;
                                }
                                if (o1.getSeq() < o2.getSeq()) {
                                    return -1;
                                }
                                return 0;
                            }
                        });
                        i = 0;
                        while (i < sorted.size()) {
                            cur = sorted.get(i);
                            if (i != cur.getSeq()) {
                                cur.setSeq(i);
                            }
                            ++i;
                        }
                    }
                }
                operCount = 0;
                for (Bylinetype line : c.getByline()) {
                    if (!line.isSetOper()) continue;
                    ++operCount;
                }
                if (operCount != 0) continue;
                removeList.add(c);
            }
            for (Criteriatype ct : removeList) {
                ct.unsetByfield();
                ct.setExp(null);
                ct.getByline().clear();
            }
            TemplateModelUtils.updateDynamicFieldStartAndLength(layout);
        }
    }

    public static void updateChangedDynamicField(Layouttype layout, Symboltype field, IPDHost pdHost) {
        Objects.requireNonNull(layout, "Must provide a non-null layout.");
        Objects.requireNonNull(field, "Must provide a non-null field.");
        if (TypeType.VB.equals((Object)field.getType()) || TypeType.VC.equals((Object)field.getType()) || TypeType.VD.equals((Object)field.getType()) || TypeType.VG.equals((Object)field.getType())) {
            Symboltype prevField = null;
            int index = layout.getSymbol().indexOf((Object)field);
            if (index >= 1) {
                prevField = (Symboltype)layout.getSymbol().get(index - 1);
            }
            if (!(prevField != null && TypeType.BI.equals((Object)prevField.getType()) && 2 == prevField.getLength() || field.getLength() < 2)) {
                Symboltype lengthField = TemplateModelUtils.createNewDynamicField(layout);
                lengthField.setName(DYNAMICFIELDNAME_LEN);
                lengthField.setType(TypeType.BI);
                if (field.isOffset()) {
                    lengthField.setOffset(true);
                    lengthField.setStart(0);
                } else {
                    lengthField.setStart(field.getStart());
                }
                lengthField.setLength(2);
                if (!field.isOffset()) {
                    field.setStart(field.getStart() + 2);
                }
                field.setLength(field.getLength() - 2);
                layout.getSymbol().add((Object)lengthField);
                while (layout.getSymbol().indexOf((Object)lengthField) > index) {
                    TemplateModelUtils.moveDynamicFieldUp(layout, lengthField, pdHost);
                }
            }
        }
        if (field.getName(null) == null || field.getName(null).isEmpty()) {
            field.setName(DYNAMICFIELDNAME_DEFAULTPREFIX + String.valueOf(TemplateModelUtils.getRelativeReferenceOfSymbol(field)));
        }
        if (TemplateModelUtils.isSymbolNumeric(field)) {
            field.setCreateC(null);
            field.setCreateDT(null);
        } else {
            field.setCreateN(null);
            field.setCreateDT(null);
        }
        TemplateModelUtils.updateDynamicFieldStartAndLength(layout);
    }

    public static void addDynamicFieldToLayout(Layouttype layout, Symboltype field, IPDHost pdHost) {
        Objects.requireNonNull(layout, "Must provide a non-null layout.");
        Objects.requireNonNull(field, "Must provide a non-null field.");
        if (TypeType.VB.equals((Object)field.getType()) || TypeType.VC.equals((Object)field.getType()) || TypeType.VD.equals((Object)field.getType()) || TypeType.VG.equals((Object)field.getType())) {
            Symboltype lastField;
            Symboltype symboltype = lastField = layout.getSymbol().isEmpty() ? null : (Symboltype)layout.getSymbol().get(layout.getSymbol().size() - 1);
            if (!(lastField != null && TypeType.BI.equals((Object)lastField.getType()) && 2 == lastField.getLength() || field.getLength() < 2)) {
                Symboltype lengthField = TemplateModelUtils.createNewDynamicField(layout);
                lengthField.setName(DYNAMICFIELDNAME_LEN);
                lengthField.setType(TypeType.BI);
                if (field.isOffset()) {
                    lengthField.setOffset(true);
                    lengthField.setStart(0);
                } else {
                    lengthField.setStart(field.getStart());
                }
                lengthField.setLength(2);
                int oldref = field.getRef();
                int newref = lengthField.getRef() + 1;
                field.setRef(newref);
                if (!field.isOffset()) {
                    field.setStart(field.getStart() + 2);
                }
                field.setLength(field.getLength() - 2);
                String oldName = field.getName(pdHost);
                if (oldName.equals(DYNAMICFIELDNAME_DEFAULTPREFIX + String.valueOf(oldref))) {
                    field.setName(DYNAMICFIELDNAME_DEFAULTPREFIX + String.valueOf(newref));
                }
                layout.getSymbol().add((Object)lengthField);
            }
        }
        layout.getSymbol().add((Object)field);
        if (field.getName(null) == null || field.getName(null).isEmpty()) {
            field.setName(DYNAMICFIELDNAME_DEFAULTPREFIX + String.valueOf(TemplateModelUtils.getRelativeReferenceOfSymbol(field)));
        }
        TemplateModelUtils.updateDynamicFieldStartAndLength(layout);
    }

    public static void updateDynamicFieldStartAndLength(Layouttype layout) {
        Objects.requireNonNull(layout, "Must provide a non-null layout.");
        if (!layout.getSymbol().isEmpty()) {
            Symboltype lvl01Field = (Symboltype)layout.getSymbol().get(0);
            if (lvl01Field.getLvl() != 1) {
                lvl01Field = null;
            }
            int totalLength = 0;
            for (Symboltype s : layout.getSymbol()) {
                if (s.getLvl() != 2) continue;
                int endOfField = TemplateModelUtils.getStartPositionOfSymbol(s) + s.getLength() - 1;
                totalLength = Math.max(totalLength, endOfField);
            }
            if (lvl01Field != null) {
                lvl01Field.setLength(totalLength);
            }
        }
    }

    public static int getStartPositionOfSymbol(Symboltype symbol) {
        Symboltype prev;
        Layouttype layout;
        int prevRef;
        Objects.requireNonNull(symbol, "Must provide a non-null symbol.");
        int start = symbol.getStart();
        if (symbol.isOffset() && (prevRef = symbol.getRef() - 1) > 0 && (layout = TemplateModelUtils.getParentLayout(symbol)) != null && (prev = TemplateModelUtils.getSymbol(layout, prevRef)) != null) {
            start = prev.getLvl() == 1 ? ++start : start + TemplateModelUtils.getStartPositionOfSymbol(prev) + prev.getLength();
        }
        return start;
    }

    public static int getRelativeReferenceOfSymbol(Symboltype symbol) {
        Objects.requireNonNull(symbol, "Must provide a non-null symbol.");
        int ref = symbol.getRef();
        Layouttype layout = TemplateModelUtils.getParentLayout(symbol);
        if (layout != null) {
            ref = ref - layout.getId() + 1;
        }
        return ref;
    }

    public static Layouttype getParentLayout(Symboltype symbol) {
        Layouttype layout = null;
        Symboltype o = symbol;
        while (o != null) {
            if (o instanceof Layouttype) {
                layout = (Layouttype)((Object)o);
                break;
            }
            o = o.eContainer();
        }
        return layout;
    }

    public static Symboltype getSymbol(Layouttype layout, int ref) {
        Objects.requireNonNull(layout, "Must provide a non-null layout.");
        Symboltype symbol = null;
        for (Symboltype s : layout.getSymbol()) {
            if (s.getRef() != ref) continue;
            symbol = s;
            break;
        }
        return symbol;
    }

    public static String getLayoutName(Layouttype layout) {
        Objects.requireNonNull(layout, "Must provide a non-null layout.");
        String name = null;
        for (Symboltype s : layout.getSymbol()) {
            name = s.getName(null);
            if (s.getLvl() == 1) break;
        }
        return name;
    }

    public static int getLayout01Ref(Layouttype layout) {
        Objects.requireNonNull(layout, "Must provide a non-null layout.");
        int layout01Ref = -1;
        for (Symboltype s : layout.getSymbol()) {
            if (s.getLvl() != 1) continue;
            layout01Ref = s.getRef();
            break;
        }
        return layout01Ref;
    }
}

