/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.template;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ActType implements Enumerator
{
    FX(0, "FX", "FX"),
    RA(1, "RA", "RA"),
    RO(2, "RO", "RO"),
    RP(3, "RP", "RP"),
    SL(4, "SL", "SL"),
    SR(5, "SR", "SR"),
    TL(6, "TL", "TL"),
    TR(7, "TR", "TR"),
    WV(8, "WV", "WV");

    public static final int FX_VALUE = 0;
    public static final int RA_VALUE = 1;
    public static final int RO_VALUE = 2;
    public static final int RP_VALUE = 3;
    public static final int SL_VALUE = 4;
    public static final int SR_VALUE = 5;
    public static final int TL_VALUE = 6;
    public static final int TR_VALUE = 7;
    public static final int WV_VALUE = 8;
    private static final ActType[] VALUES_ARRAY;
    public static final List<ActType> VALUES;
    private final int value;
    private final String name;
    private final String literal;
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    static {
        VALUES_ARRAY = new ActType[]{FX, RA, RO, RP, SL, SR, TL, TR, WV};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ActType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActType get(int value) {
        switch (value) {
            case 0: {
                return FX;
            }
            case 1: {
                return RA;
            }
            case 2: {
                return RO;
            }
            case 3: {
                return RP;
            }
            case 4: {
                return SL;
            }
            case 5: {
                return SR;
            }
            case 6: {
                return TL;
            }
            case 7: {
                return TR;
            }
            case 8: {
                return WV;
            }
        }
        return null;
    }

    private ActType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

