/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.formatted.util;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.model.formatted.DocumentRoot;
import com.ibm.etools.fm.model.formatted.EditType;
import com.ibm.etools.fm.model.formatted.FMNXEDITFactory;
import com.ibm.etools.fm.model.formatted.util.FMNXEDITResourceFactoryImpl;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.xml.sax.InputSource;

public class EditorDataSerializeUtils {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(EditorDataSerializeUtils.class);

    public static EditType load(InputStream inStream, IZRL edittedResource) throws CoreException {
        EditType edit = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        FMNXEDITResourceFactoryImpl factory = new FMNXEDITResourceFactoryImpl();
        XMLResource resource = factory.createResource(TemplateSerializeUtils.convertToResourceURI(edittedResource));
        resourceSet.getResources().add((Object)resource);
        try {
            Map loadOptions = resourceSet.getLoadOptions();
            resource.load(inStream, loadOptions);
        }
        catch (IOException e) {
            CoreException ce = new CoreException((IStatus)new Status(4, "com.ibm.etools.fm.core", MessageFormat.format(Messages.EditorDataSerializeUtils_COULD_NOT_LOAD, edittedResource.getFormattedName()), (Throwable)e));
            throw ce;
        }
        for (Resource.Diagnostic diagnostic : resource.getErrors()) {
            logger.error((Object)MessageFormat.format("An error was detected while loading {0}: {1} : Line {2} Column {3}.", TemplateSerializeUtils.convertToResourceURI(edittedResource).toString(), diagnostic.getMessage(), String.valueOf(diagnostic.getLine()), String.valueOf(diagnostic.getColumn())));
        }
        if (resource.getContents().get(0) instanceof DocumentRoot) {
            edit = ((DocumentRoot)resource.getContents().get(0)).getEdit();
        }
        return edit;
    }

    public static EditType load(StringBuffer xmlRecords, IZRL edittedResource) throws CoreException {
        return EditorDataSerializeUtils.load(new InputSource(new StringReader(xmlRecords.toString())), edittedResource);
    }

    public static EditType load(StringBuilder xmlRecords, IZRL edittedResource) throws CoreException {
        return EditorDataSerializeUtils.load(new InputSource(new StringReader(xmlRecords.toString())), edittedResource);
    }

    private static EditType load(InputSource input, IZRL edittedResource) throws CoreException {
        Objects.requireNonNull(edittedResource, "Must provide a non-null IZRL.");
        EditType edit = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        FMNXEDITResourceFactoryImpl factory = new FMNXEDITResourceFactoryImpl();
        XMLResource resource = factory.createResource(TemplateSerializeUtils.convertToResourceURI(edittedResource));
        resourceSet.getResources().add((Object)resource);
        try {
            Map loadOptions = resourceSet.getLoadOptions();
            resource.load(input, loadOptions);
        }
        catch (IOException e) {
            CoreException ce = new CoreException((IStatus)new Status(4, "com.ibm.etools.fm.core", MessageFormat.format(Messages.EditorDataSerializeUtils_COULD_NOT_LOAD, edittedResource.getFormattedName()), (Throwable)e));
            throw ce;
        }
        for (Resource.Diagnostic diagnostic : resource.getErrors()) {
            logger.error((Object)MessageFormat.format("An error was detected while loading {0}: {1} : Line {2} Column {3}.", TemplateSerializeUtils.convertToResourceURI(edittedResource).toString(), diagnostic.getMessage(), String.valueOf(diagnostic.getLine()), String.valueOf(diagnostic.getColumn())));
        }
        if (resource.getContents().get(0) instanceof DocumentRoot) {
            edit = ((DocumentRoot)resource.getContents().get(0)).getEdit();
        }
        return edit;
    }

    public static String editToString(EditType edit, IZRL edittedResource) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        FMNXEDITResourceFactoryImpl factory = new FMNXEDITResourceFactoryImpl();
        XMLResource resource = factory.createResource(TemplateSerializeUtils.convertToResourceURI(edittedResource));
        resourceSet.getResources().add((Object)resource);
        DocumentRoot root = FMNXEDITFactory.eINSTANCE.createDocumentRoot();
        root.setEdit(edit);
        resource.getContents().add((Object)root);
        StringWriter writer = new StringWriter();
        resource.save((Writer)writer, new HashMap());
        return writer.toString();
    }
}

