/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.fm;

import com.ibm.etools.fm.model.ByteUtilities;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import com.ibm.etools.fm.model.exception.FMIParseException;
import com.ibm.etools.fm.model.fm.Segment;
import java.nio.ByteBuffer;

public class SourceStatementSegment
extends Segment {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private int sourceId;
    private short sourceLength;
    private static final int FREE_SPACE = 8;
    private String sourceStatement;

    SourceStatementSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
    }

    @Override
    protected void parse(ByteBuffer buf) throws FMIParseException {
        this.sourceId = buf.getInt();
        this.sourceLength = buf.getShort();
        buf.position(buf.position() + 8);
        try {
            if (this.sourceLength > 0) {
                this.sourceStatement = ByteUtilities.getString(buf, this.sourceLength);
            }
        }
        catch (FMIConversionException ce) {
            throw new FMIParseException();
        }
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public short getSourceLength() {
        return this.sourceLength;
    }

    public String getSourceStatement() {
        return this.sourceStatement;
    }

    @Override
    public byte[] toBinary(String hostCp) throws FMIParseException {
        return null;
    }

    @Override
    public short calculateBinaryLength() {
        return -1;
    }

    @Override
    public int getType() {
        return 25;
    }
}

