/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.fm;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.model.exception.FMIParseException;
import com.ibm.etools.fm.model.fm.AttributeSegment;
import com.ibm.etools.fm.model.fm.CompileOptionsSegment;
import com.ibm.etools.fm.model.fm.CopyMemberSegment;
import com.ibm.etools.fm.model.fm.DataSetNameSegment;
import com.ibm.etools.fm.model.fm.DynamicTemplateExpressionSegment;
import com.ibm.etools.fm.model.fm.FieldMappingSegment;
import com.ibm.etools.fm.model.fm.IdentificationCriteriaSegment;
import com.ibm.etools.fm.model.fm.MainFieldDescriptorSegment;
import com.ibm.etools.fm.model.fm.PrintHeadingSegment;
import com.ibm.etools.fm.model.fm.SavedElementsSegment;
import com.ibm.etools.fm.model.fm.Segment;
import com.ibm.etools.fm.model.fm.SegmentHeader;
import com.ibm.etools.fm.model.fm.SelectionCriteriaSegment;
import com.ibm.etools.fm.model.fm.SourceStatementSegment;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Objects;

public class SegmentFactory {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(SegmentFactory.class);
    private static final short DB2_COLUMNS = 3;
    private static final short COPY_MEMBER = 10;
    private static final short DATASET_NAME = 11;
    private static final short OBJECT_MEMBER_COMMENTS = 12;
    private static final short IMS_DATASET_NAME_MEMBER = 13;
    private static final short IMS_CRITERIA = 14;
    private static final short IMS_DBD = 15;
    private static final short IMS_LAST_UPDATE = 16;
    private static final short MULTIPLE_COPYBOOKS = 17;
    private static final short COMPILE_OPTIONS = 18;
    private static final short MAIN_FIELD_DESCRIPTOR = 20;
    private static final short SELECTION_CRITERIA = 21;
    private static final short IDENTIFICATION_CRITERIA = 22;
    private static final short DB2_SELECTION_CRITERIA = 23;
    private static final short FIELD_MAPPING = 24;
    private static final short SOURCE_STATEMENT = 25;
    private static final short DYNAMIC_TEMPLATE_EXPRESSION = 26;
    private static final short DYNAMIC_TEMPLATE_EXPRESSION_2 = 27;
    private static final short IMS_EXTRACT = 28;
    private static final short PRINT_HEADING = 30;
    private static final short SAVED_ELEMENTS = 31;
    public static final short ATTRIBUTE_INFORMATION = 40;
    private static final short DB2_ISQ_HEADER = 41;
    private static final short SCRAMBLE_VALUE_OR_RANGE = 42;
    private static final short SCRAMBLE_EXIT = 43;
    private static final short SAVE_FILE_CONTROL = 99;

    public static Segment buildSegment(SegmentHeader header, ByteBuffer buf, Object[] parameters) throws FMIParseException {
        Objects.requireNonNull(header, "Must specify a non-null header.");
        logger.debug((Object)("Segment type: " + header.getType()));
        switch (header.getType()) {
            case 3: {
                throw new FMIParseException(Messages.SegmentFactory_ERROR_DB2NOT_SUPPORTED);
            }
            case 10: {
                return new CopyMemberSegment(buf);
            }
            case 11: {
                return new DataSetNameSegment(buf);
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 28: 
            case 41: {
                throw new FMIParseException(Messages.SegmentFactory_TEMPLATE_NOT_SUPPORTED);
            }
            case 40: {
                return new AttributeSegment(buf, parameters);
            }
            case 26: {
                return new DynamicTemplateExpressionSegment(buf);
            }
            case 27: {
                throw new FMIParseException(Messages.SegmentFactory_TEMPLATE_NOT_SUPPORTED);
            }
            case 20: {
                return new MainFieldDescriptorSegment(buf);
            }
            case 21: {
                return new SelectionCriteriaSegment(buf);
            }
            case 22: {
                return new IdentificationCriteriaSegment(buf);
            }
            case 24: {
                return new FieldMappingSegment(buf);
            }
            case 25: {
                return new SourceStatementSegment(buf);
            }
            case 30: {
                return new PrintHeadingSegment(buf);
            }
            case 31: {
                return new SavedElementsSegment(buf);
            }
            case 99: {
                throw new FMIParseException(Messages.SegmentFactory_INVALID_SEGMENT);
            }
            case 42: 
            case 43: {
                throw new FMIParseException(Messages.SegmentFactory_SCRAMBLE_NOT_SUPPORTED);
            }
            case 18: {
                return new CompileOptionsSegment(buf);
            }
        }
        throw new FMIParseException(MessageFormat.format(Messages.SegmentFactory_FOUND_BUT_NOT_PARSED, header.getType()));
    }
}

