/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.fm;

import java.nio.ByteBuffer;

public class SecondarySegmentHeader {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int FREE = 2;
    private short blockLen;
    private short numChain;
    private short numRefSymbols;
    private short firstSymbolOffset;
    private int symbol;
    private short freeAreaLen;
    private int singleCurLine;
    public static final int SIZE = 20;

    public SecondarySegmentHeader(ByteBuffer buf) {
        this.blockLen = buf.getShort();
        this.numChain = buf.getShort();
        this.numRefSymbols = buf.getShort();
        this.firstSymbolOffset = buf.getShort();
        this.symbol = buf.getInt();
        this.freeAreaLen = buf.getShort();
        byte[] freeArea = new byte[2];
        buf.get(freeArea, 0, 2);
        this.singleCurLine = buf.getInt();
    }

    public short getBlockLen() {
        return this.blockLen;
    }

    public void setBlockLen(short blockLen) {
        this.blockLen = blockLen;
    }

    public short getFirstSymbolOffset() {
        return this.firstSymbolOffset;
    }

    public short getFreeAreaLen() {
        return this.freeAreaLen;
    }

    public short getNumChain() {
        return this.numChain;
    }

    public void setNumChain(short numChain) {
        this.numChain = numChain;
    }

    public short getNumRefSymbols() {
        return this.numRefSymbols;
    }

    public int getSingleCurLine() {
        return this.singleCurLine;
    }

    public int getSymbol() {
        return this.symbol;
    }

    public byte[] toBinary(String hostCp) {
        ByteBuffer result = ByteBuffer.allocate(20);
        result.putShort(this.blockLen);
        result.putShort(this.numChain);
        result.putShort(this.numRefSymbols);
        result.putShort(this.firstSymbolOffset);
        result.putInt(this.symbol);
        result.putShort(this.freeAreaLen);
        result.put(new byte[2]);
        result.putInt(this.singleCurLine);
        return result.array();
    }
}

