/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.fm;

import com.ibm.etools.fm.model.ByteUtilities;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import com.ibm.etools.fm.model.exception.FMIParseException;
import com.ibm.etools.fm.model.fm.Segment;
import java.nio.ByteBuffer;

public class SavedElementsSegment
extends Segment {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private byte fieldType;
    private byte signField;
    private byte scaleFactor;
    private byte precision;
    private String fill;
    private static final int FILL_LENGTH = 8;

    public SavedElementsSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
    }

    @Override
    protected void parse(ByteBuffer buf) throws FMIParseException {
        this.fieldType = buf.get();
        this.signField = buf.get();
        this.scaleFactor = buf.get();
        this.precision = buf.get();
        try {
            this.fill = ByteUtilities.getString(buf, 8);
        }
        catch (FMIConversionException ce) {
            throw new FMIParseException();
        }
    }

    public byte getFieldType() {
        return this.fieldType;
    }

    public String getFill() {
        return this.fill;
    }

    public byte getPrecision() {
        return this.precision;
    }

    public byte getScaleFactor() {
        return this.scaleFactor;
    }

    public byte getSignField() {
        return this.signField;
    }

    @Override
    public byte[] toBinary(String hostCp) throws FMIParseException {
        return null;
    }

    @Override
    public short calculateBinaryLength() {
        return -1;
    }

    @Override
    public int getType() {
        return 31;
    }
}

