/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.fm;

import com.ibm.etools.fm.model.fm.Symbol;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class RelocationTable {
    public static final int TYPE_STANDARD = 0;
    public static final int TYPE_LANGUAGE_TMPL = 0;
    private short headerLen;
    private short tableItemLen;
    private int blockLen;
    private int symbolCount;
    private int rexxOffset;
    private int rexxLen;
    private String date;
    private String time;
    private DataSetType type;
    private TemplateLanguage lang;
    private boolean dynamicTemplate;
    private boolean imsExtended;
    private boolean segmented;
    private int imsRexxOffset;
    private int imsRexxLen;
    private int db2ColumnsOffset;
    private int expressionOffset;
    private int expressionLen;
    private ArrayList<Symbol> symbols;
    private byte[] headerBytes;

    public RelocationTable(ByteBuffer byteBuf) {
        this.fillHeader(byteBuf);
        this.fillSymbolTable(byteBuf);
    }

    private void fillHeader(ByteBuffer byteBuf) {
        int startPosition = byteBuf.position();
        this.headerLen = byteBuf.getShort();
        this.tableItemLen = byteBuf.getShort();
        this.blockLen = byteBuf.getInt();
        this.symbolCount = byteBuf.getInt();
        this.rexxOffset = byteBuf.getInt();
        this.rexxLen = byteBuf.getInt();
        byteBuf.position(startPosition);
        this.headerBytes = new byte[this.headerLen];
        byteBuf.get(this.headerBytes);
        byteBuf.position(startPosition + this.headerLen);
    }

    private byte[] buildHeader() {
        return this.headerBytes;
    }

    private void fillSymbolTable(ByteBuffer byteBuf) {
        this.symbols = new ArrayList(this.symbolCount);
        int i = 0;
        while (i < this.symbolCount) {
            Symbol s = new Symbol(byteBuf);
            this.symbols.add(s);
            ++i;
        }
    }

    public int getBlockLen() {
        return this.blockLen;
    }

    public String getDate() {
        return this.date;
    }

    public int getDb2ColumnsOffset() {
        return this.db2ColumnsOffset;
    }

    public boolean isDynamicTemplate() {
        return this.dynamicTemplate;
    }

    public int getExpressionLen() {
        return this.expressionLen;
    }

    public int getExpressionOffset() {
        return this.expressionOffset;
    }

    public boolean isImsExtended() {
        return this.imsExtended;
    }

    public int getImsRexxLen() {
        return this.imsRexxLen;
    }

    public int getImsRexxOffset() {
        return this.imsRexxOffset;
    }

    public TemplateLanguage getLang() {
        return this.lang;
    }

    public int getRexxLen() {
        return this.rexxLen;
    }

    public int getRexxOffset() {
        return this.rexxOffset;
    }

    public boolean isSegmented() {
        return this.segmented;
    }

    public int getSymbolCount() {
        return this.symbolCount;
    }

    public ArrayList<Symbol> getSymbols() {
        return this.symbols;
    }

    public String getTime() {
        return this.time;
    }

    public DataSetType getType() {
        return this.type;
    }

    public byte[] toBinary() {
        int size = this.calculateLength();
        ByteBuffer result = ByteBuffer.allocate(size);
        result.put(this.buildHeader());
        result.put(this.buildSymbolTable());
        return result.array();
    }

    public byte[] buildSymbolTable() {
        ByteBuffer result = ByteBuffer.allocate(this.tableItemLen * this.symbols.size());
        for (Symbol s : this.symbols) {
            result.put(s.toBinary());
        }
        return result.array();
    }

    public int calculateLength() {
        int size = this.headerLen + this.tableItemLen * this.symbols.size();
        return size;
    }

    public static enum DataSetType {
        BASE,
        IMS,
        DB2,
        IMS_VIEW,
        IMS_CRITERIA,
        DYNAMIC;

    }

    public static enum TemplateLanguage {
        COBOL,
        PL1;

    }
}

