/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.fm;

import com.ibm.etools.fm.model.ByteUtilities;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import com.ibm.etools.fm.model.exception.FMIParseException;
import com.ibm.etools.fm.model.fm.Segment;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class PrintHeadingSegment
extends Segment {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final short SEG_TYPE = 30;
    private short headingLen;
    private byte[] heading;

    public PrintHeadingSegment() {
        this.headingLen = 0;
        this.heading = null;
    }

    PrintHeadingSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
    }

    @Override
    protected void parse(ByteBuffer buf) throws FMIParseException {
        this.headingLen = buf.getShort();
        this.heading = new byte[this.headingLen];
        buf.get(this.heading);
    }

    public byte[] getHeadingBytes() {
        return Arrays.copyOf(this.heading, this.heading.length);
    }

    public void setHeading(byte[] headingBytes) {
        this.headingLen = (short)headingBytes.length;
        this.heading = Arrays.copyOf(headingBytes, headingBytes.length);
    }

    public String getHeading() {
        ByteBuffer buf = ByteBuffer.allocate(this.heading.length);
        buf.put(this.heading);
        buf.position(0);
        try {
            if (this.headingLen > 0) {
                return ByteUtilities.getString(buf, this.heading.length);
            }
        }
        catch (FMIConversionException ce) {
            return null;
        }
        return null;
    }

    @Override
    public byte[] toBinary(String hostCp) throws FMIParseException {
        short length = this.calculateBinaryLength();
        ByteBuffer result = ByteBuffer.allocate(length);
        result.putShort(length);
        result.putShort((short)30);
        result.putShort(this.headingLen);
        result.put(this.heading);
        return result.array();
    }

    @Override
    public int getType() {
        return 30;
    }

    @Override
    public short calculateBinaryLength() {
        return (short)(6 + this.heading.length);
    }
}

