/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.fm;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.model.ByteUtilities;
import com.ibm.etools.fm.model.datatypeconverters.FMIAlphaNumericDataTypeConverter;
import com.ibm.etools.fm.model.datatypeconverters.FMIBinaryDataTypeConverter;
import com.ibm.etools.fm.model.datatypeconverters.FMIDBCSConverter;
import com.ibm.etools.fm.model.datatypeconverters.FMIExternalFloatConverter;
import com.ibm.etools.fm.model.datatypeconverters.FMIInternalFloatingPointDataTypeConverter;
import com.ibm.etools.fm.model.datatypeconverters.FMIPackedDecimalDataTypeConverter;
import com.ibm.etools.fm.model.datatypeconverters.FMIUnsignedBinaryDataTypeConverter;
import com.ibm.etools.fm.model.datatypeconverters.FMIZonedDecimalDataTypeConverter;
import com.ibm.etools.fm.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.etools.fm.model.datatypeconverters.ZonedEditedConverter;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import com.ibm.etools.fm.model.exception.FMIParseException;
import com.ibm.etools.fm.model.fm.SecondarySegmentHeader;
import com.ibm.etools.fm.model.fm.Segment;
import com.ibm.etools.fm.model.fm.SegmentFactory;
import com.ibm.etools.fm.model.fm.SegmentHeader;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;

public class MainFieldDescriptorSegment
extends Segment {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(MainFieldDescriptorSegment.class);
    private static final String DEFAULT_CODEPAGE = "IBM-037";
    private SecondarySegmentHeader secHeader;
    private static final int HEADER_SIZE = 4;
    private static final int BASE_SIZE = 76;
    private static final int SEG_TYPE = 20;
    private static final byte GROUP_BIT = 8;
    private static final byte OCCURS_BIT = 7;
    private static final byte ODO_BIT = 6;
    private static final byte EXT_DO_BIT = 5;
    private static final byte REDEFINES_BIT = 4;
    private static final byte RENAMES_BIT = 3;
    private static final byte ODO_TGT_BIT = 2;
    private static final byte VARYING_BIT = 1;
    private static final byte BINARY_BIT = 8;
    private static final byte EXTERNAL_FLOATING_BIT = 7;
    private static final byte INTERNAL_FLOATING_BIT = 6;
    private static final byte PACKED_DECIMAL_BIT = 5;
    private static final byte ZONED_DECIMAL_BIT = 4;
    private static final byte SIGNED_BIT = 3;
    private static final byte NUMERIC_EDITED_BIT = 2;
    private static final byte BIT_BIT = 1;
    private static final byte ALPHABETIC_BIT = 8;
    private static final byte ALPHANUMERIC_BIT = 7;
    private static final byte ALPHANUMERIC_EDITED_BIT = 6;
    private static final byte GROUP_CONTAINS_ODO_BIT = 5;
    private static final byte DBCS_BIT = 4;
    private static final byte GROUP_VAR_BIT = 3;
    private static final byte EGCS_BIT = 2;
    private static final byte EGCS_EDITED_BIT = 1;
    private static final byte NOT_SELECTED_BIT = 8;
    private static final byte RELOCATION_BIT = 7;
    private static final byte NO_EDIT_BIT = 6;
    private static final byte EXPRESSION_INVALID_BIT = 5;
    private static final byte SELECTED_BIT = 4;
    private static final byte ALL_ELEM_SELECTED_BIT = 3;
    private static final byte MAPPING_SEG_BIT = 2;
    private static final byte CHILD_ODO_EXISTS_BIT = 1;
    private static final byte IMS_KEY_BIT = 8;
    private static final byte IMS_INDEX_BIT = 7;
    private static final byte FROM_PL1_BIT = 6;
    private static final byte IMS_ACTIVE_BIT = 5;
    private static final byte IMS_SUBSEQUENCE_BIT = 4;
    private static final byte IMS_LENGTH_BIT = 3;
    private static final byte DB2_NO_UPDATES_BIT = 2;
    private static final byte HOLD_COLUMN_BIT = 1;
    private static final byte PL1_VARYING_BIT = 8;
    private static final byte PL1_VARYINGZ_BIT = 7;
    private static final byte PL1_DIMS_BIT = 6;
    private static final byte PL1_SIGNED_BIT = 5;
    private static final byte PL1_UNSIGNED_BIT = 4;
    private static final byte PL1_ALIGNED_BIT = 3;
    private static final byte PL1_UNALIGNED_BIT = 2;
    private static final byte PL1_MULTIPLE_DIMS_BIT = 1;
    private static final byte DB2_TIME_BIT = 8;
    private static final byte DB2_TIMESTAMP_BIT = 7;
    private static final byte DB2_DATE_BIT = 6;
    private static final byte DB2_BINARY_BIT = 5;
    private static final byte DB2_CHARACTER_BIT = 4;
    private static final byte DB2_GRAPHIC_BIT = 3;
    private static final byte DB2_ROWID_BIT = 2;
    private static final byte DB2_NULL_BIT = 1;
    private static final byte DB2_NON_UNIQUE_BIT = 8;
    private static final byte DB2_UNIQUE_BIT = 7;
    private static final byte DB2_PRIMARY_BIT = 6;
    private static final byte DB2_FOREIGN_BIT = 5;
    private static final byte DB2_CHECK_CONSTRAINT_BIT = 4;
    private static final byte DB2_ORDER_DESCENDING_BIT = 3;
    private static final byte DB2_PART_OF_KEY_BIT = 2;
    private static final byte DB2_DEF_ATTRIBUTE_BIT = 1;
    private byte levelNumber;
    private boolean isGroupItem;
    private boolean isOccursItem;
    private boolean isOccursDependingOnItem;
    private boolean dependingOnFieldIsExternal;
    private boolean hasRedefines;
    private boolean hasRenames;
    private boolean isODOTarget;
    private boolean isVaryingLength;
    private IFMIDataTypeConverter dataType;
    private boolean isSigned;
    private boolean groupContainsODO;
    private boolean isDBCS;
    private boolean groupVariableItem;
    private boolean EGCS_item;
    private boolean EGCS_edited;
    private int fieldStart;
    private int fieldLength;
    private int fieldDimensions;
    private byte signField;
    private byte justified;
    private short pictureLen;
    private int ODOvalue;
    private int curOffset;
    private int occursMin;
    private int occursMax;
    private byte scale;
    private byte precision;
    private boolean notLayoutSelected;
    private boolean relocationRequired;
    private boolean noEdit;
    private boolean expressionInvalid;
    private boolean selected;
    private boolean allElementarySelected;
    private boolean mappingSegExists;
    private boolean childODOExists;
    private boolean IMS_Key;
    private boolean IMS_Index_Search;
    private boolean fromPL1;
    private boolean IMS_Active_Index;
    private boolean IMS_Subsequence;
    private boolean isLengthField;
    private boolean DB2noUpdates;
    private boolean holdColumn;
    private boolean pl1Varying;
    private boolean pl1Varyingz;
    private boolean pl1DimsBounds;
    private boolean pl1Signed;
    private boolean pl1Unsigned;
    private boolean pl1Aligned;
    private boolean pl1Unaligned;
    private boolean pl1MultipleDims;
    private byte bitOffset;
    private short bitLen;
    private short sqlType;
    private boolean db2Time;
    private boolean db2Timestamp;
    private boolean db2Date;
    private boolean db2BinaryLob;
    private boolean db2CharacterLob;
    private boolean db2Graphic;
    private boolean db2RowId;
    private boolean db2Nullable;
    private boolean db2NonUniqueIndex;
    private boolean db2UniqueIndex;
    private boolean db2PrimaryKey;
    private boolean db2ForeignKey;
    private boolean db2CheckConstraint;
    private boolean db2OrderDescending;
    private boolean db2PartOfkey;
    private boolean db2DefAttribute;
    private short db2ColumnNumber;
    private short orderBySequenceNumber;
    private short displayOrder;
    private byte align;
    private byte pl1BinScale;
    private String name;
    private String picture;
    private int numSlackBytes = 0;
    private boolean containsUnsupportedDatatype;
    private byte db2attributes2;
    private byte db2reservedbits;
    private byte[] ni_indicator;
    private byte scramble_options;
    private byte scramble_flags;
    private byte runtime_flags;
    private byte[] reserved_bytes;
    private boolean binary;
    private boolean externalFloat;
    private boolean internalFloat;
    private boolean packedDecimal;
    private boolean zonedDecimal;
    private boolean numericEdited;
    private boolean bit;
    private boolean alphanumeric_edited;
    private boolean alphabetic;
    private boolean alphanumeric;
    private ArrayList<MainFieldChainSymbol> symbols;
    private ArrayList<Segment> associatedSegments;

    MainFieldDescriptorSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
    }

    @Override
    public void parse(ByteBuffer buf) throws FMIParseException {
        this.containsUnsupportedDatatype = false;
        this.secHeader = new SecondarySegmentHeader(buf);
        this.levelNumber = buf.get();
        this.getDataTypeFlags(buf);
        this.fieldStart = buf.getInt();
        this.fieldLength = buf.getInt();
        this.fieldDimensions = buf.getInt();
        this.signField = buf.get();
        this.justified = buf.get();
        this.pictureLen = buf.getShort();
        this.ODOvalue = buf.getInt();
        this.curOffset = buf.getInt();
        this.occursMin = buf.getInt();
        this.occursMax = buf.getInt();
        this.scale = buf.get();
        this.precision = buf.get();
        this.getMiscFlags(buf);
        this.getPL1Flags(buf);
        this.bitOffset = buf.get();
        this.bitLen = buf.getShort();
        this.sqlType = buf.getShort();
        this.getDB2Flags(buf);
        this.db2ColumnNumber = buf.getShort();
        this.orderBySequenceNumber = buf.getShort();
        this.displayOrder = buf.getShort();
        this.align = buf.get();
        this.pl1BinScale = buf.get();
        this.getChainedSymbols(buf);
        short nameLen = buf.getShort();
        try {
            this.name = ByteUtilities.getString(buf, nameLen);
            if (this.pictureLen > 0) {
                this.picture = ByteUtilities.getString(buf, this.pictureLen);
                if (this.dataType != null && this.picture != null && this.dataType instanceof FMIZonedDecimalDataTypeConverter && (this.picture.indexOf(43) >= 0 || this.picture.indexOf(45) >= 0 || this.picture.indexOf(46) >= 0)) {
                    this.dataType = ZonedEditedConverter.getInstance();
                }
            }
        }
        catch (FMIConversionException ce) {
            throw new FMIParseException();
        }
        this.getAssociatedSegments(buf);
    }

    @Override
    public byte[] toBinary(String hostCp) {
        short segLength = this.calculateBinaryLength();
        ByteBuffer result = ByteBuffer.allocate(segLength);
        result.put(new byte[4]);
        result.position(0);
        result.putShort(segLength);
        result.putShort((short)20);
        result.put(this.secHeader.toBinary(hostCp));
        result.put(this.levelNumber);
        result.put(this.buildDataTypeFlags());
        result.putInt(this.fieldStart);
        result.putInt(this.fieldLength);
        result.putInt(this.fieldDimensions);
        result.put(this.signField);
        result.put(this.justified);
        result.putShort(this.pictureLen);
        result.putInt(this.ODOvalue);
        result.putInt(this.curOffset);
        result.putInt(this.occursMin);
        result.putInt(this.occursMax);
        result.put(this.scale);
        result.put(this.precision);
        result.put(this.buildMiscFlags());
        result.put(this.buildPL1Flags());
        result.put(this.bitOffset);
        result.putShort(this.bitLen);
        result.putShort(this.sqlType);
        result.put(this.buildDB2Flags());
        result.putShort(this.db2ColumnNumber);
        result.putShort(this.orderBySequenceNumber);
        result.putShort(this.displayOrder);
        result.put(this.align);
        result.put(this.pl1BinScale);
        result.put(this.buildChainedSymbols());
        result.putShort((short)this.name.length());
        byte[] nameBytes = null;
        try {
            nameBytes = this.name.getBytes(DEFAULT_CODEPAGE);
            result.put(nameBytes);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Throwable)e);
        }
        if (this.pictureLen > 0) {
            try {
                byte[] pictureBytes = this.picture.getBytes(DEFAULT_CODEPAGE);
                result.put(pictureBytes);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Throwable)e);
            }
        }
        return result.array();
    }

    private byte[] buildDataTypeFlags() {
        ByteBuffer result = ByteBuffer.allocate(3);
        byte flag = 0;
        if (this.isGroupItem) {
            flag = ByteUtilities.setBit(flag, 8);
        }
        if (this.isOccursItem) {
            flag = ByteUtilities.setBit(flag, 7);
        }
        if (this.isOccursDependingOnItem) {
            flag = ByteUtilities.setBit(flag, 6);
        }
        if (this.dependingOnFieldIsExternal) {
            flag = ByteUtilities.setBit(flag, 5);
        }
        if (this.hasRedefines) {
            flag = ByteUtilities.setBit(flag, 4);
        }
        if (this.hasRenames) {
            flag = ByteUtilities.setBit(flag, 3);
        }
        if (this.isODOTarget) {
            flag = ByteUtilities.setBit(flag, 2);
        }
        if (this.isVaryingLength) {
            flag = ByteUtilities.setBit(flag, 1);
        }
        result.put(flag);
        byte flag2 = 0;
        if (this.binary) {
            flag2 = ByteUtilities.setBit(flag2, 8);
        }
        if (this.externalFloat) {
            flag2 = ByteUtilities.setBit(flag2, 7);
        }
        if (this.internalFloat) {
            flag2 = ByteUtilities.setBit(flag2, 6);
        }
        if (this.packedDecimal) {
            flag2 = ByteUtilities.setBit(flag2, 5);
        }
        if (this.zonedDecimal) {
            flag2 = ByteUtilities.setBit(flag2, 4);
        }
        if (this.isSigned) {
            flag2 = ByteUtilities.setBit(flag2, 3);
        }
        if (this.numericEdited) {
            flag2 = ByteUtilities.setBit(flag2, 2);
        }
        if (this.bit) {
            flag2 = ByteUtilities.setBit(flag2, 1);
        }
        result.put(flag2);
        byte flag3 = 0;
        if (this.alphabetic) {
            flag3 = ByteUtilities.setBit(flag3, 8);
        }
        if (this.alphanumeric) {
            flag3 = ByteUtilities.setBit(flag3, 7);
        }
        if (this.alphanumeric_edited) {
            flag3 = ByteUtilities.setBit(flag3, 6);
        }
        if (this.groupContainsODO) {
            flag3 = ByteUtilities.setBit(flag3, 5);
        }
        if (this.isDBCS) {
            flag3 = ByteUtilities.setBit(flag3, 4);
        }
        if (this.groupVariableItem) {
            flag3 = ByteUtilities.setBit(flag3, 3);
        }
        if (this.EGCS_item) {
            flag3 = ByteUtilities.setBit(flag3, 2);
        }
        if (this.EGCS_edited) {
            flag3 = ByteUtilities.setBit(flag3, 1);
        }
        result.put(flag3);
        return result.array();
    }

    private byte[] buildMiscFlags() {
        ByteBuffer result = ByteBuffer.allocate(2);
        byte flag = 0;
        if (this.notLayoutSelected) {
            flag = ByteUtilities.setBit(flag, 8);
        }
        if (this.relocationRequired) {
            flag = ByteUtilities.setBit(flag, 7);
        }
        if (this.noEdit) {
            flag = ByteUtilities.setBit(flag, 6);
        }
        if (this.expressionInvalid) {
            flag = ByteUtilities.setBit(flag, 5);
        }
        if (this.selected) {
            flag = ByteUtilities.setBit(flag, 4);
        }
        if (this.allElementarySelected) {
            flag = ByteUtilities.setBit(flag, 3);
        }
        if (this.mappingSegExists) {
            flag = ByteUtilities.setBit(flag, 2);
        }
        if (this.childODOExists) {
            flag = ByteUtilities.setBit(flag, 1);
        }
        result.put(flag);
        flag = 0;
        if (this.IMS_Key) {
            flag = ByteUtilities.setBit(flag, 8);
        }
        if (this.IMS_Index_Search) {
            flag = ByteUtilities.setBit(flag, 7);
        }
        if (this.fromPL1) {
            flag = ByteUtilities.setBit(flag, 6);
        }
        if (this.IMS_Active_Index) {
            flag = ByteUtilities.setBit(flag, 5);
        }
        if (this.IMS_Subsequence) {
            flag = ByteUtilities.setBit(flag, 4);
        }
        if (this.isLengthField) {
            flag = ByteUtilities.setBit(flag, 3);
        }
        if (this.DB2noUpdates) {
            flag = ByteUtilities.setBit(flag, 2);
        }
        if (this.holdColumn) {
            flag = ByteUtilities.setBit(flag, 1);
        }
        result.put(flag);
        return result.array();
    }

    private byte buildPL1Flags() {
        byte flag = 0;
        if (this.pl1Varying) {
            flag = ByteUtilities.setBit(flag, 8);
        }
        if (this.pl1Varyingz) {
            flag = ByteUtilities.setBit(flag, 7);
        }
        if (this.pl1DimsBounds) {
            flag = ByteUtilities.setBit(flag, 6);
        }
        if (this.pl1Signed) {
            flag = ByteUtilities.setBit(flag, 5);
        }
        if (this.pl1Unsigned) {
            flag = ByteUtilities.setBit(flag, 4);
        }
        if (this.pl1Aligned) {
            flag = ByteUtilities.setBit(flag, 3);
        }
        if (this.pl1Unaligned) {
            flag = ByteUtilities.setBit(flag, 2);
        }
        if (this.pl1MultipleDims) {
            flag = ByteUtilities.setBit(flag, 1);
        }
        return flag;
    }

    public byte[] buildDB2Flags() {
        ByteBuffer result = ByteBuffer.allocate(2);
        byte flag = 0;
        if (this.db2Time) {
            flag = ByteUtilities.setBit(flag, 8);
        }
        if (this.db2Timestamp) {
            flag = ByteUtilities.setBit(flag, 7);
        }
        if (this.db2Date) {
            flag = ByteUtilities.setBit(flag, 6);
        }
        if (this.db2BinaryLob) {
            flag = ByteUtilities.setBit(flag, 5);
        }
        if (this.db2CharacterLob) {
            flag = ByteUtilities.setBit(flag, 4);
        }
        if (this.db2Graphic) {
            flag = ByteUtilities.setBit(flag, 3);
        }
        if (this.db2RowId) {
            flag = ByteUtilities.setBit(flag, 2);
        }
        if (this.db2Nullable) {
            flag = ByteUtilities.setBit(flag, 1);
        }
        result.put(flag);
        byte flag2 = 0;
        if (this.db2NonUniqueIndex) {
            flag2 = ByteUtilities.setBit(flag2, 8);
        }
        if (this.db2UniqueIndex) {
            flag2 = ByteUtilities.setBit(flag2, 7);
        }
        if (this.db2PrimaryKey) {
            flag2 = ByteUtilities.setBit(flag2, 6);
        }
        if (this.db2ForeignKey) {
            flag2 = ByteUtilities.setBit(flag2, 5);
        }
        if (this.db2CheckConstraint) {
            flag2 = ByteUtilities.setBit(flag2, 4);
        }
        if (this.db2OrderDescending) {
            flag2 = ByteUtilities.setBit(flag2, 3);
        }
        if (this.db2PartOfkey) {
            flag2 = ByteUtilities.setBit(flag2, 2);
        }
        if (this.db2DefAttribute) {
            flag2 = ByteUtilities.setBit(flag2, 1);
        }
        result.put(flag2);
        return result.array();
    }

    private byte[] buildChainedSymbols() {
        int numSymbols = this.secHeader.getNumChain();
        ByteBuffer result = ByteBuffer.allocate(numSymbols * 20);
        int i = 0;
        while (i < numSymbols) {
            result.put(this.symbols.get(i).toBinary());
            ++i;
        }
        return result.array();
    }

    private void getChainedSymbols(ByteBuffer buf) {
        this.symbols = new ArrayList();
        int i = 0;
        while (i < this.secHeader.getNumChain()) {
            this.symbols.add(new MainFieldChainSymbol(buf));
            ++i;
        }
    }

    private void getDataTypeFlags(ByteBuffer buf) {
        byte flag = buf.get();
        this.isGroupItem = ByteUtilities.testBit(flag, 8);
        this.isOccursItem = ByteUtilities.testBit(flag, 7);
        this.isOccursDependingOnItem = ByteUtilities.testBit(flag, 6);
        this.dependingOnFieldIsExternal = ByteUtilities.testBit(flag, 5);
        this.hasRedefines = ByteUtilities.testBit(flag, 4);
        this.hasRenames = ByteUtilities.testBit(flag, 3);
        this.isODOTarget = ByteUtilities.testBit(flag, 2);
        this.isVaryingLength = ByteUtilities.testBit(flag, 1);
        flag = buf.get();
        byte flag2 = buf.get();
        this.binary = ByteUtilities.testBit(flag, 8);
        this.externalFloat = ByteUtilities.testBit(flag, 7);
        this.internalFloat = ByteUtilities.testBit(flag, 6);
        this.packedDecimal = ByteUtilities.testBit(flag, 5);
        this.zonedDecimal = ByteUtilities.testBit(flag, 4);
        this.EGCS_edited = ByteUtilities.testBit(flag2, 1);
        this.numericEdited = ByteUtilities.testBit(flag, 2);
        this.bit = ByteUtilities.testBit(flag, 1);
        this.alphanumeric_edited = ByteUtilities.testBit(flag2, 6);
        this.alphabetic = ByteUtilities.testBit(flag2, 8);
        this.alphanumeric = ByteUtilities.testBit(flag2, 7);
        if (this.binary) {
            this.dataType = FMIBinaryDataTypeConverter.getInstance();
        } else if (this.externalFloat) {
            this.dataType = FMIExternalFloatConverter.getInstance();
        } else if (this.internalFloat) {
            this.dataType = FMIInternalFloatingPointDataTypeConverter.getInstance();
        } else if (this.packedDecimal) {
            this.dataType = FMIPackedDecimalDataTypeConverter.getInstance();
        } else if (this.zonedDecimal) {
            this.dataType = FMIZonedDecimalDataTypeConverter.getInstance();
        } else if (this.EGCS_edited || this.numericEdited || this.bit || this.alphanumeric_edited) {
            this.dataType = this.setAsUnsupportedDatatype();
        } else if (this.alphabetic) {
            this.dataType = FMIAlphaNumericDataTypeConverter.getInstance();
        } else if (this.alphanumeric) {
            this.dataType = FMIAlphaNumericDataTypeConverter.getInstance();
        }
        this.isSigned = ByteUtilities.testBit(flag, 3);
        if (this.dataType instanceof FMIBinaryDataTypeConverter && !this.isSigned) {
            this.dataType = FMIUnsignedBinaryDataTypeConverter.getInstance();
        }
        this.groupContainsODO = ByteUtilities.testBit(flag2, 5);
        this.isDBCS = ByteUtilities.testBit(flag2, 4);
        this.groupVariableItem = ByteUtilities.testBit(flag2, 3);
        this.EGCS_item = ByteUtilities.testBit(flag2, 2);
        if (this.EGCS_item && this.dataType == null) {
            this.dataType = FMIDBCSConverter.getInstance();
        }
    }

    private IFMIDataTypeConverter setAsUnsupportedDatatype() {
        this.containsUnsupportedDatatype = true;
        return FMIAlphaNumericDataTypeConverter.getInstance();
    }

    private void getMiscFlags(ByteBuffer buf) throws FMIParseException {
        byte flag = buf.get();
        this.notLayoutSelected = ByteUtilities.testBit(flag, 8);
        this.relocationRequired = ByteUtilities.testBit(flag, 7);
        this.noEdit = ByteUtilities.testBit(flag, 6);
        this.expressionInvalid = ByteUtilities.testBit(flag, 5);
        this.selected = ByteUtilities.testBit(flag, 4);
        this.allElementarySelected = ByteUtilities.testBit(flag, 3);
        this.mappingSegExists = ByteUtilities.testBit(flag, 2);
        this.childODOExists = ByteUtilities.testBit(flag, 1);
        flag = buf.get();
        this.IMS_Key = ByteUtilities.testBit(flag, 8);
        this.IMS_Index_Search = ByteUtilities.testBit(flag, 7);
        this.fromPL1 = ByteUtilities.testBit(flag, 6);
        this.IMS_Active_Index = ByteUtilities.testBit(flag, 5);
        this.IMS_Subsequence = ByteUtilities.testBit(flag, 4);
        this.isLengthField = ByteUtilities.testBit(flag, 3);
        this.DB2noUpdates = ByteUtilities.testBit(flag, 2);
        this.holdColumn = ByteUtilities.testBit(flag, 1);
        if (this.IMS_Key || this.IMS_Index_Search || this.IMS_Active_Index || this.IMS_Subsequence) {
            throw new FMIParseException(MessageFormat.format(Messages.MainFieldDescriptorSegment_MAIN_FIELD_DESCRIPTOR_SEGMENT_DATA_TYPE_NOT_SUPPORTED, "IMS"));
        }
        if (this.DB2noUpdates) {
            throw new FMIParseException(MessageFormat.format(Messages.MainFieldDescriptorSegment_MAIN_FIELD_DESCRIPTOR_SEGMENT_DATA_TYPE_NOT_SUPPORTED, "DB2"));
        }
    }

    private void getPL1Flags(ByteBuffer buf) throws FMIParseException {
        byte flag = buf.get();
        this.pl1Varying = ByteUtilities.testBit(flag, 8);
        this.pl1Varyingz = ByteUtilities.testBit(flag, 7);
        if (this.pl1Varyingz) {
            throw new FMIParseException(MessageFormat.format(Messages.MainFieldDescriptorSegment_MAIN_FIELD_DESCRIPTOR_SEGMENT_DATA_TYPE_NOT_SUPPORTED, "PL/1 Varying z data types"));
        }
        this.pl1DimsBounds = ByteUtilities.testBit(flag, 6);
        this.pl1Signed = ByteUtilities.testBit(flag, 5);
        this.pl1Unsigned = ByteUtilities.testBit(flag, 4);
        this.pl1Aligned = ByteUtilities.testBit(flag, 3);
        this.pl1Unaligned = ByteUtilities.testBit(flag, 2);
        this.pl1MultipleDims = ByteUtilities.testBit(flag, 1);
    }

    private void getDB2Flags(ByteBuffer buf) throws FMIParseException {
        byte flag = buf.get();
        this.db2Time = ByteUtilities.testBit(flag, 8);
        this.db2Timestamp = ByteUtilities.testBit(flag, 7);
        this.db2Date = ByteUtilities.testBit(flag, 6);
        this.db2BinaryLob = ByteUtilities.testBit(flag, 5);
        this.db2CharacterLob = ByteUtilities.testBit(flag, 4);
        this.db2Graphic = ByteUtilities.testBit(flag, 3);
        this.db2RowId = ByteUtilities.testBit(flag, 2);
        this.db2Nullable = ByteUtilities.testBit(flag, 1);
        byte flag2 = buf.get();
        this.db2NonUniqueIndex = ByteUtilities.testBit(flag, 8);
        this.db2UniqueIndex = ByteUtilities.testBit(flag, 7);
        this.db2PrimaryKey = ByteUtilities.testBit(flag, 6);
        this.db2ForeignKey = ByteUtilities.testBit(flag, 5);
        this.db2CheckConstraint = ByteUtilities.testBit(flag, 4);
        this.db2OrderDescending = ByteUtilities.testBit(flag, 3);
        this.db2PartOfkey = ByteUtilities.testBit(flag, 2);
        this.db2DefAttribute = ByteUtilities.testBit(flag, 1);
        if (flag != 0 || flag2 != 0) {
            throw new FMIParseException(MessageFormat.format(Messages.MainFieldDescriptorSegment_MAIN_FIELD_DESCRIPTOR_SEGMENT_DATA_TYPE_NOT_SUPPORTED, "DB2"));
        }
    }

    private void getAssociatedSegments(ByteBuffer buf) throws FMIParseException {
        SegmentHeader header = new SegmentHeader(buf);
        while (header.getLength() > 0 && header.getType() > 20 && header.getType() <= 43) {
            Segment seg = null;
            Object[] params = null;
            if (header.getType() == 40) {
                params = new Object[]{this.fieldLength};
            }
            seg = SegmentFactory.buildSegment(header, buf, params);
            if (this.associatedSegments == null) {
                this.associatedSegments = new ArrayList();
            }
            this.associatedSegments.add(seg);
            header = new SegmentHeader(buf);
        }
    }

    public byte getAlign() {
        return this.align;
    }

    public boolean isAllElementarySelected() {
        return this.allElementarySelected;
    }

    public ArrayList<Segment> getAssociatedSegments() {
        return this.associatedSegments;
    }

    public short getBitLen() {
        return this.bitLen;
    }

    public boolean isChildODOExists() {
        return this.childODOExists;
    }

    public int getCurOffset() {
        return this.curOffset;
    }

    public IFMIDataTypeConverter getDataType() {
        return this.dataType;
    }

    public boolean isDb2BinaryLob() {
        return this.db2BinaryLob;
    }

    public boolean isDb2CharacterLob() {
        return this.db2CharacterLob;
    }

    public boolean isDb2CheckConstraint() {
        return this.db2CheckConstraint;
    }

    public short getDb2ColumnNumber() {
        return this.db2ColumnNumber;
    }

    public boolean isDb2Date() {
        return this.db2Date;
    }

    public boolean isDb2DefAttribute() {
        return this.db2DefAttribute;
    }

    public boolean isDb2ForeignKey() {
        return this.db2ForeignKey;
    }

    public boolean isDb2Graphic() {
        return this.db2Graphic;
    }

    public boolean isDb2NonUniqueIndex() {
        return this.db2NonUniqueIndex;
    }

    public boolean isDB2noUpdates() {
        return this.DB2noUpdates;
    }

    public boolean isDb2Nullable() {
        return this.db2Nullable;
    }

    public boolean isDb2OrderDescending() {
        return this.db2OrderDescending;
    }

    public boolean isDb2PartOfkey() {
        return this.db2PartOfkey;
    }

    public boolean isDb2PrimaryKey() {
        return this.db2PrimaryKey;
    }

    public boolean isDb2RowId() {
        return this.db2RowId;
    }

    public boolean isDb2Time() {
        return this.db2Time;
    }

    public boolean isDb2Timestamp() {
        return this.db2Timestamp;
    }

    public boolean isDb2UniqueIndex() {
        return this.db2UniqueIndex;
    }

    public boolean isDependingOnFieldIsExternal() {
        return this.dependingOnFieldIsExternal;
    }

    public short getDisplayOrder() {
        return this.displayOrder;
    }

    public boolean isEGCS_edited() {
        return this.EGCS_edited;
    }

    public boolean isEGCS_item() {
        return this.EGCS_item;
    }

    public boolean isExpressionInvalid() {
        return this.expressionInvalid;
    }

    public int getFieldDimensions() {
        return this.fieldDimensions;
    }

    public int getFieldLength() {
        return this.fieldLength;
    }

    public int getFieldStart() {
        return this.fieldStart;
    }

    public boolean isFromPL1() {
        return this.fromPL1;
    }

    public boolean groupContainsODO() {
        return this.groupContainsODO;
    }

    public boolean isGroupVariableItem() {
        return this.groupVariableItem;
    }

    public boolean hasRedefines() {
        return this.hasRedefines;
    }

    public boolean hasRenames() {
        return this.hasRenames;
    }

    public boolean isHoldColumn() {
        return this.holdColumn;
    }

    public byte getBitOffset() {
        return this.bitOffset;
    }

    public boolean isIMS_Active_Index() {
        return this.IMS_Active_Index;
    }

    public boolean isIMS_Index_Search() {
        return this.IMS_Index_Search;
    }

    public boolean isIMS_Key() {
        return this.IMS_Key;
    }

    public boolean isIMS_Subsequence() {
        return this.IMS_Subsequence;
    }

    public boolean isDBCS() {
        return this.isDBCS;
    }

    public boolean isGroupItem() {
        return this.isGroupItem;
    }

    public boolean isLengthField() {
        return this.isLengthField;
    }

    public boolean isOccursDependingOnItem() {
        return this.isOccursDependingOnItem;
    }

    public boolean isOccursItem() {
        return this.isOccursItem;
    }

    public boolean isODOTarget() {
        return this.isODOTarget;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isVaryingLength() {
        return this.isVaryingLength;
    }

    public byte getJustified() {
        return this.justified;
    }

    public byte getLevelNumber() {
        return this.levelNumber;
    }

    public boolean isMappingSegExists() {
        return this.mappingSegExists;
    }

    public boolean isNoEdit() {
        return this.noEdit;
    }

    public boolean isNotSelected() {
        return this.notLayoutSelected;
    }

    public int getOccursMax() {
        return this.occursMax;
    }

    public int getOccursMin() {
        return this.occursMin;
    }

    public int getODOvalue() {
        return this.ODOvalue;
    }

    public short getOrderBySequenceNumber() {
        return this.orderBySequenceNumber;
    }

    public short getPictureLen() {
        return this.pictureLen;
    }

    public boolean isPl1Aligned() {
        return this.pl1Aligned;
    }

    public byte getPl1BinScale() {
        return this.pl1BinScale;
    }

    public boolean isPl1DimsBounds() {
        return this.pl1DimsBounds;
    }

    public boolean isPl1MultipleDims() {
        return this.pl1MultipleDims;
    }

    public boolean isPl1Signed() {
        return this.pl1Signed;
    }

    public boolean isPl1Unaligned() {
        return this.pl1Unaligned;
    }

    public boolean isPl1Unsigned() {
        return this.pl1Unsigned;
    }

    public boolean isPl1Varying() {
        return this.pl1Varying;
    }

    public boolean isPl1Varyingz() {
        return this.pl1Varyingz;
    }

    public byte getPrecision() {
        return this.precision;
    }

    public boolean isRelocationRequired() {
        return this.relocationRequired;
    }

    public byte getScale() {
        return this.scale;
    }

    public SecondarySegmentHeader getSecHeader() {
        return this.secHeader;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public byte getSignField() {
        return this.signField;
    }

    public short getSqlType() {
        return this.sqlType;
    }

    public ArrayList<MainFieldChainSymbol> getSymbols() {
        return this.symbols;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public int getParentSymbol() {
        return this.symbols.get(0).getParent();
    }

    public int getChildSymbol() {
        return this.symbols.get(0).getChild();
    }

    public int getOccursDependingOnSymbol() {
        return this.symbols.get(0).getOccurs();
    }

    public int getRedefineSymbol() {
        return this.symbols.get(0).getRedefine();
    }

    public int getSiblingSymbol() {
        return this.symbols.get(0).getSibling();
    }

    public int getNumSlackBytes() {
        return this.numSlackBytes;
    }

    public void setNumSlackBytes(int numSlackBytes) {
        this.numSlackBytes = numSlackBytes;
    }

    public boolean containsUnsupportedDatatype() {
        return this.containsUnsupportedDatatype;
    }

    public boolean getHoldStatus() {
        return this.holdColumn;
    }

    public boolean getLayoutSelected() {
        return !this.notLayoutSelected;
    }

    public void setLayoutSelected(boolean selected) {
        this.notLayoutSelected = !selected;
    }

    public boolean getSelected() {
        return this.selected;
    }

    public int getLayoutOffset() {
        return this.symbols.get(0).getOccurs();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setHold(boolean hold) {
        this.holdColumn = hold;
    }

    public void setSequence(short sequence) {
        this.displayOrder = sequence;
    }

    public String removeAssociatedSegment(Segment seg) {
        if (this.associatedSegments == null) {
            return null;
        }
        boolean succeeded = this.associatedSegments.remove(seg);
        if (succeeded) {
            return null;
        }
        return Messages.MainFieldDescriptorSegment_REMOVE_FAILED;
    }

    public void addAssociatedSegment(Segment seg) {
        if (this.associatedSegments == null) {
            this.associatedSegments = new ArrayList();
        }
        if (seg instanceof MainFieldDescriptorSegment) {
            return;
        }
        this.associatedSegments.add(seg);
    }

    @Override
    public short calculateBinaryLength() {
        return (short)(80 + this.secHeader.getNumChain() * 20 + 2 + this.name.length() + this.pictureLen);
    }

    @Override
    public int getType() {
        return 20;
    }

    public String setLayoutOffset(int newOffset) {
        this.symbols.get(0).setOccurs(newOffset);
        return null;
    }

    private static class MainFieldChainSymbol {
        public static final int SIZE = 20;
        private int sibling;
        private int child;
        private int redefine;
        private int occurs;
        private int parent;

        MainFieldChainSymbol(ByteBuffer buf) {
            this.sibling = buf.getInt();
            this.child = buf.getInt();
            this.redefine = buf.getInt();
            this.occurs = buf.getInt();
            this.parent = buf.getInt();
        }

        public int getChild() {
            return this.child;
        }

        public int getOccurs() {
            return this.occurs;
        }

        public int getParent() {
            return this.parent;
        }

        public int getRedefine() {
            return this.redefine;
        }

        public int getSibling() {
            return this.sibling;
        }

        public byte[] toBinary() {
            ByteBuffer result = ByteBuffer.allocate(20);
            result.putInt(this.sibling);
            result.putInt(this.child);
            result.putInt(this.redefine);
            result.putInt(this.occurs);
            result.putInt(this.parent);
            return result.array();
        }

        public void setOccurs(int val) {
            this.occurs = val;
        }
    }
}

