/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.fm;

import com.ibm.etools.fm.model.ByteUtilities;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import com.ibm.etools.fm.model.exception.FMIParseException;
import com.ibm.etools.fm.model.fm.Segment;
import java.nio.ByteBuffer;

public class FieldMappingSegment
extends Segment {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int FREE_SPACE = 3;
    private int mapSymbol;
    private short nameLength;
    private byte mapType;
    private String fieldName;

    FieldMappingSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
    }

    @Override
    public void parse(ByteBuffer buf) throws FMIParseException {
        this.mapSymbol = buf.getInt();
        this.nameLength = buf.getShort();
        this.mapType = buf.get();
        buf.position(buf.position() + 3);
        try {
            if (this.nameLength > 0) {
                this.fieldName = ByteUtilities.getString(buf, this.nameLength);
            }
        }
        catch (FMIConversionException ce) {
            throw new FMIParseException();
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public int getMapSymbol() {
        return this.mapSymbol;
    }

    public void setMapSymbol(int mapSymbol) {
        this.mapSymbol = mapSymbol;
    }

    public byte getMapType() {
        return this.mapType;
    }

    public void setMapType(byte mapType) {
        this.mapType = mapType;
    }

    public short getNameLength() {
        return this.nameLength;
    }

    public void setNameLength(short nameLength) {
        this.nameLength = nameLength;
    }

    @Override
    public byte[] toBinary(String hostCp) throws FMIParseException {
        return null;
    }

    @Override
    public short calculateBinaryLength() {
        return -1;
    }

    @Override
    public int getType() {
        return 24;
    }
}

