/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.fm;

import com.ibm.etools.fm.model.ByteUtilities;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import com.ibm.etools.fm.model.exception.FMIParseException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class DynamicTemplateExpression {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    int lineNum;
    byte conn;
    byte[] operator;
    byte leftParen;
    byte rightParen;
    int valLen1;
    int valStart2;
    int valLen2;
    private static byte VAL1_REQ_QUOTES_BIT = (byte)8;
    private static byte VAL2_REQ_QUOTES_BIT = (byte)7;
    private static byte VAL_REQ_REXX_BIT = (byte)6;
    private static byte START_VAL_OFFSET_BIT = (byte)5;
    boolean val1ReqQuotes;
    boolean val2ReqQuotes;
    boolean valReqRexx;
    boolean startValIsOffset;
    int offset;
    String value;

    public DynamicTemplateExpression(ByteBuffer buf) throws FMIParseException {
        this.parse(buf);
    }

    private void parse(ByteBuffer buf) throws FMIParseException {
        this.lineNum = buf.get();
        this.conn = buf.get();
        this.operator = new byte[3];
        buf.get(this.operator);
        this.leftParen = buf.get();
        this.rightParen = buf.get();
        this.valLen1 = buf.get();
        this.valStart2 = buf.get();
        this.valLen2 = buf.get();
        byte flag = buf.get();
        this.val1ReqQuotes = ByteUtilities.testBit(flag, VAL1_REQ_QUOTES_BIT);
        this.val2ReqQuotes = ByteUtilities.testBit(flag, VAL2_REQ_QUOTES_BIT);
        this.valReqRexx = ByteUtilities.testBit(flag, VAL_REQ_REXX_BIT);
        this.startValIsOffset = ByteUtilities.testBit(flag, START_VAL_OFFSET_BIT);
        this.offset = buf.get();
        buf.get();
        buf.get();
        buf.get();
        buf.get();
        buf.get(new byte[5]);
        short valueLen = buf.getShort();
        try {
            this.value = ByteUtilities.getString(buf, valueLen);
        }
        catch (FMIConversionException ce) {
            throw new FMIParseException();
        }
    }

    public byte getConn() {
        return this.conn;
    }

    public String getValue() {
        return this.value;
    }

    public byte getLeftParen() {
        return this.leftParen;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getOperator() {
        return Arrays.copyOf(this.operator, this.operator.length);
    }

    public byte getRightParen() {
        return this.rightParen;
    }

    public boolean isStartValIsOffset() {
        return this.startValIsOffset;
    }

    public boolean isVal1ReqQuotes() {
        return this.val1ReqQuotes;
    }

    public boolean isVal2ReqQuotes() {
        return this.val2ReqQuotes;
    }

    public int getValLen1() {
        return this.valLen1;
    }

    public int getValLen2() {
        return this.valLen2;
    }

    public boolean isValReqRexx() {
        return this.valReqRexx;
    }

    public int getValStart2() {
        return this.valStart2;
    }

    public String toString() {
        Object output = "";
        if (this.leftParen != 64) {
            output = (String)output + "(";
        }
        output = (String)output + "#" + this.lineNum;
        try {
            output = (String)output + new String(this.operator, "IBM-037");
        }
        catch (UnsupportedEncodingException e) {
            output = (String)output + "invalid operator";
        }
        output = (String)output + this.value;
        if (this.rightParen != 64) {
            output = (String)output + ")";
        }
        return output;
    }
}

