/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.fm;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.model.ByteUtilities;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import com.ibm.etools.fm.model.exception.FMIParseException;
import com.ibm.etools.fm.model.fm.Segment;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class DataSetNameSegment
extends Segment {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String DEFAULT_CODEPAGE = "IBM-037";
    private static final short SEG_TYPE = 11;
    private short nameLen;
    private String name;

    DataSetNameSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
    }

    @Override
    public void parse(ByteBuffer buf) throws FMIParseException {
        this.nameLen = buf.getShort();
        try {
            this.name = ByteUtilities.getString(buf, this.nameLen);
        }
        catch (FMIConversionException ce) {
            throw new FMIParseException(Messages.DataSetNameSegment_INVALID_DATA_SET_NAME);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public byte[] toBinary(String hostCp) throws FMIParseException {
        short size = this.calculateBinaryLength();
        ByteBuffer result = ByteBuffer.allocate(size);
        result.putShort(size);
        result.putShort((short)11);
        result.putShort(this.nameLen);
        if (this.name != null) {
            try {
                result.put(this.name.getBytes(DEFAULT_CODEPAGE));
            }
            catch (UnsupportedEncodingException e) {
                throw new FMIParseException();
            }
        }
        return result.array();
    }

    @Override
    public short calculateBinaryLength() {
        short size = 6;
        if (this.name != null) {
            size = (short)(size + this.name.length());
        }
        return size;
    }

    @Override
    public int getType() {
        return 11;
    }
}

