/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.fm;

import com.ibm.etools.fm.model.ByteUtilities;
import com.ibm.etools.fm.model.exception.FMIParseException;
import com.ibm.etools.fm.model.fm.Segment;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class CriteriaSegment
extends Segment {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int HEADER_SIZE = 4;
    private static final int BASE_SIZE = 12;
    private short expressionLength;
    private short rexxLength;
    private short numRefSymbols;
    private boolean expressionInvalid;
    private boolean needRexx;
    private boolean rexxRequiredValid;
    private boolean exprBuiltFrom26;
    private static final int INVALID_BIT = 8;
    private static final int NEED_REXX_BIT = 7;
    private static final int REXX_REQUIRED_BIT = 6;
    private static final int BUILD_26_BIT = 5;
    private byte setNumber;
    private int ssaPtr;
    private byte[] exprBytes;
    private byte[] rexxBytes;
    private ArrayList<CriteriaRefSymbol> refSymbols;

    public CriteriaSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
    }

    @Override
    public void parse(ByteBuffer buf) throws FMIParseException {
        this.expressionLength = buf.getShort();
        this.rexxLength = buf.getShort();
        this.numRefSymbols = buf.getShort();
        byte tempByte = buf.get();
        this.expressionInvalid = ByteUtilities.testBit(tempByte, 8);
        this.needRexx = ByteUtilities.testBit(tempByte, 7);
        this.rexxRequiredValid = ByteUtilities.testBit(tempByte, 6);
        this.exprBuiltFrom26 = ByteUtilities.testBit(tempByte, 5);
        this.setNumber = buf.get();
        this.ssaPtr = buf.getInt();
        if (this.expressionLength > 0) {
            this.exprBytes = new byte[this.expressionLength];
            buf.get(this.exprBytes);
        }
        if (this.rexxLength > 0) {
            this.rexxBytes = new byte[this.rexxLength];
            buf.get(this.rexxBytes);
        }
        if (this.numRefSymbols > 0) {
            this.refSymbols = new ArrayList(this.numRefSymbols);
            int i = 0;
            while (i < this.numRefSymbols) {
                this.refSymbols.add(new CriteriaRefSymbol(buf));
                ++i;
            }
        }
    }

    public boolean isExprBuiltFrom26() {
        return this.exprBuiltFrom26;
    }

    public String getExpression(String codePage) throws UnsupportedEncodingException {
        return new String(this.exprBytes, codePage);
    }

    public boolean isExpressionInvalid() {
        return this.expressionInvalid;
    }

    public short getExpressionLength() {
        return this.expressionLength;
    }

    public boolean isNeedRexx() {
        return this.needRexx;
    }

    public short getNumRefSymbols() {
        return this.numRefSymbols;
    }

    public short getRexxLength() {
        return this.rexxLength;
    }

    public boolean isRexxRequiredValid() {
        return this.rexxRequiredValid;
    }

    public byte getSetNumber() {
        return this.setNumber;
    }

    public int getSsaPtr() {
        return this.ssaPtr;
    }

    public String getRexxLine(String codePage) throws UnsupportedEncodingException {
        return new String(this.rexxBytes, codePage);
    }

    public ArrayList<CriteriaRefSymbol> getRefSymbols() {
        return this.refSymbols;
    }

    @Override
    public byte[] toBinary(String hostCp) throws FMIParseException {
        short segSize = this.calculateBinaryLength();
        ByteBuffer result = ByteBuffer.allocate(segSize);
        result.putShort(segSize);
        result.putShort((short)this.getType());
        result.putShort(this.expressionLength);
        result.putShort(this.rexxLength);
        result.putShort(this.numRefSymbols);
        byte flags = 0;
        if (this.expressionInvalid) {
            flags = ByteUtilities.setBit(flags, 8);
        }
        if (this.needRexx) {
            flags = ByteUtilities.setBit(flags, 7);
        }
        if (this.rexxRequiredValid) {
            flags = ByteUtilities.setBit(flags, 6);
        }
        if (this.exprBuiltFrom26) {
            flags = ByteUtilities.setBit(flags, 5);
        }
        result.put(flags);
        result.put(this.setNumber);
        result.putInt(this.ssaPtr);
        if (this.expressionLength > 0) {
            result.put(this.exprBytes);
        }
        if (this.rexxLength > 0) {
            result.put(this.rexxBytes);
        }
        if (this.numRefSymbols > 0) {
            int i = 0;
            while (i < this.numRefSymbols) {
                result.put(this.refSymbols.get(i).toBinary());
                ++i;
            }
        }
        return result.array();
    }

    @Override
    public short calculateBinaryLength() {
        int result = 16 + this.expressionLength + this.rexxLength + this.numRefSymbols * 8;
        return (short)result;
    }

    @Override
    public int getType() {
        return 21;
    }

    private static class CriteriaRefSymbol {
        private static final int REF_SYMBOL_SIZE = 8;
        private int symbol;
        private short position;
        private short errorCode;

        CriteriaRefSymbol(ByteBuffer buf) {
            this.symbol = buf.getInt();
            this.position = buf.getShort();
            this.errorCode = buf.getShort();
        }

        public byte[] toBinary() {
            ByteBuffer result = ByteBuffer.allocate(8);
            result.putInt(this.symbol);
            result.putShort(this.position);
            result.putShort(this.errorCode);
            return result.array();
        }
    }
}

