/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.fm;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.model.ByteUtilities;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import com.ibm.etools.fm.model.exception.FMIParseException;
import com.ibm.etools.fm.model.fm.SecondarySegmentHeader;
import com.ibm.etools.fm.model.fm.Segment;
import com.ibm.etools.fm.model.fm.SegmentFactory;
import com.ibm.etools.fm.model.fm.SegmentHeader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class CopyMemberSegment
extends Segment {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String DEFAULT_CODEPAGE = "IBM-037";
    private static final int HEADER_SIZE = 4;
    private static final int BASE_SIZE = 52;
    private static final short SEG_TYPE = 10;
    private static final int MEMBER_NAME_LENGTH = 8;
    private static final int DATE_LENGTH = 8;
    private static final int TIME_LENGTH = 8;
    private static final int EXPRESSION_INVALID_BIT = 8;
    private static final int MULTIPLE_COPYBOOKS_BIT = 7;
    private SecondarySegmentHeader secHeader;
    private String memberName;
    private String date;
    private String time;
    private byte version;
    private byte flags;
    private boolean invalidExpression;
    private boolean multipleCopybooks;
    private byte selectionSets;
    private byte nextIndex;
    private int curSymbolIndex;
    private ArrayList<SymbolRef> symbolRefs;
    private ArrayList<Segment> associatedSegments;

    protected CopyMemberSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
        this.getAssociatedSegments(buf);
    }

    private void getAssociatedSegments(ByteBuffer buf) throws FMIParseException {
        SegmentHeader header = new SegmentHeader(buf);
        while (header.getLength() > 0 && header.getType() > 10 && header.getType() < 19 && header.getType() != 17) {
            Segment seg = SegmentFactory.buildSegment(header, buf, null);
            if (this.associatedSegments == null) {
                this.associatedSegments = new ArrayList();
            }
            this.associatedSegments.add(seg);
            header = new SegmentHeader(buf);
        }
    }

    public ArrayList<Segment> getAssociatedSegments() {
        return this.associatedSegments;
    }

    @Override
    public void parse(ByteBuffer buf) throws FMIParseException {
        this.secHeader = new SecondarySegmentHeader(buf);
        try {
            this.memberName = ByteUtilities.getString(buf, 8);
            this.date = ByteUtilities.getString(buf, 8);
            this.time = ByteUtilities.getString(buf, 8);
        }
        catch (FMIConversionException ce) {
            throw new FMIParseException();
        }
        this.version = buf.get();
        byte tempByte = buf.get();
        this.invalidExpression = ByteUtilities.testBit(tempByte, 8);
        this.multipleCopybooks = ByteUtilities.testBit(tempByte, 7);
        this.selectionSets = buf.get();
        this.nextIndex = buf.get();
        this.curSymbolIndex = buf.getInt();
        this.getSymbolRefs(buf);
    }

    private void getSymbolRefs(ByteBuffer buf) {
        this.symbolRefs = new ArrayList(this.secHeader.getNumChain());
        int i = 0;
        while (i < this.secHeader.getNumChain()) {
            SymbolRef newRef = new SymbolRef(buf);
            this.symbolRefs.add(newRef);
            ++i;
        }
    }

    public int getCurSymbolIndex() {
        return this.curSymbolIndex;
    }

    public String getDate() {
        return this.date;
    }

    public byte getFlags() {
        return this.flags;
    }

    public boolean isInvalidExpression() {
        return this.invalidExpression;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public boolean isMultipleCopybooks() {
        return this.multipleCopybooks;
    }

    public int getNextIndex() {
        return this.nextIndex;
    }

    public SecondarySegmentHeader getSecondaryHeader() {
        return this.secHeader;
    }

    public int getSelectionSets() {
        return this.selectionSets;
    }

    public ArrayList<SymbolRef> getSymbolRefs() {
        return this.symbolRefs;
    }

    public String getTime() {
        return this.time;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public byte[] toBinary(String hostCp) throws FMIParseException {
        short length = this.calculateBinaryLength();
        ByteBuffer result = ByteBuffer.allocate(length);
        result.putShort(length);
        result.putShort((short)10);
        result.put(this.secHeader.toBinary(hostCp));
        try {
            result.put(this.memberName.getBytes(DEFAULT_CODEPAGE));
            result.put(this.date.getBytes(DEFAULT_CODEPAGE));
            result.put(this.time.getBytes(DEFAULT_CODEPAGE));
        }
        catch (UnsupportedEncodingException e) {
            throw new FMIParseException(Messages.CopyMemberSegment_DECODING_PROBLEM);
        }
        result.put(this.version);
        byte tempByte = 0;
        if (this.invalidExpression) {
            tempByte = ByteUtilities.setBit(tempByte, 8);
        }
        if (this.multipleCopybooks) {
            tempByte = ByteUtilities.setBit(tempByte, 7);
        }
        result.put(this.selectionSets);
        result.put(this.nextIndex);
        result.putInt(this.curSymbolIndex);
        byte slackByte = 0;
        result.put(slackByte);
        if (this.symbolRefs != null) {
            result.put(this.buildSymbolRefs());
        }
        return result.array();
    }

    @Override
    public short calculateBinaryLength() {
        short size = 56;
        if (this.symbolRefs != null) {
            size = (short)(size + (short)(this.symbolRefs.size() * 20));
        }
        return size;
    }

    private byte[] buildSymbolRefs() {
        ByteBuffer result = ByteBuffer.allocate(this.symbolRefs.size() * 20);
        for (SymbolRef symbolRef : this.symbolRefs) {
            result.put(symbolRef.toBinary());
        }
        return result.array();
    }

    @Override
    public int getType() {
        return 10;
    }

    private static class SymbolRef {
        private static final int SIZE = 20;
        private int symbol;
        private int minLen;
        private int maxLen;
        private int rexxOffset;
        private int templatePointersOffset;

        public SymbolRef(ByteBuffer buf) {
            this.symbol = buf.getInt();
            this.minLen = buf.getInt();
            this.maxLen = buf.getInt();
            this.rexxOffset = buf.getInt();
            this.templatePointersOffset = buf.getInt();
        }

        public byte[] toBinary() {
            ByteBuffer result = ByteBuffer.allocate(20);
            result.putInt(this.symbol);
            result.putInt(this.minLen);
            result.putInt(this.maxLen);
            result.putInt(this.rexxOffset);
            result.putInt(this.templatePointersOffset);
            return result.array();
        }
    }
}

