/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.fm;

import com.ibm.etools.fm.model.exception.FMIParseException;
import com.ibm.etools.fm.model.fm.Segment;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class CompileOptionsSegment
extends Segment {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int TYPE = 18;
    private static final int BASE_SIZE = 6;
    private static final int HEADER_SIZE = 4;
    private static final short SEG_TYPE = 18;
    private short max_rc_cobol;
    private short max_rc_pli;
    private byte pli_option_bits;
    private byte cobol_option_bits;
    private short num_cbl_rep;
    private ArrayList<COBOLReplacingOptions> options;

    public CompileOptionsSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
    }

    @Override
    protected void parse(ByteBuffer buf) throws FMIParseException {
        this.max_rc_cobol = buf.getShort();
        this.max_rc_pli = buf.getShort();
        this.pli_option_bits = buf.get();
        this.cobol_option_bits = buf.get();
        this.parseCOBOLReplacingOptions(buf);
    }

    private void parseCOBOLReplacingOptions(ByteBuffer buf) {
        int numOptions;
        this.options = new ArrayList();
        this.num_cbl_rep = numOptions = buf.getShort();
        int i = 0;
        while (i < numOptions) {
            this.options.add(new COBOLReplacingOptions(buf));
            ++i;
        }
    }

    @Override
    public byte[] toBinary(String hostCp) {
        short length = this.calculateBinaryLength();
        ByteBuffer result = ByteBuffer.allocate(length);
        result.putShort(length);
        result.putShort((short)18);
        result.putShort(this.max_rc_cobol);
        result.putShort(this.max_rc_pli);
        result.put(this.pli_option_bits);
        result.put(this.cobol_option_bits);
        if (this.options != null && !this.options.isEmpty()) {
            result.putShort((short)this.options.size());
            for (COBOLReplacingOptions option : this.options) {
                result.put(option.toBinary());
            }
        }
        return result.array();
    }

    @Override
    public short calculateBinaryLength() {
        short size = 10;
        if (this.options != null) {
            size = (short)(size + (short)(this.num_cbl_rep * 62));
        }
        return size;
    }

    @Override
    public int getType() {
        return 18;
    }

    private static class COBOLReplacingOptions {
        private static final int SIZE = 62;
        private static final short REPLACING_FROM_TEXT_LEN = 30;
        private static final short REPLACING_TOO_TEXT_LEN = 30;
        byte replacingFromLength;
        byte[] replacingFromText;
        byte replacingTooLength;
        byte[] replacingTooText;

        public COBOLReplacingOptions(ByteBuffer buf) {
            this.replacingFromLength = buf.get();
            this.replacingFromText = new byte[30];
            buf.get(this.replacingFromText);
            this.replacingTooLength = buf.get();
            this.replacingTooText = new byte[30];
            buf.get(this.replacingTooText);
        }

        public byte[] toBinary() {
            ByteBuffer result = ByteBuffer.allocate(62);
            result.put(this.replacingFromLength);
            result.put(this.replacingFromText);
            result.put(this.replacingTooLength);
            result.put(this.replacingTooText);
            return result.array();
        }
    }
}

