/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.fm;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.model.ByteUtilities;
import com.ibm.etools.fm.model.datatypeconverters.ConverterUtils;
import com.ibm.etools.fm.model.exception.FMIParseException;
import com.ibm.etools.fm.model.fm.DependentSegment;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class AttributeSegment
extends DependentSegment {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(AttributeSegment.class);
    public static final String[] ACTIONS = new String[]{"FX", "RA", "RO", "RP", "SL", "SR", "TL", "TR", "WV"};
    private static final int HEADER_SIZE = 4;
    private static final int BASE_SIZE = 40;
    private static final int TYPE = 40;
    private boolean keepLeadingZeros;
    private static final int KEEP_LEADING_ZEROS_BIT = 7;
    private boolean validationError;
    private static final int VALIDATION_ERR_BIT = 8;
    private boolean numericInvalid;
    private static final int NUMERIC_INVALID_BIT = 7;
    private static final int FIRST_FREE_LENGTH = 2;
    private int width;
    private static final int SECOND_FREE_LENGTH = 4;
    private boolean createDataExists;
    private boolean fillCharHex;
    private boolean random;
    private boolean repeatUserPattern;
    private boolean displayPatternHex;
    private static final int CREATE_DATA_EXISTS_BIT = 8;
    private static final int FILL_CHAR_HEX_BIT = 7;
    private static final int RANDOM_BIT = 6;
    private static final int REPEAT_USER_PATTERN_BIT = 5;
    private static final int DISPLAY_PATTERN_HEX_BIT = 4;
    private boolean minValueNotBlank;
    private boolean maxValueNotBlank;
    private boolean incrValueNotBlank;
    private boolean cycleValueNotBlank;
    private boolean fillCharNotBlank;
    private boolean repeatUserPatternNotBlank;
    private static final int MIN_VAL_NOT_BLANK_BIT = 8;
    private static final int MAX_VAL_NOT_BLANK_BIT = 7;
    private static final int INCR_VAL_NOT_BLANK_BIT = 6;
    private static final int CYCLE_VAL_NOT_BLANK_BIT = 5;
    private static final int FILL_CHAR_NOT_BLANK_BIT = 4;
    private static final int REPEAT_USER_PATTERN_NOT_BLANK_BIT = 3;
    private short patternLen;
    private int cycle;
    private byte createPattern;
    private byte createAction;
    private byte startCharByte;
    private byte[] fillChar;
    private byte[] patternBytes;
    private byte[] incrBytes;
    private byte[] startValueBytes;
    private byte[] endValueBytes;
    private static final int THIRD_FREE_LENGTH = 15;
    private static final String CODEPAGE = "IBM-037";
    private int fieldLength;

    public AttributeSegment() {
        this.patternLen = 0;
        this.cycle = 0;
        this.createPattern = 0;
        this.createAction = 0;
        this.startCharByte = 0;
        this.minValueNotBlank = false;
        this.maxValueNotBlank = false;
        this.incrValueNotBlank = false;
        this.cycleValueNotBlank = false;
        this.fillCharNotBlank = false;
        this.repeatUserPatternNotBlank = false;
        this.fillChar = new byte[2];
        this.patternBytes = null;
        this.incrBytes = null;
        this.startValueBytes = null;
        this.endValueBytes = null;
    }

    public AttributeSegment(ByteBuffer buf, Object[] requiredParams) throws FMIParseException {
        super(buf, requiredParams);
    }

    @Override
    protected void parse(ByteBuffer buf) throws FMIParseException {
    }

    @Override
    protected void parse(ByteBuffer buf, Object[] requiredParams) throws FMIParseException {
        boolean numericField;
        this.fieldLength = (Integer)requiredParams[0];
        byte tempByte = buf.get();
        this.keepLeadingZeros = ByteUtilities.testBit(tempByte, 7);
        tempByte = buf.get();
        this.validationError = ByteUtilities.testBit(tempByte, 8);
        this.numericInvalid = ByteUtilities.testBit(tempByte, 7);
        buf.position(buf.position() + 2);
        this.width = buf.getInt();
        buf.position(buf.position() + 4);
        tempByte = buf.get();
        this.createDataExists = ByteUtilities.testBit(tempByte, 8);
        this.fillCharHex = ByteUtilities.testBit(tempByte, 7);
        this.random = ByteUtilities.testBit(tempByte, 6);
        this.repeatUserPattern = ByteUtilities.testBit(tempByte, 5);
        this.displayPatternHex = ByteUtilities.testBit(tempByte, 4);
        tempByte = buf.get();
        this.minValueNotBlank = ByteUtilities.testBit(tempByte, 8);
        this.maxValueNotBlank = ByteUtilities.testBit(tempByte, 7);
        this.incrValueNotBlank = ByteUtilities.testBit(tempByte, 6);
        this.cycleValueNotBlank = ByteUtilities.testBit(tempByte, 5);
        this.fillCharNotBlank = ByteUtilities.testBit(tempByte, 4);
        this.repeatUserPatternNotBlank = ByteUtilities.testBit(tempByte, 3);
        this.patternLen = buf.getShort();
        this.cycle = buf.getInt();
        this.createPattern = buf.get();
        this.createAction = buf.get();
        this.startCharByte = buf.get();
        this.fillChar = new byte[2];
        this.fillChar[0] = buf.get();
        this.fillChar[1] = buf.get();
        buf.position(buf.position() + 15);
        boolean bl = numericField = this.minValueNotBlank || this.maxValueNotBlank || this.incrValueNotBlank;
        if (numericField) {
            if (this.fieldLength <= 0) {
                throw new FMIParseException(Messages.AttributeSegment_FIELD_SIZE_ZERO_ILLEGAL);
            }
            if (this.minValueNotBlank) {
                this.startValueBytes = new byte[this.fieldLength];
                buf.get(this.startValueBytes, 0, this.fieldLength);
            }
            if (this.maxValueNotBlank) {
                this.endValueBytes = new byte[this.fieldLength];
                buf.get(this.endValueBytes, 0, this.fieldLength);
            }
            if (this.incrValueNotBlank) {
                this.incrBytes = new byte[this.fieldLength];
                buf.get(this.incrBytes, 0, this.fieldLength);
            }
        } else if (this.patternLen > 0) {
            this.patternBytes = new byte[this.patternLen];
            buf.get(this.patternBytes, 0, this.patternLen);
        }
    }

    @Override
    public byte[] toBinary(String hostCp) {
        short size = this.calculateBinaryLength();
        ByteBuffer results = ByteBuffer.allocate(size);
        results.putShort(size);
        results.putShort((short)40);
        byte usageFlags = 0;
        if (this.keepLeadingZeros) {
            usageFlags = ByteUtilities.setBit(usageFlags, 7);
        }
        results.put(usageFlags);
        byte usageFlags2 = 0;
        if (this.validationError) {
            usageFlags2 = ByteUtilities.setBit(usageFlags2, 8);
        }
        if (this.numericInvalid) {
            usageFlags2 = ByteUtilities.setBit(usageFlags2, 7);
        }
        results.put(usageFlags2);
        results.put(new byte[2]);
        results.put(ByteUtilities.intToByteArray(this.width));
        results.put(new byte[4]);
        byte create_flags_1 = 0;
        if (this.createDataExists) {
            create_flags_1 = ByteUtilities.setBit(create_flags_1, 8);
        }
        if (this.fillCharHex) {
            create_flags_1 = ByteUtilities.setBit(create_flags_1, 7);
        }
        if (this.random) {
            create_flags_1 = ByteUtilities.setBit(create_flags_1, 6);
        }
        if (this.repeatUserPattern) {
            create_flags_1 = ByteUtilities.setBit(create_flags_1, 5);
        }
        if (this.displayPatternHex) {
            create_flags_1 = ByteUtilities.setBit(create_flags_1, 4);
        }
        results.put(create_flags_1);
        byte create_flags2 = 0;
        if (this.minValueNotBlank) {
            create_flags2 = ByteUtilities.setBit(create_flags2, 8);
        }
        if (this.maxValueNotBlank) {
            create_flags2 = ByteUtilities.setBit(create_flags2, 7);
        }
        if (this.incrValueNotBlank) {
            create_flags2 = ByteUtilities.setBit(create_flags2, 6);
        }
        if (this.cycleValueNotBlank) {
            create_flags2 = ByteUtilities.setBit(create_flags2, 5);
        }
        if (this.fillCharNotBlank) {
            create_flags2 = ByteUtilities.setBit(create_flags2, 4);
        }
        if (this.repeatUserPatternNotBlank) {
            create_flags2 = ByteUtilities.setBit(create_flags2, 3);
        }
        results.put(create_flags2);
        results.put(ByteUtilities.shortToByteArray(this.patternLen));
        results.put(ByteUtilities.intToByteArray(this.cycle));
        results.put(this.createPattern);
        results.put(this.createAction);
        results.put(this.startCharByte);
        results.put(this.fillChar);
        results.put(new byte[15]);
        if (this.minValueNotBlank || this.maxValueNotBlank || this.incrValueNotBlank) {
            if (this.minValueNotBlank) {
                results.put(this.startValueBytes);
            }
            if (this.maxValueNotBlank) {
                results.put(this.endValueBytes);
            }
            if (this.incrValueNotBlank) {
                results.put(this.incrBytes);
            }
        } else if (this.patternLen > 0) {
            results.put(this.patternBytes);
        }
        return results.array();
    }

    @Override
    public short calculateBinaryLength() {
        int segSize = 44;
        if (this.minValueNotBlank || this.maxValueNotBlank || this.incrValueNotBlank) {
            if (this.minValueNotBlank) {
                segSize += this.startValueBytes.length;
            }
            if (this.maxValueNotBlank) {
                segSize += this.endValueBytes.length;
            }
            if (this.incrValueNotBlank) {
                segSize += this.incrBytes.length;
            }
        } else if (this.patternLen > 0) {
            segSize += this.patternLen;
        }
        return (short)segSize;
    }

    public char getStartChar() {
        byte[] startCharArray = new byte[]{this.startCharByte};
        try {
            return new String(startCharArray, CODEPAGE).charAt(0);
        }
        catch (UnsupportedEncodingException e1) {
            logger.error((Throwable)e1);
            return (char)this.startCharByte;
        }
    }

    public boolean getRepeatUserPattern() {
        return this.repeatUserPattern;
    }

    public String getFiller() {
        if (this.fillCharHex) {
            byte[] hexBytes = new byte[]{this.fillChar[0]};
            return "X'" + ConverterUtils.bytesToString(hexBytes) + "'";
        }
        try {
            return new String(this.fillChar, CODEPAGE);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public ActionTypes getAction() {
        switch (this.createAction) {
            case 1: {
                return ActionTypes.SL;
            }
            case 2: {
                return ActionTypes.SR;
            }
            case 3: {
                return ActionTypes.TL;
            }
            case 4: {
                return ActionTypes.TR;
            }
            case 5: {
                return ActionTypes.FX;
            }
            case 6: {
                return ActionTypes.RP;
            }
            case 8: {
                return ActionTypes.WV;
            }
            case 9: {
                return ActionTypes.RO;
            }
            case 12: {
                return ActionTypes.RA;
            }
        }
        return null;
    }

    public int getCycle() {
        return this.cycle;
    }

    public byte[] getIncrement() {
        return Arrays.copyOf(this.incrBytes, this.incrBytes.length);
    }

    public String getPattern() {
        String pattern;
        if (this.patternLen == 0) {
            return "";
        }
        if (this.displayPatternHex) {
            return "X'" + ConverterUtils.bytesToString(this.patternBytes) + "'";
        }
        try {
            pattern = new String(this.patternBytes, CODEPAGE);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Throwable)e);
            pattern = "";
        }
        return pattern;
    }

    public byte[] getStartValue() {
        return Arrays.copyOf(this.startValueBytes, this.startValueBytes.length);
    }

    public byte[] getEndValue() {
        return Arrays.copyOf(this.endValueBytes, this.endValueBytes.length);
    }

    public String setStartValue(byte[] startValue) {
        if (startValue == null) {
            this.startValueBytes = null;
            this.minValueNotBlank = false;
            return null;
        }
        if (this.startValueBytes != null && startValue.length != this.startValueBytes.length) {
            return Messages.AttributeSegment_INVALID_START_VALUE_LENGTH;
        }
        this.startValueBytes = Arrays.copyOf(startValue, startValue.length);
        this.minValueNotBlank = true;
        return null;
    }

    public String setEndValue(byte[] endValue) {
        if (endValue == null) {
            this.endValueBytes = null;
            this.maxValueNotBlank = false;
            return null;
        }
        if (this.endValueBytes != null && endValue.length != this.endValueBytes.length) {
            return Messages.AttributeSegment_INVALID_END_VALUE_LENGTH;
        }
        this.endValueBytes = Arrays.copyOf(endValue, endValue.length);
        this.maxValueNotBlank = true;
        return null;
    }

    public String setIncrementValue(byte[] increment) {
        if (increment == null) {
            this.incrBytes = null;
            this.incrValueNotBlank = false;
            return null;
        }
        if (this.incrBytes != null && increment.length != this.incrBytes.length) {
            return Messages.AttributeSegment_INVALID_INCREMENT_LENGTH;
        }
        this.incrBytes = Arrays.copyOf(increment, increment.length);
        this.incrValueNotBlank = true;
        return null;
    }

    public int getOutputWidth() {
        return this.width;
    }

    public void setOutputWidth(int width) {
        this.width = width;
    }

    public void setLeadingZeros(boolean leadingZeros) {
        this.keepLeadingZeros = leadingZeros;
    }

    public boolean leadingZeros() {
        return this.keepLeadingZeros;
    }

    public String setStartChar(byte startChar) {
        this.startCharByte = startChar;
        return null;
    }

    public String setFiller(byte[] fillerChar, boolean hexFormat) {
        if (fillerChar == null) {
            throw new IllegalArgumentException();
        }
        byte[] fillerCharCopy = Arrays.copyOf(fillerChar, fillerChar.length);
        this.fillCharHex = hexFormat;
        if (this.fillCharHex) {
            this.fillChar[0] = fillerCharCopy[0];
            this.fillChar[1] = 0;
        } else {
            this.fillChar[0] = fillerCharCopy[0];
            this.fillChar[1] = 0;
        }
        return null;
    }

    public String setAction(ActionTypes action) {
        if (action == null) {
            this.createAction = 0;
            return null;
        }
        switch (action) {
            case FX: {
                this.createAction = (byte)5;
                break;
            }
            case RA: {
                this.createAction = (byte)12;
                break;
            }
            case RO: {
                this.createAction = (byte)9;
                break;
            }
            case RP: {
                this.createAction = (byte)6;
                break;
            }
            case SL: {
                this.createAction = 1;
                break;
            }
            case SR: {
                this.createAction = (byte)2;
                break;
            }
            case TL: {
                this.createAction = (byte)3;
                break;
            }
            case TR: {
                this.createAction = (byte)4;
                break;
            }
            case WV: {
                this.createAction = (byte)8;
                break;
            }
            default: {
                this.createAction = 0;
            }
        }
        return null;
    }

    public String setPattern(byte[] patternBytes, boolean isHex) {
        if (patternBytes == null) {
            this.patternLen = 0;
            this.patternBytes = null;
            this.displayPatternHex = false;
            return null;
        }
        this.displayPatternHex = isHex;
        byte[] patternBytesCopy = Arrays.copyOf(patternBytes, patternBytes.length);
        this.patternLen = (short)patternBytesCopy.length;
        this.patternBytes = patternBytesCopy;
        return null;
    }

    @Override
    public int getType() {
        return 40;
    }

    public void setCycle(int cycleValue) {
        this.cycle = cycleValue;
        if (this.cycle != 0) {
            this.cycleValueNotBlank = true;
        }
    }

    public void setRepeatUserPattern(boolean repeat) {
        this.repeatUserPattern = repeat;
    }

    public void setRepeatUserPatternNotBlank(boolean notBlank) {
        this.repeatUserPatternNotBlank = notBlank;
    }

    public boolean hasPattern() {
        return this.patternLen > 0;
    }

    public static enum ActionTypes {
        FX,
        RA,
        RO,
        RP,
        SL,
        SR,
        TL,
        TR,
        WV;

    }
}

