/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.datatypeconverters;

import com.ibm.etools.fm.model.datatypeconverters.ConverterUtils;
import com.ibm.etools.fm.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import java.io.UnsupportedEncodingException;

public class ZonedEditedConverter
implements IFMIDataTypeConverter {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String codepage = "IBM-037";
    private static final String symbol = "ZE";
    private static ZonedEditedConverter theInstance = null;

    private ZonedEditedConverter() {
    }

    public static ZonedEditedConverter getInstance() {
        if (theInstance == null) {
            theInstance = new ZonedEditedConverter();
        }
        return theInstance;
    }

    @Override
    public byte[] ASCIIstrToEBCDIC(String asciiString, byte[] oldEBCDIC, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        int i;
        boolean validAscii;
        ZEParams params = new ZEParams();
        if (extraParams != null) {
            params = ZonedEditedConverter.getZEParams(extraParams);
        }
        if (!(validAscii = this.validateASCII(asciiString, tgtWidth, extraParams))) {
            throw new FMIConversionException();
        }
        String wholePart = ConverterUtils.getWholePart(asciiString);
        String fraction = ConverterUtils.getFracPart(asciiString);
        int wholeSize = ZonedEditedConverter.numPreDecimal(params, tgtWidth);
        int fracSize = ZonedEditedConverter.numPostDecimal(params, tgtWidth);
        StringBuffer sb = new StringBuffer();
        if (wholeSize > 0) {
            i = wholeSize;
            int j = wholePart.length() - 1;
            while (j >= 0 && i > 0) {
                sb.insert(0, wholePart.charAt(j));
                --j;
                --i;
            }
            while (i > 0) {
                sb.insert(0, '0');
                --i;
            }
        }
        if (params.decimalPos != -1) {
            sb.append('.');
        }
        i = 0;
        while (i < fracSize) {
            if (i < fraction.length()) {
                sb.append(fraction.charAt(i));
            } else {
                sb.append('0');
            }
            ++i;
        }
        if (params.signPos != -1) {
            char c = ZonedEditedConverter.getSign(asciiString);
            if (params.signPos == 0) {
                sb.insert(0, c);
            } else {
                sb.append(c);
            }
        }
        byte[] result = null;
        try {
            result = sb.toString().getBytes(codepage);
        }
        catch (UnsupportedEncodingException e) {
            throw new FMIConversionException();
        }
        return result;
    }

    @Override
    public String EBCDICtoASCIIstr(byte[] EBCDICval, int maxStrLength, Object[] extraParams) throws FMIConversionException {
        char decimal;
        char sign;
        if (EBCDICval.length == 0) {
            throw new FMIConversionException();
        }
        ZEParams params = ZonedEditedConverter.getZEParams(extraParams);
        if (EBCDICval.length != maxStrLength) {
            throw new FMIConversionException();
        }
        String displayString = ConverterUtils.decodeBytes(EBCDICval, Character.toString('\u25ad'), codepage);
        if (displayString.indexOf(9645) != -1) {
            throw new FMIConversionException();
        }
        if (params.signPos != -1 && (sign = displayString.charAt(params.signPos)) != '+' && sign != '-' && sign != ' ') {
            throw new FMIConversionException();
        }
        if (params.decimalPos != -1 && (decimal = displayString.charAt(params.decimalPos)) != '.') {
            throw new FMIConversionException();
        }
        int i = 0;
        while (i < displayString.length()) {
            if (i != params.decimalPos && i != params.signPos && !Character.isDigit(displayString.charAt(i))) {
                throw new FMIConversionException();
            }
            ++i;
        }
        return displayString;
    }

    @Override
    public String correctASCIIStringFormat(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        return null;
    }

    @Override
    public byte[] getDefaultValue(int length, Object[] extraParams) {
        if (length <= 0) {
            return null;
        }
        byte[] newBytes = new byte[length];
        ZEParams params = ZonedEditedConverter.getZEParams(extraParams);
        if (params == null) {
            return null;
        }
        int i = 0;
        while (i < length) {
            newBytes[i] = -16;
            ++i;
        }
        if (params.decimalPos != -1) {
            newBytes[params.decimalPos] = 75;
        }
        if (params.signPos != -1) {
            newBytes[params.signPos] = 78;
        }
        return newBytes;
    }

    @Override
    public int getMaxASCIIWidth(int ebcdicWidth, Object[] extraParams) throws FMIConversionException {
        if (ebcdicWidth <= 0) {
            throw new FMIConversionException();
        }
        return ebcdicWidth;
    }

    @Override
    public String getSymbol() {
        return symbol;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean requiresFullWordBoundary(int length) {
        return false;
    }

    @Override
    public boolean requiresHalfWordBoundary(int length) {
        return false;
    }

    private static ZEParams getZEParams(Object[] extraParams) {
        ZEParams result = new ZEParams();
        if (extraParams == null || extraParams.length != 2) {
            return null;
        }
        result.decimalPos = (Integer)extraParams[0];
        result.signPos = extraParams[1] != null ? (Integer)extraParams[1] : -1;
        return result;
    }

    @Override
    public boolean validateASCII(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        int signs = 0;
        int decimals = 0;
        ZEParams params = ZonedEditedConverter.getZEParams(extraParams);
        int i = 0;
        while (i < asciiString.length()) {
            char c = asciiString.charAt(i);
            if (c == '+' || c == '-') {
                ++signs;
            } else if (c == '.') {
                ++decimals;
            } else if (c != '+' && c != '-' && !Character.isDigit(c)) {
                return false;
            }
            ++i;
        }
        if (signs > 1 || decimals > 1) {
            return false;
        }
        if (params.signPos == -1 && asciiString.indexOf(45) != -1) {
            return false;
        }
        int wholePartSize = ZonedEditedConverter.numPreDecimal(params, tgtWidth);
        String wholePart = ConverterUtils.getWholePart(asciiString);
        if (wholePart.length() > wholePartSize) {
            return false;
        }
        return asciiString.length() <= tgtWidth;
    }

    private static int numPreDecimal(ZEParams params, int length) {
        if (params.decimalPos == -1) {
            if (params.signPos != -1) {
                return length - 1;
            }
            return length;
        }
        if (params.signPos == 0) {
            return params.decimalPos - 1;
        }
        return params.decimalPos;
    }

    private static int numPostDecimal(ZEParams params, int length) {
        if (params.decimalPos == -1) {
            return 0;
        }
        if (params.signPos == length - 1) {
            return length - 2 - params.decimalPos;
        }
        return length - 1 - params.decimalPos;
    }

    private static char getSign(String in) {
        int minus = in.indexOf(45);
        if (minus != -1) {
            return '-';
        }
        return '+';
    }

    private static class ZEParams {
        int decimalPos;
        int signPos;

        private ZEParams() {
        }
    }
}

