/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.datatypeconverters;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.model.ByteUtilities;
import com.ibm.etools.fm.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import java.nio.charset.StandardCharsets;

public class FMIZonedDecimalDataTypeConverter
implements IFMIDataTypeConverter {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final String INVALID_ZD_EXTRA_PARAMETER_ARR = Messages.FMIZonedDecimalDataTypeConverter_ERROR_INVALID_PARAMS;
    private final String INVALID_ZONED_DECIMAL = Messages.FMIZonedDecimalDataTypeConverter_ERROR_INVALID_FIELD;
    private static FMIZonedDecimalDataTypeConverter theInstance = null;

    private FMIZonedDecimalDataTypeConverter() {
    }

    public static FMIZonedDecimalDataTypeConverter getInstance() {
        if (theInstance == null) {
            theInstance = new FMIZonedDecimalDataTypeConverter();
        }
        return theInstance;
    }

    @Override
    public String correctASCIIStringFormat(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        ZDParams params = this.getParams(extraParams);
        StringBuffer buf = null;
        int aIndex = 0;
        if (asciiString == null || asciiString.equals("")) {
            buf = new StringBuffer("0");
        } else {
            buf = new StringBuffer(asciiString);
            aIndex = buf.charAt(0) == '-' ? 1 : 0;
            while (aIndex < buf.length() && buf.charAt(aIndex) == '0') {
                buf.deleteCharAt(aIndex);
            }
            if (buf.length() == 0 || buf.charAt(0) == '.') {
                buf.insert(0, '0');
            }
        }
        if (params.impliedDecimal != -1) {
            int decimalIndex;
            int indexDifference;
            if (buf.indexOf(".") == -1) {
                buf.append(".");
            }
            if ((indexDifference = (decimalIndex = buf.length() - (buf.indexOf(".") + 1)) - params.impliedDecimal) > 0) {
                i = 0;
                while (i < indexDifference) {
                    if (buf.charAt(buf.length() - 1) != '0') {
                        throw new FMIConversionException(Messages.FMIZonedDecimalDataTypeConverter_ERROR_DECIMAL_POSITION);
                    }
                    buf.deleteCharAt(buf.length() - 1);
                    ++i;
                }
            } else if (indexDifference < 0) {
                i = 0;
                while (i < -indexDifference) {
                    buf.append('0');
                    ++i;
                }
            }
            if (buf.charAt(aIndex) == '.') {
                buf.insert(aIndex, '0');
            }
        }
        boolean foundPoint = false;
        int i = aIndex;
        while (i < buf.length()) {
            if (!Character.isDigit(buf.charAt(i))) {
                if (buf.charAt(i) == '.' && !foundPoint) {
                    foundPoint = true;
                } else {
                    throw new FMIConversionException(Messages.FMIZonedDecimalDataTypeConverter_ERROR_INVALID_CHAR);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    @Override
    public byte[] ASCIIstrToEBCDIC(String asciiString, byte[] oldEBCDIC, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        int aIndex;
        int i;
        asciiString = this.correctASCIIStringFormat((String)asciiString, this.getMaxASCIIWidth(tgtWidth, extraParams), extraParams);
        ZDParams params = this.getParams(extraParams);
        boolean negative = ((String)asciiString).charAt(0) == '-';
        int decimalIndex = ((String)asciiString).indexOf(46);
        int numZeros = tgtWidth - ((String)asciiString).length();
        if (decimalIndex != -1) {
            ++numZeros;
        }
        if (negative) {
            ++numZeros;
        }
        if (numZeros > 0) {
            StringBuffer buf = new StringBuffer((String)asciiString);
            int insertIndex = negative ? 1 : 0;
            i = 0;
            while (i < numZeros) {
                buf.insert(insertIndex, '0');
                ++i;
            }
            asciiString = buf.toString();
        }
        if ((decimalIndex = ((String)asciiString).indexOf(46)) != -1) {
            asciiString = ((String)asciiString).substring(0, decimalIndex) + ((String)asciiString).substring(decimalIndex + 1, ((String)asciiString).length());
        }
        byte[] ebcdic = new byte[tgtWidth];
        byte[] ascii = ((String)asciiString).getBytes(StandardCharsets.UTF_8);
        i = 0;
        while (i < ebcdic.length) {
            ebcdic[i] = 0;
            ++i;
        }
        int eIndex = 0;
        int n = aIndex = negative ? 1 : 0;
        if (params.signLeading) {
            if (params.signSeparate) {
                ebcdic[eIndex++] = negative ? 96 : 78;
            } else {
                if (negative) {
                    int n2 = eIndex;
                    ebcdic[n2] = (byte)(ebcdic[n2] | 0xFFFFFFD0);
                } else {
                    int n3 = eIndex;
                    ebcdic[n3] = (byte)(ebcdic[n3] | 0xFFFFFFC0);
                }
                int n4 = eIndex++;
                ebcdic[n4] = (byte)(ebcdic[n4] | (byte)(0xF & ascii[aIndex++]));
            }
        }
        while (aIndex < ascii.length) {
            ebcdic[eIndex++] = (byte)(0xF0 | ascii[aIndex]);
            ++aIndex;
        }
        if (!params.signLeading) {
            if (params.signSeparate) {
                ebcdic[eIndex] = negative ? 96 : 78;
            } else if (negative) {
                int n5 = --eIndex;
                ebcdic[n5] = (byte)(ebcdic[n5] & 0xFFFFFFDF);
            } else {
                int n6 = --eIndex;
                ebcdic[n6] = (byte)(ebcdic[n6] & 0xFFFFFFFF);
            }
        }
        return ebcdic;
    }

    @Override
    public String EBCDICtoASCIIstr(byte[] EBCDICval, int maxStrLength, Object[] extraParams) throws FMIConversionException {
        if (EBCDICval == null || EBCDICval.length == 0) {
            throw new FMIConversionException();
        }
        StringBuffer strVal = new StringBuffer();
        int curIndex = 0;
        int endIndex = EBCDICval.length - 1;
        if (EBCDICval == null || EBCDICval.length == 0) {
            return null;
        }
        ZDParams params = this.getParams(extraParams);
        if (params.signLeading && params.signSeparate) {
            if (EBCDICval[curIndex] == 96) {
                strVal.append('-');
            } else if (EBCDICval[curIndex] != 78) {
                throw new FMIConversionException(this.INVALID_ZONED_DECIMAL);
            }
            ++curIndex;
        } else if (params.signLeading && ByteUtilities.isNegative(EBCDICval[curIndex], true, this.INVALID_ZONED_DECIMAL)) {
            strVal.append('-');
        } else if (params.signSeparate) {
            --endIndex;
        }
        boolean foundFirst = false;
        int startIndex = curIndex;
        while (curIndex <= endIndex) {
            boolean isSignByte = !params.signSeparate && (params.signLeading && curIndex == startIndex || !params.signLeading && curIndex == endIndex);
            char curChar = (char)(0x30 | EBCDICval[curIndex] & 0xF);
            if (!Character.isDigit(curChar) || (0xFFFFFFF0 & EBCDICval[curIndex]) != -16 && !isSignByte) {
                throw new FMIConversionException(this.INVALID_ZONED_DECIMAL);
            }
            if (curChar != '0' && !foundFirst) {
                foundFirst = true;
            }
            if (foundFirst || curChar != '0') {
                strVal.append(curChar);
            }
            ++curIndex;
        }
        if (params.signLeading && strVal.length() == 1 && strVal.charAt(0) == '-') {
            strVal.deleteCharAt(0);
        }
        if (!params.signLeading && strVal.length() != 0) {
            if (!params.signSeparate && ByteUtilities.isNegative(EBCDICval[endIndex], true, this.INVALID_ZONED_DECIMAL)) {
                strVal.insert(0, '-');
            } else if (params.signSeparate && EBCDICval[endIndex] == 96) {
                strVal.insert(0, '-');
            } else if (params.signSeparate && EBCDICval[endIndex] != 78) {
                throw new FMIConversionException(this.INVALID_ZONED_DECIMAL);
            }
        } else if (strVal.length() == 0) {
            strVal.append('0');
        }
        if (params.impliedDecimal != -1) {
            int impliedDecimalLocation = strVal.length() > params.impliedDecimal ? strVal.length() - params.impliedDecimal : 0;
            strVal.insert(impliedDecimalLocation, '.');
        }
        return this.correctASCIIStringFormat(strVal.toString(), this.getMaxASCIIWidth(EBCDICval.length, extraParams), extraParams);
    }

    @Override
    public int getMaxASCIIWidth(int ebcdicWidth, Object[] extraParams) throws FMIConversionException {
        ZDParams params = this.getParams(extraParams);
        return this.getMaxASCIIWidth(ebcdicWidth, params);
    }

    private int getMaxASCIIWidth(int ebcdicWidth, ZDParams params) throws FMIConversionException {
        if (params.signSeparate) {
            if (ebcdicWidth < 2) {
                throw new FMIConversionException(this.INVALID_ZONED_DECIMAL);
            }
            return params.impliedDecimal == -1 ? ebcdicWidth : ebcdicWidth + 1;
        }
        if (ebcdicWidth < 1) {
            throw new FMIConversionException(this.INVALID_ZONED_DECIMAL);
        }
        return params.impliedDecimal == -1 ? ebcdicWidth + 1 : ebcdicWidth + 2;
    }

    @Override
    public boolean validateASCII(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        int maxDigitsLeftOfDecimal;
        String str = this.correctASCIIStringFormat(asciiString, tgtWidth, extraParams);
        ZDParams params = this.getParams(extraParams);
        int n = maxDigitsLeftOfDecimal = params.impliedDecimal == -1 ? tgtWidth : tgtWidth - params.impliedDecimal;
        if (params.signSeparate) {
            --maxDigitsLeftOfDecimal;
        }
        String leftOfDecimal = params.impliedDecimal == -1 ? str : str.substring(0, str.indexOf(46));
        int numDigitsLeft = leftOfDecimal.length();
        if (leftOfDecimal.charAt(0) == '-') {
            --numDigitsLeft;
        }
        if (numDigitsLeft > maxDigitsLeftOfDecimal) {
            throw new FMIConversionException(Messages.FMIZonedDecimalDataTypeConverter_ERROR_VAL_TOO_LARGE);
        }
        return true;
    }

    private ZDParams getParams(Object[] extraParams) throws FMIConversionException {
        Boolean signLeading = Boolean.FALSE;
        Boolean signSeparate = Boolean.FALSE;
        Integer impliedDecimal = -1;
        if (extraParams != null) {
            if (extraParams.length != 3 || extraParams[0].getClass() != Boolean.class || extraParams[1].getClass() != Boolean.class || extraParams[2].getClass() != Integer.class) {
                throw new FMIConversionException(this.INVALID_ZD_EXTRA_PARAMETER_ARR);
            }
            signLeading = (Boolean)extraParams[0];
            signSeparate = (Boolean)extraParams[1];
            impliedDecimal = (Integer)extraParams[2];
        }
        ZDParams curParams = new ZDParams();
        curParams.signLeading = signLeading;
        curParams.signSeparate = signSeparate;
        curParams.impliedDecimal = impliedDecimal;
        return curParams;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public String getSymbol() {
        return "ZD";
    }

    @Override
    public byte[] getDefaultValue(int length, Object[] extraParams) {
        ZDParams params = new ZDParams();
        params.signLeading = false;
        params.signSeparate = false;
        params.impliedDecimal = -1;
        try {
            this.getParams(extraParams);
        }
        catch (FMIConversionException fMIConversionException) {
            // empty catch block
        }
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = -16;
            ++i;
        }
        int signByte = params.signSeparate ? 78 : -16;
        int signPosition = params.signLeading ? 0 : bytes.length - 1;
        bytes[signPosition] = signByte;
        return bytes;
    }

    @Override
    public boolean requiresFullWordBoundary(int length) {
        return false;
    }

    @Override
    public boolean requiresHalfWordBoundary(int length) {
        return false;
    }

    private static class ZDParams {
        public boolean signLeading;
        public boolean signSeparate;
        public int impliedDecimal;

        private ZDParams() {
        }
    }
}

