/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.datatypeconverters;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class FMIUnsignedBinaryDataTypeConverter
implements IFMIDataTypeConverter {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private String MSG_UNEXPECTED_DATA_SIZE = Messages.FMIUnsignedBinaryDataTypeConverter_ERROR_CONVERSION;
    private static final int MAX_DIGITS_ULONG_CONVERTED = 9;
    private static FMIUnsignedBinaryDataTypeConverter theInstance = null;

    private FMIUnsignedBinaryDataTypeConverter() {
    }

    public static FMIUnsignedBinaryDataTypeConverter getInstance() {
        if (theInstance == null) {
            theInstance = new FMIUnsignedBinaryDataTypeConverter();
        }
        return theInstance;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public byte[] ASCIIstrToEBCDIC(String asciiString, byte[] oldEBCDIC, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        try {
            bytes = null;
            tgtArr = new byte[tgtWidth];
            if (asciiString == null || asciiString.equals("")) {
                i = 0;
                while (i < tgtArr.length) {
                    tgtArr[i] = 0;
                    ++i;
                }
            } else {
                block16: {
                    if (tgtWidth == 2) {
                        bytes = ByteBuffer.allocate(tgtWidth * 2);
                        bytes.putInt(Integer.parseInt(asciiString));
                        bytes.position(tgtWidth);
                    } else if (tgtWidth == 4) {
                        bytes = ByteBuffer.allocate(tgtWidth * 2);
                        bytes.putLong(Long.parseLong(asciiString));
                        bytes.position(tgtWidth);
                    } else if (tgtWidth == 8) {
                        bytes = ByteBuffer.allocate(tgtWidth);
                        try {
                            tempLong = Long.parseLong(asciiString);
                            bytes.putLong(tempLong);
                            bytes.position(0);
                            break block16;
                        }
                        catch (NumberFormatException nfe) {
                            tmpBig = new BigInteger(asciiString);
                            nineBytes = tmpBig.toByteArray();
                            if (nineBytes.length > 9) {
                                throw new FMIConversionException(this.MSG_UNEXPECTED_DATA_SIZE);
                            }
                            i = 1;
                            ** while (i < nineBytes.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            bytes.put(nineBytes[i]);
                            ++i;
                            continue;
                        }
lbl45:
                        // 1 sources

                        bytes.position(0);
                    } else {
                        throw new FMIConversionException();
                    }
                }
                bytes.get(tgtArr, 0, tgtWidth);
            }
            return tgtArr;
        }
        catch (FMIConversionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FMIConversionException(FMIUnsignedBinaryDataTypeConverter.MSG_ASCII_EBCDIC_FAILURE + e.getClass().getName());
        }
    }

    @Override
    public String correctASCIIStringFormat(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        int aIndex = ((String)asciiString).charAt(0) == '-' ? 1 : 0;
        while (aIndex < ((String)asciiString).length() && ((String)asciiString).charAt(aIndex) == '0') {
            Object object = asciiString = aIndex == 0 ? ((String)asciiString).substring(aIndex + 1) : "-" + ((String)asciiString).substring(aIndex + 1);
        }
        return asciiString;
    }

    @Override
    public String EBCDICtoASCIIstr(byte[] EBCDICval, int maxWidth, Object[] extraParams) throws FMIConversionException {
        String strVal = null;
        try {
            if (EBCDICval.length == 8) {
                if ((EBCDICval[0] & 0xFFFFFF80) == -128) {
                    BigInteger ulong = new BigInteger(1, EBCDICval);
                    strVal = ulong.toString();
                } else {
                    ByteBuffer bytes = ByteBuffer.allocate(8);
                    bytes.put(EBCDICval);
                    strVal = Long.toString(bytes.getLong(0));
                }
            } else if (EBCDICval.length == 4) {
                ByteBuffer bytes = ByteBuffer.allocate(8);
                byte[] topBytes = new byte[4];
                bytes.put(topBytes);
                bytes.put(EBCDICval);
                strVal = Long.toString(bytes.getLong(0));
            } else if (EBCDICval.length == 2) {
                ByteBuffer bytes = ByteBuffer.allocate(4);
                byte[] topBytes = new byte[2];
                bytes.put(topBytes);
                bytes.put(EBCDICval);
                strVal = Integer.toString(bytes.getInt(0));
            }
        }
        catch (Exception e) {
            throw new FMIConversionException(MSG_EBCDIC_ASCII_FAILURE + e.getClass().getName());
        }
        if (strVal == null) {
            throw new FMIConversionException(this.MSG_UNEXPECTED_DATA_SIZE);
        }
        if (strVal.length() > maxWidth) {
            throw new FMIConversionException(MSG_EXCEEDS_DISPLAY_WIDTH + strVal);
        }
        return strVal;
    }

    @Override
    public boolean validateASCII(String ascii, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        if (ascii == null || ascii.equals("")) {
            return true;
        }
        char[] charArr = ascii.toCharArray();
        int i = 0;
        while (i < charArr.length) {
            if (!Character.isDigit(charArr[i])) {
                String errMsg = INVALID_CHARACTER + charArr[i] + " found in field.";
                throw new FMIConversionException(errMsg);
            }
            ++i;
        }
        if (tgtWidth == 2 && ascii.length() > 5 || tgtWidth == 4 && ascii.length() > 10 || tgtWidth == 8 && ascii.length() > 20) {
            throw new FMIConversionException(MSG_EXCEEDS_DISPLAY_WIDTH);
        }
        return true;
    }

    @Override
    public int getMaxASCIIWidth(int ebcdicWidth, Object[] extraParams) throws FMIConversionException {
        if (ebcdicWidth == 2) {
            return 5;
        }
        if (ebcdicWidth == 4) {
            return 10;
        }
        if (ebcdicWidth == 8) {
            return 20;
        }
        throw new FMIConversionException(MSG_ASCII_LENGTH_CALC);
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public String getSymbol() {
        return "BI";
    }

    @Override
    public byte[] getDefaultValue(int length, Object[] extraParams) {
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = 0;
            ++i;
        }
        return bytes;
    }

    @Override
    public boolean requiresFullWordBoundary(int length) {
        return length >= 4;
    }

    @Override
    public boolean requiresHalfWordBoundary(int length) {
        return length == 2;
    }
}

