/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.datatypeconverters;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.model.ByteUtilities;
import com.ibm.etools.fm.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import java.nio.charset.StandardCharsets;

public class FMIPackedDecimalDataTypeConverter
implements IFMIDataTypeConverter {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final String INVALID_PACKED_DECIMAL = Messages.FMIPackedDecimalDataTypeConverter_ERROR_INVALID_FIELD;
    private final String INVALID_PD_EXTRA_PARAMETER_ARR = Messages.FMIPackedDecimalDataTypeConverter_ERROR_INVALID_PARAMS;
    private final String INVALID_IMPLIED_DECIMAL_OFFSET = Messages.FMIPackedDecimalDataTypeConverter_ERROR_IMPLIED_DECIMAL_OFFSET;
    private static final int NO_IMPLIED_DECIMAL = -1;
    private static FMIPackedDecimalDataTypeConverter theInstance = null;

    private FMIPackedDecimalDataTypeConverter() {
    }

    public static FMIPackedDecimalDataTypeConverter getInstance() {
        if (theInstance == null) {
            theInstance = new FMIPackedDecimalDataTypeConverter();
        }
        return theInstance;
    }

    @Override
    public byte[] ASCIIstrToEBCDIC(String asciiString, byte[] oldEBCDIC, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        asciiString = this.correctASCIIStringFormat((String)asciiString, tgtWidth, extraParams);
        int impliedDecimal = this.getImpliedDecimalOffset(extraParams);
        if (impliedDecimal != -1) {
            int decimalLocation = ((String)asciiString).indexOf(46);
            if (decimalLocation == -1) {
                throw new FMIConversionException(INTERNAL_ERROR + "FMIPackedDecimalDataTypeConverter#ASCIIstrToEBCDIC");
            }
            asciiString = ((String)asciiString).substring(0, decimalLocation) + ((String)asciiString).substring(decimalLocation + 1, ((String)asciiString).length());
        }
        boolean negative = false;
        byte[] ebcdicBytes = new byte[tgtWidth];
        int ebcdicIndex = ebcdicBytes.length - 1;
        int i = 0;
        while (i < ebcdicBytes.length - 1) {
            ebcdicBytes[i] = 0;
            ++i;
        }
        if (asciiString == null || ((String)asciiString).equals("")) {
            ebcdicBytes[ebcdicBytes.length - 1] = 12;
            return ebcdicBytes;
        }
        if (((String)asciiString).charAt(0) == '-') {
            negative = true;
        }
        if (negative && ((String)asciiString).length() > tgtWidth * 2 || !negative && ((String)asciiString).length() > tgtWidth * 2 - 1) {
            throw new FMIConversionException(MSG_EXCEEDS_DISPLAY_WIDTH);
        }
        byte[] asciiBytes = ((String)asciiString).getBytes(StandardCharsets.UTF_8);
        int asciiIndex = asciiBytes.length - 1;
        int lastAsciiIndex = negative ? 1 : 0;
        ebcdicBytes[ebcdicIndex] = negative ? -3 : -4;
        asciiBytes[asciiIndex] = (byte)(asciiBytes[asciiIndex] << 4);
        asciiBytes[asciiIndex] = (byte)(asciiBytes[asciiIndex] | 0xF);
        ebcdicBytes[ebcdicIndex] = (byte)(asciiBytes[asciiIndex] & ebcdicBytes[ebcdicIndex]);
        --asciiIndex;
        --ebcdicIndex;
        while (asciiIndex > lastAsciiIndex) {
            asciiBytes[asciiIndex - 1] = (byte)(asciiBytes[asciiIndex - 1] << 4);
            asciiBytes[asciiIndex] = (byte)(asciiBytes[asciiIndex] & 0xF);
            ebcdicBytes[ebcdicIndex--] = (byte)(asciiBytes[asciiIndex - 1] | asciiBytes[asciiIndex]);
            asciiIndex -= 2;
        }
        if (asciiIndex == lastAsciiIndex) {
            ebcdicBytes[ebcdicIndex] = (byte)(asciiBytes[asciiIndex] & 0xF);
        }
        return ebcdicBytes;
    }

    @Override
    public String correctASCIIStringFormat(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        int impliedDecimal = this.getImpliedDecimalOffset(extraParams);
        StringBuffer buf = null;
        int aIndex = 0;
        if (asciiString == null || asciiString.equals("")) {
            buf = new StringBuffer("0");
        } else {
            buf = new StringBuffer(asciiString);
            aIndex = buf.charAt(0) == '-' ? 1 : 0;
            while (aIndex < buf.length() && buf.charAt(aIndex) == '0') {
                buf.deleteCharAt(aIndex);
            }
            if (buf.length() == 0 || buf.charAt(0) == '.') {
                buf.insert(0, '0');
            }
        }
        if (impliedDecimal != -1) {
            int decimalIndex;
            int indexDifference;
            if (buf.indexOf(".") == -1) {
                buf.append(".");
            }
            if ((indexDifference = (decimalIndex = buf.length() - (buf.indexOf(".") + 1)) - impliedDecimal) > 0) {
                i = 0;
                while (i < indexDifference) {
                    if (buf.charAt(buf.length() - 1) != '0') {
                        throw new FMIConversionException(Messages.FMIPackedDecimalDataTypeConverter_ERROR_TOO_MANY_PLACES);
                    }
                    buf.deleteCharAt(buf.length() - 1);
                    ++i;
                }
            } else if (indexDifference < 0) {
                i = 0;
                while (i < -indexDifference) {
                    buf.append('0');
                    ++i;
                }
            }
            if (buf.charAt(aIndex) == '.') {
                buf.insert(aIndex, '0');
            }
        }
        boolean foundPoint = false;
        int i = aIndex;
        while (i < buf.length()) {
            if (!Character.isDigit(buf.charAt(i))) {
                if (buf.charAt(i) == '.' && !foundPoint) {
                    foundPoint = true;
                } else {
                    throw new FMIConversionException(Messages.FMIPackedDecimalDataTypeConverter_ERROR_INVALID_CHAR);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String EBCDICtoASCIIstr(byte[] EBCDICval, int maxWidth, Object[] extraParams) throws FMIConversionException {
        if (EBCDICval.length == 0) {
            throw new FMIConversionException();
        }
        impliedDecimalOffset = this.getImpliedDecimalOffset(extraParams);
        strVal = null;
        negative = false;
        asciiLength = EBCDICval.length * 2 - 1;
        curIndex = 0;
        startLow = false;
        if (EBCDICval != null && EBCDICval.length != 0) ** GOTO lbl13
        throw new FMIConversionException(this.INVALID_PACKED_DECIMAL);
lbl-1000:
        // 1 sources

        {
            asciiLength -= 2;
            ++curIndex;
lbl13:
            // 2 sources

            ** while (curIndex < EBCDICval.length && EBCDICval[curIndex] == 0)
        }
lbl14:
        // 1 sources

        if (curIndex >= EBCDICval.length) {
            throw new FMIConversionException(this.INVALID_PACKED_DECIMAL);
        }
        if ((EBCDICval[curIndex] & 15) == EBCDICval[curIndex]) {
            --asciiLength;
            startLow = true;
        }
        try {
            if (ByteUtilities.isNegative(EBCDICval[EBCDICval.length - 1], false, this.INVALID_PACKED_DECIMAL)) {
                ++asciiLength;
                negative = true;
            }
        }
        catch (Exception e) {
            throw new FMIConversionException(e.getMessage());
        }
        if (asciiLength == 0) {
            return "0";
        }
        if (asciiLength == 1 && negative) {
            return "-0";
        }
        asciiBytes = new byte[asciiLength];
        v0 = asciiIndex = negative != false ? 1 : 0;
        if (negative) {
            asciiBytes[0] = 45;
        }
        if (startLow) {
            asciiBytes[asciiIndex++] = (byte)(EBCDICval[curIndex++] | 48);
        }
        while (curIndex < EBCDICval.length - 1) {
            asciiBytes[asciiIndex++] = (byte)(48 | (EBCDICval[curIndex] & 255) >> 4);
            asciiBytes[asciiIndex++] = (byte)(EBCDICval[curIndex] & 15 | 48);
            ++curIndex;
        }
        asciiBytes[asciiIndex] = (byte)(48 | (EBCDICval[curIndex] & 255) >> 4);
        strVal = new String(asciiBytes, StandardCharsets.UTF_8);
        if (strVal.length() > maxWidth || strVal.length() == maxWidth && !negative) {
            throw new FMIConversionException(FMIPackedDecimalDataTypeConverter.MSG_EXCEEDS_DISPLAY_WIDTH);
        }
        if (impliedDecimalOffset != -1) {
            buf = new StringBuffer(strVal);
            offset = buf.length() > impliedDecimalOffset ? buf.length() - impliedDecimalOffset : 0;
            buf.insert(offset, '.');
            strVal = buf.toString();
        }
        return this.correctASCIIStringFormat(strVal, EBCDICval.length, extraParams);
    }

    @Override
    public boolean validateASCII(String ascii, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        int impliedDecimal = this.getImpliedDecimalOffset(extraParams);
        if (ascii.length() > tgtWidth * 2 && impliedDecimal == -1 || ascii.length() > tgtWidth * 2 + 1 && impliedDecimal != -1) {
            throw new FMIConversionException(Messages.FMIPackedDecimalDataTypeConverter_ERROR_TOO_MANY_PLACES);
        }
        String str = this.correctASCIIStringFormat(ascii, tgtWidth, extraParams);
        int maxDigits = tgtWidth * 2 - 1;
        int numDigits = str.length();
        if (str.charAt(0) == '-') {
            --numDigits;
        }
        if (impliedDecimal != -1 && str.indexOf(".") != -1) {
            --numDigits;
        }
        if (numDigits > maxDigits) {
            throw new FMIConversionException(Messages.FMIPackedDecimalDataTypeConverter_ERROR_VAL_TOO_LARGE);
        }
        return true;
    }

    @Override
    public int getMaxASCIIWidth(int ebcdicWidth, Object[] extraParams) throws FMIConversionException {
        int impliedDecimalOffset = this.getImpliedDecimalOffset(extraParams);
        int maxWidth = -1;
        if (ebcdicWidth > 0) {
            maxWidth = ebcdicWidth * 2;
        } else if (ebcdicWidth == 0) {
            maxWidth = 0;
        } else {
            throw new FMIConversionException(MSG_ASCII_LENGTH_CALC);
        }
        if (impliedDecimalOffset > maxWidth) {
            throw new FMIConversionException(this.INVALID_IMPLIED_DECIMAL_OFFSET);
        }
        if (impliedDecimalOffset != -1) {
            ++maxWidth;
        }
        return maxWidth;
    }

    private int getImpliedDecimalOffset(Object[] extraParams) throws FMIConversionException {
        if (extraParams == null || extraParams.length == 0) {
            return -1;
        }
        if (extraParams.length != 1 || extraParams[0].getClass() != Integer.class) {
            throw new FMIConversionException(this.INVALID_PD_EXTRA_PARAMETER_ARR);
        }
        int offset = (Integer)extraParams[0];
        if (offset < 0) {
            throw new FMIConversionException(this.INVALID_IMPLIED_DECIMAL_OFFSET);
        }
        return offset;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public String getSymbol() {
        return "PD";
    }

    @Override
    public byte[] getDefaultValue(int length, Object[] extraParams) {
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < bytes.length - 1) {
            bytes[i] = 0;
            ++i;
        }
        bytes[bytes.length - 1] = 12;
        return bytes;
    }

    @Override
    public boolean requiresFullWordBoundary(int length) {
        return false;
    }

    @Override
    public boolean requiresHalfWordBoundary(int length) {
        return false;
    }
}

