/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.model.datatypeconverters;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.etools.fm.model.exception.FMIConversionException;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.Stack;

public class FMIInternalFloatingPointDataTypeConverter
implements IFMIDataTypeConverter {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(FMIInternalFloatingPointDataTypeConverter.class);
    private final int FLOATBYTES = 4;
    private final int DOUBLEBYTES = 8;
    private final String INVALID_DOUBLE = Messages.FMIInternalFloatingPointDataTypeConverter_ERROR_INVALID_VAL;
    private final String INVALID_FIELD_WIDTH = Messages.FMIInternalFloatingPointDataTypeConverter_ERROR_INVALID_WIDTH;
    private static FMIInternalFloatingPointDataTypeConverter theInstance = null;

    private FMIInternalFloatingPointDataTypeConverter() {
    }

    public static FMIInternalFloatingPointDataTypeConverter getInstance() {
        if (theInstance == null) {
            theInstance = new FMIInternalFloatingPointDataTypeConverter();
        }
        return theInstance;
    }

    @Override
    public byte[] ASCIIstrToEBCDIC(String asciiString, byte[] oldEBCDIC, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        long wholepart;
        BigDecimal sixteen = new BigDecimal(16);
        BigDecimal bdFraction = null;
        BigDecimal bdResult = null;
        int characteristic = 0;
        int hexpos = 0;
        boolean nowhole = false;
        boolean firstdigithit = false;
        boolean doFractionConversion = true;
        int mantissalength = 0;
        int compareResult = 0;
        BigDecimal bd = null;
        try {
            bd = new BigDecimal(asciiString);
        }
        catch (NumberFormatException e) {
            throw new FMIConversionException(this.INVALID_DOUBLE);
        }
        byte[] bin = null;
        if (tgtWidth == 4 || tgtWidth == 8) {
            bin = new byte[tgtWidth];
            int i = 0;
            while (i < bin.length) {
                bin[i] = 0;
                ++i;
            }
        } else {
            throw new FMIConversionException(this.INVALID_FIELD_WIDTH);
        }
        mantissalength = bin.length - 1;
        compareResult = bd.compareTo(BigDecimal.ZERO);
        if (compareResult == 0) {
            return bin;
        }
        if (compareResult == -1) {
            bin[0] = (byte)(bin[0] & 0xFFFFFF80);
        }
        if ((wholepart = bd.longValue()) != 0L) {
            if (wholepart < 0L) {
                wholepart = -wholepart;
            }
            Stack<Byte> st = new Stack<Byte>();
            while (wholepart != 0L) {
                st.push((byte)(wholepart % 16L));
                wholepart /= 16L;
            }
            characteristic = (byte)st.size();
            if (characteristic > mantissalength * 2) {
                doFractionConversion = false;
            }
            int i = 0;
            while (i < mantissalength * 2 && !st.isEmpty()) {
                byte next;
                byte b = (Byte)st.pop();
                if (i == mantissalength * 2 - 1 && (next = ((Byte)st.pop()).byteValue()) >= 7) {
                    b = (byte)(b + 1);
                }
                if (i % 2 == 0) {
                    b = (byte)(b << 4);
                }
                int n = i / 2 + 1;
                bin[n] = (byte)(bin[n] | b);
                hexpos = (byte)(hexpos + 1);
                ++i;
            }
        } else {
            nowhole = true;
        }
        if (doFractionConversion) {
            bdFraction = FMIInternalFloatingPointDataTypeConverter.getFractionPart(bd);
            while (hexpos < mantissalength * 2) {
                bdResult = bdFraction.multiply(sixteen);
                if (hexpos == mantissalength * 2 - 1) {
                    MathContext mc = new MathContext(1, RoundingMode.HALF_UP);
                    bdResult = bdResult.round(mc);
                }
                byte b = 0;
                b = bdResult.byteValue();
                bdFraction = FMIInternalFloatingPointDataTypeConverter.getFractionPart(bdResult);
                if (hexpos % 2 == 0) {
                    b = (byte)(b << 4);
                }
                if (nowhole) {
                    if (b != 0) {
                        firstdigithit = true;
                    }
                    if (firstdigithit) {
                        int n = hexpos / 2 + 1;
                        bin[n] = (byte)(bin[n] | b);
                        hexpos = (byte)(hexpos + 1);
                        continue;
                    }
                    characteristic = (byte)(characteristic - 1);
                    continue;
                }
                int n = hexpos / 2 + 1;
                bin[n] = (byte)(bin[n] | b);
                hexpos = (byte)(hexpos + 1);
            }
        }
        bin[0] = (byte)(bin[0] | characteristic + 64);
        return bin;
    }

    private static BigDecimal getFractionPart(BigDecimal input) {
        BigInteger wholepart = input.toBigInteger();
        return input.subtract(new BigDecimal(wholepart));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String EBCDICtoASCIIstr(byte[] EBCDICval, int maxStrLength, Object[] extraParams) throws FMIConversionException {
        int i;
        byte[] fraction;
        boolean negative;
        if (EBCDICval.length == 0) {
            throw new FMIConversionException();
        }
        boolean useBigDecimal = false;
        double total = 0.0;
        BigDecimal bd = null;
        if (EBCDICval.length <= 0) throw new FMIConversionException(this.INVALID_DOUBLE);
        byte exponent = EBCDICval[0];
        exponent = (byte)(exponent & 0x7F);
        exponent = (byte)(exponent - 64);
        boolean bl = negative = (EBCDICval[0] & 0xFFFFFF80) == -128;
        if (EBCDICval.length == 4) {
            fraction = new byte[]{EBCDICval[1], EBCDICval[2], EBCDICval[3]};
        } else {
            if (EBCDICval.length != 8) throw new FMIConversionException(this.INVALID_DOUBLE);
            fraction = new byte[7];
            i = 0;
            while (i < 7) {
                fraction[i] = EBCDICval[i + 1];
                ++i;
            }
            useBigDecimal = true;
            bd = BigDecimal.ZERO;
        }
        int pow = exponent - 1;
        i = 0;
        while (i < fraction.length) {
            int b = fraction[i] & 0xF0;
            double c = (double)(b >>= 4) * Math.pow(16.0, pow);
            b = fraction[i] & 0xF;
            if ((c += (double)b * Math.pow(16.0, pow - 1)) != 0.0) {
                if (useBigDecimal) {
                    Objects.requireNonNull(bd);
                    bd = bd.add(new BigDecimal(c));
                } else {
                    total += c;
                }
            }
            pow -= 2;
            ++i;
        }
        String tmpString = null;
        if (useBigDecimal) {
            Objects.requireNonNull(bd);
            tmpString = bd.toString();
            return negative ? "-" + tmpString : tmpString;
        } else {
            tmpString = Double.toString(total);
        }
        return negative ? "-" + tmpString : tmpString;
    }

    @Override
    public String correctASCIIStringFormat(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        boolean negative;
        boolean isFloat = tgtWidth == 4;
        boolean isDouble = tgtWidth == 8;
        boolean bl = negative = asciiString.charAt(0) == '-';
        if (!isFloat && !isDouble) {
            throw new FMIConversionException(this.INVALID_FIELD_WIDTH);
        }
        try {
            double bfpDouble = 0.0;
            if (isFloat) {
                Float f = Float.valueOf(Float.parseFloat(asciiString));
                bfpDouble = f.doubleValue();
            } else if (isDouble) {
                bfpDouble = Double.parseDouble(asciiString);
            }
            return FMIInternalFloatingPointDataTypeConverter.generateFormattedASCII(bfpDouble, isFloat, negative);
        }
        catch (Exception e) {
            throw new FMIConversionException(this.INVALID_DOUBLE);
        }
    }

    private static String generateFormattedASCII(double bfpDouble, boolean isFloat, boolean negative) {
        if (isFloat) {
            if (negative) {
                return String.format("%1$13.7E", bfpDouble);
            }
            return String.format(" %1$12.7E", bfpDouble);
        }
        if (negative) {
            return String.format("%1$20.14E", bfpDouble);
        }
        return String.format(" %1$19.14E", bfpDouble);
    }

    @Override
    public int getMaxASCIIWidth(int ebcdicWidth, Object[] extraParams) throws FMIConversionException {
        if (ebcdicWidth == 4) {
            return 14;
        }
        if (ebcdicWidth == 8) {
            return 23;
        }
        throw new FMIConversionException(MSG_ASCII_LENGTH_CALC);
    }

    private static double parseComp12(String displayString) {
        return Double.parseDouble(displayString);
    }

    @Override
    public boolean validateASCII(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        boolean isDouble;
        if (asciiString.length() > this.getMaxASCIIWidth(tgtWidth, extraParams)) {
            throw new FMIConversionException(MSG_EXCEEDS_DISPLAY_WIDTH);
        }
        boolean isFloat = tgtWidth == 4;
        boolean bl = isDouble = tgtWidth == 8;
        if (!isFloat && !isDouble) {
            throw new FMIConversionException(this.INVALID_DOUBLE);
        }
        try {
            FMIInternalFloatingPointDataTypeConverter.parseComp12(asciiString);
        }
        catch (Exception e) {
            throw new FMIConversionException(this.INVALID_DOUBLE);
        }
        return true;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public String getSymbol() {
        return "FP";
    }

    @Override
    public byte[] getDefaultValue(int length, Object[] extraParams) {
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = 0;
            ++i;
        }
        return bytes;
    }

    @Override
    public boolean requiresFullWordBoundary(int length) {
        return length >= 4;
    }

    @Override
    public boolean requiresHalfWordBoundary(int length) {
        return length == 2;
    }
}

